/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.tracing.impl;

import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.DfPreferences;
import com.documentum.fc.common.impl.preferences.IPreferencesObserver;
import com.documentum.fc.common.impl.preferences.TypedPreferences;
import com.documentum.fc.tracing.impl.MethodContext;
import com.documentum.fc.tracing.impl.RpcContext;
import com.documentum.fc.tracing.impl.Tracer;
import com.documentum.fc.tracing.impl.TracingConfig;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import org.apache.log4j.spi.LoggingEvent;

public class Tracing {
    private static boolean s_enabled = false;
    private static boolean s_verbose = false;
    private static int s_muteLevel = 0;
    private static Tracer s_tracer;
    private static TracingConfig s_config;

    public static synchronized TracingConfig getTracingConfig() {
        return s_config.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTracingConfig(TracingConfig config) {
        if (config == null) {
            throw new NullPointerException("config");
        }
        if (config.equals(s_config)) {
            DfLogger.debug(Tracing.class, "setTracingConfig: configs are equal -- ignored", null, null);
            return;
        }
        Class<Tracing> clazz = Tracing.class;
        synchronized (Tracing.class) {
            Tracer oldTracer = s_tracer;
            s_tracer = null;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (oldTracer != null) {
                oldTracer.close();
            }
            Tracer newTracer = config.isEnabled() ? new Tracer(config) : null;
            Class<Tracing> clazz2 = Tracing.class;
            synchronized (Tracing.class) {
                s_config = config.clone();
                s_enabled = config.isEnabled();
                s_verbose = config.isVerbose();
                s_tracer = newTracer;
                // ** MonitorExit[var3_4] (shouldn't be in output)
                DfLogger.debug(Tracing.class, "setTracingConfig called; enabled: {0}", new Object[]{s_enabled}, null);
                return;
            }
        }
    }

    public static boolean isEnabled() {
        return s_enabled;
    }

    public static boolean isVerbose() {
        return s_verbose;
    }

    public static synchronized void reset() {
        Tracing.getTracer().reset();
    }

    public static String getTraceFileName() {
        Tracer tracer = Tracing.getTracer();
        if (tracer != null) {
            return tracer.getFilePath();
        }
        return null;
    }

    protected static synchronized Tracer getTracer() {
        return s_tracer;
    }

    public static void traceMethodEntrance(MethodContext methodContext) {
        Tracer tracer;
        if (!Tracing.isMuted() && (tracer = Tracing.getTracer()) != null) {
            tracer.traceMethodEntrance(methodContext);
        }
    }

    public static void traceMethodExit(MethodContext methodContext) {
        Tracer tracer;
        if (!Tracing.isMuted() && (tracer = Tracing.getTracer()) != null) {
            tracer.traceMethodExit(methodContext);
        }
    }

    public static void traceMethodException(MethodContext methodContext) {
        Tracer tracer;
        if (!Tracing.isMuted() && (tracer = Tracing.getTracer()) != null) {
            tracer.traceMethodException(methodContext);
        }
    }

    public static void traceRpcEntrance(RpcContext rpcContext) {
        Tracer tracer = Tracing.getTracer();
        if (tracer != null) {
            tracer.traceRpcEntrance(rpcContext);
        }
    }

    public static void traceRpcExit(RpcContext rpcContext) {
        Tracer tracer = Tracing.getTracer();
        if (tracer != null) {
            tracer.traceRpcExit(rpcContext);
        }
    }

    public static void traceRpcException(RpcContext rpcContext) {
        Tracer tracer = Tracing.getTracer();
        if (tracer != null) {
            tracer.traceRpcException(rpcContext);
        }
    }

    public static void traceLogEvent(LoggingEvent event) {
        Tracer tracer = Tracing.getTracer();
        if (tracer != null) {
            tracer.traceLogEvent(event);
        }
    }

    public static void logTracingError(String msgId, String[] args, Throwable t) {
        try {
            DfLogger.error(Tracing.class, msgId, args, t);
        }
        catch (Throwable throwable) {
            Tracing.lastChanceErrorReporting(msgId, args, t, throwable);
        }
    }

    public static void logTracingDebug(String msgId, String[] args, Throwable t) {
        try {
            DfLogger.debug(Tracing.class, msgId, args, t);
        }
        catch (Throwable throwable) {
            Tracing.lastChanceErrorReporting(msgId, args, t, throwable);
        }
    }

    public static void onPreferencesInitialized() {
        DfPreferences preferences = DfPreferences.getInstance();
        try {
            Tracing.setTracingConfig(new TracingConfig(preferences));
        }
        catch (DfException dfe) {
            DfLogger.error(Tracing.class, "Unable to initialize tracing from DfPreferences", null, (Throwable)dfe);
        }
        preferences.addObserver(new TracingPreferenceObserver());
    }

    private static void lastChanceErrorReporting(String msgId, String[] args, Throwable original, Throwable subsequent) {
        StringWriter sw = new StringWriter(512);
        PrintWriter pw = new PrintWriter(sw);
        String nl = System.getProperty("line.separator");
        pw.write("Error occurred in Tracing in context of reporting another error:");
        pw.write(nl);
        subsequent.printStackTrace(pw);
        pw.write("Original error: MSG=" + msgId + "; ARGS=" + Arrays.toString(args));
        pw.write(nl);
        original.printStackTrace(pw);
        pw.flush();
        System.err.println(sw.toString());
    }

    public static void setMuted(boolean muted) {
        s_muteLevel = muted ? ++s_muteLevel : --s_muteLevel;
    }

    public static boolean isMuted() {
        return s_muteLevel > 0;
    }

    static class TracingPreferenceObserver
    implements IPreferencesObserver {
        TracingPreferenceObserver() {
        }

        public void update(TypedPreferences preferences, String preferenceName) {
            try {
                TracingConfig config = new TracingConfig(preferences);
                if (!Tracing.getTracingConfig().equals(config)) {
                    DfLogger.debug((Object)this, "Configuring tracing as a result of a preferences update", null, null);
                    Tracing.setTracingConfig(config);
                }
            }
            catch (DfException dfe) {
                DfLogger.debug((Object)this, "Unable to configure tracing from preferences due to error", null, (Throwable)dfe);
            }
        }
    }
}

