/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.tracing.impl;

import com.documentum.fc.common.DfLogger;
import com.documentum.fc.tracing.IUserTracingInfo;
import com.documentum.fc.tracing.impl.TimingStyle;
import com.documentum.fc.tracing.impl.TraceItem;
import com.documentum.fc.tracing.impl.Tracing;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

class TracerLayout
extends Layout {
    private Field[] m_fields;
    private Field[] m_fieldsOneLine;
    private Field[] m_fieldsEnter;
    private Field[] m_fieldsExit;
    private Field[] m_fieldsException;
    private Field[] m_fieldsRpcOneLine;
    private Field[] m_fieldsRpcEnter;
    private Field[] m_fieldsRpcExit;
    private Field[] m_fieldsRpcException;
    private Field[] m_fieldsLogEvent;
    private Field[] m_fieldsCompactLogEvent;
    private String m_oneLineFormat;
    private String m_enterFormat;
    private String m_exitFormat;
    private String m_exceptionFormat;
    private String m_rpcOneLineFormat;
    private String m_rpcEnterFormat;
    private String m_rpcExitFormat;
    private String m_rpcExceptionFormat;
    private String m_logEventFormat;
    private String m_compactLogEventFormat;
    private Object[] m_argsOneLine;
    private Object[] m_argsEnter;
    private Object[] m_argsExit;
    private Object[] m_argsException;
    private Object[] m_argsRpcOneLine;
    private Object[] m_argsRpcEnter;
    private Object[] m_argsRpcExit;
    private Object[] m_argsRpcException;
    private Object[] m_argsLogEvent;
    private Object[] m_argsCompactLogEvent;
    private Config m_config;
    private ThreadLocal<CallDepthHistory> m_callDepthHistory = new ThreadLocal();
    private static final String NL = System.getProperty("line.separator");
    public static final int THREAD_NAME_WIDTH = 22;
    public static final String THREAD_NAME_FORMAT = "$24s";

    public TracerLayout() {
        this(new Field[]{Field.TIMESTAMP, Field.DURATION, Field.USER, Field.THREAD, Field.ENTER_EXIT, Field.CALL_DEPTH, Field.CLASS_IDENTIFIER, Field.METHOD, Field.ARGS, Field.RETURN_VALUE, Field.MESSAGE, Field.EXCEPTION});
    }

    public TracerLayout(Field[] fields) {
        this(fields, new Config(new SimpleDateFormat()));
    }

    public TracerLayout(Field[] fields, Config config) {
        this.m_fields = fields;
        this.m_config = config;
        this.createFormats();
    }

    public void activateOptions() {
    }

    public String format(LoggingEvent event) {
        StringBuilder builder = new StringBuilder(256);
        Object message = event.getMessage();
        if (message instanceof TraceItem) {
            TraceItem item = (TraceItem)message;
            this.optionallyAdjustCallDepth(item);
            this.format(item, builder);
            builder.append('\n');
        }
        return builder.toString();
    }

    void optionallyAdjustCallDepth(TraceItem item) {
        CallDepthHistory history = this.getCallDepthHistory();
        switch (item.getType()) {
            case ONE_LINE: 
            case ENTRANCE: {
                history.m_lastMethodEnterDepth = item.getCallDepth();
                break;
            }
            case EXIT: 
            case EXCEPTION: {
                history.m_lastMethodEnterDepth = item.getCallDepth() - 1;
                break;
            }
            case RPC_ONE_LINE: 
            case RPC_ENTRANCE: 
            case RPC_EXIT: 
            case RPC_EXCEPTION: 
            case LOG_EVENT: 
            case COMPACT_LOG_EVENT: {
                item.setCallDepth(history.m_lastMethodEnterDepth + 1);
            }
        }
    }

    private CallDepthHistory getCallDepthHistory() {
        CallDepthHistory history = this.m_callDepthHistory.get();
        if (history == null) {
            history = new CallDepthHistory();
            this.m_callDepthHistory.set(history);
        }
        return history;
    }

    private static boolean isMethodTraceItem(TraceItem item) {
        switch (item.getType()) {
            case LOG_EVENT: 
            case COMPACT_LOG_EVENT: {
                return false;
            }
        }
        return true;
    }

    void format(TraceItem traceItem, StringBuilder builder) {
        switch (traceItem.getType()) {
            case ENTRANCE: {
                this.formatTraceItem(traceItem, builder, this.m_fieldsEnter, this.m_argsEnter, this.m_enterFormat);
                break;
            }
            case EXIT: {
                this.formatTraceItem(traceItem, builder, this.m_fieldsExit, this.m_argsExit, this.m_exitFormat);
                break;
            }
            case EXCEPTION: {
                this.formatTraceItem(traceItem, builder, this.m_fieldsException, this.m_argsException, this.m_exceptionFormat);
                break;
            }
            case ONE_LINE: {
                this.formatTraceItem(traceItem, builder, this.m_fieldsOneLine, this.m_argsOneLine, this.m_oneLineFormat);
                break;
            }
            case RPC_ENTRANCE: {
                this.formatTraceItem(traceItem, builder, this.m_fieldsRpcEnter, this.m_argsRpcEnter, this.m_rpcEnterFormat);
                break;
            }
            case RPC_EXIT: {
                this.formatTraceItem(traceItem, builder, this.m_fieldsRpcExit, this.m_argsRpcExit, this.m_rpcExitFormat);
                break;
            }
            case RPC_EXCEPTION: {
                this.formatTraceItem(traceItem, builder, this.m_fieldsRpcException, this.m_argsRpcException, this.m_rpcExceptionFormat);
                break;
            }
            case RPC_ONE_LINE: {
                this.formatTraceItem(traceItem, builder, this.m_fieldsRpcOneLine, this.m_argsRpcOneLine, this.m_rpcOneLineFormat);
                break;
            }
            case LOG_EVENT: {
                this.formatTraceItem(traceItem, builder, this.m_fieldsLogEvent, this.m_argsLogEvent, this.m_logEventFormat);
                break;
            }
            case COMPACT_LOG_EVENT: {
                this.formatTraceItem(traceItem, builder, this.m_fieldsCompactLogEvent, this.m_argsCompactLogEvent, this.m_compactLogEventFormat);
                break;
            }
            default: {
                assert (false) : "Unrecognized traceItem type: " + traceItem.getType().toString();
                break;
            }
        }
    }

    public boolean ignoresThrowable() {
        return false;
    }

    private void formatTraceItem(TraceItem traceItem, StringBuilder b, Field[] fields, Object[] traceArgs, String format) {
        try {
            Object[] formatArgs = this.buildFormatArgs(fields, traceItem, traceArgs);
            b.append(String.format(format, formatArgs));
        }
        catch (RuntimeException e) {
            DfLogger.error((Object)this, "Failed to format trace item, Format {0}, Args {1}", new Object[]{format, traceArgs}, (Throwable)e);
        }
    }

    private void createFormats() {
        StringBuilder bufOneLine = new StringBuilder(128);
        StringBuilder bufEnter = new StringBuilder(128);
        StringBuilder bufExit = new StringBuilder(128);
        StringBuilder bufException = new StringBuilder(128);
        StringBuilder bufRpcOneLine = new StringBuilder(128);
        StringBuilder bufRpcEnter = new StringBuilder(128);
        StringBuilder bufRpcExit = new StringBuilder(128);
        StringBuilder bufRpcException = new StringBuilder(128);
        StringBuilder bufLogEvent = new StringBuilder(128);
        StringBuilder bufCompactLogEvent = new StringBuilder(128);
        int idxOneLine = 1;
        int idxEnter = 1;
        int idxExit = 1;
        int idxException = 1;
        int idxRpcOneLine = 1;
        int idxRpcEnter = 1;
        int idxRpcExit = 1;
        int idxRpcException = 1;
        int idxLogEvent = 1;
        int idxCompactLogEvent = 1;
        LinkedList<Field> fieldsOneLine = new LinkedList<Field>();
        LinkedList<Field> fieldsEnter = new LinkedList<Field>();
        LinkedList<Field> fieldsExit = new LinkedList<Field>();
        LinkedList<Field> fieldsException = new LinkedList<Field>();
        LinkedList<Field> fieldsRpcOneLine = new LinkedList<Field>();
        LinkedList<Field> fieldsRpcEnter = new LinkedList<Field>();
        LinkedList<Field> fieldsRpcExit = new LinkedList<Field>();
        LinkedList<Field> fieldsRpcException = new LinkedList<Field>();
        LinkedList<Field> fieldsLogEvent = new LinkedList<Field>();
        LinkedList<Field> fieldsCompactLogEvent = new LinkedList<Field>();
        LinkedList<Object> argsOneLine = new LinkedList<Object>();
        LinkedList<Object> argsEnter = new LinkedList<Object>();
        LinkedList<Object> argsExit = new LinkedList<Object>();
        LinkedList<Object> argsException = new LinkedList<Object>();
        LinkedList<Object> argsRpcOneLine = new LinkedList<Object>();
        LinkedList<Object> argsRpcEnter = new LinkedList<Object>();
        LinkedList<Object> argsRpcExit = new LinkedList<Object>();
        LinkedList<Object> argsRpcException = new LinkedList<Object>();
        LinkedList<Object> argsLogEvent = new LinkedList<Object>();
        LinkedList<Object> argsCompactLogEvent = new LinkedList<Object>();
        for (Field field : this.m_fields) {
            if (field.isOneLineField()) {
                bufOneLine.append(idxOneLine > 1 ? field.getPreceedingString(TraceType.ONE_LINE) : "").append(field.getFormatString(idxOneLine++, this.m_config, TraceType.ONE_LINE));
                fieldsOneLine.add(field);
                argsOneLine.add(field.getTraceItemArg(this.m_config, TraceType.ONE_LINE));
            }
            if (field.isEntranceField()) {
                bufEnter.append(idxEnter > 1 ? field.getPreceedingString(TraceType.ENTER) : "").append(field.getFormatString(idxEnter++, this.m_config, TraceType.ENTER));
                fieldsEnter.add(field);
                argsEnter.add(field.getTraceItemArg(this.m_config, TraceType.ENTER));
            }
            if (field.isExitField()) {
                bufExit.append(idxExit > 1 ? field.getPreceedingString(TraceType.EXIT) : "").append(field.getFormatString(idxExit++, this.m_config, TraceType.EXIT));
                fieldsExit.add(field);
                argsExit.add(field.getTraceItemArg(this.m_config, TraceType.EXIT));
            }
            if (field.isExceptionField()) {
                bufException.append(idxException > 1 ? field.getPreceedingString(TraceType.EXCEPTION) : "").append(field.getFormatString(idxException++, this.m_config, TraceType.EXCEPTION));
                fieldsException.add(field);
                argsException.add(field.getTraceItemArg(this.m_config, TraceType.EXCEPTION));
            }
            if (field.isRpcOneLineField()) {
                bufRpcOneLine.append(idxRpcOneLine > 1 ? field.getPreceedingString(TraceType.RPC_ONE_LINE) : "").append(field.getFormatString(idxRpcOneLine++, this.m_config, TraceType.RPC_ONE_LINE));
                fieldsRpcOneLine.add(field);
                argsRpcOneLine.add(field.getTraceItemArg(this.m_config, TraceType.RPC_ONE_LINE));
            }
            if (field.isRpcEntranceField()) {
                bufRpcEnter.append(idxRpcEnter > 1 ? field.getPreceedingString(TraceType.RPC_ENTER) : "").append(field.getFormatString(idxRpcEnter++, this.m_config, TraceType.RPC_ENTER));
                fieldsRpcEnter.add(field);
                argsRpcEnter.add(field.getTraceItemArg(this.m_config, TraceType.RPC_ENTER));
            }
            if (field.isRpcExitField()) {
                bufRpcExit.append(idxRpcExit > 1 ? field.getPreceedingString(TraceType.RPC_EXIT) : "").append(field.getFormatString(idxRpcExit++, this.m_config, TraceType.RPC_EXIT));
                fieldsRpcExit.add(field);
                argsRpcExit.add(field.getTraceItemArg(this.m_config, TraceType.RPC_EXIT));
            }
            if (field.isLogEventField()) {
                bufLogEvent.append(idxLogEvent > 1 ? field.getPreceedingString(TraceType.LOG_EVENT) : "").append(field.getFormatString(idxLogEvent++, this.m_config, TraceType.LOG_EVENT));
                fieldsLogEvent.add(field);
                argsLogEvent.add(field.getTraceItemArg(this.m_config, TraceType.LOG_EVENT));
            }
            if (field.isCompactLogEventField()) {
                bufCompactLogEvent.append(idxCompactLogEvent > 1 ? field.getPreceedingString(TraceType.COMPACT_LOG_EVENT) : "").append(field.getFormatString(idxCompactLogEvent++, this.m_config, TraceType.COMPACT_LOG_EVENT));
                fieldsCompactLogEvent.add(field);
                argsCompactLogEvent.add(field.getTraceItemArg(this.m_config, TraceType.COMPACT_LOG_EVENT));
            }
            if (!field.isRpcExceptionField()) continue;
            bufRpcException.append(idxRpcException > 1 ? field.getPreceedingString(TraceType.RPC_EXCEPTION) : "").append(field.getFormatString(idxRpcException++, this.m_config, TraceType.RPC_EXCEPTION));
            fieldsRpcException.add(field);
            argsRpcException.add(field.getTraceItemArg(this.m_config, TraceType.RPC_EXCEPTION));
        }
        this.m_fieldsOneLine = fieldsOneLine.toArray(new Field[fieldsOneLine.size()]);
        this.m_fieldsEnter = fieldsEnter.toArray(new Field[fieldsEnter.size()]);
        this.m_fieldsExit = fieldsExit.toArray(new Field[fieldsExit.size()]);
        this.m_fieldsException = fieldsException.toArray(new Field[fieldsException.size()]);
        this.m_fieldsRpcOneLine = fieldsRpcOneLine.toArray(new Field[fieldsRpcOneLine.size()]);
        this.m_fieldsRpcEnter = fieldsRpcEnter.toArray(new Field[fieldsRpcEnter.size()]);
        this.m_fieldsRpcExit = fieldsRpcExit.toArray(new Field[fieldsRpcExit.size()]);
        this.m_fieldsRpcException = fieldsRpcException.toArray(new Field[fieldsRpcException.size()]);
        this.m_fieldsLogEvent = fieldsLogEvent.toArray(new Field[fieldsLogEvent.size()]);
        this.m_fieldsCompactLogEvent = fieldsCompactLogEvent.toArray(new Field[fieldsCompactLogEvent.size()]);
        this.m_argsOneLine = argsOneLine.toArray(new Object[fieldsOneLine.size()]);
        this.m_argsEnter = argsEnter.toArray(new Object[fieldsEnter.size()]);
        this.m_argsExit = argsExit.toArray(new Object[fieldsExit.size()]);
        this.m_argsException = argsException.toArray(new Object[fieldsException.size()]);
        this.m_argsRpcOneLine = argsRpcOneLine.toArray(new Object[fieldsRpcOneLine.size()]);
        this.m_argsRpcEnter = argsRpcEnter.toArray(new Object[fieldsRpcEnter.size()]);
        this.m_argsRpcExit = argsRpcExit.toArray(new Object[fieldsRpcExit.size()]);
        this.m_argsRpcException = argsRpcException.toArray(new Object[fieldsRpcException.size()]);
        this.m_argsLogEvent = argsLogEvent.toArray(new Object[fieldsLogEvent.size()]);
        this.m_argsCompactLogEvent = argsCompactLogEvent.toArray(new Object[fieldsCompactLogEvent.size()]);
        this.m_oneLineFormat = bufOneLine.toString();
        this.m_enterFormat = bufEnter.toString();
        this.m_exitFormat = bufExit.toString();
        this.m_exceptionFormat = bufException.toString();
        this.m_rpcOneLineFormat = bufRpcOneLine.toString();
        this.m_rpcEnterFormat = bufRpcEnter.toString();
        this.m_rpcExitFormat = bufRpcExit.toString();
        this.m_rpcExceptionFormat = bufRpcException.toString();
        this.m_logEventFormat = bufLogEvent.toString();
        this.m_compactLogEventFormat = bufCompactLogEvent.toString();
    }

    private Object[] buildFormatArgs(Field[] fields, TraceItem traceItem, Object[] fieldArgs) {
        int len = fields.length;
        Object[] args = new String[len];
        for (int i = 0; i < len; ++i) {
            args[i] = fields[i].getTraceItemValue(traceItem, fieldArgs[i]);
        }
        return args;
    }

    static String trim(String s, int maxLen) {
        if (s == null) {
            return "N/A";
        }
        int l = s.length();
        if (l > maxLen) {
            StringBuilder b = new StringBuilder(maxLen);
            int frontIndex = (maxLen - 3) / 2;
            int backIndex = l - maxLen + 3 + frontIndex;
            b.append(s.substring(0, frontIndex)).append("...").append(s.substring(backIndex));
        }
        return s;
    }

    public static class Config {
        private int m_timeUnitLength = 0;
        private int m_dateWidth = 18;
        private int m_timestampWidth = 14;
        private int m_durationWidth = 18;
        private boolean m_includeTimestampUnits = false;
        private boolean m_includeDurationUnits = false;
        private boolean m_printExcStack = false;
        private DateFormat m_dateFormat = null;

        public Config(DateFormat dateFormat) {
            this.m_dateFormat = dateFormat;
        }

        public int getTimeUnitLength() {
            return this.m_timeUnitLength;
        }

        public void setTimeUnitLength(int timeUnitLength) {
            this.m_timeUnitLength = timeUnitLength;
        }

        public boolean getIncludeTimestampUnits() {
            return this.m_includeTimestampUnits;
        }

        public void setIncludeTimestampUnits(boolean includeTimestampUnits) {
            this.m_includeTimestampUnits = includeTimestampUnits;
        }

        public boolean getIncludeDurationUnits() {
            return this.m_includeDurationUnits;
        }

        public void setIncludeDurationUnits(boolean includeDurationUnits) {
            this.m_includeDurationUnits = includeDurationUnits;
        }

        public int getTimestampWidth() {
            return this.m_timestampWidth;
        }

        public void setTimestampWidth(TimingStyle style) {
            switch (style) {
                case NANOSECONDS: {
                    this.m_timestampWidth = Long.toString(System.nanoTime()).length() + 2;
                    break;
                }
                case MILLISECONDS: 
                case MILLISECONDS_FROM_START: {
                    this.m_timestampWidth = Long.toString(System.currentTimeMillis()).length() + 1;
                    break;
                }
                case SECONDS: {
                    this.m_durationWidth = 12;
                    break;
                }
                default: {
                    this.m_durationWidth = 14;
                }
            }
        }

        public int getDateWidth() {
            return this.m_dateWidth;
        }

        public void setDateWidth(int dateWidth) {
            this.m_dateWidth = dateWidth;
        }

        public int getDurationWidth() {
            return this.m_durationWidth;
        }

        public void setDurationWidth(int durationWidth) {
            this.m_durationWidth = durationWidth;
        }

        public void setDurationWidth(TimingStyle style) {
            switch (style) {
                case NANOSECONDS: {
                    this.m_durationWidth = 14;
                    break;
                }
                case MILLISECONDS: {
                    this.m_durationWidth = 8;
                    break;
                }
                case SECONDS: {
                    this.m_durationWidth = 12;
                    break;
                }
                default: {
                    this.m_durationWidth = 14;
                }
            }
        }

        public DateFormat getDateFormat() {
            return this.m_dateFormat;
        }

        public boolean getPrintExcStack() {
            return this.m_printExcStack;
        }

        public void setPrintExcStack(boolean printExcStack) {
            this.m_printExcStack = printExcStack;
        }
    }

    private static class CallDepthHistory {
        int m_lastMethodEnterDepth = 0;
        int m_rpcNestDepth = 0;

        private CallDepthHistory() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Field {
        TIMESTAMP{

            String getFormatString(int index, Config config, TraceType traceType) {
                return "%" + index + "$" + config.getTimestampWidth() + "s";
            }

            String getTraceItemValue(TraceItem traceItem, Object arg) {
                return traceItem.getTimestampString(null);
            }

            Object getTraceItemArg(Config config, TraceType traceType) {
                return null;
            }

            boolean isOneLineField() {
                return true;
            }

            boolean isEntranceField() {
                return true;
            }

            boolean isExitField() {
                return true;
            }

            boolean isExceptionField() {
                return true;
            }

            boolean isRpcOneLineField() {
                return true;
            }

            boolean isRpcEntranceField() {
                return true;
            }

            boolean isRpcExitField() {
                return true;
            }

            boolean isRpcExceptionField() {
                return true;
            }

            boolean isLogEventField() {
                return true;
            }

            boolean isCompactLogEventField() {
                return true;
            }
        }
        ,
        TIMESTAMP_DATE{

            String getFormatString(int index, Config config, TraceType traceType) {
                return "%" + index + "$" + config.getDateWidth() + "s";
            }

            String getTraceItemValue(TraceItem traceItem, Object arg) {
                return traceItem.getTimestampString((SimpleDateFormat)arg);
            }

            Object getTraceItemArg(Config config, TraceType traceType) {
                return config.getDateFormat();
            }

            boolean isOneLineField() {
                return false;
            }

            boolean isEntranceField() {
                return true;
            }

            boolean isExitField() {
                return true;
            }

            boolean isExceptionField() {
                return true;
            }

            boolean isRpcOneLineField() {
                return false;
            }

            boolean isRpcEntranceField() {
                return true;
            }

            boolean isRpcExitField() {
                return true;
            }

            boolean isRpcExceptionField() {
                return true;
            }

            boolean isLogEventField() {
                return true;
            }

            boolean isCompactLogEventField() {
                return false;
            }
        }
        ,
        DURATION{

            String getFormatString(int index, Config config, TraceType traceType) {
                return "%" + index + "$" + config.getDurationWidth() + "s";
            }

            String getTraceItemValue(TraceItem traceItem, Object arg) {
                if (TracerLayout.isMethodTraceItem(traceItem)) {
                    return traceItem.getDurationString();
                }
                return "N/A";
            }

            Object getTraceItemArg(Config config, TraceType traceType) {
                return null;
            }

            boolean isOneLineField() {
                return true;
            }

            boolean isEntranceField() {
                return false;
            }

            boolean isExitField() {
                return false;
            }

            boolean isExceptionField() {
                return false;
            }

            boolean isRpcOneLineField() {
                return true;
            }

            boolean isRpcEntranceField() {
                return false;
            }

            boolean isRpcExitField() {
                return false;
            }

            boolean isRpcExceptionField() {
                return false;
            }

            boolean isLogEventField() {
                return false;
            }

            boolean isCompactLogEventField() {
                return true;
            }
        }
        ,
        USER{

            String getFormatString(int index, Config arg, TraceType traceType) {
                return "%" + index + "$-20s";
            }

            String getTraceItemValue(TraceItem traceItem, Object arg) {
                String user = traceItem.getUser();
                if (user == null) {
                    user = "N/A";
                }
                return "<" + TracerLayout.trim(user, 20) + ">";
            }

            Object getTraceItemArg(Config config, TraceType traceType) {
                return null;
            }

            boolean isOneLineField() {
                return true;
            }

            boolean isEntranceField() {
                return true;
            }

            boolean isExitField() {
                return true;
            }

            boolean isExceptionField() {
                return true;
            }

            boolean isRpcOneLineField() {
                return true;
            }

            boolean isRpcEntranceField() {
                return true;
            }

            boolean isRpcExitField() {
                return true;
            }

            boolean isRpcExceptionField() {
                return true;
            }

            boolean isLogEventField() {
                return true;
            }

            boolean isCompactLogEventField() {
                return true;
            }
        }
        ,
        USER_INFO{

            String getFormatString(int index, Config arg, TraceType traceType) {
                return "%" + index + "$-30s ";
            }

            String getTraceItemValue(TraceItem traceItem, Object arg) {
                IUserTracingInfo info = traceItem.getUserTracingInfo();
                if (info == null) {
                    return "N/A";
                }
                StringBuilder builder = new StringBuilder(30);
                int hash = info.getSessionManagerIdHash();
                builder.append('<').append(TracerLayout.trim(info.getUser(), 14)).append('|').append(TracerLayout.trim(info.getSessionId(), 5)).append('|').append(hash > 0 ? "SM@" + Integer.toString(hash) : "N/A").append('>');
                return builder.toString();
            }

            Object getTraceItemArg(Config config, TraceType traceType) {
                return null;
            }

            boolean isOneLineField() {
                return true;
            }

            boolean isEntranceField() {
                return true;
            }

            boolean isExitField() {
                return true;
            }

            boolean isExceptionField() {
                return true;
            }

            boolean isRpcOneLineField() {
                return true;
            }

            boolean isRpcEntranceField() {
                return true;
            }

            boolean isRpcExitField() {
                return true;
            }

            boolean isRpcExceptionField() {
                return true;
            }

            boolean isLogEventField() {
                return true;
            }

            boolean isCompactLogEventField() {
                return true;
            }
        }
        ,
        THREAD{

            String getFormatString(int index, Config arg, TraceType traceType) {
                return "%" + index + "$22s";
            }

            String getTraceItemValue(TraceItem traceItem, Object arg) {
                StringBuilder b = new StringBuilder(32);
                b.append('[').append(TracerLayout.trim(traceItem.getThreadName(), 22)).append(']');
                return b.toString();
            }

            Object getTraceItemArg(Config config, TraceType traceType) {
                return null;
            }

            boolean isOneLineField() {
                return true;
            }

            boolean isEntranceField() {
                return true;
            }

            boolean isExitField() {
                return true;
            }

            boolean isExceptionField() {
                return true;
            }

            boolean isRpcOneLineField() {
                return true;
            }

            boolean isRpcEntranceField() {
                return true;
            }

            boolean isRpcExitField() {
                return true;
            }

            boolean isRpcExceptionField() {
                return true;
            }

            boolean isLogEventField() {
                return true;
            }

            boolean isCompactLogEventField() {
                return true;
            }
        }
        ,
        CALL_DEPTH{

            String getFormatString(int index, Config arg, TraceType traceType) {
                return "%" + index + "$s";
            }

            String getTraceItemValue(TraceItem traceItem, Object arg) {
                return traceItem.getCallDepthString();
            }

            Object getTraceItemArg(Config config, TraceType traceType) {
                return null;
            }

            boolean isOneLineField() {
                return true;
            }

            boolean isEntranceField() {
                return true;
            }

            boolean isExitField() {
                return true;
            }

            boolean isExceptionField() {
                return true;
            }

            boolean isRpcOneLineField() {
                return true;
            }

            boolean isRpcEntranceField() {
                return true;
            }

            boolean isRpcExitField() {
                return true;
            }

            boolean isRpcExceptionField() {
                return true;
            }

            boolean isLogEventField() {
                return true;
            }

            boolean isCompactLogEventField() {
                return true;
            }
        }
        ,
        CLASS_IDENTIFIER{

            String getFormatString(int index, Config arg, TraceType traceType) {
                return "%" + index + "$s";
            }

            String getTraceItemValue(TraceItem traceItem, Object arg) {
                return traceItem.getIdentityName();
            }

            Object getTraceItemArg(Config config, TraceType traceType) {
                return null;
            }

            String getPreceedingString(TraceType traceType) {
                return "";
            }

            boolean isOneLineField() {
                return true;
            }

            boolean isEntranceField() {
                return true;
            }

            boolean isExitField() {
                return true;
            }

            boolean isExceptionField() {
                return true;
            }

            boolean isRpcOneLineField() {
                return false;
            }

            boolean isRpcEntranceField() {
                return false;
            }

            boolean isRpcExitField() {
                return false;
            }

            boolean isRpcExceptionField() {
                return false;
            }

            boolean isLogEventField() {
                return false;
            }

            boolean isCompactLogEventField() {
                return false;
            }
        }
        ,
        METHOD{

            String getFormatString(int index, Config arg, TraceType traceType) {
                return "%" + index + "$s";
            }

            String getTraceItemValue(TraceItem traceItem, Object arg) {
                return traceItem.getMethodName();
            }

            Object getTraceItemArg(Config config, TraceType traceType) {
                return null;
            }

            String getPreceedingString(TraceType traceType) {
                String retval;
                switch (traceType) {
                    case ENTER: 
                    case EXCEPTION: 
                    case EXIT: 
                    case ONE_LINE: {
                        retval = ".";
                        break;
                    }
                    case RPC_ENTER: 
                    case RPC_EXCEPTION: 
                    case RPC_EXIT: 
                    case RPC_ONE_LINE: {
                        return "RPC: ";
                    }
                    default: {
                        retval = "";
                    }
                }
                return retval;
            }

            boolean isOneLineField() {
                return true;
            }

            boolean isEntranceField() {
                return true;
            }

            boolean isExitField() {
                return true;
            }

            boolean isExceptionField() {
                return true;
            }

            boolean isRpcOneLineField() {
                return true;
            }

            boolean isRpcEntranceField() {
                return true;
            }

            boolean isRpcExitField() {
                return true;
            }

            boolean isRpcExceptionField() {
                return true;
            }

            boolean isLogEventField() {
                return false;
            }

            boolean isCompactLogEventField() {
                return false;
            }
        }
        ,
        ARGS{

            String getFormatString(int index, Config arg, TraceType traceType) {
                return "(%" + index + "$s)";
            }

            String getTraceItemValue(TraceItem traceItem, Object arg) {
                return traceItem.getArgsString();
            }

            Object getTraceItemArg(Config config, TraceType traceType) {
                return null;
            }

            String getPreceedingString(TraceType traceType) {
                return "";
            }

            boolean isOneLineField() {
                return true;
            }

            boolean isEntranceField() {
                return true;
            }

            boolean isExitField() {
                return false;
            }

            boolean isExceptionField() {
                return false;
            }

            boolean isRpcOneLineField() {
                return true;
            }

            boolean isRpcEntranceField() {
                return true;
            }

            boolean isRpcExitField() {
                return false;
            }

            boolean isRpcExceptionField() {
                return false;
            }

            boolean isLogEventField() {
                return false;
            }

            boolean isCompactLogEventField() {
                return false;
            }
        }
        ,
        RETURN_VALUE{

            String getFormatString(int index, Config arg, TraceType traceType) {
                return "==> %" + index + "$s";
            }

            String getTraceItemValue(TraceItem traceItem, Object arg) {
                String rv = traceItem.getReturnValueString();
                if (rv == null) {
                    rv = "";
                }
                return rv;
            }

            Object getTraceItemArg(Config config, TraceType traceType) {
                return null;
            }

            boolean isOneLineField() {
                return true;
            }

            boolean isEntranceField() {
                return false;
            }

            boolean isExitField() {
                return true;
            }

            boolean isExceptionField() {
                return false;
            }

            boolean isRpcOneLineField() {
                return true;
            }

            boolean isRpcEntranceField() {
                return false;
            }

            boolean isRpcExitField() {
                return true;
            }

            boolean isRpcExceptionField() {
                return false;
            }

            boolean isLogEventField() {
                return false;
            }

            boolean isCompactLogEventField() {
                return false;
            }
        }
        ,
        EXCEPTION{

            String getFormatString(int index, Config arg, TraceType traceType) {
                return "%" + index + "$s";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            String getTraceItemValue(TraceItem traceItem, Object arg) {
                String retval = "";
                Throwable t = traceItem.getThrowable();
                if (t != null) {
                    Tracing.getTracer().disableTracingOnThread();
                    try {
                        StringBuilder b = new StringBuilder(512);
                        b.append("[!").append(t.getClass().getName());
                        b.append(": ").append(this.getMessage(t)).append("!]");
                        if (((Boolean)arg).booleanValue()) {
                            b.append(NL).append(traceItem.getStackTraceString());
                        }
                        retval = b.toString();
                    }
                    finally {
                        Tracing.getTracer().enableTracingOnThread();
                    }
                }
                return retval;
            }

            private String getMessage(Throwable t) {
                StringBuilder b = new StringBuilder(512);
                b.append(t.getMessage());
                for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
                    b.append("; caused by: ").append(cause.getMessage());
                }
                return b.toString();
            }

            Object getTraceItemArg(Config config, TraceType traceType) {
                return config.getPrintExcStack() ? Boolean.TRUE : Boolean.FALSE;
            }

            boolean isOneLineField() {
                return true;
            }

            boolean isEntranceField() {
                return true;
            }

            boolean isExitField() {
                return true;
            }

            boolean isExceptionField() {
                return true;
            }

            boolean isRpcOneLineField() {
                return true;
            }

            boolean isRpcEntranceField() {
                return true;
            }

            boolean isRpcExitField() {
                return true;
            }

            boolean isRpcExceptionField() {
                return true;
            }

            boolean isLogEventField() {
                return false;
            }

            boolean isCompactLogEventField() {
                return false;
            }
        }
        ,
        ENTER_EXIT{

            String getFormatString(int index, Config config, TraceType traceType) {
                String retval;
                switch (traceType) {
                    case ENTER: {
                        retval = "[ENTER]    ";
                        break;
                    }
                    case EXIT: {
                        retval = "[EXIT]     ";
                        break;
                    }
                    case EXCEPTION: {
                        retval = "[!EXC!]    ";
                        break;
                    }
                    case RPC_ENTER: {
                        retval = "[RPC_ENTER]";
                        break;
                    }
                    case RPC_EXIT: {
                        retval = "[RPC_EXIT] ";
                        break;
                    }
                    case RPC_EXCEPTION: {
                        retval = "[RPC_!EXC!]";
                        break;
                    }
                    case LOG_EVENT: 
                    case COMPACT_LOG_EVENT: {
                        retval = "[LOG]      ";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(traceType.toString() + " not allowed here");
                    }
                }
                return retval;
            }

            String getTraceItemValue(TraceItem traceItem, Object arg) {
                return "";
            }

            Object getTraceItemArg(Config config, TraceType traceType) {
                return null;
            }

            boolean isOneLineField() {
                return false;
            }

            boolean isEntranceField() {
                return true;
            }

            boolean isExitField() {
                return true;
            }

            boolean isExceptionField() {
                return true;
            }

            boolean isRpcOneLineField() {
                return false;
            }

            boolean isRpcEntranceField() {
                return true;
            }

            boolean isRpcExitField() {
                return true;
            }

            boolean isRpcExceptionField() {
                return true;
            }

            boolean isLogEventField() {
                return true;
            }

            boolean isCompactLogEventField() {
                return false;
            }
        }
        ,
        RPC_COUNT{

            String getFormatString(int index, Config config, TraceType traceType) {
                return "%" + index + "$-12s";
            }

            String getTraceItemValue(TraceItem traceItem, Object arg) {
                StringBuilder builder = new StringBuilder(12);
                IUserTracingInfo info = traceItem.getUserTracingInfo();
                if (info == null) {
                    builder.append("(RPCs=N/A)");
                } else {
                    builder.append("(RPCs=").append(info.getRpcCount()).append(')');
                }
                return builder.toString();
            }

            Object getTraceItemArg(Config config, TraceType traceType) {
                return null;
            }

            boolean isOneLineField() {
                return true;
            }

            boolean isEntranceField() {
                return true;
            }

            boolean isExitField() {
                return true;
            }

            boolean isExceptionField() {
                return true;
            }

            boolean isRpcOneLineField() {
                return true;
            }

            boolean isRpcEntranceField() {
                return true;
            }

            boolean isRpcExitField() {
                return true;
            }

            boolean isRpcExceptionField() {
                return true;
            }

            boolean isLogEventField() {
                return true;
            }

            boolean isCompactLogEventField() {
                return true;
            }
        }
        ,
        MESSAGE{

            String getFormatString(int index, Config arg, TraceType traceType) {
                return "%" + index + "$s";
            }

            String getTraceItemValue(TraceItem traceItem, Object arg) {
                return traceItem.getMessage();
            }

            Object getTraceItemArg(Config config, TraceType traceType) {
                return null;
            }

            String getPreceedingString(TraceType traceType) {
                return "";
            }

            boolean isOneLineField() {
                return false;
            }

            boolean isEntranceField() {
                return false;
            }

            boolean isExitField() {
                return false;
            }

            boolean isExceptionField() {
                return false;
            }

            boolean isRpcOneLineField() {
                return false;
            }

            boolean isRpcEntranceField() {
                return false;
            }

            boolean isRpcExitField() {
                return false;
            }

            boolean isRpcExceptionField() {
                return false;
            }

            boolean isLogEventField() {
                return true;
            }

            boolean isCompactLogEventField() {
                return true;
            }
        };


        abstract String getFormatString(int var1, Config var2, TraceType var3);

        abstract String getTraceItemValue(TraceItem var1, Object var2);

        abstract Object getTraceItemArg(Config var1, TraceType var2);

        String getPreceedingString(TraceType traceType) {
            return " ";
        }

        abstract boolean isOneLineField();

        abstract boolean isEntranceField();

        abstract boolean isExitField();

        abstract boolean isExceptionField();

        abstract boolean isRpcOneLineField();

        abstract boolean isRpcEntranceField();

        abstract boolean isRpcExitField();

        abstract boolean isRpcExceptionField();

        abstract boolean isLogEventField();

        abstract boolean isCompactLogEventField();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TraceType {
        ONE_LINE,
        ENTER,
        EXIT,
        EXCEPTION,
        RPC_ONE_LINE,
        RPC_ENTER,
        RPC_EXIT,
        RPC_EXCEPTION,
        LOG_EVENT,
        COMPACT_LOG_EVENT;

    }
}

