/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.tracing.impl;

import com.documentum.fc.tracing.impl.DateTimingHelper;
import com.documentum.fc.tracing.impl.MethodContext;
import com.documentum.fc.tracing.impl.MilliTimingHelper;
import com.documentum.fc.tracing.impl.NanoTimingHelper;
import com.documentum.fc.tracing.impl.RelativeMilliTimingHelper;
import com.documentum.fc.tracing.impl.RelativeSecondsTimingHelper;
import com.documentum.fc.tracing.impl.TraceItem;
import com.documentum.fc.tracing.impl.TracerLayout;

abstract class TraceItemFactory {
    public static final TraceItemFactory TRACEITEMMILLISFACTORY = new TraceItemMillisFactory();
    public static final TraceItemFactory TRACEITEMMILLISJVMSTARTFACTORY = new TraceItemMillisJvmStartFactory();
    public static final TraceItemFactory TRACEITEMSECSFACTORY = new TraceItemSecsFactory();
    public static final TraceItemFactory TRACEITEMNANOSFACTORY = new TraceItemNanosFactory();
    public static final TraceItemFactory TRACEITEMDATEFACTORY = new TraceItemDateFactory();

    TraceItemFactory() {
    }

    public abstract TraceItem create(TraceItem.Type var1, MethodContext var2, int var3);

    static class Log4jWrapperFactory
    extends TraceItemFactory {
        private TraceItemFactory m_factory;
        private TracerLayout m_layout;

        public Log4jWrapperFactory(TraceItemFactory factory, TracerLayout layout) {
            this.m_factory = factory;
            this.m_layout = layout;
        }

        public TraceItem create(TraceItem.Type type, MethodContext methodContext, int stackDepth) {
            TraceItem retval = this.m_factory.create(type, methodContext, stackDepth);
            retval.setLayout(this.m_layout);
            return retval;
        }
    }

    static class TraceItemDateFactory
    extends TraceItemFactory {
        TraceItemDateFactory() {
        }

        public TraceItem create(TraceItem.Type type, MethodContext methodContext, int stackDepth) {
            return new TraceItem(type, methodContext, stackDepth, new DateTimingHelper());
        }
    }

    static class TraceItemNanosFactory
    extends TraceItemFactory {
        TraceItemNanosFactory() {
        }

        public TraceItem create(TraceItem.Type type, MethodContext methodContext, int stackDepth) {
            return new TraceItem(type, methodContext, stackDepth, new NanoTimingHelper());
        }
    }

    static class TraceItemSecsFactory
    extends TraceItemFactory {
        TraceItemSecsFactory() {
        }

        public TraceItem create(TraceItem.Type type, MethodContext methodContext, int stackDepth) {
            return new TraceItem(type, methodContext, stackDepth, new RelativeSecondsTimingHelper());
        }
    }

    static class TraceItemMillisJvmStartFactory
    extends TraceItemFactory {
        TraceItemMillisJvmStartFactory() {
        }

        public TraceItem create(TraceItem.Type type, MethodContext methodContext, int stackDepth) {
            return new TraceItem(type, methodContext, stackDepth, new RelativeMilliTimingHelper());
        }
    }

    static class TraceItemMillisFactory
    extends TraceItemFactory {
        TraceItemMillisFactory() {
        }

        public TraceItem create(TraceItem.Type type, MethodContext methodContext, int stackDepth) {
            return new TraceItem(type, methodContext, stackDepth, new MilliTimingHelper());
        }
    }
}

