/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.tracing.impl;

import com.documentum.fc.client.impl.connection.docbase.IDocbaseRpcClient;
import com.documentum.fc.tracing.impl.MethodContext;
import com.documentum.fc.tracing.impl.MethodTracer;
import com.documentum.fc.tracing.impl.RpcContext;
import com.documentum.fc.tracing.impl.ThreadTraceContext;
import com.documentum.fc.tracing.impl.TraceItem;
import com.documentum.fc.tracing.impl.TraceItemFactory;
import com.documentum.fc.tracing.impl.Tracer;
import org.apache.log4j.Logger;

class EnterAndExitTracer
implements MethodTracer {
    private Tracer m_tracer;
    private Logger m_logger;
    private TraceItemFactory m_itemFactory;
    private boolean m_hasMethodFilter;

    public EnterAndExitTracer(Tracer tracer, TraceItemFactory itemFactory) {
        this.m_tracer = tracer;
        this.m_logger = tracer.getLogger();
        this.m_itemFactory = itemFactory;
        this.m_hasMethodFilter = tracer.hasMethodFilters();
        assert (this.m_logger != null) : "TracerImpl's logger is null";
    }

    public void traceMethodEntrance(Tracer tracer, MethodContext methodContext) {
        assert (this.m_logger != null) : "TracerImpl's logger is null";
        methodContext.getUserInfo(tracer);
        TraceItem item = this.m_itemFactory.create(TraceItem.Type.ENTRANCE, methodContext, this.m_tracer.getCallDepth(this.m_hasMethodFilter));
        item.setMethodContext(methodContext);
        this.m_logger.debug((Object)item);
    }

    public void traceMethodExit(Tracer tracer, MethodContext methodContext) {
        methodContext.getUserInfo(tracer);
        TraceItem item = this.m_itemFactory.create(TraceItem.Type.EXIT, methodContext, this.m_tracer.getCallDepth(this.m_hasMethodFilter));
        item.methodExited();
        item.setReturnValue(methodContext);
        this.m_logger.debug((Object)item);
    }

    public void traceMethodException(Tracer tracer, MethodContext methodContext) {
        methodContext.getUserInfo(tracer);
        TraceItem item = this.m_itemFactory.create(TraceItem.Type.EXCEPTION, methodContext, this.m_tracer.getCallDepth(this.m_hasMethodFilter));
        item.methodExited();
        item.setThrowable(methodContext);
        this.m_logger.debug((Object)item);
    }

    public void traceRpcEntrance(Tracer tracer, RpcContext rpcContext) {
        this.updateThreadRpcCount(tracer, rpcContext);
        rpcContext.getUserInfo(tracer);
        TraceItem item = this.m_itemFactory.create(TraceItem.Type.RPC_ENTRANCE, rpcContext, this.m_tracer.getCallDepth(this.m_hasMethodFilter));
        item.setRpcDepth(this.m_tracer.getRpcDepth(this.m_hasMethodFilter));
        item.setMethodContext(rpcContext);
        this.m_logger.debug((Object)item);
    }

    public void traceRpcExit(Tracer tracer, RpcContext rpcContext) {
        this.updateThreadRpcCount(tracer, rpcContext);
        rpcContext.getUserInfo(tracer);
        TraceItem item = this.m_itemFactory.create(TraceItem.Type.RPC_EXIT, rpcContext, this.m_tracer.getCallDepth(this.m_hasMethodFilter));
        item.setRpcDepth(this.m_tracer.getRpcDepth(this.m_hasMethodFilter));
        item.methodExited();
        item.setReturnValue(rpcContext);
        ThreadTraceContext context = this.m_tracer.getThreadTraceContext();
        context.addTimeAdjustmentToSurroundingRpcTraceItems(item.getDuration());
        this.m_logger.debug((Object)item);
    }

    public void traceRpcException(Tracer tracer, RpcContext rpcContext) {
        this.updateThreadRpcCount(tracer, rpcContext);
        rpcContext.getUserInfo(tracer);
        TraceItem item = this.m_itemFactory.create(TraceItem.Type.RPC_EXCEPTION, rpcContext, this.m_tracer.getCallDepth(this.m_hasMethodFilter));
        item.setRpcDepth(this.m_tracer.getRpcDepth(this.m_hasMethodFilter));
        item.methodExited();
        item.setThrowable(rpcContext);
        ThreadTraceContext context = this.m_tracer.getThreadTraceContext();
        context.addTimeAdjustmentToSurroundingRpcTraceItems(item.getDuration());
        this.m_logger.debug((Object)item);
    }

    public void traceLogEvent(Tracer tracer, MethodContext eventContext) {
        eventContext.getUserInfo(tracer);
        TraceItem item = this.m_itemFactory.create(TraceItem.Type.LOG_EVENT, eventContext, this.m_tracer.getCallDepth(this.m_hasMethodFilter));
        this.m_logger.debug((Object)item);
    }

    private void updateThreadRpcCount(Tracer tracer, RpcContext rpcContext) {
        Object target = rpcContext.getTarget();
        if (target instanceof IDocbaseRpcClient) {
            int newRpcCount = ((IDocbaseRpcClient)target).getNumberOfSends();
            tracer.updateThreadRpcCount(newRpcCount);
        }
    }
}

