/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.impl.util.reflection.proxy;

import com.documentum.fc.impl.util.WeakValueMap;
import com.documentum.fc.impl.util.reflection.proxy.BaseDoubleProxy;
import com.documentum.fc.impl.util.reflection.proxy.BaseProxy;
import com.documentum.fc.impl.util.reflection.proxy.IDoubleProxyHandler;
import com.documentum.fc.impl.util.reflection.proxy.IProxyHandler;
import com.documentum.fc.impl.util.reflection.proxy.ProxyClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;

public final class ProxyFactory {
    private static final String BASE_PROXY = BaseProxy.class.getName();
    private static final String BASE_DOUBLE_PROXY = BaseDoubleProxy.class.getName();
    private static Map s_proxyClassLoaders = new WeakValueMap();

    public static Object makeProxy(ClassLoader classloader, Object imp, Object data) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return ProxyFactory.makeProxy(classloader, imp, data, BASE_PROXY);
    }

    public static Object makeProxy(ClassLoader classloader, Object imp, Object data, String baseProxy) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class proxyClass = ProxyFactory.getProxyClass(classloader, imp, baseProxy);
        return ProxyFactory.instantiateProxy(proxyClass, imp, data);
    }

    public static Object makeDoubleProxy(ClassLoader classloader, Object imp, Object data) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return ProxyFactory.makeDoubleProxy(classloader, imp, data, (IProxyHandler)null);
    }

    public static Object makeDoubleProxy(ClassLoader classloader, Object imp, Object data, String baseProxy) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return ProxyFactory.makeDoubleProxy(classloader, imp, data, null, baseProxy);
    }

    public static Object makeDoubleProxy(ClassLoader classloader, Object imp, Object data, IProxyHandler existingHandler) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return ProxyFactory.makeDoubleProxy(classloader, imp, data, existingHandler, BASE_DOUBLE_PROXY);
    }

    public static Object makeDoubleProxy(ClassLoader classloader, Object imp, Object data, IProxyHandler existingHandler, String baseProxy) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class proxyClass = ProxyFactory.getProxyClass(classloader, imp, baseProxy);
        return ProxyFactory.instantiateDoubleProxy(proxyClass, imp, data, existingHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class getProxyClass(ClassLoader parent, Object imp, String baseProxy) throws ClassNotFoundException {
        ProxyClassLoader loader;
        Map map = s_proxyClassLoaders;
        synchronized (map) {
            loader = (ProxyClassLoader)s_proxyClassLoaders.get(parent);
            if (loader == null) {
                loader = ProxyFactory.newProxyClassLoader(parent, baseProxy);
                s_proxyClassLoaders.put(parent, loader);
            }
        }
        return loader.loadProxyClass(imp.getClass());
    }

    private static ProxyClassLoader newProxyClassLoader(final ClassLoader parent, final String baseProxy) {
        return AccessController.doPrivileged(new PrivilegedAction<ProxyClassLoader>(){

            @Override
            public ProxyClassLoader run() {
                return new ProxyClassLoader(parent, baseProxy);
            }
        });
    }

    private static Object instantiateProxy(Class proxyClass, Object imp, Object data) throws InstantiationException, IllegalAccessException {
        Object proxy = proxyClass.newInstance();
        ((IProxyHandler)proxy).____initHandler____(imp, data);
        return (IProxyHandler)proxy;
    }

    private static Object instantiateDoubleProxy(Class proxyClass, Object imp, Object data, IProxyHandler existingHandler) throws InstantiationException, IllegalAccessException {
        Object proxy = proxyClass.newInstance();
        IDoubleProxyHandler handler = (IDoubleProxyHandler)proxy;
        if (existingHandler != null) {
            existingHandler.____initHandler____(imp, data);
            handler.____setProxy____(existingHandler);
        } else {
            handler.____setProxy____(new BaseProxy(imp, data));
        }
        return handler;
    }
}

