/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.impl.util.reflection.proxy;

import com.documentum.fc.impl.util.reflection.ClassReflectionUtil;
import com.documentum.fc.impl.util.reflection.MethodMangling;
import com.documentum.thirdparty.javassist.CannotCompileException;
import com.documentum.thirdparty.javassist.ClassPool;
import com.documentum.thirdparty.javassist.CtClass;
import com.documentum.thirdparty.javassist.CtMethod;
import com.documentum.thirdparty.javassist.CtNewMethod;
import com.documentum.thirdparty.javassist.LoaderClassPath;
import com.documentum.thirdparty.javassist.NotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class ProxyClassGenerator {
    private ClassPool m_pool = new ClassPool(ClassPool.getDefault());
    private CtClass m_proxyBaseClass;

    ProxyClassGenerator(String baseProxy) throws ClassNotFoundException {
        this.addCurrentClasspath();
        try {
            this.m_proxyBaseClass = this.m_pool.get(baseProxy);
        }
        catch (NotFoundException e) {
            throw new ClassNotFoundException(baseProxy, e);
        }
    }

    public boolean isClassGenerated(String proxyClassName) {
        boolean isGenerated = false;
        try {
            this.m_pool.get(proxyClassName);
            isGenerated = true;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return isGenerated;
    }

    public byte[] makeProxyByteCode(Class impClass, String proxyClassName) throws CannotCompileException, NotFoundException, IOException {
        Class[] interfaces = ClassReflectionUtil.getAllInterfaces(impClass);
        CtClass cc = this.newClass(proxyClassName);
        HashMap methodIndex = new HashMap(1001);
        for (int i = 0; i < interfaces.length; ++i) {
            this.processInterface(interfaces[i], cc, methodIndex);
        }
        return cc.toBytecode();
    }

    protected String getReferenceImpMethod() {
        return "____referenceImp____";
    }

    protected String getUnreferenceImpMethod() {
        return "____unreferenceImp____";
    }

    protected void getOptionalMethodBody(StringBuffer methodBodyBuf) {
    }

    private void addCurrentClasspath() {
        this.addClasspath(ProxyClassGenerator.class);
    }

    private void addClasspath(Class clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        LoaderClassPath classPath = new LoaderClassPath(classLoader);
        this.m_pool.insertClassPath(classPath);
    }

    private CtClass newClass(String proxyClassName) throws CannotCompileException {
        CtClass cc = this.m_pool.makeClass(proxyClassName);
        cc.setSuperclass(this.m_proxyBaseClass);
        return cc;
    }

    private void processInterface(Class anInterface, CtClass cc, Map methodsIndex) throws NotFoundException, CannotCompileException {
        String interfaceName = anInterface.getName();
        CtClass ccI = this.loadInterface(interfaceName, anInterface);
        cc.addInterface(ccI);
        CtMethod[] methods = ccI.getDeclaredMethods();
        for (int j = 0; j < methods.length; ++j) {
            CtMethod method = methods[j];
            String signature = method.getName() + method.getSignature();
            if (methodsIndex.containsKey(signature) || signature.equals("clone()Ljava/lang/Object;")) continue;
            this.processMethod(method, interfaceName, cc);
            methodsIndex.put(signature, Boolean.TRUE);
        }
    }

    private CtClass loadInterface(String interfaceName, Class anInterface) throws NotFoundException {
        CtClass ccI;
        try {
            ccI = this.m_pool.get(interfaceName);
        }
        catch (NotFoundException e) {
            this.addClasspath(anInterface);
            ccI = this.m_pool.get(interfaceName);
        }
        return ccI;
    }

    private void processMethod(CtMethod method, String interfaceName, CtClass cc) throws CannotCompileException, NotFoundException {
        CtClass[] params = method.getParameterTypes();
        StringBuffer methodHeaderBuf = new StringBuffer(128);
        StringBuffer methodBodyBuf = new StringBuffer(128);
        String returnTypeName = MethodMangling.getJavaType(method.getReturnType());
        String methodName = method.getName();
        methodHeaderBuf.append("public ").append(returnTypeName).append(' ').append(methodName).append('(');
        methodBodyBuf.append('{');
        this.getOptionalMethodBody(methodBodyBuf);
        methodBodyBuf.append("try{");
        if (!returnTypeName.equals("void")) {
            methodBodyBuf.append("return ");
        }
        methodBodyBuf.append("((").append(interfaceName).append(')');
        methodBodyBuf.append(this.getReferenceImpMethod()).append("()).").append(methodName).append('(');
        for (int paramIndex = 0; paramIndex < params.length; ++paramIndex) {
            CtClass param = params[paramIndex];
            if (paramIndex > 0) {
                methodHeaderBuf.append(',');
                methodBodyBuf.append(',');
            }
            methodHeaderBuf.append(MethodMangling.getJavaType(param)).append(" p").append(paramIndex);
            methodBodyBuf.append(" p").append(paramIndex);
        }
        methodHeaderBuf.append(')');
        methodBodyBuf.append(");}finally{").append(this.getUnreferenceImpMethod()).append("();}}");
        this.processExceptions(method, methodHeaderBuf);
        methodHeaderBuf.append(methodBodyBuf);
        CtMethod m = CtNewMethod.make(methodHeaderBuf.toString(), cc);
        cc.addMethod(m);
    }

    private void processExceptions(CtMethod method, StringBuffer methodHeaderBuf) throws NotFoundException {
        CtClass[] exceptions = method.getExceptionTypes();
        for (int i = 0; i < exceptions.length; ++i) {
            CtClass exc = exceptions[i];
            if (i == 0) {
                methodHeaderBuf.append(" throws ");
            } else {
                methodHeaderBuf.append(',');
            }
            methodHeaderBuf.append(exc.getName());
        }
    }
}

