/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.impl.util.io;

import com.documentum.fc.common.DfLogger;
import com.documentum.fc.impl.util.io.BufferSizeException;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SocketChannel;

public final class MessageChannel
implements ByteChannel,
GatheringByteChannel,
ScatteringByteChannel {
    public static final int NUMBER_OF_LENGTH_BYTES = 4;
    private Socket m_socket;
    private final SocketChannel m_channel;
    private int m_incomingMessageLength;
    private ByteBuffer m_lengthBuffer;

    public MessageChannel(Socket socket) {
        if (socket == null) {
            throw new IllegalArgumentException("socket");
        }
        this.m_socket = socket;
        this.m_channel = this.m_socket.getChannel();
        this.m_lengthBuffer = ByteBuffer.allocate(4);
        this.m_incomingMessageLength = 0;
        this.disableTcpDelay();
    }

    private void disableTcpDelay() {
        try {
            this.m_socket.setTcpNoDelay(true);
        }
        catch (IOException e) {
            DfLogger.warn((Object)this, "DFC_CONNECTION_SOCKET_CONFIG_FAILED", null, (Throwable)e);
        }
    }

    public boolean isOpen() {
        return !this.m_socket.isClosed();
    }

    public void close() throws IOException {
        this.m_socket.close();
    }

    public synchronized int read(ByteBuffer buffer) throws IOException {
        int capacity;
        int messageLength = this.getIncomingMessageLength();
        if (messageLength > (capacity = buffer.limit() - buffer.position())) {
            throw new BufferSizeException(capacity, messageLength);
        }
        buffer.limit(buffer.position() + messageLength);
        this.consumeIncomingMessageLength();
        this.readSocket(buffer, messageLength);
        return messageLength;
    }

    private int getIncomingMessageLength() throws IOException {
        if (this.m_incomingMessageLength == 0) {
            this.m_incomingMessageLength = this.readLength();
        }
        return this.m_incomingMessageLength;
    }

    private int readLength() throws IOException {
        this.m_lengthBuffer.clear();
        this.readSocket(this.m_lengthBuffer, 4);
        this.m_lengthBuffer.position(0);
        int length = this.m_lengthBuffer.get();
        length = length << 8 | this.m_lengthBuffer.get() & 0xFF;
        length = length << 8 | this.m_lengthBuffer.get() & 0xFF;
        length = length << 8 | this.m_lengthBuffer.get() & 0xFF;
        return length;
    }

    private void consumeIncomingMessageLength() {
        this.m_incomingMessageLength = 0;
    }

    private void readSocket(ByteBuffer buffer, int length) throws IOException {
        int bytesRead;
        do {
            if (this.m_channel != null) {
                bytesRead = this.m_channel.read(buffer);
            } else {
                byte[] rawBuffer = buffer.array();
                int position = buffer.position();
                bytesRead = this.m_socket.getInputStream().read(rawBuffer, position, buffer.limit() - position);
                if (bytesRead >= 0) {
                    buffer.position(position + bytesRead);
                }
            }
            if (bytesRead >= 0) continue;
            throw new IOException("Unexpected end-of-stream");
        } while ((length -= bytesRead) > 0);
    }

    public long read(ByteBuffer[] buffers) throws IOException {
        return this.read(buffers, 0, buffers.length);
    }

    public synchronized long read(ByteBuffer[] buffers, int offset, int maximumCount) throws IOException {
        if (offset < 0 || offset >= buffers.length) {
            throw new IndexOutOfBoundsException("offset");
        }
        if (maximumCount < 0 || offset + maximumCount > buffers.length) {
            throw new IndexOutOfBoundsException("maximumCount");
        }
        int length = this.getIncomingMessageLength();
        int newMaximumCount = MessageChannel.prepareBufferArrayForRead(buffers, offset, maximumCount, length);
        this.consumeIncomingMessageLength();
        this.readSocket(buffers, offset, newMaximumCount, length);
        return length;
    }

    private static int prepareBufferArrayForRead(ByteBuffer[] buffers, int offset, int maximumCount, int length) throws IOException {
        int remainingLength = length;
        int numberOfBuffersNeeded = 0;
        int limit = offset + maximumCount;
        for (int i = offset; i < limit; ++i) {
            ++numberOfBuffersNeeded;
            ByteBuffer buffer = buffers[i];
            int capacity = buffer.limit() - buffer.position();
            if (capacity > remainingLength) {
                buffer.limit(buffer.position() + remainingLength);
                remainingLength = 0;
                break;
            }
            remainingLength -= capacity;
        }
        if (remainingLength > 0) {
            throw new BufferSizeException(length - remainingLength, length);
        }
        return numberOfBuffersNeeded;
    }

    private void readSocket(ByteBuffer[] buffers, int offset, int maximumCount, int length) throws IOException {
        int remainingLength = length;
        do {
            if (this.m_channel != null) {
                int bytesRead = (int)this.m_channel.read(buffers, offset, maximumCount);
                if (bytesRead < 0) {
                    throw new IOException("Unexpected end-of-stream");
                }
                remainingLength -= bytesRead;
                continue;
            }
            int limit = offset + maximumCount;
            for (int i = offset; i < limit; ++i) {
                this.readSocket(buffers[i], buffers[i].limit() - buffers[i].position());
            }
            remainingLength = 0;
        } while (remainingLength > 0);
    }

    public synchronized int write(ByteBuffer buffer) throws IOException {
        int messageLength = buffer.limit() - buffer.position();
        if (this.doesRoomExistToInsertLength(buffer)) {
            MessageChannel.prependLength(buffer, messageLength);
            this.writeSocket(buffer);
        } else {
            this.m_lengthBuffer.position(4);
            MessageChannel.prependLength(this.m_lengthBuffer, messageLength);
            this.writeSocket(new ByteBuffer[]{this.m_lengthBuffer, buffer}, messageLength + 4);
        }
        return messageLength;
    }

    private boolean doesRoomExistToInsertLength(ByteBuffer buffer) {
        return buffer.position() - 4 >= 0;
    }

    private static void prependLength(ByteBuffer buffer, int value) {
        int newPosition = buffer.position() - 4;
        buffer.position(newPosition);
        buffer.put(newPosition++, (byte)(value >> 24));
        buffer.put(newPosition++, (byte)(value >> 16));
        buffer.put(newPosition++, (byte)(value >> 8));
        buffer.put(newPosition, (byte)value);
    }

    private void writeSocket(ByteBuffer buffer) throws IOException {
        int remainingLength = buffer.limit() - buffer.position();
        do {
            if (this.m_channel != null) {
                remainingLength -= this.m_channel.write(buffer);
                continue;
            }
            byte[] rawBuffer = buffer.array();
            int position = buffer.position();
            int limit = buffer.limit();
            int length = limit - position;
            this.m_socket.getOutputStream().write(rawBuffer, position, length);
            buffer.position(limit);
            remainingLength -= length;
        } while (remainingLength > 0);
    }

    public long write(ByteBuffer[] buffers) throws IOException {
        return this.write(buffers, 0, buffers.length);
    }

    public synchronized long write(ByteBuffer[] buffers, int offset, int maximumCount) throws IOException {
        if (offset < 0 || offset >= buffers.length) {
            throw new IndexOutOfBoundsException("offset");
        }
        if (maximumCount < 0 || offset + maximumCount > buffers.length) {
            throw new IndexOutOfBoundsException("maximumCount");
        }
        int messageLength = MessageChannel.calculateLength(buffers, offset, maximumCount);
        this.m_lengthBuffer.position(4);
        MessageChannel.prependLength(this.m_lengthBuffer, messageLength);
        ByteBuffer[] effectiveBuffers = MessageChannel.buildBufferArrayForWrite(buffers, offset, maximumCount, this.m_lengthBuffer);
        this.writeSocket(effectiveBuffers, messageLength + 4);
        return messageLength;
    }

    private static int calculateLength(ByteBuffer[] buffers, int offset, int maximumCount) {
        int length = 0;
        int limit = offset + maximumCount;
        for (int i = offset; i < limit; ++i) {
            length += buffers[i].limit() - buffers[i].position();
        }
        return length;
    }

    private static ByteBuffer[] buildBufferArrayForWrite(ByteBuffer[] buffers, int offset, int maximumCount, ByteBuffer lengthBuffer) {
        ByteBuffer[] result = new ByteBuffer[maximumCount + 1];
        int i = 0;
        result[i++] = lengthBuffer;
        int limit = offset + maximumCount;
        for (int j = offset; j < limit; ++j) {
            result[i++] = buffers[j];
        }
        return result;
    }

    private void writeSocket(ByteBuffer[] buffers, int length) throws IOException {
        int remainingLength = length;
        do {
            if (this.m_channel != null) {
                remainingLength -= (int)this.m_channel.write(buffers);
                continue;
            }
            for (ByteBuffer buffer : buffers) {
                this.writeSocket(buffer);
            }
            remainingLength = 0;
        } while (remainingLength > 0);
    }
}

