/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.impl.util.enumeration;

import com.documentum.fc.impl.util.enumeration.BaseEnumeration;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundEnumeration<E>
extends BaseEnumeration<E> {
    private Enumeration<Enumeration<E>> m_enumerationSource;
    private Enumeration<E> m_currentEnumeration;

    public CompoundEnumeration(Enumeration<Enumeration<E>> enumerationSource) {
        this.m_enumerationSource = enumerationSource;
        this.switchEnumeration();
        this.moveToNextElement();
    }

    @Override
    protected void moveToNextElement() {
        this.m_nextObject = this.getNext();
        if (!this.m_hasMoreElements) {
            this.m_enumerationSource = null;
            this.m_currentEnumeration = null;
        }
    }

    private E getNext() {
        E result = null;
        boolean toContinue = true;
        while (this.m_hasMoreElements && toContinue) {
            result = this.getNextFromCurrentEnumeration();
            if (this.m_hasMoreElements) {
                toContinue = false;
                continue;
            }
            this.switchEnumeration();
        }
        return result;
    }

    private E getNextFromCurrentEnumeration() {
        E result = null;
        boolean toContinue = true;
        while (this.m_hasMoreElements && toContinue) {
            this.m_hasMoreElements = this.m_currentEnumeration.hasMoreElements();
            if (!this.m_hasMoreElements) continue;
            result = this.m_currentEnumeration.nextElement();
            toContinue = false;
        }
        return result;
    }

    private void switchEnumeration() {
        this.m_hasMoreElements = this.m_enumerationSource.hasMoreElements();
        if (this.m_hasMoreElements) {
            this.m_currentEnumeration = this.m_enumerationSource.nextElement();
        }
    }
}

