/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.impl.util.caching;

import com.documentum.fc.impl.util.caching.NullObjectFetcher;
import com.documentum.fc.impl.util.caching.ObjectFetcher;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheManager {
    private static final int MULTIPLIER = 1000;
    private static final int INIT_BUCKET_NUMBER = 100;
    private int m_size;
    private int m_optimalSize;
    private int m_bucketNumber;
    private final Map<Object, CacheEntry> m_cache;
    private long m_accessCounter;
    private long m_insertObjectCounter;
    private long m_nextFreeupCache;
    private ObjectFetcher m_fetcher;

    public CacheManager(int size) {
        this(size, null);
    }

    public CacheManager(int size, ObjectFetcher fetcher) {
        this.m_size = size;
        this.m_optimalSize = (int)(0.75 * (double)this.m_size);
        this.m_bucketNumber = 100;
        this.m_fetcher = fetcher != null ? fetcher : new NullObjectFetcher();
        this.m_cache = new HashMap<Object, CacheEntry>();
        this.m_accessCounter = 0L;
        this.m_nextFreeupCache = this.m_size;
        this.m_insertObjectCounter = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object key, Object value) {
        boolean isExist;
        if (value == null) {
            return;
        }
        CacheEntry entry = new CacheEntry(key, value, this.m_accessCounter++);
        Map<Object, CacheEntry> map = this.m_cache;
        synchronized (map) {
            isExist = this.m_cache.containsKey(key);
            this.m_cache.put(key, entry);
        }
        if (!isExist) {
            ++this.m_insertObjectCounter;
        }
        if (this.m_cache.size() > this.m_size) {
            this.freeupCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Object value;
        CacheEntry entry;
        Map<Object, CacheEntry> map = this.m_cache;
        synchronized (map) {
            entry = this.m_cache.get(key);
        }
        if (entry != null) {
            ++this.m_accessCounter;
            value = entry.getChachedObject(this.m_accessCounter);
            if (entry.isWeak()) {
                if (value != null) {
                    entry.restore(value);
                } else {
                    value = this.m_fetcher.get(key);
                    this.restore(key, value);
                }
            }
            return value;
        }
        value = this.m_fetcher.get(key);
        this.put(key, value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object key) {
        Map<Object, CacheEntry> map = this.m_cache;
        synchronized (map) {
            this.m_cache.remove(key);
        }
    }

    public Set<Object> keySet() {
        return new HashSet<Object>(this.m_cache.keySet());
    }

    public int size() {
        return this.m_cache.size();
    }

    public synchronized void forceCacheCleanup() {
        this.m_nextFreeupCache = this.m_insertObjectCounter - 1L;
        this.freeupCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void freeupCache() {
        if (this.m_insertObjectCounter > this.m_nextFreeupCache) {
            ArrayList<Object> entryToDelete = new ArrayList<Object>();
            int retireCount = 0;
            this.m_nextFreeupCache += (long)(0.25 * (double)this.m_size);
            Map<Object, CacheEntry> map = this.m_cache;
            synchronized (map) {
                Collection<CacheEntry> entries = this.m_cache.values();
                List[] buckets = new List[this.m_bucketNumber];
                for (CacheEntry entry : entries) {
                    if (entry.isWeak()) {
                        Object cachedObjeect = entry.getCachedObject();
                        if (cachedObjeect == null) {
                            entryToDelete.add(entry.getKey());
                            continue;
                        }
                        ++retireCount;
                        continue;
                    }
                    int score = entry.calculateScore(this.m_accessCounter, this.m_size, 1000);
                    int bucket = score / this.m_bucketNumber;
                    if (bucket >= this.m_bucketNumber) {
                        bucket = this.m_bucketNumber - 1;
                    }
                    if (buckets[bucket] == null) {
                        buckets[bucket] = new ArrayList();
                    }
                    buckets[bucket].add(entry);
                }
                int size = entryToDelete.size();
                for (int i = 0; i < size; ++i) {
                    Object key = entryToDelete.get(i);
                    this.m_cache.remove(key);
                }
                int shouldRetire = this.m_cache.size() - this.m_optimalSize;
                if (shouldRetire < 1 || shouldRetire < retireCount) {
                    return;
                }
                for (int bucket = this.m_bucketNumber - 1; bucket > -1 && shouldRetire > retireCount; --bucket) {
                    List entriesToRetire = buckets[bucket];
                    if (entriesToRetire == null) continue;
                    int size2 = entriesToRetire.size();
                    for (int i = 0; i < size2 && shouldRetire > retireCount; ++retireCount, ++i) {
                        CacheEntry entry = (CacheEntry)entriesToRetire.get(i);
                        entry.retire(this.m_accessCounter, this.m_size);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restore(Object key, Object value) {
        if (value == null) {
            return;
        }
        CacheEntry entry = new CacheEntry(key, value, this.m_accessCounter);
        Map<Object, CacheEntry> map = this.m_cache;
        synchronized (map) {
            this.m_cache.put(key, entry);
        }
    }

    private static class CacheEntry {
        private Object m_key;
        private Object m_cachedObject;
        private int m_useCounter;
        private long m_fetchAccessCounter;
        private boolean m_isWeak;

        public CacheEntry(Object key, Object chachedObject, long accessCounter) {
            this.m_key = key;
            this.m_cachedObject = chachedObject;
            this.m_isWeak = false;
            this.m_fetchAccessCounter = accessCounter;
            this.m_useCounter = 1;
        }

        public Object getKey() {
            return this.m_key;
        }

        public void retire(long currentAccessCounter, int cacheSize) {
            this.m_cachedObject = new WeakReference<Object>(this.m_cachedObject);
            this.m_isWeak = true;
        }

        public synchronized void restore(Object value) {
            this.m_cachedObject = value;
            this.m_isWeak = false;
        }

        public Object getChachedObject(long accessCounter) {
            ++this.m_useCounter;
            return this.getCachedObject();
        }

        public synchronized Object getCachedObject() {
            if (this.isWeak()) {
                return ((WeakReference)this.m_cachedObject).get();
            }
            return this.m_cachedObject;
        }

        public boolean isWeak() {
            return this.m_isWeak;
        }

        public int getUseCounter() {
            return this.m_useCounter;
        }

        public long getFetchAccessCounter() {
            return this.m_fetchAccessCounter;
        }

        public int calculateScore(long accessCounter, int size, int multiplier) {
            int useCountFactor = this.m_useCounter < 10 ? this.m_useCounter * this.m_useCounter : 100;
            return (int)((accessCounter - this.m_fetchAccessCounter) * (long)multiplier / (long)(useCountFactor * size));
        }
    }
}

