/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.impl.util.appledouble;

import com.documentum.fc.impl.util.appledouble.DfAppleDoubleHeader;
import com.documentum.fc.impl.util.appledouble.DfAppleDoubleHeaderData;
import com.documentum.fc.impl.util.appledouble.DfEntryDescriptor;
import com.documentum.fc.impl.util.appledouble.DfExtendedFinderInfo;
import com.documentum.fc.impl.util.appledouble.DfFileAttributes;
import com.documentum.fc.impl.util.appledouble.DfFinderInfo;
import com.documentum.fc.impl.util.appledouble.DfResourceFork;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.SimpleTimeZone;

public class DfAppleDoubleHeaderParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DfAppleDoubleHeader parse(String filename) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        DfAppleDoubleHeader adHeader = null;
        try {
            adHeader = this.readHeader(raf);
        }
        finally {
            try {
                raf.close();
            }
            catch (Exception intentionallyIgnored) {}
        }
        return adHeader;
    }

    private DfAppleDoubleHeader readHeader(RandomAccessFile raf) throws IOException {
        DfAppleDoubleHeaderData headerData = new DfAppleDoubleHeaderData(raf);
        DfAppleDoubleHeader adHeader = null;
        adHeader = headerData.getDescriptors().length == 2 ? new DfAppleDoubleHeader(false) : new DfAppleDoubleHeader(true);
        adHeader.setHeaderData(headerData);
        block8: for (int i = 0; i < headerData.getDescriptors().length; ++i) {
            DfEntryDescriptor descriptor = headerData.getDescriptors()[i];
            switch (descriptor.getEntryID()) {
                case 2: {
                    DfResourceFork dmDescriptor = new DfResourceFork(raf, descriptor);
                    adHeader.setResourceFork(dmDescriptor.getBytes());
                    continue block8;
                }
                case 3: {
                    adHeader.setFilename(this.readDescriptorString(raf, descriptor));
                    continue block8;
                }
                case 4: {
                    adHeader.setComment(this.readDescriptorString(raf, descriptor));
                    continue block8;
                }
                case 8: {
                    adHeader.setCreationDate(this.readDescriptorDate(raf, descriptor, 0));
                    adHeader.setModificationDate(this.readDescriptorDate(raf, descriptor, 1));
                    adHeader.setBackupDate(this.readDescriptorDate(raf, descriptor, 2));
                    adHeader.setAccessDate(this.readDescriptorDate(raf, descriptor, 3));
                    continue block8;
                }
                case 9: {
                    adHeader.setFinderInfo(new DfFinderInfo(raf, descriptor));
                    adHeader.setExtendedFinderInfo(new DfExtendedFinderInfo(raf, descriptor));
                    continue block8;
                }
                case 10: {
                    adHeader.setFileAttributes(new DfFileAttributes(raf, descriptor));
                }
            }
        }
        return adHeader;
    }

    private String readDescriptorString(RandomAccessFile raf, DfEntryDescriptor descriptor) throws IOException {
        raf.seek(0L);
        raf.seek(descriptor.getOffset());
        byte[] buf1 = new byte[descriptor.getDataLength()];
        raf.read(buf1);
        return new String(buf1).trim();
    }

    private Calendar readDescriptorDate(RandomAccessFile raf, DfEntryDescriptor descriptor, int dateOffset) throws IOException {
        raf.seek(0L);
        raf.seek(descriptor.getOffset() + dateOffset * 4);
        int dateSeconds = raf.readInt();
        if (Integer.toHexString(dateSeconds).equals("80000000")) {
            return null;
        }
        Calendar date = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
        date.set(1, 2000);
        date.set(2, 0);
        date.set(5, 1);
        date.set(10, 0);
        date.set(12, 0);
        date.set(13, 0);
        date.add(13, dateSeconds);
        return date;
    }
}

