/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.impl.util;

public class UTF8Util {
    public static final char SURROGATE_MIN = '\ud800';
    public static final char SURROGATE_MAX = '\udfff';

    public static boolean isSurrogate(int c) {
        return 55296 <= c && c <= 57343;
    }

    public static int calculateMaximumAllowedChars(String value, int maximumAllowedBytes) {
        assert (value != null);
        int lengthInBytes = 0;
        int lengthInChars = 0;
        int limit = value.length();
        for (int i = 0; i < limit; ++i) {
            char charNum = value.charAt(i);
            lengthInBytes = charNum <= '\u007f' ? ++lengthInBytes : (charNum <= '\u07ff' ? (lengthInBytes += 2) : (lengthInBytes += 3));
            if (lengthInBytes > maximumAllowedBytes) break;
            ++lengthInChars;
        }
        return lengthInChars;
    }

    public static int calculateEncodedLength(String value) {
        assert (value != null);
        int lengthInBytes = 0;
        int limit = value.length();
        for (int i = 0; i < limit; ++i) {
            char charNum = value.charAt(i);
            if (charNum <= '\u007f') {
                ++lengthInBytes;
                continue;
            }
            if (charNum <= '\u07ff') {
                lengthInBytes += 2;
                continue;
            }
            if (UTF8Util.isSurrogate(charNum)) {
                lengthInBytes += 2;
                continue;
            }
            lengthInBytes += 3;
        }
        return lengthInBytes;
    }
}

