/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.impl.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SoftValueMap<K, V>
implements Map {
    private final Map<K, Entry<K, V>> m_map;
    private final ReferenceQueue m_queue;

    public SoftValueMap() {
        this.m_map = new HashMap<K, Entry<K, V>>();
        this.m_queue = new ReferenceQueue();
    }

    public SoftValueMap(int initialCapacity) {
        this.m_map = new HashMap<K, Entry<K, V>>(initialCapacity);
        this.m_queue = new ReferenceQueue();
    }

    public SoftValueMap(int initialCapacity, float loadFactor) {
        this.m_map = new HashMap<K, Entry<K, V>>(initialCapacity, loadFactor);
        this.m_queue = new ReferenceQueue();
    }

    @Override
    public int hashCode() {
        return ((Object)this.m_map).hashCode();
    }

    @Override
    public int size() {
        this.cleanup();
        return this.m_map.size();
    }

    @Override
    public void clear() {
        this.m_map.clear();
    }

    @Override
    public boolean isEmpty() {
        this.cleanup();
        return this.m_map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.cleanup();
        return this.m_map.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new RuntimeException("Feature is not implemented");
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.m_map).equals(o);
    }

    public Collection values() {
        throw new RuntimeException("Feature is not implemented");
    }

    public void putAll(Map t) {
        throw new RuntimeException("Feature is not implemented");
    }

    public Set entrySet() {
        throw new RuntimeException("Feature is not implemented");
    }

    public Set keySet() {
        throw new RuntimeException("Feature is not implemented");
    }

    public Object get(Object key) {
        Entry<K, V> ref = this.m_map.get(key);
        this.cleanup();
        return ref != null ? ref.get() : null;
    }

    public Object remove(Object key) {
        Entry<K, V> entry = this.m_map.remove(key);
        Object removedObject = null;
        if (entry != null) {
            removedObject = entry.get();
            entry.clear();
        }
        return removedObject;
    }

    public Object put(Object key, Object value) {
        this.cleanup();
        return this.m_map.put(key, new Entry(key, value, this.m_queue));
    }

    public void cleanup() {
        Entry entry;
        while ((entry = (Entry)this.m_queue.poll()) != null) {
            Object key = entry.getKey();
            if (key == null) continue;
            this.m_map.remove(key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<K, V>
    extends SoftReference {
        private final Reference m_key;

        Entry(Object key, Object ref, ReferenceQueue refQueue) {
            super(ref, refQueue);
            this.m_key = new SoftReference<Object>(key);
        }

        public Object getKey() {
            return this.m_key.get();
        }
    }
}

