/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.impl.util;

import com.documentum.fc.client.impl.bof.classmgmt.ModuleManager;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfRuntimeException;
import com.documentum.fc.impl.util.PBEUtils;
import com.documentum.operations.common.DfBase64Decoder;
import com.documentum.operations.common.DfBase64Encoder;
import com.documentum.operations.common.DfBase64FormatException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RegistryPasswordUtils {
    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                System.err.println("usage: java <password>");
                System.exit(1);
            }
            System.out.println(RegistryPasswordUtils.encrypt(args[0]));
        }
        catch (DfException e) {
            e.printStackTrace();
        }
    }

    public static String encrypt(String password) throws DfException {
        try {
            return RegistryPasswordUtils.encryptUnchecked(password);
        }
        catch (DfRuntimeException e) {
            throw new DfException(e.getCause());
        }
    }

    public static String encryptUnchecked(String password) {
        try {
            byte[] encypted = PBEUtils.getInstance().encrypt(ModuleManager.DEFAULT_PASS_PHRASE, password.getBytes());
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            new DfBase64Encoder(new ByteArrayInputStream(encypted), os).process();
            return os.toString();
        }
        catch (Exception e) {
            throw new DfRuntimeException("Failed to encrypt password", e);
        }
    }

    public static String decrypt(String password) throws DfException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            new DfBase64Decoder(new ByteArrayInputStream(password.getBytes()), os).process();
            byte[] decrypted = PBEUtils.getInstance().decrypt(ModuleManager.DEFAULT_PASS_PHRASE, os.toByteArray());
            return new String(decrypted);
        }
        catch (IOException e) {
            throw new DfException(e);
        }
        catch (DfBase64FormatException e) {
            throw new DfException(e);
        }
    }
}

