/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.impl.util;

import com.documentum.fc.common.DfCriticalException;
import com.documentum.fc.common.DfException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class DfSimpleEncoderDecoder {
    private static char[] s_Base64Alphabet;
    private static byte[] m_Base64Codes;

    public static char[] base64Encode(byte[] data) {
        char[] out = new char[(data.length + 2) / 3 * 4];
        int i = 0;
        int index = 0;
        while (i < data.length) {
            boolean quad = false;
            boolean trip = false;
            int val = 0xFF & data[i];
            val <<= 8;
            if (i + 1 < data.length) {
                val |= 0xFF & data[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < data.length) {
                val |= 0xFF & data[i + 2];
                quad = true;
            }
            out[index + 3] = s_Base64Alphabet[quad ? val & 0x3F : 64];
            out[index + 2] = s_Base64Alphabet[trip ? (val >>= 6) & 0x3F : 64];
            out[index + 1] = s_Base64Alphabet[(val >>= 6) & 0x3F];
            out[index + 0] = s_Base64Alphabet[(val >>= 6) & 0x3F];
            i += 3;
            index += 4;
        }
        return out;
    }

    public static byte[] base64Decode(char[] data) {
        int tempLen = data.length;
        for (int ix = 0; ix < data.length; ++ix) {
            if (data[ix] <= '\u00ff' && m_Base64Codes[data[ix]] >= 0) continue;
            --tempLen;
        }
        int len = tempLen / 4 * 3;
        if (tempLen % 4 == 3) {
            len += 2;
        }
        if (tempLen % 4 == 2) {
            ++len;
        }
        byte[] out = new byte[len];
        int shift = 0;
        int accum = 0;
        int index = 0;
        for (int ix = 0; ix < data.length; ++ix) {
            int value;
            int n = value = data[ix] > '\u00ff' ? -1 : m_Base64Codes[data[ix]];
            if (value < 0) continue;
            accum <<= 6;
            accum |= value;
            if ((shift += 6) < 8) continue;
            out[index++] = (byte)(accum >> (shift -= 8) & 0xFF);
        }
        if (index != out.length) {
            throw new DfCriticalException("Corrupted Base 64 array");
        }
        return out;
    }

    public static String serializeObjectToString(Object object) throws DfException {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream objStream = new ObjectOutputStream(byteStream);
            objStream.writeObject(object);
            objStream.flush();
            return new String(DfSimpleEncoderDecoder.base64Encode(byteStream.toByteArray()));
        }
        catch (Exception e) {
            throw DfException.newSerializeFailedException(object, e);
        }
    }

    public static Object deserializeObjectFromString(String image) throws DfException {
        try {
            ByteArrayInputStream byteStream = new ByteArrayInputStream(DfSimpleEncoderDecoder.base64Decode(image.toCharArray()));
            ObjectInputStream objStream = new ObjectInputStream(byteStream);
            return objStream.readObject();
        }
        catch (Exception e) {
            throw DfException.newDeserializeFailedException(image, e);
        }
    }

    static {
        int i;
        s_Base64Alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
        m_Base64Codes = new byte[256];
        for (i = 0; i < 256; ++i) {
            DfSimpleEncoderDecoder.m_Base64Codes[i] = -1;
        }
        for (i = 65; i <= 90; ++i) {
            DfSimpleEncoderDecoder.m_Base64Codes[i] = (byte)(i - 65);
        }
        for (i = 97; i <= 122; ++i) {
            DfSimpleEncoderDecoder.m_Base64Codes[i] = (byte)(26 + i - 97);
        }
        for (i = 48; i <= 57; ++i) {
            DfSimpleEncoderDecoder.m_Base64Codes[i] = (byte)(52 + i - 48);
        }
        DfSimpleEncoderDecoder.m_Base64Codes[43] = 62;
        DfSimpleEncoderDecoder.m_Base64Codes[47] = 63;
    }
}

