/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.impl.util;

import com.documentum.fc.common.DfException;
import com.documentum.fc.impl.util.DfMacUtilHelper;
import com.documentum.fc.impl.util.appledouble.DfAppleDoubleHeader;
import com.documentum.fc.impl.util.appledouble.DfAppleDoubleHeaderParser;
import com.documentum.fc.impl.util.appledouble.DfExtendedFinderInfo;
import com.documentum.fc.impl.util.appledouble.DfFinderInfo;
import glguerin.io.FileHelper;
import glguerin.io.RandomRW;
import glguerin.io.RandomRWFile;
import glguerin.io.RandomRWInputStream;
import glguerin.macbinary.MacBinaryHeader;
import glguerin.macbinary.MacBinaryPiecer;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.Date;

public class DfMacUtils {
    private static DfAppleDoubleHeader createSimpleAppleDoubleHeader(String macFileType, String macCreatorType, boolean os9Format) {
        DfAppleDoubleHeader header = new DfAppleDoubleHeader(os9Format);
        DfFinderInfo finderInfo = new DfFinderInfo();
        finderInfo.setCreator(macCreatorType);
        finderInfo.setFileType(macFileType);
        header.setFinderInfo(finderInfo);
        DfExtendedFinderInfo extInfo = new DfExtendedFinderInfo();
        header.setExtendedFinderInfo(extInfo);
        return header;
    }

    public static File createSimpleAppleDoubleHeaderFile(String macFileType, String macCreatorType, File dataFile, File headerFile, boolean os9Format) throws DfException {
        DfAppleDoubleHeader simpleHeader = DfMacUtils.createSimpleAppleDoubleHeader(macFileType, macCreatorType, os9Format);
        long modify = dataFile.lastModified();
        Calendar modificationDate = Calendar.getInstance();
        Date theDate = new Date();
        theDate.setTime(modify);
        modificationDate.setTime(theDate);
        simpleHeader.setModificationDate(modificationDate);
        simpleHeader.setCreationDate(modificationDate);
        simpleHeader.setFilename(dataFile.getName());
        try {
            RandomAccessFile raf = new RandomAccessFile(headerFile, "rw");
            simpleHeader.write(raf);
            raf.close();
        }
        catch (IOException ioe) {
            DfException exception = new DfException();
            exception.setMessage(ioe.getMessage());
            throw exception;
        }
        return headerFile;
    }

    public static void createSimpleAppleDoubleHeaderStream(DataOutputStream dos, String macFileType, String macCreatorType, File dataFile, boolean os9Format) throws DfException {
        try {
            DfAppleDoubleHeader simpleHeader = DfMacUtils.createSimpleAppleDoubleHeader(macFileType, macCreatorType, os9Format);
            Date theDate = new Date();
            Calendar modificationDate = Calendar.getInstance();
            modificationDate.setTime(theDate);
            simpleHeader.setModificationDate(modificationDate);
            simpleHeader.setCreationDate(modificationDate);
            String dataFileName = null;
            dataFileName = dataFile == null ? "unknown" : dataFile.getName();
            simpleHeader.setFilename(dataFileName);
            simpleHeader.write(dos);
        }
        catch (IOException e) {
            DfException excp = new DfException();
            excp.setMessage(e.getMessage());
            throw excp;
        }
    }

    public static String getMacFileType(String resourceForkPath) throws DfException {
        try {
            DfFinderInfo finderInfo = DfMacUtils.getFinderInfo(resourceForkPath);
            if (finderInfo == null) {
                return null;
            }
            String macFileType = finderInfo.getOSFileTypeString();
            DfMacUtils.validateFinderInfoData(macFileType, resourceForkPath);
            return macFileType;
        }
        catch (IOException e) {
            DfException dfException = new DfException();
            String message = "Header format of resource file " + resourceForkPath + " is invalid. ";
            if (e.getMessage() != null) {
                message = message + e.getMessage();
            }
            dfException.setMessage(message);
            throw dfException;
        }
    }

    public static String getMacCreatorType(String resourceForkPath) throws DfException {
        try {
            DfFinderInfo finderInfo = DfMacUtils.getFinderInfo(resourceForkPath);
            if (finderInfo == null) {
                return null;
            }
            String crttype = finderInfo.getOSCreatorString();
            DfMacUtils.validateFinderInfoData(crttype, resourceForkPath);
            return crttype;
        }
        catch (IOException e) {
            DfException dfException = new DfException();
            String message = "Header format of resource file " + resourceForkPath + " is invalid. ";
            if (e.getMessage() != null) {
                message = message + e.getMessage();
            }
            dfException.setMessage(message);
            throw dfException;
        }
    }

    private static void validateFinderInfoData(String data, String resourceForkPath) throws DfException {
        boolean resNotDamaged = DfMacUtilHelper.readableStringValue(data);
        if (!resNotDamaged) {
            DfException dfException = new DfException();
            dfException.setMessage("Header of resource file " + resourceForkPath + " is damaged");
            throw dfException;
        }
    }

    private static DfFinderInfo getFinderInfo(String macResFilePath) throws IOException {
        if (macResFilePath != null) {
            File resFile = new File(macResFilePath);
            if (!resFile.exists()) {
                return null;
            }
            DfAppleDoubleHeaderParser parser = new DfAppleDoubleHeaderParser();
            DfAppleDoubleHeader header = parser.parse(macResFilePath);
            return header.getFinderInfo();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File extractAppleDoubleHeaderFromMacBinary(File macBinaryFile, String macResFilePath, String dataFileName) throws DfException {
        if (macBinaryFile == null || !macBinaryFile.exists()) {
            DfException exception = new DfException();
            exception.setMessage("MacBinary file is not specfied or it does not exist. To extract apple doubleheader, mac binary file needs to be specified");
        }
        MacBinaryHeader macBinHeader = null;
        try {
            FileInputStream ins = new FileInputStream(macBinaryFile);
            try {
                MacBinaryHeader header;
                ins.mark(130);
                byte[] bytes = new byte[128];
                ins.read(bytes);
                macBinHeader = header = new MacBinaryHeader(bytes);
                macBinHeader.loadNameAndEncoding();
            }
            finally {
                ins.close();
            }
        }
        catch (Exception e) {
            DfException excp = new DfException();
            excp.setMessage("Macbinary format not recognized. " + e.getMessage());
            throw excp;
        }
        int macBinaryFormat = macBinHeader.checkFormat(false);
        if (macBinaryFormat != 3) {
            DfException excp = new DfException();
            excp.setMessage("Macbinary format not recognized.");
            throw excp;
        }
        long resourceLength = macBinHeader.getForkLength(true);
        if (resourceLength > 0L) {
            DfAppleDoubleHeader header = new DfAppleDoubleHeader(true);
            header.setFilename(dataFileName);
            Calendar modificationDate = Calendar.getInstance();
            Date theDate = new Date();
            theDate.setTime(macBinHeader.getTimeModified());
            modificationDate.setTime(theDate);
            header.setModificationDate(modificationDate);
            Calendar createDate = Calendar.getInstance();
            theDate = new Date();
            theDate.setTime(macBinHeader.getTimeCreated());
            createDate.setTime(theDate);
            header.setCreationDate(createDate);
            DfFinderInfo finderInfo = new DfFinderInfo();
            finderInfo.setCreator(macBinHeader.getFileCreator());
            finderInfo.setFileType(macBinHeader.getFileType());
            finderInfo.setFlags((short)macBinHeader.getFinderFlags());
            header.setFinderInfo(finderInfo);
            DfExtendedFinderInfo extInfo = new DfExtendedFinderInfo();
            header.setExtendedFinderInfo(extInfo);
            byte[] resourceForkBytes = null;
            File tempResourceForkFile = null;
            try {
                tempResourceForkFile = new File(macBinaryFile.getParentFile(), new Long(new Date().getTime()).toString() + macBinaryFile.getName());
                RandomRWFile in = null;
                try {
                    in = new RandomRWFile(macBinaryFile, false);
                    MacBinaryPiecer pieces = new MacBinaryPiecer((RandomRW)in, true);
                    OutputStream rscout = null;
                    RandomRWInputStream rscin = null;
                    try {
                        rscout = new FileOutputStream(tempResourceForkFile);
                        rscin = new RandomRWInputStream(pieces.getForkPiece(true));
                        FileHelper.writeAllThenClose((InputStream)rscin, (OutputStream)rscout, (byte[])new byte[16384]);
                    }
                    finally {
                        rscout.close();
                    }
                }
                catch (Throwable th) {
                    DfException excp = new DfException();
                    excp.setMessage("Can not split the MacBinary. " + th.getMessage());
                    throw excp;
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
                RandomAccessFile resrc = new RandomAccessFile(tempResourceForkFile, "r");
                try {
                    resrc.seek(0L);
                    resourceForkBytes = new byte[(int)resrc.length()];
                    resrc.readFully(resourceForkBytes);
                }
                finally {
                    resrc.close();
                }
            }
            catch (Exception e) {
                DfException excp = new DfException();
                excp.setMessage("Resource Fork can not be read. " + e.getMessage());
                throw excp;
            }
            finally {
                if (tempResourceForkFile != null) {
                    tempResourceForkFile.delete();
                }
            }
            if (resourceForkBytes != null) {
                header.setResourceFork(resourceForkBytes);
            }
            File adpFile = null;
            try {
                adpFile = new File(macResFilePath);
                RandomAccessFile raf = new RandomAccessFile(adpFile, "rw");
                header.write(raf);
                raf.close();
            }
            catch (IOException ioe) {
                DfException excp = new DfException();
                excp.setMessage("IO exception encountered during creation of apple double resource fork. " + ioe.getMessage());
                throw excp;
            }
            return adpFile;
        }
        DfException excp = new DfException();
        excp.setMessage("MacBinary file does not include Resource Information.");
        throw excp;
    }
}

