/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.common.impl.preferences;

import com.documentum.fc.client.DfPreferenceException;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.IDfAttr;
import com.documentum.fc.common.impl.preferences.PreferencesManager;
import com.documentum.fc.common.impl.preferences.TypedPreferences;
import com.documentum.fc.impl.util.RegistryPasswordUtils;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class PreferencesMBean
implements DynamicMBean,
NotificationBroadcaster {
    private final PreferencesManager m_manager;
    private final String m_description;
    private final TypedPreferences m_preferences;
    private final Properties m_modifiedAttributes;
    private final NotificationBroadcasterSupport m_broadcaster;
    private static final String PERSIST_ACTION;
    private static final String PERSIST_AND_MAKE_ACTIVE_ACTION;
    private static final Comparator<? super OpenMBeanAttributeInfo> ATTRIBUTE_COMPARATOR;
    private static int m_sequenceNumber;
    private static ArrayList<String> s_JMXPreferences;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;

    public PreferencesMBean(PreferencesManager manager, TypedPreferences preferences, String description) {
        PreferencesManager preferencesManager = manager;
        TypedPreferences typedPreferences = preferences;
        String string = description;
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{preferencesManager, typedPreferences, string};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_modifiedAttributes = new Properties();
            this.m_broadcaster = new NotificationBroadcasterSupport();
            assert (null != manager) : "PreferencesManager argument cannot be null";
            assert (null != preferences) : "Preferences argument cannot be null";
            this.m_manager = manager;
            this.m_preferences = preferences;
            this.m_description = description;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{preferencesManager, typedPreferences, string};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{preferencesManager, typedPreferences, string};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            Comparable<Boolean> comparable;
            Comparable<Boolean> comparable2;
            void name;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            try {
                Object[] value;
                int attrDataType = this.m_preferences.getAttrDataType((String)name);
                switch (attrDataType) {
                    case 0: {
                        if (this.m_preferences.isAttrRepeating((String)name)) {
                            int count = this.m_preferences.getValueCount((String)name);
                            Object[] values = new Object[count];
                            for (int i = 0; i < count; ++i) {
                                values[i] = this.m_preferences.getRepeatingBoolean((String)name, i);
                            }
                            value = values;
                            break;
                        }
                        value = this.m_preferences.getBoolean((String)name);
                        break;
                    }
                    case 5: {
                        if (this.m_preferences.isAttrRepeating((String)name)) {
                            int count = this.m_preferences.getValueCount((String)name);
                            Object[] values = new Object[count];
                            for (int i = 0; i < count; ++i) {
                                values[i] = this.m_preferences.getRepeatingDouble((String)name, i);
                            }
                            value = values;
                            break;
                        }
                        value = this.m_preferences.getDouble((String)name);
                        break;
                    }
                    case 1: {
                        if (this.m_preferences.isAttrRepeating((String)name)) {
                            int count = this.m_preferences.getValueCount((String)name);
                            Object[] values = new Object[count];
                            for (int i = 0; i < count; ++i) {
                                values[i] = this.m_preferences.getRepeatingInt((String)name, i);
                            }
                            value = values;
                            break;
                        }
                        value = this.m_preferences.getInt((String)name);
                        break;
                    }
                    case 2: {
                        if (this.m_preferences.isAttrRepeating((String)name)) {
                            int count = this.m_preferences.getValueCount((String)name);
                            Object[] values = new Object[count];
                            for (int i = 0; i < count; ++i) {
                                values[i] = this.m_preferences.getRepeatingString((String)name, i);
                            }
                            value = values;
                            break;
                        }
                        if (PreferencesManager.isPasswordAttribute((String)name)) {
                            value = RegistryPasswordUtils.encrypt(this.m_preferences.getString((String)name));
                            break;
                        }
                        value = this.m_preferences.getString((String)name);
                        break;
                    }
                    case 4: {
                        if (this.m_preferences.isAttrRepeating((String)name)) {
                            int count = this.m_preferences.getValueCount((String)name);
                            Object[] values = new Object[count];
                            for (int i = 0; i < count; ++i) {
                                values[i] = this.m_preferences.getRepeatingTime((String)name, i).getDate();
                            }
                            value = values;
                            break;
                        }
                        value = this.m_preferences.getTime((String)name).getDate();
                        break;
                    }
                    default: {
                        throw new DfException("Unable to identify type for attribute: " + (String)name);
                    }
                }
                comparable2 = value;
            }
            catch (DfException e) {
                DfLogger.getLogger(PreferencesMBean.class).warn((Object)("Unable to obtain value for attribute: " + (String)name), (Throwable)e);
                throw new AttributeNotFoundException("Unable to obtain value for attribute: " + (String)name);
            }
            Comparable<Boolean> comparable3 = comparable = comparable2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(comparable, joinPoint);
            }
            return comparable2;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Attribute attribute2 = attribute;
        JoinPoint joinPoint = null;
        try {
            void attribute3;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)attribute2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.checkForJMXAttributes(attribute3.getName());
            Object oldValue = this.setAttributeValue(attribute3.getName(), attribute3.getValue());
            this.m_broadcaster.sendNotification(new AttributeChangeNotification(this, ++m_sequenceNumber, System.currentTimeMillis(), attribute3.getName() + " value changed", attribute3.getName(), String.class.getName(), oldValue.toString(), attribute3.getValue()));
            Object var5_5 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)attribute2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var5_5, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)attribute2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public AttributeList getAttributes(String[] stringArray) {
        String[] stringArray2 = stringArray;
        JoinPoint joinPoint = null;
        try {
            AttributeList attributeList;
            AttributeList attributeList2;
            AttributeList attributeList3;
            block11: {
                void attributes;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)stringArray2);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                AttributeList attributeList4 = new AttributeList();
                for (void name : attributes) {
                    try {
                        Object value = this.getAttribute((String)name);
                        attributeList4.add(new Attribute((String)name, value));
                    }
                    catch (Exception e) {
                        DfLogger.getLogger(this.getClass()).warn((Object)("Error getting typed value for attribute: " + (String)name), (Throwable)e);
                        attributeList2 = attributeList3 = new AttributeList();
                        break block11;
                    }
                }
                attributeList2 = attributeList3 = attributeList4;
            }
            AttributeList attributeList5 = attributeList = attributeList2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)stringArray2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(attributeList, joinPoint);
            }
            return attributeList3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)stringArray2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public AttributeList setAttributes(AttributeList attributeList) {
        AttributeList attributeList2 = attributeList;
        JoinPoint joinPoint = null;
        try {
            AttributeList attributeList3;
            AttributeList attributeList4;
            void attributes;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)attributeList2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            AttributeList results = new AttributeList();
            for (Object object : attributes) {
                Attribute attribute = (Attribute)object;
                try {
                    this.setAttributeValue(attribute.getName(), attribute.getValue());
                    results.add(attribute);
                }
                catch (OperationsException e) {}
            }
            AttributeList attributeList5 = attributeList4 = (attributeList3 = results);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)attributeList2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(attributeList4, joinPoint);
            }
            return attributeList3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)attributeList2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected OpenType lookupDataTypeClass(int n) {
        int n2 = n;
        JoinPoint joinPoint = null;
        try {
            SimpleType<Object> simpleType;
            SimpleType<Object> simpleType2;
            SimpleType<Object> dataTypeClass;
            void type;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            switch (type) {
                case 0: {
                    dataTypeClass = SimpleType.BOOLEAN;
                    break;
                }
                case 5: {
                    dataTypeClass = SimpleType.DOUBLE;
                    break;
                }
                case 1: {
                    dataTypeClass = SimpleType.INTEGER;
                    break;
                }
                case 2: {
                    dataTypeClass = SimpleType.STRING;
                    break;
                }
                case 4: {
                    dataTypeClass = SimpleType.DATE;
                    break;
                }
                default: {
                    dataTypeClass = null;
                }
            }
            SimpleType<Object> simpleType3 = simpleType2 = (simpleType = dataTypeClass);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(simpleType2, joinPoint);
            }
            return simpleType;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        NotificationListener notificationListener2 = notificationListener;
        NotificationFilter notificationFilter2 = notificationFilter;
        Object object2 = object;
        JoinPoint joinPoint = null;
        try {
            void handback;
            void filter;
            void listener;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{notificationListener2, notificationFilter2, object2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_broadcaster.addNotificationListener((NotificationListener)listener, (NotificationFilter)filter, handback);
            Object var10_9 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{notificationListener2, notificationFilter2, object2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var10_9, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{notificationListener2, notificationFilter2, object2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        JoinPoint joinPoint = null;
        try {
            MBeanNotificationInfo[] mBeanNotificationInfoArray;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            MBeanNotificationInfo[] mBeanNotificationInfoArray2 = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, AttributeChangeNotification.class.getName(), "Preferences attribute change notification.")};
            MBeanNotificationInfo[] mBeanNotificationInfoArray3 = mBeanNotificationInfoArray = mBeanNotificationInfoArray2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(mBeanNotificationInfoArray, joinPoint);
            }
            return mBeanNotificationInfoArray2;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        NotificationListener notificationListener2 = notificationListener;
        JoinPoint joinPoint = null;
        try {
            void listener;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)notificationListener2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_broadcaster.removeNotificationListener((NotificationListener)listener);
            Object var4_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)notificationListener2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var4_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)notificationListener2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        String string2 = string;
        Object[] objectArray2 = objectArray;
        String[] stringArray2 = stringArray;
        JoinPoint joinPoint = null;
        try {
            Object var11_10;
            Object v1;
            Object var10_9;
            void actionName;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray3 = new Object[]{string2, objectArray2, stringArray2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray3);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (PERSIST_ACTION.equals(actionName)) {
                this.m_manager.persistChanges(this.m_modifiedAttributes);
                this.m_modifiedAttributes.clear();
                v1 = var10_9 = null;
            } else if (PERSIST_AND_MAKE_ACTIVE_ACTION.equals(actionName)) {
                this.m_manager.persistAndApplyChanges(this.m_modifiedAttributes);
                this.m_modifiedAttributes.clear();
                v1 = var10_9 = null;
            } else {
                throw new ReflectionException(new NoSuchMethodException((String)actionName));
            }
            Object v2 = var11_10 = v1;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray4 = new Object[]{string2, objectArray2, stringArray2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray4);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var11_10, joinPoint);
            }
            return var10_9;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray5 = new Object[]{string2, objectArray2, stringArray2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray5);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Object setAttributeValue(String string, Object object) throws AttributeNotFoundException, InvalidAttributeValueException {
        String string2 = string;
        Object object2 = object;
        JoinPoint joinPoint = null;
        try {
            String string3;
            String string4;
            String oldValue;
            void name;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string2, (Object)object2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            try {
                if (this.m_preferences.isAttrRepeating((String)name)) {
                    throw new InvalidAttributeValueException("Repeating attributes cannot be set using JMX yet");
                }
                oldValue = this.m_preferences.getString((String)name);
            }
            catch (DfException e) {
                throw new AttributeNotFoundException(e.getMessage());
            }
            try {
                void value;
                String stringValue = value.toString();
                this.m_preferences.setString((String)name, stringValue);
                this.m_modifiedAttributes.put((Object)name, this.m_preferences.getString((String)name));
            }
            catch (DfException e) {
                throw new InvalidAttributeValueException(e.getMessage());
            }
            String string5 = string4 = (string3 = oldValue);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string2, (Object)object2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string4, joinPoint);
            }
            return string3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string2, (Object)object2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public MBeanInfo getMBeanInfo() {
        JoinPoint joinPoint = null;
        try {
            OpenMBeanInfoSupport openMBeanInfoSupport;
            OpenMBeanInfoSupport openMBeanInfoSupport2;
            OpenMBeanInfoSupport openMBeanInfoSupport3;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            try {
                Enumeration attributeEnumeration = this.m_preferences.enumAttrs();
                ArrayList<OpenMBeanAttributeInfoSupport> attributesList = new ArrayList<OpenMBeanAttributeInfoSupport>();
                boolean allowsPersistence = this.m_manager.allowsPersistence(this.m_preferences);
                while (attributeEnumeration.hasMoreElements()) {
                    ArrayType dataTypeClass;
                    IDfAttr attribute = (IDfAttr)attributeEnumeration.nextElement();
                    String name = attribute.getName();
                    TypedPreferences.PreferenceMetadata preferenceMetadata = this.m_preferences.getPreference(name, true);
                    String description = this.getPreferenceMetadata(preferenceMetadata);
                    boolean isChangeable = allowsPersistence || preferenceMetadata.isDynamic();
                    int type = attribute.getDataType();
                    if (preferenceMetadata.isDeprecated() || null == (dataTypeClass = this.lookupDataTypeClass(type))) continue;
                    if (attribute.isRepeating()) {
                        dataTypeClass = new ArrayType(1, dataTypeClass);
                    }
                    attributesList.add(new OpenMBeanAttributeInfoSupport(name, description, dataTypeClass, true, isChangeable, 0 == type && !attribute.isRepeating()));
                }
                Collections.sort(attributesList, ATTRIBUTE_COMPARATOR);
                OpenMBeanOperationInfo[] mbeanOperationInfo = allowsPersistence ? new OpenMBeanOperationInfo[]{new OpenMBeanOperationInfoSupport(PERSIST_ACTION, "Save the preferences configuration to storage", null, SimpleType.VOID, 1), new OpenMBeanOperationInfoSupport(PERSIST_AND_MAKE_ACTIVE_ACTION, "Save the preferences configuration to storage and make active", null, SimpleType.VOID, 1)} : null;
                OpenMBeanAttributeInfo[] mbeanAttributeInfo = attributesList.toArray(new OpenMBeanAttributeInfo[0]);
                openMBeanInfoSupport2 = openMBeanInfoSupport3 = new OpenMBeanInfoSupport(this.getClass().getName(), this.m_description, mbeanAttributeInfo, null, mbeanOperationInfo, this.getNotificationInfo());
            }
            catch (Exception e) {
                DfLogger.getLogger(this.getClass()).warn((Object)"Unable to create MBeanInfo instance", (Throwable)e);
                openMBeanInfoSupport2 = openMBeanInfoSupport3 = null;
            }
            OpenMBeanInfoSupport openMBeanInfoSupport4 = openMBeanInfoSupport = openMBeanInfoSupport2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(openMBeanInfoSupport, joinPoint);
            }
            return openMBeanInfoSupport3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getPreferenceMetadata(TypedPreferences.PreferenceMetadata preferenceMetadata) {
        TypedPreferences.PreferenceMetadata preferenceMetadata2 = preferenceMetadata;
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            void preferenceMetadata3;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)preferenceMetadata2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String name = preferenceMetadata3.getName();
            String description = preferenceMetadata3.getDescription();
            URL preferenceOrigin = this.m_manager.getPreferenceOrigin(name);
            StringBuffer result = new StringBuffer();
            if (description != null && description.length() > 0) {
                result.append(description);
                result.append(' ');
            }
            result.append('(');
            if (preferenceOrigin == null) {
                result.append("defaulted");
            } else {
                result.append(preferenceOrigin.toExternalForm());
            }
            result.append(')');
            String string3 = string2 = (string = result.toString());
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)preferenceMetadata2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)preferenceMetadata2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkForJMXAttributes(String string) throws MBeanException {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            void attributeName;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (s_JMXPreferences.contains(attributeName)) {
                throw new MBeanException(DfPreferenceException.newNotProgrammaticException(this.m_preferences, (String)attributeName));
            }
            Object var4_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var4_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("PreferencesMBean.java", Class.forName("com.documentum.fc.common.impl.preferences.PreferencesMBean"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttribute", "com.documentum.fc.common.impl.preferences.PreferencesMBean", "java.lang.String:", "name:", "javax.management.AttributeNotFoundException:javax.management.MBeanException:javax.management.ReflectionException:", "java.lang.Object"), 62);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setAttribute", "com.documentum.fc.common.impl.preferences.PreferencesMBean", "javax.management.Attribute:", "attribute:", "javax.management.AttributeNotFoundException:javax.management.InvalidAttributeValueException:javax.management.MBeanException:javax.management.ReflectionException:", "void"), 170);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMBeanInfo", "com.documentum.fc.common.impl.preferences.PreferencesMBean", "", "", "", "javax.management.MBeanInfo"), 414);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getPreferenceMetadata", "com.documentum.fc.common.impl.preferences.PreferencesMBean", "com.documentum.fc.common.impl.preferences.TypedPreferences$PreferenceMetadata:", "preferenceMetadata:", "", "java.lang.String"), 496);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkForJMXAttributes", "com.documentum.fc.common.impl.preferences.PreferencesMBean", "java.lang.String:", "attributeName:", "javax.management.MBeanException:", "void"), 520);
        ajc$tjp_13 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.documentum.fc.common.impl.preferences.PreferencesMBean", "com.documentum.fc.common.impl.preferences.PreferencesManager:com.documentum.fc.common.impl.preferences.TypedPreferences:java.lang.String:", "manager:preferences:description:", ""), 548);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttributes", "com.documentum.fc.common.impl.preferences.PreferencesMBean", "[Ljava.lang.String;:", "attributes:", "", "javax.management.AttributeList"), 197);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setAttributes", "com.documentum.fc.common.impl.preferences.PreferencesMBean", "javax.management.AttributeList:", "attributes:", "", "javax.management.AttributeList"), 228);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "lookupDataTypeClass", "com.documentum.fc.common.impl.preferences.PreferencesMBean", "int:", "type:", "", "javax.management.openmbean.OpenType"), 260);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addNotificationListener", "com.documentum.fc.common.impl.preferences.PreferencesMBean", "javax.management.NotificationListener:javax.management.NotificationFilter:java.lang.Object:", "listener:filter:handback:", "java.lang.IllegalArgumentException:", "void"), 302);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNotificationInfo", "com.documentum.fc.common.impl.preferences.PreferencesMBean", "", "", "", "[Ljavax.management.MBeanNotificationInfo;"), 316);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeNotificationListener", "com.documentum.fc.common.impl.preferences.PreferencesMBean", "javax.management.NotificationListener:", "listener:", "javax.management.ListenerNotFoundException:", "void"), 341);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "invoke", "com.documentum.fc.common.impl.preferences.PreferencesMBean", "java.lang.String:[Ljava.lang.Object;:[Ljava.lang.String;:", "actionName:params:signature:", "javax.management.MBeanException:javax.management.ReflectionException:", "java.lang.Object"), 353);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setAttributeValue", "com.documentum.fc.common.impl.preferences.PreferencesMBean", "java.lang.String:java.lang.Object:", "name:value:", "javax.management.AttributeNotFoundException:javax.management.InvalidAttributeValueException:", "java.lang.Object"), 381);
        PERSIST_ACTION = "save".intern();
        PERSIST_AND_MAKE_ACTIVE_ACTION = "saveAndMakeActive".intern();
        ATTRIBUTE_COMPARATOR = new AttributeComparator(null);
        m_sequenceNumber = 1;
        s_JMXPreferences = new ArrayList();
        s_JMXPreferences.add("dfc.jmx.connector.port");
        s_JMXPreferences.add("dfc.jmx.connector.readonly.password");
        s_JMXPreferences.add("dfc.jmx.connector.readonly.user");
        s_JMXPreferences.add("dfc.jmx.connector.readwrite.password");
        s_JMXPreferences.add("dfc.jmx.connector.readwrite.user");
        s_JMXPreferences.add("dfc.jmx.mbeanserver.domain");
        s_JMXPreferences.add("dfc.jmx.mbean_server_provider");
    }

    static class 1 {
    }

    private static class AttributeComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = -6767547683876655240L;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        private AttributeComparator() {
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        /*
         * WARNING - void declaration
         */
        public int compare(Object object, Object object2) {
            Object object3 = object;
            Object object4 = object2;
            JoinPoint joinPoint = null;
            try {
                int n;
                int n2;
                void o2;
                void o1;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)object3, (Object)object4);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                assert (o1 instanceof OpenMBeanAttributeInfo) : "First argument passed to compare was not an OpenMBeanAttributeInfo instance: " + o1.getClass();
                assert (o2 instanceof OpenMBeanAttributeInfo) : "Second argument passed to compare was not an OpenMBeanAttributeInfo instance: " + o1.getClass();
                int n3 = n2 = (n = ((OpenMBeanAttributeInfo)o1).getName().compareTo(((OpenMBeanAttributeInfo)o2).getName()));
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    Object object5 = Conversions.intObject((int)n2);
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)object3, (Object)object4);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object5, joinPoint);
                }
                return n;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)object3, (Object)object4);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        /* synthetic */ AttributeComparator(1 x0) {
            AttributeComparator attributeComparator = this;
            1 var4_3 = x0;
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)var4_3);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)var4_3);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)var4_3);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        static {
            Factory factory = new Factory("PreferencesMBean.java", Class.forName("com.documentum.fc.common.impl.preferences.PreferencesMBean$AttributeComparator"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "compare", "com.documentum.fc.common.impl.preferences.PreferencesMBean$AttributeComparator", "java.lang.Object:java.lang.Object:", "o1:o2:", "", "int"), 537);
            ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("2", "com.documentum.fc.common.impl.preferences.PreferencesMBean$AttributeComparator", "", "", ""), 527);
            ajc$tjp_2 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1000", "com.documentum.fc.common.impl.preferences.PreferencesMBean$AttributeComparator", "com.documentum.fc.common.impl.preferences.PreferencesMBean$1:", "x0:", ""), 527);
        }
    }
}

