/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.common.impl;

import com.documentum.fc.common.DfPreferences;
import com.documentum.fc.common.DfUtil;
import com.documentum.fc.common.impl.GlobalResourceBundle;
import com.documentum.fc.common.impl.preferences.IPreferencesObserver;
import com.documentum.fc.common.impl.preferences.TypedPreferences;
import com.documentum.fc.impl.util.StringUtil;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public final class MessageHelper
implements Serializable {
    private String m_message;
    private String m_messageId;
    private Object[] m_arguments;
    private static boolean s_includeIdInMessage = true;
    private static boolean s_includeStackInMessage = false;
    private static boolean s_includeDecorationInToString = true;
    private static PreferencesObserver s_preferenceObserver = null;

    public MessageHelper(String message, Object[] arguments) {
        this.setMessage(message, arguments);
    }

    public MessageHelper(String message, Object[] arguments, ResourceBundle resourceBundle) {
        this.setMessage(message, arguments, resourceBundle);
    }

    public String getMessageWithStack(Throwable t) {
        String className;
        String stackTrace = MessageHelper.getStackTraceAsString(t);
        if (stackTrace.startsWith(className = this.getClass().getName())) {
            return stackTrace.substring(className.length() + 2);
        }
        return stackTrace;
    }

    public String getMessageWithoutStack() {
        if (MessageHelper.shouldIncludeIdInMessage() && !this.m_messageId.equals(this.m_message)) {
            if (this.m_messageId.startsWith("DM_")) {
                return "[" + this.m_messageId + "]" + MessageHelper.getSeverityString(this.m_messageId) + "  \"" + this.m_message + "\"";
            }
            return "[" + this.m_messageId + "] " + this.m_message;
        }
        return this.m_message;
    }

    private static String getSeverityString(String messageId) {
        if (messageId.indexOf("_E_") >= 0) {
            return "error:";
        }
        if (messageId.indexOf("_W_") >= 0) {
            return "warning:";
        }
        if (messageId.indexOf("_I_") >= 0) {
            return "info:";
        }
        if (messageId.indexOf("_F_") >= 0) {
            return "fatal:";
        }
        if (messageId.indexOf("_T_") >= 0) {
            return "info:";
        }
        if (messageId.startsWith("DM_")) {
            return "error:";
        }
        return "";
    }

    public String getMessageId() {
        return this.m_messageId;
    }

    public Object[] getArguments() {
        return this.m_arguments;
    }

    public void setMessage(String message, Object[] arguments) {
        this.setMessage(message, arguments, GlobalResourceBundle.getInstance());
    }

    private void setMessage(String message, Object[] arguments, ResourceBundle resourceBundle) {
        this.m_arguments = arguments;
        if (MessageHelper.isPreformatted(message = StringUtil.nullToEmpty(message))) {
            this.m_messageId = MessageHelper.extractMessageId(message);
            this.m_message = MessageHelper.extractMessage(message);
        } else {
            try {
                this.m_message = message.length() > 0 ? DfUtil.formatString(resourceBundle.getString(message), arguments) : message;
                this.m_messageId = message;
            }
            catch (MissingResourceException mre) {
                this.m_messageId = this.m_message = DfUtil.formatString(message, arguments);
            }
        }
    }

    private static boolean isPreformatted(String message) {
        return message.startsWith("[");
    }

    private static String extractMessageId(String message) {
        return message.substring(1, message.indexOf("]"));
    }

    private static String extractMessage(String message) {
        int messageBegin = 1;
        int messageEnd = message.length();
        int temp = message.indexOf("]", messageBegin);
        if (temp >= 0) {
            messageBegin = temp + 1;
        }
        if (message.charAt(messageEnd - 1) == '\n') {
            --messageEnd;
        }
        if ((temp = message.indexOf(":  ", messageBegin)) >= 0) {
            messageBegin = temp + 3;
        }
        if (message.charAt(messageBegin) == '\"') {
            ++messageBegin;
            if (message.charAt(messageEnd - 1) == '\"') {
                --messageEnd;
            }
        }
        return message.substring(messageBegin, messageEnd);
    }

    public static String getStackTraceAsString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public static void registerResourceBundle(ResourceBundle bundle) {
        GlobalResourceBundle.getInstance().add(bundle);
    }

    public static boolean shouldIncludeIdInMessage() {
        MessageHelper.activatePreferenceObserverIfNecessary();
        return s_includeIdInMessage;
    }

    public static boolean shouldIncludeStackInMessage() {
        MessageHelper.activatePreferenceObserverIfNecessary();
        return s_includeStackInMessage;
    }

    public static boolean shouldIncludeDecorationInToString() {
        MessageHelper.activatePreferenceObserverIfNecessary();
        return s_includeDecorationInToString;
    }

    private static synchronized void activatePreferenceObserverIfNecessary() {
        try {
            if (s_preferenceObserver == null && DfPreferences.isInstanceInitialized()) {
                s_preferenceObserver = new PreferencesObserver();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class PreferencesObserver
    implements IPreferencesObserver {
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        public PreferencesObserver() {
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                DfPreferences.getInstance().addObserver(this);
                this.update(DfPreferences.getInstance(), null);
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        /*
         * WARNING - void declaration
         */
        public void update(TypedPreferences typedPreferences, String string) {
            TypedPreferences typedPreferences2 = typedPreferences;
            String string2 = string;
            JoinPoint joinPoint = null;
            try {
                void typedPreferences3;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)typedPreferences2, (Object)string2);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                DfPreferences preferences = (DfPreferences)typedPreferences3;
                s_includeIdInMessage = preferences.getIncludeExceptionId();
                s_includeStackInMessage = preferences.getIncludeExceptionStack();
                s_includeDecorationInToString = preferences.getIncludeExceptionDecoration();
                Object var7_7 = null;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)typedPreferences2, (Object)string2);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var7_7, joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)typedPreferences2, (Object)string2);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        static {
            Factory factory = new Factory("MessageHelper.java", Class.forName("com.documentum.fc.common.impl.MessageHelper$PreferencesObserver"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "update", "com.documentum.fc.common.impl.MessageHelper$PreferencesObserver", "com.documentum.fc.common.impl.preferences.TypedPreferences:java.lang.String:", "typedPreferences:preferenceName:", "", "void"), 228);
            ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.documentum.fc.common.impl.MessageHelper$PreferencesObserver", "", "", ""), 222);
        }
    }
}

