/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.common;

import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfList;
import com.documentum.fc.common.IDfList;
import com.documentum.fc.common.IDfValue;

public class DfValidationException
extends DfException {
    public static final int DF_VALIDATION_ERROR = 1536;
    public static final int DF_ATTR_RULES_VIOLATED = 1552;
    public static final int DF_OBJ_RULES_VIOLATED = 1568;
    public static final String DFE_ATTR_NAME = "attrName";
    public static final String DFE_ATTR_VALUE = "attrValue";
    public static final String DFE_ATTRS_NAMES = "attrsNames";
    public static final String DFE_ATTRS_VALUES = "attrsValues";
    public static final String DFE_ATTR_RULES_VIOLATED = "attrExpt";
    public static final String DFE_OBJ_RULES_VIOLATED = "objExpt";
    public static final String DFE_CONSTRAINT_ERR_MSG = "constraintErrMsg";
    public static final String DFE_MAX_LENGTH = "maxLength";
    public static final String DFE_DATA_TYPE = "dataType";
    public static final String DFE_FORMAT_PATTERN = "formatPattern";
    public static final String DFE_VALUE_LIST = "valueList";
    private static final String[] NO_ARGS = new String[0];

    public DfValidationException(String strKey, String[] args) {
        super(strKey, args);
    }

    public DfValidationException(String strKey, String[] args, Throwable t) {
        super(strKey, args, t);
    }

    public DfValidationException(String strKey, IDfValue value) {
        super(strKey, NO_ARGS);
        this.setAttrValue(value);
    }

    public DfValidationException(String strKey, String strAttrName, IDfValue value, String msg) {
        super(strKey, new String[]{msg});
        this.setAttrName(strAttrName);
        this.setAttrValue(value);
    }

    public DfValidationException(String strKey, IDfList attrs, IDfList values, String msg) {
        super(strKey, new String[]{msg});
        this.setAttrsNames(attrs);
        this.setAttrsValues(values);
    }

    public String getAttrName() {
        String retval = null;
        try {
            retval = this.getProperties().getString(DFE_ATTR_NAME);
        }
        catch (DfException dfException) {
            // empty catch block
        }
        return retval;
    }

    public String getAttrValue() {
        String retval = null;
        try {
            retval = this.getProperties().getString(DFE_ATTR_VALUE);
        }
        catch (DfException dfException) {
            // empty catch block
        }
        return retval;
    }

    public IDfList getAttrsNames() {
        IDfList retval = null;
        try {
            if (!this.getProperties().get(DFE_ATTRS_NAMES).equals("")) {
                retval = this.getProperties().getList(DFE_ATTRS_NAMES);
            }
        }
        catch (DfException dfException) {
            // empty catch block
        }
        return retval;
    }

    public IDfList getAttrsValues() {
        IDfList retval = null;
        try {
            if (!this.getProperties().get(DFE_ATTRS_VALUES).equals("")) {
                retval = this.getProperties().getList(DFE_ATTRS_VALUES);
            }
        }
        catch (DfException dfException) {
            // empty catch block
        }
        return retval;
    }

    public void setAttrName(String attrName) {
        if (attrName == null) {
            this.getProperties().putString(DFE_ATTR_NAME, "");
        } else {
            this.getProperties().putString(DFE_ATTR_NAME, attrName);
        }
    }

    public void setAttrValue(IDfValue attrValue) {
        if (attrValue == null) {
            this.getProperties().putString(DFE_ATTR_VALUE, "");
        } else {
            this.getProperties().putString(DFE_ATTR_VALUE, attrValue.toString());
        }
    }

    public void setAttrsNames(IDfList attrNameList) {
        if (attrNameList == null) {
            this.getProperties().putString(DFE_ATTRS_NAMES, "");
        } else {
            this.getProperties().putList(DFE_ATTRS_NAMES, attrNameList);
        }
    }

    public void setAttrsValues(IDfList attrValueList) {
        if (attrValueList == null) {
            this.getProperties().putString(DFE_ATTRS_VALUES, "");
        } else {
            this.getProperties().putList(DFE_ATTRS_VALUES, attrValueList);
        }
    }

    public void setProperty(String strName, String value) {
        this.getProperties().putString(strName, value == null ? "" : value);
    }

    public void setProperty(String strName, int value) {
        this.getProperties().putInt(strName, value);
    }

    public void setProperty(String strName, IDfList value) {
        this.getProperties().putList(strName, value == null ? new DfList() : value);
    }
}

