/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.common;

import com.documentum.fc.client.impl.typeddata.DataConverter;
import com.documentum.fc.common.DfObject;
import com.documentum.fc.common.DfPreferences;
import com.documentum.fc.common.IDfTime;
import com.documentum.fc.common.impl.documentation.Visibility;
import com.documentum.fc.common.impl.documentation.VisibilityType;
import com.documentum.fc.common.impl.preferences.IPreferencesObserver;
import com.documentum.fc.common.impl.preferences.TypedPreferences;
import com.documentum.fc.common.impl.util.ContentServerDateFormat;
import com.documentum.fc.impl.util.StringUtil;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Visibility(visibility=VisibilityType.PUBLIC)
public final class DfTime
extends DfObject
implements IDfTime,
Externalizable {
    private static final long serialVersionUID = -5271867254074707069L;
    private Date m_date;
    private SimpleDateFormat m_format;
    private final Object m_mutexFormat = new Object();
    private Calendar m_calendar = null;
    private String m_originalDateString;
    private String m_pattern;
    private static final Date s_invalidDatePlaceholder = new Date(0L);
    private static final Date s_nullDatePlaceholder = new Date(0L);
    private static Hashtable<String, SimpleDateFormat> s_knownServerPatterns = new Hashtable(101);
    private static Hashtable<String, SimpleDateFormat> s_knownJavaPatterns = new Hashtable(101);
    private static SimpleDateFormat s_clientDateFormat;
    private static TimeZone s_timeZone;
    private static final Object s_mutexClientDateFormat;
    public static final String DF_NULLDATE_STR = "nulldate";
    public static final DfTime DF_NULLDATE;
    public static final String DF_INVALIDDATE_STR = "invaliddate";
    public static final DfTime DF_INVALIDDATE;

    public static DfTime valueOf(String string) {
        return new DfTime(string);
    }

    public DfTime() {
        this(new Date());
    }

    public DfTime(Date date) {
        this(date, (DateFormat)s_clientDateFormat);
    }

    public DfTime(String dateString) {
        this(dateString, (DateFormat)s_clientDateFormat);
    }

    public DfTime(String dateString, String pattern) {
        this(dateString, pattern, false);
    }

    public DfTime(String dateString, String pattern, boolean interpretAsJavaPatternOnlyIgnored) {
        this(dateString, (DateFormat)DfTime.getFormat(pattern, s_clientDateFormat));
        this.m_pattern = pattern;
    }

    public DfTime(String dateString, DateFormat format) {
        this(DfTime.parseDateString(dateString, format), format);
        this.m_originalDateString = dateString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DfTime(Date date, DateFormat format) {
        Object object = s_mutexClientDateFormat;
        synchronized (object) {
            Object object2 = this.m_mutexFormat;
            synchronized (object2) {
                if (format != s_clientDateFormat && !(format instanceof SimpleDateFormat)) {
                    throw new IllegalArgumentException("the format must be an instance of SimpleDateFormat");
                }
                this.m_format = (SimpleDateFormat)format;
                if (date == null) {
                    date = s_nullDatePlaceholder;
                }
                this.m_date = date;
                if (this.isValid() && !this.isNullDate()) {
                    this.m_date = DfTime.removeMilliSeconds(date);
                }
                this.m_pattern = this.m_format == s_clientDateFormat ? "" : this.m_format.toPattern();
            }
        }
    }

    public static boolean isValidPattern(String pattern) {
        return DfTime.getFormat(pattern, null) != null;
    }

    private static SimpleDateFormat getFormat(String pattern, SimpleDateFormat defaultFormat) {
        if (StringUtil.isEmptyOrNull(pattern)) {
            return defaultFormat;
        }
        SimpleDateFormat format = DfTime.getFormatForServerPattern(pattern);
        if (format != null) {
            return format;
        }
        format = DfTime.getFormatForJavaPattern(pattern);
        if (format != null) {
            return format;
        }
        return defaultFormat;
    }

    private static synchronized SimpleDateFormat getFormatForServerPattern(String pattern) {
        SimpleDateFormat format = s_knownServerPatterns.get(pattern);
        if (format != null) {
            return format;
        }
        if (pattern.contains("mi")) {
            pattern = pattern.replace("mm", "MM").replace("mi", "mm").replace("hh", "HH");
            try {
                format = DfTime.newDateFormat(pattern);
            }
            catch (Throwable t) {
                format = null;
            }
        }
        return format;
    }

    private static synchronized SimpleDateFormat getFormatForJavaPattern(String pattern) {
        SimpleDateFormat format = s_knownJavaPatterns.get(pattern);
        if (format != null) {
            return format;
        }
        try {
            format = DfTime.newDateFormat(pattern);
            s_knownJavaPatterns.put(pattern, format);
        }
        catch (Throwable t) {
            format = null;
        }
        return format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date parseDateString(String dateString, DateFormat format) {
        if (StringUtil.isEmptyOrNull(dateString) || dateString.equals(DF_NULLDATE_STR)) {
            return s_nullDatePlaceholder;
        }
        try {
            DateFormat dateFormat = format;
            synchronized (dateFormat) {
                return format.parse(dateString);
            }
        }
        catch (ParseException e1) {
            try {
                return DataConverter.convertToDate(dateString);
            }
            catch (IllegalArgumentException e2) {
                return s_invalidDatePlaceholder;
            }
        }
    }

    private static Date removeMilliSeconds(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public int compareTo(IDfTime object) {
        if (object == null) {
            return 1;
        }
        DfTime that = (DfTime)object;
        if (!this.isValid()) {
            return !that.isValid() ? 0 : -1;
        }
        if (!that.isValid()) {
            return 1;
        }
        if (this.isNullDate()) {
            return that.isNullDate() ? 0 : -1;
        }
        if (that.isNullDate()) {
            return 1;
        }
        return this.getDate().compareTo(that.getDate());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof DfTime)) {
            return false;
        }
        DfTime that = (DfTime)o;
        return this.m_date.equals(that.m_date);
    }

    public int hashCode() {
        int result = 49;
        result = 37 * result + this.m_date.hashCode();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String asString(String pattern) {
        if (!this.isValid()) {
            return DF_INVALIDDATE_STR;
        }
        if (this.isNullDate()) {
            return DF_NULLDATE_STR;
        }
        Object object = this.m_mutexFormat;
        synchronized (object) {
            SimpleDateFormat format = DfTime.getFormat(pattern, this.m_format);
            return format.format(this.getDate());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.m_originalDateString != null) {
            return this.m_originalDateString;
        }
        if (this.isNullDate()) {
            return DF_NULLDATE_STR;
        }
        if (!this.isValid()) {
            return DF_NULLDATE_STR;
        }
        Object object = this.m_mutexFormat;
        synchronized (object) {
            return this.m_format.format(this.getDate());
        }
    }

    public final Date getDate() {
        return this.isValid() && !this.isNullDate() ? this.m_date : null;
    }

    public int getDay() {
        if (this.isNullDate()) {
            return 0;
        }
        return this.getCalendar().get(5);
    }

    private synchronized Calendar getCalendar() {
        if (this.m_calendar == null) {
            this.m_calendar = Calendar.getInstance();
            this.m_calendar.setTime(this.m_date);
        }
        return this.m_calendar;
    }

    public int getHour() {
        if (this.isNullDate()) {
            return 0;
        }
        return this.getCalendar().get(11);
    }

    public int getMinutes() {
        if (this.isNullDate()) {
            return 0;
        }
        return this.getCalendar().get(12);
    }

    public int getMonth() {
        if (this.isNullDate()) {
            return 0;
        }
        return this.getCalendar().get(2) + 1;
    }

    public int getSeconds() {
        if (this.isNullDate()) {
            return 0;
        }
        return this.getCalendar().get(13);
    }

    public int getYear() {
        if (this.isNullDate()) {
            return 0;
        }
        return this.getCalendar().get(1);
    }

    public boolean isValid() {
        return this.m_date != s_invalidDatePlaceholder;
    }

    public final boolean isNullDate() {
        return this.m_date == s_nullDatePlaceholder || this.m_date == s_invalidDatePlaceholder;
    }

    public String getPattern() {
        return this.m_pattern;
    }

    public static boolean isKnownServerPattern(String pattern) {
        return s_knownServerPatterns.get(pattern) != null;
    }

    private static SimpleDateFormat newDateFormat(String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        format.setTimeZone(s_timeZone);
        format.setLenient(false);
        format.format(new Date());
        return format;
    }

    private static synchronized void staticInit() {
        if (s_knownServerPatterns.size() != 0) {
            return;
        }
        new DfDatePrefObs();
        DfTime.initializeKnownServerPatterns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeKnownServerPatterns() {
        Object object = s_mutexClientDateFormat;
        synchronized (object) {
            for (String contentServerFormat : ContentServerDateFormat.getKnownContentServerFormats()) {
                s_knownServerPatterns.put(contentServerFormat, DfTime.newDateFormat(ContentServerDateFormat.getJavaPattern(contentServerFormat)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput out) throws IOException {
        Object object = this.m_mutexFormat;
        synchronized (object) {
            out.writeObject(this.m_date);
            out.writeObject(this.m_format);
            out.writeObject(this.m_calendar);
            out.writeObject(this.m_originalDateString);
            out.writeObject(this.m_pattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Object object = this.m_mutexFormat;
        synchronized (object) {
            this.m_date = (Date)in.readObject();
            this.m_format = (SimpleDateFormat)in.readObject();
            this.m_calendar = (Calendar)in.readObject();
            this.m_originalDateString = (String)in.readObject();
            this.m_pattern = (String)in.readObject();
        }
    }

    static {
        s_mutexClientDateFormat = new Object();
        DfTime.staticInit();
        DF_NULLDATE = new DfTime(DF_NULLDATE_STR);
        DF_INVALIDDATE = new DfTime(DF_INVALIDDATE_STR);
    }

    private static class DfDatePrefObs
    implements IPreferencesObserver {
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        public DfDatePrefObs() {
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                DfPreferences.getInstance().addObserver(this);
                this.update(DfPreferences.getInstance(), null);
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void update(TypedPreferences typedPreferences, String string) {
            TypedPreferences typedPreferences2 = typedPreferences;
            String string2 = string;
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)typedPreferences2, (Object)string2);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                Object object = s_mutexClientDateFormat;
                synchronized (object) {
                    void typedPreferences3;
                    DfPreferences preferences = (DfPreferences)typedPreferences3;
                    TimeZone newTimeZone = TimeZone.getTimeZone(preferences.getTimeZone());
                    if (!newTimeZone.equals(s_timeZone)) {
                        s_timeZone = newTimeZone;
                        s_knownJavaPatterns.clear();
                        s_knownServerPatterns.clear();
                        DfTime.initializeKnownServerPatterns();
                    }
                    s_clientDateFormat = DfTime.newDateFormat(preferences.getDateFormat());
                }
                Object var10_10 = null;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)typedPreferences2, (Object)string2);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var10_10, joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)typedPreferences2, (Object)string2);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        static {
            Factory factory = new Factory("DfTime.java", Class.forName("com.documentum.fc.common.DfTime$DfDatePrefObs"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "update", "com.documentum.fc.common.DfTime$DfDatePrefObs", "com.documentum.fc.common.impl.preferences.TypedPreferences:java.lang.String:", "typedPreferences:preferenceName:", "", "void"), 444);
            ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.documentum.fc.common.DfTime$DfDatePrefObs", "", "", ""), 438);
        }
    }
}

