/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.common;

import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.IDfLoginInfo;
import com.documentum.fc.impl.util.CompareUtil;
import com.documentum.fc.impl.util.StringUtil;
import com.documentum.fc.tracing.ITraceString;
import com.documentum.fc.tracing.impl.Verbosity;
import com.documentum.fc.tracing.impl.annotation.Mask;
import com.documentum.fc.tracing.impl.annotation.TracingVerbosity;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.WriteAbortedException;
import java.text.MessageFormat;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

@TracingVerbosity(verbosity=Verbosity.VERBOSE)
public final class DfLoginInfo
implements IDfLoginInfo,
ITraceString,
Externalizable {
    private String m_user;
    private String m_password;
    private String m_domain;
    private String m_userArg1;
    private String m_securityMode;
    private String m_applicationId;
    private String m_applicationToken;
    private boolean m_principalMode;
    private boolean m_forceAuthentication;
    private boolean m_periodicAuthentication;
    private Object m_binaryCredential;
    static final long serialVersionUID = 4988617120819082953L;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;

    public DfLoginInfo() {
        this.m_user = StringUtil.EMPTY_STRING;
        this.m_password = StringUtil.EMPTY_STRING;
        this.m_domain = StringUtil.EMPTY_STRING;
        this.m_userArg1 = StringUtil.EMPTY_STRING;
        this.m_securityMode = StringUtil.EMPTY_STRING;
        this.m_applicationId = StringUtil.EMPTY_STRING;
        this.m_applicationToken = StringUtil.EMPTY_STRING;
        this.m_principalMode = false;
        this.m_forceAuthentication = true;
        this.m_periodicAuthentication = false;
    }

    public DfLoginInfo(String user, @Mask String password) {
        this();
        this.setUser(user);
        this.setPassword(password);
    }

    public DfLoginInfo(IDfLoginInfo that) {
        assert (that != null);
        this.m_user = that.getUser();
        this.m_password = that.getPassword();
        this.m_domain = that.getDomain();
        this.m_userArg1 = that.getUserArg1();
        this.m_applicationId = that.getApplicationId();
        this.m_applicationToken = that.getApplicationToken();
        this.m_securityMode = that.getSecurityMode();
        this.m_principalMode = that.getPrincipalMode();
        this.m_forceAuthentication = that.getForceAuthentication();
        this.m_periodicAuthentication = that.getPeriodicAuthentication();
        this.m_binaryCredential = that.getBinaryCredential();
    }

    /*
     * WARNING - void declaration
     */
    public boolean matches(IDfLoginInfo iDfLoginInfo) {
        IDfLoginInfo iDfLoginInfo2 = iDfLoginInfo;
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            void that;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)iDfLoginInfo2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            boolean bl3 = bl2 = that == this ? (bl = true) : (that == null ? (bl = false) : (bl = CompareUtil.isEqual(this.m_user, that.getUser()) && CompareUtil.isEqual(this.m_domain, that.getDomain()) && CompareUtil.isEqual(this.m_userArg1, that.getUserArg1()) && CompareUtil.isEqual(this.m_applicationId, that.getApplicationId()) && CompareUtil.isEqual(this.m_applicationToken, that.getApplicationToken()) && CompareUtil.isEqual(this.m_securityMode, that.getSecurityMode()) && this.m_principalMode == that.getPrincipalMode() && (this.m_principalMode || this.credentialMatches((IDfLoginInfo)that))));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)iDfLoginInfo2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)iDfLoginInfo2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DfLoginInfo)) {
            return false;
        }
        DfLoginInfo that = (DfLoginInfo)o;
        return CompareUtil.isEqual(this.m_user, that.m_user) && CompareUtil.isEqual(this.m_domain, that.m_domain) && CompareUtil.isEqual(this.m_userArg1, that.m_userArg1) && CompareUtil.isEqual(this.m_applicationId, that.m_applicationId) && CompareUtil.isEqual(this.m_applicationToken, that.m_applicationToken) && CompareUtil.isEqual(this.m_securityMode, that.m_securityMode) && CompareUtil.isEqual(this.m_binaryCredential, that.m_binaryCredential) && this.m_principalMode == that.m_principalMode && (this.m_principalMode || CompareUtil.isEqual(this.m_password, that.m_password)) && this.m_forceAuthentication == that.m_forceAuthentication && this.m_periodicAuthentication == that.m_periodicAuthentication;
    }

    public int hashCode() {
        int value = 17;
        value = 37 * value + (this.m_user != null ? this.m_user.hashCode() : 0);
        value = 37 * value + (this.m_password != null ? this.m_password.hashCode() : 0);
        value = 37 * value + (this.m_domain != null ? this.m_domain.hashCode() : 0);
        value = 37 * value + (this.m_userArg1 != null ? this.m_userArg1.hashCode() : 0);
        value = 37 * value + (this.m_applicationId != null ? this.m_applicationId.hashCode() : 0);
        value = 37 * value + (this.m_applicationToken != null ? this.m_applicationToken.hashCode() : 0);
        value = 37 * value + (this.m_securityMode != null ? this.m_securityMode.hashCode() : 0);
        value = 37 * value + (this.m_binaryCredential != null ? this.m_binaryCredential.hashCode() : 0);
        value = 37 * value + (this.m_principalMode ? 1 : 0);
        value = 37 * value + (this.m_forceAuthentication ? 1 : 0);
        value = 37 * value + (this.m_periodicAuthentication ? 1 : 0);
        return value;
    }

    public String toString() {
        StringBuilder b = new StringBuilder(64);
        b.append("DfLoginInfo{");
        b.append("user=").append(this.m_user);
        if (!this.m_domain.equals(StringUtil.EMPTY_STRING)) {
            b.append(", domain=").append(this.m_domain);
        }
        if (!this.m_userArg1.equals(StringUtil.EMPTY_STRING)) {
            b.append(", userArg=").append(this.m_userArg1);
        }
        if (!this.m_applicationId.equals(StringUtil.EMPTY_STRING)) {
            b.append(", appId=").append(this.m_applicationId);
        }
        if (!this.m_applicationToken.equals(StringUtil.EMPTY_STRING)) {
            b.append(", appToken=").append(this.m_applicationToken);
        }
        if (!this.m_securityMode.equals(StringUtil.EMPTY_STRING)) {
            b.append(", securityMode=").append(this.m_securityMode);
        }
        if (this.m_principalMode) {
            b.append(", principalMode=").append(this.m_principalMode);
        }
        if (this.m_forceAuthentication) {
            b.append(", forceAuth=").append(this.m_forceAuthentication);
        }
        if (this.m_periodicAuthentication) {
            b.append(", periodicAuth=").append(this.m_periodicAuthentication);
        }
        b.append("}");
        return b.toString();
    }

    public String toTraceString(boolean verbose) {
        return this.toString();
    }

    public String getUser() {
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            String string3 = string2 = (string = this.m_user);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setUser(String string) {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            void user;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            this.m_user = StringUtil.nullToEmpty((String)user);
            Object var4_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(var4_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    @Mask
    public String getPassword() {
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            if (BaseTracingAspect.ajc$if_0() || BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            String string3 = string2 = (string = this.m_password);
            if (BaseTracingAspect.ajc$if_0() || BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0() || BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setPassword(@Mask String string) {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            void password;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            this.m_password = StringUtil.nullToEmpty((String)password);
            Object var4_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(var4_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public String getDomain() {
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            String string3 = string2 = (string = this.m_domain);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setDomain(String string) {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            void domain;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            this.m_domain = StringUtil.nullToEmpty((String)domain);
            Object var4_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(var4_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public String getUserArg1() {
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            String string3 = string2 = (string = this.m_userArg1);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setUserArg1(String string) {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            void userArg1;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            this.m_userArg1 = StringUtil.nullToEmpty((String)userArg1);
            Object var4_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(var4_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public String getUserArg2() {
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            String string3 = string2 = (string = StringUtil.EMPTY_STRING);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public void setUserArg2(String string) {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            Object var4_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(var4_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public String getApplicationId() {
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            String string3 = string2 = (string = this.m_applicationId);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setApplicationId(String string) {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            void id;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            this.m_applicationId = StringUtil.nullToEmpty((String)id);
            Object var4_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(var4_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public String getApplicationToken() {
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            String string3 = string2 = (string = this.m_applicationToken);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setApplicationToken(String string) {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            void token;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            this.m_applicationToken = StringUtil.nullToEmpty((String)token);
            Object var4_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(var4_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public String getSecurityMode() {
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            String string3 = string2 = (string = this.m_securityMode);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setSecurityMode(String string) {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            void securityMode;
            String canonicalSecurityMode;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            String string3 = canonicalSecurityMode = StringUtil.isEmptyOrNull((String)securityMode) ? StringUtil.EMPTY_STRING : securityMode.intern();
            if (!DfLoginInfo.isValidSecurityMode(canonicalSecurityMode)) {
                throw new IllegalArgumentException("Invalid security mode");
            }
            this.m_securityMode = canonicalSecurityMode;
            Object var5_5 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(var5_5, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public static boolean isValidSecurityMode(String string) {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            String securityMode;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, null, null, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            boolean bl2 = StringUtil.isEmptyOrNull(securityMode) || securityMode.equals(IDfLoginInfo.SECURITY_MODE_NATIVE) || securityMode.equals(IDfLoginInfo.SECURITY_MODE_SECURE) || securityMode.equals(IDfLoginInfo.SECURITY_MODE_TRY_SECURE_FIRST) || securityMode.equals(IDfLoginInfo.SECURITY_MODE_TRY_NATIVE_FIRST);
            boolean bl3 = bl = bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(object, joinPoint);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public boolean getPrincipalMode() {
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            boolean bl3 = bl2 = (bl = this.m_principalMode);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setPrincipalMode(boolean bl) {
        boolean bl2 = bl;
        JoinPoint joinPoint = null;
        try {
            void principalMode;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            this.m_principalMode = principalMode;
            Object var4_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(var4_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public boolean getForceAuthentication() {
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            boolean bl3 = bl2 = (bl = this.m_forceAuthentication);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setForceAuthentication(boolean bl) {
        boolean bl2 = bl;
        JoinPoint joinPoint = null;
        try {
            void forceAuthentication;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            this.m_forceAuthentication = forceAuthentication;
            Object var4_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(var4_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public boolean getPeriodicAuthentication() {
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            boolean bl3 = bl2 = (bl = this.m_periodicAuthentication);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setPeriodicAuthentication(boolean bl) {
        boolean bl2 = bl;
        JoinPoint joinPoint = null;
        try {
            void periodicAuthentication;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            this.m_periodicAuthentication = periodicAuthentication;
            Object var4_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(var4_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        ObjectOutput objectOutput2 = objectOutput;
        JoinPoint joinPoint = null;
        try {
            void objectOutput3;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object)objectOutput2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            objectOutput3.writeUTF(this.getUser());
            objectOutput3.writeUTF(this.getPassword());
            objectOutput3.writeUTF(this.getDomain());
            objectOutput3.writeUTF(this.getUserArg1());
            objectOutput3.writeUTF(this.getSecurityMode());
            objectOutput3.writeUTF(this.getApplicationId());
            objectOutput3.writeUTF(this.getApplicationToken());
            objectOutput3.writeBoolean(this.getPrincipalMode());
            objectOutput3.writeBoolean(this.getForceAuthentication());
            objectOutput3.writeBoolean(this.getPeriodicAuthentication());
            try {
                objectOutput3.writeObject(this.getBinaryCredential());
            }
            catch (NotSerializableException e) {
                DfLogger.warn((Object)this, "DFC_LOGIN_SERIALIZE_BINARY_CRED_FAIL", null, (Throwable)e);
                objectOutput3.writeObject(null);
            }
            Object var5_5 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object)objectOutput2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(var5_5, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object)objectOutput2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void readExternal(ObjectInput objectInput) throws IOException {
        ObjectInput objectInput2 = objectInput;
        JoinPoint joinPoint = null;
        try {
            void objectInput3;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)objectInput2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            this.setUser(objectInput3.readUTF());
            this.setPassword(objectInput3.readUTF());
            this.setDomain(objectInput3.readUTF());
            this.setUserArg1(objectInput3.readUTF());
            this.setSecurityMode(objectInput3.readUTF());
            this.setApplicationId(objectInput3.readUTF());
            this.setApplicationToken(objectInput3.readUTF());
            this.setPrincipalMode(objectInput3.readBoolean());
            this.setForceAuthentication(objectInput3.readBoolean());
            this.setPeriodicAuthentication(objectInput3.readBoolean());
            try {
                this.setBinaryCredential(objectInput3.readObject());
            }
            catch (ClassNotFoundException e) {
                IOException ioEx = new IOException(MessageFormat.format("DFC_LOGIN_DESERIALIZATION_FAILURE", e.getMessage()));
                ioEx.initCause(e);
                throw ioEx;
            }
            catch (WriteAbortedException e) {
                DfLogger.warn((Object)this, "DFC_LOGIN_DESERIALIZE_BINARY_CRED_FAIL", null, (Throwable)e);
                this.setBinaryCredential(null);
            }
            Object var6_7 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)objectInput2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(var6_7, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)objectInput2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setBinaryCredential(Object object) {
        Object object2 = object;
        JoinPoint joinPoint = null;
        try {
            void binaryCredential;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this, (Object)object2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            if (binaryCredential instanceof GSSCredential) {
                try {
                    GSSCredential userTGT = (GSSCredential)binaryCredential;
                    String userName = ((Object)userTGT.getName()).toString();
                    int index = userName.indexOf("@");
                    userName = index != -1 ? userName.substring(0, userName.indexOf("@")) : userName;
                    this.setUser(userName);
                }
                catch (GSSException e) {
                    DfLogger.warn(DfLoginInfo.class, "Unexpected failure while processing binary credential", null, (Throwable)e);
                }
            }
            this.m_binaryCredential = binaryCredential;
            Object var7_8 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this, (Object)object2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(var7_8, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this, (Object)object2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public Object getBinaryCredential() {
        JoinPoint joinPoint = null;
        try {
            Object object;
            Object object2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            Object object3 = object2 = (object = this.m_binaryCredential);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(object2, joinPoint);
            }
            return object;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean credentialMatches(IDfLoginInfo iDfLoginInfo) {
        IDfLoginInfo iDfLoginInfo2 = iDfLoginInfo;
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            void that;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this, (Object)iDfLoginInfo2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            boolean bl3 = bl2 = that.getBinaryCredential() != null || this.m_binaryCredential != null ? (bl = DfLoginInfo.matches(this.m_binaryCredential, that.getBinaryCredential())) : (bl = CompareUtil.isEqual(this.m_password, that.getPassword()));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this, (Object)iDfLoginInfo2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this, (Object)iDfLoginInfo2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean matches(Object object, Object object2) {
        Object object3 = object;
        Object object4 = object2;
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            boolean bl3;
            block10: {
                void object22;
                Object object1;
                block11: {
                    if (BaseTracingAspect.ajc$if_0()) {
                        TracingAspect tracingAspect = TracingAspect.aspectOf();
                        if (joinPoint == null) {
                            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, null, null, (Object)object3, (Object)object4);
                        }
                        tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
                    }
                    if (!(object1 instanceof GSSCredential) || !(object22 instanceof GSSCredential)) break block11;
                    GSSCredential credential1 = (GSSCredential)object1;
                    GSSCredential credential2 = (GSSCredential)object22;
                    try {
                        bl2 = bl3 = credential1.getRemainingLifetime() > 0 && credential2.getRemainingLifetime() > 0 && credential1.getName().equals(credential2.getName());
                    }
                    catch (GSSException e) {
                        DfLogger.warn(DfLoginInfo.class, "Unexpected failure comparing GSSCredential", null, (Throwable)e);
                        bl2 = bl3 = false;
                        break block10;
                    }
                    break block10;
                }
                bl2 = bl3 = CompareUtil.isEqual(object1, object22);
            }
            boolean bl4 = bl = bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object5 = Conversions.booleanObject((boolean)bl);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, null, null, (Object)object3, (Object)object4);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(object5, joinPoint);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, null, null, (Object)object3, (Object)object4);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("DfLoginInfo.java", Class.forName("com.documentum.fc.common.DfLoginInfo"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "matches", "com.documentum.fc.common.DfLoginInfo", "com.documentum.fc.common.IDfLoginInfo:", "that:", "", "boolean"), 71);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUser", "com.documentum.fc.common.DfLoginInfo", "", "", "", "java.lang.String"), 164);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setUserArg2", "com.documentum.fc.common.DfLoginInfo", "java.lang.String:", "userArg2:", "", "void"), 216);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getApplicationId", "com.documentum.fc.common.DfLoginInfo", "", "", "", "java.lang.String"), 220);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setApplicationId", "com.documentum.fc.common.DfLoginInfo", "java.lang.String:", "id:", "", "void"), 225);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getApplicationToken", "com.documentum.fc.common.DfLoginInfo", "", "", "", "java.lang.String"), 230);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setApplicationToken", "com.documentum.fc.common.DfLoginInfo", "java.lang.String:", "token:", "", "void"), 235);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSecurityMode", "com.documentum.fc.common.DfLoginInfo", "", "", "", "java.lang.String"), 240);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSecurityMode", "com.documentum.fc.common.DfLoginInfo", "java.lang.String:", "securityMode:", "", "void"), 245);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "isValidSecurityMode", "com.documentum.fc.common.DfLoginInfo", "java.lang.String:", "securityMode:", "", "boolean"), 255);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPrincipalMode", "com.documentum.fc.common.DfLoginInfo", "", "", "", "boolean"), 264);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPrincipalMode", "com.documentum.fc.common.DfLoginInfo", "boolean:", "principalMode:", "", "void"), 269);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setUser", "com.documentum.fc.common.DfLoginInfo", "java.lang.String:", "user:", "", "void"), 169);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getForceAuthentication", "com.documentum.fc.common.DfLoginInfo", "", "", "", "boolean"), 274);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setForceAuthentication", "com.documentum.fc.common.DfLoginInfo", "boolean:", "forceAuthentication:", "", "void"), 279);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPeriodicAuthentication", "com.documentum.fc.common.DfLoginInfo", "", "", "", "boolean"), 284);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPeriodicAuthentication", "com.documentum.fc.common.DfLoginInfo", "boolean:", "periodicAuthentication:", "", "void"), 289);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "writeExternal", "com.documentum.fc.common.DfLoginInfo", "java.io.ObjectOutput:", "objectOutput:", "java.io.IOException:", "void"), 294);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "readExternal", "com.documentum.fc.common.DfLoginInfo", "java.io.ObjectInput:", "objectInput:", "java.io.IOException:", "void"), 318);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setBinaryCredential", "com.documentum.fc.common.DfLoginInfo", "java.lang.Object:", "binaryCredential:", "", "void"), 350);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBinaryCredential", "com.documentum.fc.common.DfLoginInfo", "", "", "", "java.lang.Object"), 370);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "credentialMatches", "com.documentum.fc.common.DfLoginInfo", "com.documentum.fc.common.IDfLoginInfo:", "that:", "", "boolean"), 375);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "matches", "com.documentum.fc.common.DfLoginInfo", "java.lang.Object:java.lang.Object:", "object1:object2:", "", "boolean"), 383);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPassword", "com.documentum.fc.common.DfLoginInfo", "", "", "", "java.lang.String"), 175);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPassword", "com.documentum.fc.common.DfLoginInfo", "java.lang.String:", "password:", "", "void"), 180);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDomain", "com.documentum.fc.common.DfLoginInfo", "", "", "", "java.lang.String"), 185);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDomain", "com.documentum.fc.common.DfLoginInfo", "java.lang.String:", "domain:", "", "void"), 190);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserArg1", "com.documentum.fc.common.DfLoginInfo", "", "", "", "java.lang.String"), 195);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setUserArg1", "com.documentum.fc.common.DfLoginInfo", "java.lang.String:", "userArg1:", "", "void"), 200);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserArg2", "com.documentum.fc.common.DfLoginInfo", "", "", "", "java.lang.String"), 208);
    }
}

