/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.common;

import com.documentum.fc.common.DfcMessages;
import com.documentum.fc.common.impl.GlobalResourceBundle;
import com.documentum.fc.common.impl.documentation.Visibility;
import com.documentum.fc.common.impl.documentation.VisibilityType;
import com.documentum.fc.common.impl.logging.LoggingConfigurator;
import com.documentum.fc.impl.util.ThrowableStack;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Stack;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Visibility(visibility=VisibilityType.PUBLIC)
public final class DfLogger {
    private static final String MUTE = "MUTE";
    private static final String NULL_CATEGORY = "null";
    private static final String FQCN;
    private static final String TRACING = "tracing.";
    private static final int TRACING_LENGTH;
    private static ThreadLocal<Stack<String>> s_prefixes;
    private static ThreadLocal<Integer> s_muteCounter;
    private static final Loggers s_loggers;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public DfLogger() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private static Throwable optionallyGetLogStack(Level level, Throwable givenThrowable) {
        if (level.isGreaterOrEqual((Priority)LoggingConfigurator.getLevelToForceStack())) {
            if (givenThrowable != null) {
                return new ThrowableStack(2, givenThrowable);
            }
            return new ThrowableStack(2);
        }
        return givenThrowable;
    }

    public static void fatal(Object source, String message, Object[] params, Throwable t) {
        Logger logger = DfLogger.getLogger(source);
        if (logger.isEnabledFor((Priority)Level.FATAL)) {
            logger.log(FQCN, (Priority)Level.FATAL, (Object)DfLogger.getFullMessage(message, params), DfLogger.optionallyGetLogStack(Level.FATAL, t));
        }
    }

    public static void fatal(Object source, String message, String[] params, Throwable t) {
        Logger logger = DfLogger.getLogger(source);
        if (logger.isEnabledFor((Priority)Level.FATAL)) {
            logger.log(FQCN, (Priority)Level.FATAL, (Object)DfLogger.getFullMessage(message, params), DfLogger.optionallyGetLogStack(Level.FATAL, t));
        }
    }

    public static void error(Object source, String message, Object[] params, Throwable t) {
        Logger logger = DfLogger.getLogger(source);
        if (logger.isEnabledFor((Priority)Level.ERROR)) {
            logger.log(FQCN, (Priority)Level.ERROR, (Object)DfLogger.getFullMessage(message, params), DfLogger.optionallyGetLogStack(Level.ERROR, t));
        }
    }

    public static void error(Object source, String message, String[] params, Throwable t) {
        Logger logger = DfLogger.getLogger(source);
        if (logger.isEnabledFor((Priority)Level.ERROR)) {
            logger.log(FQCN, (Priority)Level.ERROR, (Object)DfLogger.getFullMessage(message, params), DfLogger.optionallyGetLogStack(Level.ERROR, t));
        }
    }

    public static void warn(Object source, String message, Object[] params, Throwable t) {
        Logger logger = DfLogger.getLogger(source);
        if (logger.isEnabledFor((Priority)Level.WARN)) {
            logger.log(FQCN, (Priority)Level.WARN, (Object)DfLogger.getFullMessage(message, params), DfLogger.optionallyGetLogStack(Level.WARN, t));
        }
    }

    public static void warn(Object source, String message, String[] params, Throwable t) {
        Logger logger = DfLogger.getLogger(source);
        if (logger.isEnabledFor((Priority)Level.WARN)) {
            logger.log(FQCN, (Priority)Level.WARN, (Object)DfLogger.getFullMessage(message, params), DfLogger.optionallyGetLogStack(Level.WARN, t));
        }
    }

    public static void info(Object source, String message, Object[] params, Throwable t) {
        Logger logger = DfLogger.getLogger(source);
        if (logger.isEnabledFor((Priority)Level.INFO)) {
            logger.log(FQCN, (Priority)Level.INFO, (Object)DfLogger.getFullMessage(message, params), DfLogger.optionallyGetLogStack(Level.INFO, t));
        }
    }

    public static void info(Object source, String message, String[] params, Throwable t) {
        Logger logger = DfLogger.getLogger(source);
        if (logger.isEnabledFor((Priority)Level.INFO)) {
            logger.log(FQCN, (Priority)Level.INFO, (Object)DfLogger.getFullMessage(message, params), DfLogger.optionallyGetLogStack(Level.INFO, t));
        }
    }

    public static void debug(Object source, String message, Object[] params, Throwable t) {
        Logger logger = DfLogger.getLogger(source);
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            logger.log(FQCN, (Priority)Level.DEBUG, (Object)DfLogger.getFullMessage(message, params), DfLogger.optionallyGetLogStack(Level.DEBUG, t));
        }
    }

    public static void debug(Object source, String message, String[] params, Throwable t) {
        Logger logger = DfLogger.getLogger(source);
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            logger.log(FQCN, (Priority)Level.DEBUG, (Object)DfLogger.getFullMessage(message, params), DfLogger.optionallyGetLogStack(Level.DEBUG, t));
        }
    }

    public static void trace(Object source, String message, Object[] params, Throwable t) {
        DfLogger.getLoggerForTrace(source).log(FQCN, (Priority)Level.DEBUG, (Object)DfLogger.getFullMessage(message, params), DfLogger.optionallyGetLogStack(Level.DEBUG, t));
    }

    public static void trace(Object source, String message, String[] params, Throwable t) {
        DfLogger.getLoggerForTrace(source).log(FQCN, (Priority)Level.DEBUG, (Object)DfLogger.getFullMessage(message, params), DfLogger.optionallyGetLogStack(Level.DEBUG, t));
    }

    public static boolean isFatalEnabled(Object source) {
        return DfLogger.getLogger(source).isEnabledFor((Priority)Level.FATAL);
    }

    public static boolean isErrorEnabled(Object source) {
        return DfLogger.getLogger(source).isEnabledFor((Priority)Level.ERROR);
    }

    public static boolean isWarnEnabled(Object source) {
        return DfLogger.getLogger(source).isEnabledFor((Priority)Level.WARN);
    }

    public static boolean isInfoEnabled(Object source) {
        return DfLogger.getLogger(source).isEnabledFor((Priority)Level.INFO);
    }

    public static boolean isDebugEnabled(Object source) {
        return DfLogger.getLogger(source).isEnabledFor((Priority)Level.DEBUG);
    }

    public static boolean isTraceEnabled(Object source) {
        return DfLogger.getLoggerForTrace(source).isEnabledFor((Priority)Level.DEBUG);
    }

    public static Logger getLogger(Object source) {
        Object categoryObj = source instanceof String ? source : (source instanceof Class ? source : (source != null ? source.getClass() : NULL_CATEGORY));
        Map<Object, Logger> loggersMap = s_loggers.getLoggersMap();
        Logger logger = loggersMap.get(categoryObj);
        if (logger == null) {
            String coreCategory = source instanceof String ? (String)((Object)source) : (source instanceof Class ? source.getName() : (source != null ? source.getClass().getName() : NULL_CATEGORY));
            String categoryWithPrefix = coreCategory;
            String prefix = DfLogger.getCurrentPrefix();
            if (prefix != null) {
                StringBuffer sb = new StringBuffer(prefix.length() + coreCategory.length() + 1);
                categoryWithPrefix = sb.append(prefix).append('.').append(coreCategory).toString();
            }
            logger = Logger.getLogger((String)categoryWithPrefix);
            loggersMap.put(categoryObj, logger);
        }
        return logger;
    }

    public static Logger getRootLogger() {
        String prefix = DfLogger.getCurrentPrefix();
        if (prefix == null) {
            return Logger.getRootLogger();
        }
        return Logger.getLogger((String)prefix);
    }

    public static void setClientContext(String prefix) {
        s_loggers.reset();
        Stack<String> prefixesStack = s_prefixes.get();
        if (prefixesStack == null) {
            prefixesStack = new Stack();
            s_prefixes.set(prefixesStack);
        }
        prefixesStack.push(prefix);
    }

    public static void restoreClientContext() {
        Stack<String> prefixesStack = s_prefixes.get();
        if (prefixesStack != null && !prefixesStack.empty()) {
            prefixesStack.pop();
            s_loggers.reset();
        }
    }

    public static void mute(boolean fMode) {
        int muteCounter;
        Integer mute = s_muteCounter.get();
        if (mute == null && !fMode) {
            return;
        }
        s_loggers.reset();
        int n = muteCounter = mute != null ? mute : 0;
        if (fMode) {
            s_muteCounter.set(muteCounter + 1);
        } else if (--muteCounter > 0) {
            s_muteCounter.set(muteCounter + 1);
        } else {
            s_muteCounter.set(null);
        }
    }

    public static void registerResourceBundle(ResourceBundle bundle) {
        GlobalResourceBundle.getInstance().add(bundle);
    }

    public static String getFullMessage(String message, String[] params) {
        String fullMessage = (String)new LoggingResourceBundle().getObject(message);
        if (fullMessage != null) {
            if (params != null) {
                fullMessage = MessageFormat.format(fullMessage, params);
            }
        } else {
            fullMessage = message;
        }
        return fullMessage;
    }

    public static String getFullMessage(String message, Object[] params) {
        String fullMessage = (String)new LoggingResourceBundle().getObject(message);
        if (fullMessage != null) {
            if (params != null) {
                fullMessage = MessageFormat.format(fullMessage, params);
            }
        } else {
            fullMessage = message;
        }
        return fullMessage;
    }

    private static Logger getLoggerForTrace(Object source) {
        String coreCategory = source instanceof String ? (String)source : (source instanceof Class ? ((Class)source).getName() : (source != null ? source.getClass().getName() : NULL_CATEGORY));
        StringBuffer sb = new StringBuffer(TRACING_LENGTH + coreCategory.length());
        String category = sb.append(TRACING).append(coreCategory).toString();
        return Logger.getLogger((String)category);
    }

    private static String getCurrentPrefix() {
        if (s_muteCounter.get() != null) {
            return MUTE;
        }
        Stack<String> prefixesStack = s_prefixes.get();
        if (prefixesStack == null || prefixesStack.empty()) {
            return null;
        }
        return prefixesStack.peek();
    }

    static {
        Factory factory = new Factory("DfLogger.java", Class.forName("com.documentum.fc.common.DfLogger"));
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.documentum.fc.common.DfLogger", "", "", ""), 575);
        FQCN = DfLogger.class.getName() + ".";
        TRACING_LENGTH = TRACING.length();
        s_prefixes = new ThreadLocal();
        s_muteCounter = new ThreadLocal();
        s_loggers = new Loggers();
        Logger.getRootLogger().setResourceBundle((ResourceBundle)new LoggingResourceBundle());
        DfLogger.registerResourceBundle(DfcMessages.getResourceBundle());
        LoggingConfigurator.performInitialConfiguration();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LoggingResourceBundle
    extends ResourceBundle {
        private LoggingResourceBundle() {
        }

        @Override
        public synchronized Enumeration<String> getKeys() {
            return GlobalResourceBundle.getInstance().getKeys();
        }

        @Override
        protected synchronized Object handleGetObject(String key) {
            try {
                return "[" + key + "] " + GlobalResourceBundle.getInstance().getObject(key);
            }
            catch (MissingResourceException e) {
                return key;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Loggers {
        static final int CACHE_SIZE = 4999;
        private final ThreadLocal<Map<Object, Logger>> m_loggersMap = new ThreadLocal();

        private Loggers() {
        }

        public Map<Object, Logger> getLoggersMap() {
            Map<Object, Logger> map = this.m_loggersMap.get();
            if (map == null) {
                map = new HashMap<Object, Logger>(4999);
                this.m_loggersMap.set(map);
            }
            return map;
        }

        public void reset() {
            this.m_loggersMap.set(new HashMap(4999));
        }
    }
}

