/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.common;

import com.documentum.fc.common.DfLogger;
import com.documentum.fc.tracing.impl.Verbosity;
import com.documentum.fc.tracing.impl.annotation.TracingVerbosity;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

@TracingVerbosity(verbosity=Verbosity.VERBOSE)
public class DfLockHeartbeatThread
extends Thread {
    private boolean m_shouldStop;
    private boolean m_inactive;
    private boolean m_pacified;
    private File m_lockFile;
    private int m_updateInterval;
    private int m_maxUpdateInterval;
    private static final int DELETE_INTERVAL = 10;
    private static final int DELETE_RETRIES = 50;
    private static final int MAX_MODIFICATION_REPETITION = 200;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;

    public DfLockHeartbeatThread(File file, int updateInterval) {
        File file2 = file;
        int n = updateInterval;
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)file2, (Object)Conversions.intObject((int)n));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_lockFile = file;
            this.m_updateInterval = updateInterval;
            this.m_maxUpdateInterval = 4 * this.m_updateInterval;
            this.m_shouldStop = false;
            this.m_inactive = true;
            this.m_pacified = true;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)file2, (Object)Conversions.intObject((int)n));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)file2, (Object)Conversions.intObject((int)n));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public synchronized void exit() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            this.setShouldStop(true);
            this.notifyAll();
            Object var2_2 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(var2_2, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public void run() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            try {
                while (!this.isShouldStop()) {
                    if (!this.activateHeartbeat()) continue;
                    this.setModifiedTime();
                    this.sleepAWhile();
                }
            }
            catch (ThreadDeath e) {
                DfLogger.error((Object)this, "Programming Error: Use exit() to terminate DfLockHeartbeatThread instead of stop()", null, (Throwable)e);
            }
            catch (Throwable t) {
                DfLogger.error((Object)this, "Heartbeat thread failed on lock {0}", new Object[]{this.m_lockFile.getAbsolutePath()}, null);
            }
            Object var3_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(var3_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean setModifiedTime() {
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            boolean flag = false;
            File file = this.m_lockFile;
            synchronized (file) {
                if (this.m_lockFile.exists()) {
                    long modifiedTime;
                    long currentTime;
                    int counter = 0;
                    do {
                        if (!this.m_lockFile.exists()) {
                            DfLogger.warn((Object)this, "Lock file " + this.getLockFile().getAbsolutePath() + " didn't exist when it should be updated ", null, null);
                            break;
                        }
                        currentTime = new Date().getTime();
                        flag = this.m_lockFile.setLastModified(currentTime);
                    } while (Math.abs(currentTime - (modifiedTime = this.m_lockFile.lastModified())) > 1000L && counter < 200);
                } else {
                    DfLogger.warn((Object)this, "Lock file " + this.getLockFile().getAbsolutePath() + " didn't exist when it should be updated ", null, null);
                }
                if (!flag) {
                    DfLogger.debug((Object)this, "Failed to update modification date on the lock file " + this.getLockFile().getAbsolutePath(), null, null);
                }
            }
            boolean bl3 = bl2 = (bl = flag);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public File getLockFile() {
        JoinPoint joinPoint = null;
        try {
            File file;
            File file2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            File file3 = file2 = (file = this.m_lockFile);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(file2, joinPoint);
            }
            return file;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLockFile() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            File file = this.m_lockFile;
            synchronized (file) {
                boolean result = this.m_lockFile.delete();
                int counter = 0;
                while (!result && this.m_lockFile.exists()) {
                    if (++counter > 50) {
                        DfLogger.warn((Object)this, "Failed to delete interprocess lock file!!!" + this.getLockFile().getAbsolutePath(), null, null);
                        break;
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        this.interrupt();
                    }
                    if (!(result = this.m_lockFile.delete())) continue;
                    DfLogger.debug((Object)this, "Thread " + Thread.currentThread().getName() + "Successfully removed lock file " + this.getLockFile().getAbsolutePath(), null, null);
                }
            }
            Object var7_7 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(var7_7, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public boolean createFile() throws IOException {
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            boolean bl3 = bl2 = (bl = this.m_lockFile.createNewFile());
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public boolean isFileExists() {
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            boolean bl3 = bl2 = (bl = this.m_lockFile.exists());
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    protected void recoverLockFile() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            if (this.m_lockFile != null && this.m_lockFile.exists()) {
                long fileLastModified = this.m_lockFile.lastModified();
                long currentTime = new Date().getTime();
                long prevModifiedTime = -1L;
                boolean deleteFileFlag = false;
                int count = 0;
                while (this.m_lockFile.exists() && fileLastModified + (long)this.m_maxUpdateInterval < currentTime) {
                    if (prevModifiedTime == fileLastModified) {
                        if (count >= 50) {
                            deleteFileFlag = true;
                            break;
                        }
                        ++count;
                    } else {
                        count = 0;
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException intenionallyIgnored) {
                        // empty catch block
                    }
                    prevModifiedTime = fileLastModified;
                    fileLastModified = this.m_lockFile.lastModified();
                    currentTime = new Date().getTime();
                }
                if (this.m_lockFile.exists() && deleteFileFlag) {
                    try {
                        this.m_lockFile.delete();
                        DfLogger.warn((Object)this, "Stale lock file " + this.getLockFile().getAbsolutePath() + " forcefully removed", null, null);
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException intenionallyIgnored) {
                        // empty catch block
                    }
                    DfLogger.error((Object)this, "Deleting the lock file {0} due to deadlock. A deadlock on lock file may have occured due to abnormal program termination - {1}", new Object[]{this.m_lockFile.getAbsolutePath(), this.toString()}, null);
                }
            }
            Object var11_9 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(var11_9, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private synchronized void sleepAWhile() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            try {
                this.wait(this.m_updateInterval);
            }
            catch (InterruptedException interruptedException) {
            }
            Object var3_3 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(var3_3, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private synchronized boolean isShouldStop() {
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            boolean bl3 = bl2 = (bl = this.m_shouldStop);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void setShouldStop(boolean bl) {
        boolean bl2 = bl;
        JoinPoint joinPoint = null;
        try {
            void shouldStop;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            this.m_shouldStop = shouldStop;
            this.interrupt();
            Object var4_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(var4_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public synchronized boolean isInactivate() {
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            boolean bl3 = bl2 = (bl = this.m_inactive);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setInactivate(boolean bl) {
        boolean bl2 = bl;
        JoinPoint joinPoint = null;
        try {
            void inactive;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            this.m_inactive = inactive;
            this.notifyAll();
            Object var4_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(var4_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public synchronized boolean activateHeartbeat() {
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            boolean bl3;
            block13: {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
                }
                while (this.isInactivate()) {
                    block12: {
                        this.setPacified();
                        if (!this.isShouldStop()) break block12;
                        bl2 = bl3 = false;
                        break block13;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        this.setUnpacified();
                    }
                }
                bl2 = bl3 = true;
            }
            boolean bl4 = bl = bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(object, joinPoint);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public synchronized boolean isPacified() {
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            boolean bl3 = bl2 = (bl = this.m_pacified);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public synchronized void setPacified() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            this.m_pacified = true;
            this.notifyAll();
            Object var2_2 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(var2_2, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public synchronized void setUnpacified() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(joinPoint);
            }
            this.m_pacified = false;
            Object var2_2 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(var2_2, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("DfLockHeartbeatThread.java", Class.forName("com.documentum.fc.common.DfLockHeartbeatThread"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "exit", "com.documentum.fc.common.DfLockHeartbeatThread", "", "", "", "void"), 46);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "com.documentum.fc.common.DfLockHeartbeatThread", "", "", "", "void"), 60);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("22", "setShouldStop", "com.documentum.fc.common.DfLockHeartbeatThread", "boolean:", "shouldStop:", "", "void"), 288);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "isInactivate", "com.documentum.fc.common.DfLockHeartbeatThread", "", "", "", "boolean"), 298);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "setInactivate", "com.documentum.fc.common.DfLockHeartbeatThread", "boolean:", "inactive:", "", "void"), 303);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "activateHeartbeat", "com.documentum.fc.common.DfLockHeartbeatThread", "", "", "", "boolean"), 309);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "isPacified", "com.documentum.fc.common.DfLockHeartbeatThread", "", "", "", "boolean"), 330);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "setPacified", "com.documentum.fc.common.DfLockHeartbeatThread", "", "", "", "void"), 335);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "setUnpacified", "com.documentum.fc.common.DfLockHeartbeatThread", "", "", "", "void"), 341);
        ajc$tjp_17 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.documentum.fc.common.DfLockHeartbeatThread", "java.io.File:int:", "file:updateInterval:", ""), 22);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("24", "setModifiedTime", "com.documentum.fc.common.DfLockHeartbeatThread", "", "", "", "boolean"), 93);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLockFile", "com.documentum.fc.common.DfLockHeartbeatThread", "", "", "", "java.io.File"), 130);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteLockFile", "com.documentum.fc.common.DfLockHeartbeatThread", "", "", "", "void"), 135);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createFile", "com.documentum.fc.common.DfLockHeartbeatThread", "", "", "java.io.IOException:", "boolean"), 168);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isFileExists", "com.documentum.fc.common.DfLockHeartbeatThread", "", "", "", "boolean"), 173);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "recoverLockFile", "com.documentum.fc.common.DfLockHeartbeatThread", "", "", "", "void"), 182);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("22", "sleepAWhile", "com.documentum.fc.common.DfLockHeartbeatThread", "", "", "", "void"), 270);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("22", "isShouldStop", "com.documentum.fc.common.DfLockHeartbeatThread", "", "", "", "boolean"), 283);
    }
}

