/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.common;

import com.documentum.fc.common.IDfId;
import com.documentum.fc.common.impl.documentation.Visibility;
import com.documentum.fc.common.impl.documentation.VisibilityType;
import com.documentum.fc.impl.util.StringUtil;
import com.documentum.fc.tracing.ITraceString;
import java.io.Serializable;

@Visibility(visibility=VisibilityType.PUBLIC)
public final class DfId
implements IDfId,
ITraceString,
Serializable {
    private static final int[] s_charToNumberMap = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 48, 49, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 60, 61, 62, 63, -1, -1, -1, -1, -1};
    private static final char[] s_intToCharMap = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', '#', '$', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'w', 'x', 'y', 'z'};
    public static final String DF_NULLID_STR = "0000000000000000";
    public static final DfId DF_NULLID = new DfId("0000000000000000");
    private final String m_string;
    private transient int m_typePart;
    private transient long m_docbasePart;
    private static final long serialVersionUID = 9216899495804588621L;

    public DfId(String string) {
        this.m_string = StringUtil.isEmptyOrNull(string) ? DF_NULLID_STR : string;
        this.m_typePart = 0;
        this.m_docbasePart = 0L;
    }

    public DfId(int typePart, long docbasePart, long objectPart) {
        this.m_string = DfId.generateString(typePart, docbasePart, objectPart);
        this.m_typePart = typePart;
        this.m_docbasePart = docbasePart;
    }

    private static String generateString(int typePart, long docbasePart, long objectPart) {
        return new String(DfId.generateGalacticValue(typePart, 2)) + new String(DfId.generateGalacticValue(docbasePart, 6)) + new String(DfId.generateGalacticValue(objectPart, 8));
    }

    private static char[] generateGalacticValue(long value, int numberOfCharacters) {
        long lowBits = value & 0xFFFFFFFFL;
        long highBits = value >> 32 & 0xFFFFFFFFL;
        char[] result = new char[numberOfCharacters];
        for (int i = result.length - 1; i >= 0; --i) {
            int digitValue = (int)(((highBits & 3L) << 4) + (lowBits & 0xFL));
            result[i] = s_intToCharMap[digitValue];
            highBits >>= 2;
            lowBits >>= 4;
        }
        return result;
    }

    public DfId nextSequentialId() {
        return new DfId(this.getTypePart(), this.getDocbasePart(), this.getObjectPart() + 1L);
    }

    public String getId() {
        return this.toString();
    }

    public synchronized int getTypePart() {
        if (this.m_typePart == 0) {
            try {
                this.m_typePart = DfId.parseTypePart(DfId.extractTypePartChars(this.m_string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.m_typePart;
    }

    public String getDocbaseId() {
        try {
            return new String(DfId.extractDocbasePartChars(this.m_string));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public long getNumericDocbaseId() {
        return this.getDocbasePart();
    }

    private synchronized long getDocbasePart() {
        if (this.m_docbasePart == 0L) {
            try {
                this.m_docbasePart = DfId.parseDocbasePart(DfId.extractDocbasePartChars(this.m_string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.m_docbasePart;
    }

    private long getObjectPart() {
        return DfId.parseObjectPart(DfId.extractObjectPartChars(this.m_string));
    }

    private static char[] extractTypePartChars(String string) {
        try {
            char[] result = new char[2];
            string.getChars(0, 2, result, 0);
            return result;
        }
        catch (StringIndexOutOfBoundsException e) {
            throw DfId.newInvalidLengthException(string.length());
        }
    }

    private static char[] extractDocbasePartChars(String string) {
        try {
            char[] result = new char[6];
            string.getChars(2, 8, result, 0);
            return result;
        }
        catch (StringIndexOutOfBoundsException e) {
            throw DfId.newInvalidLengthException(string.length());
        }
    }

    private static char[] extractObjectPartChars(String string) {
        try {
            char[] result = new char[8];
            string.getChars(8, 16, result, 0);
            return result;
        }
        catch (StringIndexOutOfBoundsException e) {
            throw DfId.newInvalidLengthException(string.length());
        }
    }

    private static IllegalArgumentException newInvalidLengthException(int length) {
        return new IllegalArgumentException("Invalid object id length: " + length);
    }

    private static int parseTypePart(char[] value) {
        return (int)DfId.parseHexidecimalValue(value);
    }

    private static long parseDocbasePart(char[] value) {
        return DfId.parseGalacticValue(value);
    }

    private static long parseObjectPart(char[] value) {
        return DfId.parseGalacticValue(value);
    }

    private static long parseHexidecimalValue(char[] value) {
        assert (value.length <= 16);
        long accumulatedBits = 0L;
        int limit = value.length;
        for (int i = 0; i < limit; ++i) {
            int newBits = Character.digit(value[i], 16);
            if (newBits == -1) {
                throw DfId.newInvalidCharacterException(value[i], "hexidecimal");
            }
            accumulatedBits = (accumulatedBits << 4) + (long)(newBits % 16);
        }
        return accumulatedBits;
    }

    private static long parseGalacticValue(char[] value) {
        assert (value.length <= 8);
        long accumulatedLowBits = 0L;
        long accumulatedHighBits = 0L;
        int limit = value.length;
        for (int i = 0; i < limit; ++i) {
            int newBits = DfId.mapCharToNumber(value[i]);
            accumulatedLowBits = (accumulatedLowBits << 4) + (long)(newBits % 16);
            accumulatedHighBits = (accumulatedHighBits << 2) + (long)(newBits / 16);
        }
        return (accumulatedHighBits << 32) + accumulatedLowBits;
    }

    private static int mapCharToNumber(char c) {
        if (c > '\u007f') {
            throw DfId.newInvalidCharacterException(c, "galactic");
        }
        int number = s_charToNumberMap[c];
        if (number == -1) {
            throw DfId.newInvalidCharacterException(c, "galactic");
        }
        return number;
    }

    private static IllegalArgumentException newInvalidCharacterException(char value, String radixDescription) {
        return new IllegalArgumentException("Invalid " + radixDescription + " object id character: " + value);
    }

    public boolean isObjectId() {
        if (this.isNull() || this.m_string.length() != 16) {
            return false;
        }
        try {
            DfId.parseTypePart(DfId.extractTypePartChars(this.m_string));
            DfId.parseDocbasePart(DfId.extractDocbasePartChars(this.m_string));
            DfId.parseObjectPart(DfId.extractObjectPartChars(this.m_string));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public boolean isNull() {
        return this.m_string.equals(DF_NULLID_STR);
    }

    public int compareTo(IDfId id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        int comparison = this.m_string.compareTo(((Object)id).toString());
        if (comparison > 0) {
            return 1;
        }
        if (comparison < 0) {
            return -1;
        }
        return 0;
    }

    public final String toString() {
        return this.m_string;
    }

    public String toTraceString(boolean verbose) {
        return "DfId{" + this.toString() + "}";
    }

    public boolean equals(Object that) {
        if (that instanceof IDfId) {
            return this.compareTo((IDfId)that) == 0;
        }
        return false;
    }

    public final int hashCode() {
        return this.m_string.hashCode();
    }

    public static DfId valueOf(String string) {
        if (string == null || string.length() == 0 || string.equals(DF_NULLID_STR)) {
            return DF_NULLID;
        }
        return new DfId(string);
    }

    public static boolean isObjectId(String string) {
        return DfId.valueOf(string).isObjectId();
    }
}

