/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.smart;

import com.documentum.com.DfClientX;
import com.documentum.fc.client.IDfPersistentObject;
import com.documentum.fc.client.IDfSession;
import com.documentum.fc.client.smart.IDfConstraint;
import com.documentum.fc.common.DfException;

public class DfConstraintViolationException
extends DfException {
    private String m_constraintDescription;
    private String m_violatorId;
    private transient IDfConstraint m_constraint;
    private transient IDfPersistentObject m_violator;

    private DfConstraintViolationException(String key, Object[] args) {
        super(key, args);
    }

    public DfConstraintViolationException(IDfPersistentObject violator, IDfConstraint constraint) {
        this("DFC_SMART_CONSTRAINT_VIOLATION", DfConstraintViolationException.getArgs(violator, constraint));
        this.m_violator = violator;
        this.m_constraint = constraint;
        this.m_violatorId = DfConstraintViolationException.getViolatorIdString(violator);
        this.m_constraintDescription = DfConstraintViolationException.getConstraintDescriptionString(constraint);
    }

    public IDfConstraint getConstraint() {
        return this.m_constraint;
    }

    public IDfPersistentObject getViolator() {
        return this.m_violator;
    }

    public IDfPersistentObject getViolator(IDfSession session) throws DfException {
        if (!"0000000000000000".equals(this.m_violatorId)) {
            return session.getObject(new DfClientX().getId(this.m_violatorId));
        }
        return null;
    }

    public String getConstraintDescription() {
        return this.m_constraintDescription;
    }

    private static String getViolatorIdString(IDfPersistentObject violator) {
        try {
            if (violator != null) {
                return violator.getObjectId().getId();
            }
            return "0000000000000000";
        }
        catch (DfException e) {
            return "0000000000000000";
        }
    }

    private static String getConstraintDescriptionString(IDfConstraint constraint) {
        try {
            return constraint.getDescription();
        }
        catch (DfException e) {
            return null;
        }
    }

    private static Object[] getArgs(IDfPersistentObject violator, IDfConstraint constraint) {
        assert (violator != null);
        assert (constraint != null);
        String objectId = "unknown";
        try {
            objectId = violator.getObjectId().getId();
        }
        catch (DfException e) {
            // empty catch block
        }
        String description = "";
        try {
            description = constraint.getDescription();
        }
        catch (Exception e) {
            // empty catch block
        }
        return new Object[]{objectId, description};
    }
}

