/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.security.internal;

import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.DfRuntimeException;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplifiedX500DN {
    public static final String COMMON_NAME = "CN";
    public static final String STREET = "STREET";
    public static final String LOCALITY = "L";
    public static final String STATE_OR_PROVINCE = "ST";
    public static final String COUNTRY = "C";
    public static final String ORGANIZATION = "O";
    public static final String ORGANIZATIONAL_UNIT = "OU";
    public static final String DOMAIN_COMPONENT = "DC";
    public static final String USER_ID = "UID";
    public static final String DN_QUANTIFIER = "DNQ";
    public static final String TITLE = "T";
    public static final String NAME = "NAME";
    public static final String GIVEN_NAME = "GIVENNAME";
    public static final String SURNAME = "SN";
    public static final String INITIALS = "INITIALS";
    public static final String GENERATION = "GENERATION";
    public static final String EMAIL = "EMAIL";
    private Map<String, String> valueByAttribute;
    private static final Set KNOWN_ATTRIBUTES;
    private static String[] OUTER_DELIMITERS_START;
    private static String[] OUTER_DELIMITERS_END;
    protected static final String SEQUENCE_SEPARATORS_1779_REGEX = "(?<!\\\\)(,|;|\\+)";
    protected static final String SEQUENCE_SEPARATORS_2253_REGEX = "(?<!\\\\)(,|\\+)";
    protected static final String UNESCAPED_1779_REGEX = "(?<!\\\\)(,|\\+|=|\\n|<|>|\\#|;|\\s{2,}|^\\s|\\s$)";
    protected static final String UNESCAPED_2253_REGEX = "(?<!\\\\)(,|\\+|=|\\|<|>|;|^\\#|^\\s|\\s$)";
    protected static final String UNESCAPED_EQUALS_REGEX = "(?<!\\\\)=";
    protected static final String UNESCAPED_QUOTE_REGEX = "(?<!\\\\)\"";
    protected static final String ESCAPED_QUOTE_REGEX = "\\\\\"";
    protected static final String ESCAPE_SLASH_REGEX = "(?<!\\\\)\\\\";
    protected static final String QUOTED_STRING_REGEX = "\"([^\"\\\\]|\\\\.)*\"";
    private Pattern quotedString;
    private Matcher matcher;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    public SimplifiedX500DN(String name) {
        String string = name;
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.valueByAttribute = new LinkedHashMap<String, String>(KNOWN_ATTRIBUTES.size());
            KNOWN_ATTRIBUTES.add(COMMON_NAME);
            KNOWN_ATTRIBUTES.add(STREET);
            KNOWN_ATTRIBUTES.add(LOCALITY);
            KNOWN_ATTRIBUTES.add(STATE_OR_PROVINCE);
            KNOWN_ATTRIBUTES.add(COUNTRY);
            KNOWN_ATTRIBUTES.add(ORGANIZATION);
            KNOWN_ATTRIBUTES.add(ORGANIZATIONAL_UNIT);
            KNOWN_ATTRIBUTES.add(DOMAIN_COMPONENT);
            KNOWN_ATTRIBUTES.add(USER_ID);
            KNOWN_ATTRIBUTES.add(DN_QUANTIFIER);
            KNOWN_ATTRIBUTES.add(TITLE);
            KNOWN_ATTRIBUTES.add(NAME);
            KNOWN_ATTRIBUTES.add(GIVEN_NAME);
            KNOWN_ATTRIBUTES.add(SURNAME);
            KNOWN_ATTRIBUTES.add(INITIALS);
            KNOWN_ATTRIBUTES.add(GENERATION);
            KNOWN_ATTRIBUTES.add(EMAIL);
            this.quotedString = Pattern.compile(QUOTED_STRING_REGEX);
            this.parseName(name, false);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public SimplifiedX500DN(String name, boolean rfc1779) {
        String string = name;
        boolean bl = rfc1779;
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.valueByAttribute = new LinkedHashMap<String, String>(KNOWN_ATTRIBUTES.size());
            KNOWN_ATTRIBUTES.add(COMMON_NAME);
            KNOWN_ATTRIBUTES.add(STREET);
            KNOWN_ATTRIBUTES.add(LOCALITY);
            KNOWN_ATTRIBUTES.add(STATE_OR_PROVINCE);
            KNOWN_ATTRIBUTES.add(COUNTRY);
            KNOWN_ATTRIBUTES.add(ORGANIZATION);
            KNOWN_ATTRIBUTES.add(ORGANIZATIONAL_UNIT);
            KNOWN_ATTRIBUTES.add(DOMAIN_COMPONENT);
            KNOWN_ATTRIBUTES.add(USER_ID);
            KNOWN_ATTRIBUTES.add(DN_QUANTIFIER);
            KNOWN_ATTRIBUTES.add(TITLE);
            KNOWN_ATTRIBUTES.add(NAME);
            KNOWN_ATTRIBUTES.add(GIVEN_NAME);
            KNOWN_ATTRIBUTES.add(SURNAME);
            KNOWN_ATTRIBUTES.add(INITIALS);
            KNOWN_ATTRIBUTES.add(GENERATION);
            KNOWN_ATTRIBUTES.add(EMAIL);
            this.quotedString = Pattern.compile(QUOTED_STRING_REGEX);
            this.parseName(name, rfc1779);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getValueForAttribute(String string) {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            void attributeName;
            String string3;
            String string4;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String string5 = string4 = (string3 = this.valueByAttribute.get(attributeName));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string4, joinPoint);
            }
            return string3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public Set<String> getAttributesWithValue() {
        JoinPoint joinPoint = null;
        try {
            Set<String> set;
            Set<String> set2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            Set<String> set3 = set2 = (set = Collections.unmodifiableSet(this.valueByAttribute.keySet()));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(set2, joinPoint);
            }
            return set;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public static Set<String> getAllKnownAttributes() {
        JoinPoint joinPoint = null;
        try {
            Set<String> set;
            Set<String> set2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            Set<String> set3 = set2 = (set = Collections.unmodifiableSet(KNOWN_ATTRIBUTES));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(set2, joinPoint);
            }
            return set;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public String toString() {
        Iterator<String> i = this.valueByAttribute.keySet().iterator();
        StringBuffer sb = new StringBuffer(500);
        sb.append('<');
        while (i.hasNext()) {
            String keyVal = i.next();
            sb.append(keyVal);
            sb.append('=');
            sb.append(this.valueByAttribute.get(keyVal));
            sb.append(',');
        }
        if (0 < sb.length()) {
            sb.setLength(sb.length() - 1);
        }
        sb.append('>');
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object object) {
        Object object2 = object;
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            void dn;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)object2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            boolean bl3 = bl2 = this == dn ? (bl = true) : (dn instanceof SimplifiedX500DN ? (bl = this.toString().equals(((SimplifiedX500DN)dn).toString())) : (bl = false));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object3 = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)object2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object3, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)object2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    protected void parseName(String string, boolean bl) {
        String string2 = string;
        boolean bl2 = bl;
        JoinPoint joinPoint = null;
        try {
            String[] fields;
            void rfc1779;
            String name;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string2, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            assert (null != name && 0 < name.length());
            DfLogger.debug((Object)this, "parsing X500 DN ----{0}---- rfc1779 is {1}", new Object[]{name, new Boolean((boolean)rfc1779)}, null);
            int n = OUTER_DELIMITERS_START.length;
            for (int i = 0; i < n; ++i) {
                if (!name.startsWith(OUTER_DELIMITERS_START[i])) continue;
                if (name.endsWith(OUTER_DELIMITERS_END[i])) {
                    name = name.substring(1, name.length() - 1);
                    continue;
                }
                throw new DfRuntimeException("DFC_SECURITY_BAD_X500DN", new Object[]{name, "mismatched delimiters"});
            }
            String newName = new String(name);
            String onUnescaped = UNESCAPED_2253_REGEX;
            if (rfc1779 != false) {
                onUnescaped = UNESCAPED_1779_REGEX;
            }
            this.matcher = this.quotedString.matcher(name);
            while (this.matcher.find()) {
                String unquoted = this.matcher.group(0);
                unquoted = unquoted.substring(1, unquoted.length() - 1);
                unquoted = unquoted.replaceAll(onUnescaped, "\\\\$1");
                unquoted = unquoted.replaceAll(ESCAPED_QUOTE_REGEX, "\"");
                newName = name.replace(this.matcher.group(0), unquoted);
            }
            String onSeparator = SEQUENCE_SEPARATORS_2253_REGEX;
            if (rfc1779 != false) {
                onSeparator = SEQUENCE_SEPARATORS_1779_REGEX;
            }
            for (String field : fields = newName.split(onSeparator)) {
                String[] attVal = field.split(UNESCAPED_EQUALS_REGEX);
                if (2 != attVal.length || null == attVal[0] || null == attVal[1]) {
                    throw new DfRuntimeException("DFC_SECURITY_BAD_X500DN", new Object[]{name, field});
                }
                attVal[0] = attVal[0].trim();
                if (0 == attVal[0].length() || 0 == attVal[1].length()) {
                    throw new DfRuntimeException("DFC_SECURITY_BAD_X500DN", new Object[]{field, "incomplete field"});
                }
                if (!KNOWN_ATTRIBUTES.contains(attVal[0])) {
                    throw new DfRuntimeException("DFC_SECURITY_BAD_X500DN", new Object[]{attVal[0], "unknown attribute"});
                }
                String val = this.unescape(attVal[1]);
                this.valueByAttribute.put(attVal[0], val);
            }
            Object var17_19 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string2, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var17_19, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string2, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String unescape(String string) {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            void str;
            String string3;
            String string4;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String string5 = string4 = (string3 = str.replaceAll(ESCAPE_SLASH_REGEX, ""));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string4, joinPoint);
            }
            return string3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    protected SimplifiedX500DN() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.valueByAttribute = new LinkedHashMap<String, String>(KNOWN_ATTRIBUTES.size());
            KNOWN_ATTRIBUTES.add(COMMON_NAME);
            KNOWN_ATTRIBUTES.add(STREET);
            KNOWN_ATTRIBUTES.add(LOCALITY);
            KNOWN_ATTRIBUTES.add(STATE_OR_PROVINCE);
            KNOWN_ATTRIBUTES.add(COUNTRY);
            KNOWN_ATTRIBUTES.add(ORGANIZATION);
            KNOWN_ATTRIBUTES.add(ORGANIZATIONAL_UNIT);
            KNOWN_ATTRIBUTES.add(DOMAIN_COMPONENT);
            KNOWN_ATTRIBUTES.add(USER_ID);
            KNOWN_ATTRIBUTES.add(DN_QUANTIFIER);
            KNOWN_ATTRIBUTES.add(TITLE);
            KNOWN_ATTRIBUTES.add(NAME);
            KNOWN_ATTRIBUTES.add(GIVEN_NAME);
            KNOWN_ATTRIBUTES.add(SURNAME);
            KNOWN_ATTRIBUTES.add(INITIALS);
            KNOWN_ATTRIBUTES.add(GENERATION);
            KNOWN_ATTRIBUTES.add(EMAIL);
            this.quotedString = Pattern.compile(QUOTED_STRING_REGEX);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("SimplifiedX500DN.java", Class.forName("com.documentum.fc.client.security.internal.SimplifiedX500DN"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getValueForAttribute", "com.documentum.fc.client.security.internal.SimplifiedX500DN", "java.lang.String:", "attributeName:", "", "java.lang.String"), 57);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttributesWithValue", "com.documentum.fc.client.security.internal.SimplifiedX500DN", "", "", "", "java.util.Set"), 66);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getAllKnownAttributes", "com.documentum.fc.client.security.internal.SimplifiedX500DN", "", "", "", "java.util.Set"), 75);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "equals", "com.documentum.fc.client.security.internal.SimplifiedX500DN", "java.lang.Object:", "dn:", "", "boolean"), 100);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "parseName", "com.documentum.fc.client.security.internal.SimplifiedX500DN", "java.lang.String:boolean:", "name:rfc1779:", "", "void"), 117);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "unescape", "com.documentum.fc.client.security.internal.SimplifiedX500DN", "java.lang.String:", "str:", "", "java.lang.String"), 194);
        ajc$tjp_6 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.documentum.fc.client.security.internal.SimplifiedX500DN", "java.lang.String:", "name:", ""), 220);
        ajc$tjp_7 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.documentum.fc.client.security.internal.SimplifiedX500DN", "java.lang.String:boolean:", "name:rfc1779:", ""), 220);
        ajc$tjp_8 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("4", "com.documentum.fc.client.security.internal.SimplifiedX500DN", "", "", ""), 220);
        KNOWN_ATTRIBUTES = new LinkedHashSet();
        OUTER_DELIMITERS_START = new String[]{"<", "["};
        OUTER_DELIMITERS_END = new String[]{">", "]"};
    }
}

