/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.security.impl.policy;

import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class AugmentedPolicy
extends Policy {
    private Policy m_originalPolicy;
    private Map<CodeSource, PermissionCollection> m_extraPermissions;

    public AugmentedPolicy() {
        this(Policy.getPolicy());
    }

    public AugmentedPolicy(Policy originalPolicy) {
        assert (originalPolicy != null);
        this.m_originalPolicy = originalPolicy;
        this.m_extraPermissions = new HashMap<CodeSource, PermissionCollection>();
    }

    public void add(CodeSource codeSource, PermissionCollection extraPermissions) {
        this.m_extraPermissions.put(codeSource, extraPermissions);
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissions = this.m_originalPolicy.getPermissions(codeSource);
        PermissionCollection extraPermissions = this.m_extraPermissions.get(codeSource);
        if (extraPermissions != null) {
            this.augmentPermissions(permissions, extraPermissions);
        }
        return permissions;
    }

    private void augmentPermissions(PermissionCollection permissions, PermissionCollection extraPermissions) {
        Enumeration<Permission> en = extraPermissions.elements();
        while (en.hasMoreElements()) {
            permissions.add(en.nextElement());
        }
    }

    public PermissionCollection getPermissions(ProtectionDomain domain) {
        PermissionCollection permissions = this.m_originalPolicy.getPermissions(domain);
        PermissionCollection extraPermissions = this.m_extraPermissions.get(domain.getCodeSource());
        if (extraPermissions != null) {
            this.augmentPermissions(permissions, extraPermissions);
        }
        return permissions;
    }

    public void refresh() {
        this.m_originalPolicy.refresh();
    }

    public boolean implies(ProtectionDomain domain, Permission permission) {
        if (this.m_originalPolicy.implies(domain, permission)) {
            return true;
        }
        PermissionCollection extraPermissions = this.m_extraPermissions.get(domain.getCodeSource());
        return extraPermissions != null && extraPermissions.implies(permission);
    }
}

