/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.security.impl;

import com.documentum.fc.client.security.IDfAuthenticationInfo;
import com.documentum.fc.client.security.impl.AuthenticationMgrForDfc;
import com.documentum.fc.client.security.impl.IIdentityManager;
import com.documentum.fc.client.security.impl.IdentityKeystore;
import com.documentum.fc.client.security.internal.IPublicIdentity;
import com.documentum.fc.client.security.internal.KeystoreMgr;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.DfUtil;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.util.Date;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class IdentityManager
implements IIdentityManager {
    private String m_hostName;
    private AuthenticationMgrForDfc m_am;
    private long lastBundleTime = 0L;
    private String lastBundle = null;
    private long lastInfoTime = 0L;
    private IDfAuthenticationInfo lastInfo = null;
    private static long msToLive;
    private static long zombieCacheWindow;
    private static long maxCacheAge;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;

    public IdentityManager() {
        IdentityManager.computeMaxCacheAge();
        this.initFromKeystore();
    }

    public String getIdentityBundle() {
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            String string3;
            block21: {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                if (null == this.lastBundle) {
                    this.lastBundleTime = System.currentTimeMillis();
                    try {
                        this.lastBundle = this.createIdentityBundle();
                    }
                    catch (DfException ex) {
                        DfLogger.error((Object)this, "DFC_SECURITY_IDENTITY_CREATION", new Object[]{"bad bundle"}, (Throwable)ex);
                        string2 = string3 = null;
                        break block21;
                    }
                    string2 = string3 = this.lastBundle;
                } else if (System.currentTimeMillis() - this.lastBundleTime > maxCacheAge) {
                    this.lastBundleTime = System.currentTimeMillis();
                    try {
                        this.lastBundle = this.createIdentityBundle();
                    }
                    catch (DfException ex) {
                        DfLogger.error((Object)this, "DFC_SECURITY_IDENTITY_CREATION", new Object[]{"bad bundle"}, (Throwable)ex);
                        string2 = string3 = null;
                        break block21;
                    }
                    string2 = string3 = this.lastBundle;
                } else {
                    assert (0L < maxCacheAge);
                    assert (System.currentTimeMillis() > this.lastBundleTime);
                    assert (System.currentTimeMillis() - this.lastBundleTime < maxCacheAge);
                    assert (null != this.lastBundle);
                    if (DfLogger.isDebugEnabled(this)) {
                        Date dNow = new Date();
                        DfLogger.debug((Object)this, "time now (s since POSIX epoch): {0}", new Object[]{dNow.getTime() / 1000L}, null);
                        DfLogger.debug((Object)this, "bundle: <{0}>", new Object[]{this.lastBundle}, null);
                    }
                    string2 = string3 = this.lastBundle;
                }
            }
            String string4 = string = string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string, joinPoint);
            }
            return string3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public IDfAuthenticationInfo getAuthenticationInfo() {
        JoinPoint joinPoint = null;
        try {
            IDfAuthenticationInfo iDfAuthenticationInfo;
            IDfAuthenticationInfo iDfAuthenticationInfo2;
            IDfAuthenticationInfo iDfAuthenticationInfo3;
            block21: {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                if (null == this.lastInfo) {
                    this.lastInfoTime = System.currentTimeMillis();
                    try {
                        this.lastInfo = this.createAuthenticationInfo();
                    }
                    catch (DfException ex) {
                        DfLogger.error((Object)this, "DFC_SECURITY_IDENTITY_CREATION", new Object[]{"authentication info"}, (Throwable)ex);
                        iDfAuthenticationInfo2 = iDfAuthenticationInfo3 = null;
                        break block21;
                    }
                    iDfAuthenticationInfo2 = iDfAuthenticationInfo3 = this.lastInfo;
                } else if (System.currentTimeMillis() - this.lastInfoTime > maxCacheAge) {
                    this.lastInfoTime = System.currentTimeMillis();
                    try {
                        this.lastInfo = this.createAuthenticationInfo();
                    }
                    catch (DfException ex) {
                        DfLogger.error((Object)this, "DFC_SECURITY_IDENTITY_CREATION", new Object[]{"authentication info"}, (Throwable)ex);
                        iDfAuthenticationInfo2 = iDfAuthenticationInfo3 = null;
                        break block21;
                    }
                    iDfAuthenticationInfo2 = iDfAuthenticationInfo3 = this.lastInfo;
                } else {
                    assert (0L < maxCacheAge);
                    assert (System.currentTimeMillis() > this.lastInfoTime);
                    assert (System.currentTimeMillis() - this.lastInfoTime < maxCacheAge);
                    assert (null != this.lastInfo);
                    if (DfLogger.isDebugEnabled(this)) {
                        Date dNow = new Date();
                        DfLogger.debug((Object)this, "time now (s since POSIX epoch): {0}", new Object[]{dNow.getTime() / 1000L}, null);
                        DfLogger.debug((Object)this, "info, raw <{0}> sig <{1}>", new Object[]{this.lastInfo.getRaw(), this.lastInfo.getDigitalSignature()}, null);
                    }
                    iDfAuthenticationInfo2 = iDfAuthenticationInfo3 = this.lastInfo;
                }
            }
            IDfAuthenticationInfo iDfAuthenticationInfo4 = iDfAuthenticationInfo = iDfAuthenticationInfo2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(iDfAuthenticationInfo, joinPoint);
            }
            return iDfAuthenticationInfo3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public IPublicIdentity getPublicIdentity() {
        JoinPoint joinPoint = null;
        try {
            IPublicIdentity iPublicIdentity;
            IPublicIdentity iPublicIdentity2;
            IPublicIdentity iPublicIdentity3;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            try {
                iPublicIdentity2 = iPublicIdentity3 = KeystoreMgr.getDfcPublicIdentity();
            }
            catch (Exception ex) {
                DfLogger.error((Object)this, "DFC_SECURITY_IDENTITY_RETRIEVAL", null, (Throwable)ex);
                iPublicIdentity2 = iPublicIdentity3 = null;
            }
            IPublicIdentity iPublicIdentity4 = iPublicIdentity = iPublicIdentity2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(iPublicIdentity, joinPoint);
            }
            return iPublicIdentity3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public void initFromKeystore() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            try {
                IdentityKeystore iks = KeystoreMgr.initForDfcWithDefaultPolicy();
                this.m_am = new AuthenticationMgrForDfc(iks);
                this.m_hostName = DfUtil.getMyHostNameForPrivilegedDfc();
            }
            catch (Exception ex) {
                DfLogger.error((Object)this, "DFC_SECURITY_IDENTITY_INIT", null, (Throwable)ex);
            }
            Object var3_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var3_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private static void computeMaxCacheAge() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            maxCacheAge = zombieCacheWindow > msToLive ? 0L : msToLive - zombieCacheWindow;
            Object var1_1 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var1_1, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    protected static long getMsToLive() {
        JoinPoint joinPoint = null;
        try {
            long l;
            long l2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            long l3 = l2 = (l = msToLive);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.longObject((long)l2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return l;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    protected static void setMsToLive(long l) {
        long l2 = l;
        JoinPoint joinPoint = null;
        try {
            long msToLive;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object)Conversions.longObject((long)l2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            IdentityManager.msToLive = msToLive;
            IdentityManager.computeMaxCacheAge();
            Object var5_3 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object)Conversions.longObject((long)l2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var5_3, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object)Conversions.longObject((long)l2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    protected static long getZombieCacheWindow() {
        JoinPoint joinPoint = null;
        try {
            long l;
            long l2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            long l3 = l2 = (l = zombieCacheWindow);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.longObject((long)l2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return l;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    protected static void setZombieCacheWindow(long l) {
        long l2 = l;
        JoinPoint joinPoint = null;
        try {
            long zombieCacheWindow;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null, (Object)Conversions.longObject((long)l2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            IdentityManager.zombieCacheWindow = zombieCacheWindow;
            IdentityManager.computeMaxCacheAge();
            Object var5_3 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null, (Object)Conversions.longObject((long)l2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var5_3, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null, (Object)Conversions.longObject((long)l2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private String createIdentityBundle() throws DfException {
        JoinPoint joinPoint = null;
        try {
            String string;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (this.m_am == null) {
                throw new DfException("DFC_SECURITY_IDENTITY_BUNDLE_FAIL");
            }
            String string2 = this.m_am.createIdentityBundle(this.m_hostName, null);
            String string3 = string = string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string, joinPoint);
            }
            return string2;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private IDfAuthenticationInfo createAuthenticationInfo() throws DfException {
        JoinPoint joinPoint = null;
        try {
            IDfAuthenticationInfo iDfAuthenticationInfo;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (this.m_am == null) {
                throw new DfException("DFC_SECURITY_AUTHENTICATION_INFO_FAIL");
            }
            IDfAuthenticationInfo iDfAuthenticationInfo2 = this.m_am.createAuthenticationInfo(this.m_hostName, null);
            IDfAuthenticationInfo iDfAuthenticationInfo3 = iDfAuthenticationInfo = iDfAuthenticationInfo2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(iDfAuthenticationInfo, joinPoint);
            }
            return iDfAuthenticationInfo2;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("IdentityManager.java", Class.forName("com.documentum.fc.client.security.impl.IdentityManager"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getIdentityBundle", "com.documentum.fc.client.security.impl.IdentityManager", "", "", "", "java.lang.String"), 45);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAuthenticationInfo", "com.documentum.fc.client.security.impl.IdentityManager", "", "", "", "com.documentum.fc.client.security.IDfAuthenticationInfo"), 97);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createAuthenticationInfo", "com.documentum.fc.client.security.impl.IdentityManager", "", "", "com.documentum.fc.common.DfException:", "com.documentum.fc.client.security.IDfAuthenticationInfo"), 224);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPublicIdentity", "com.documentum.fc.client.security.impl.IdentityManager", "", "", "", "com.documentum.fc.client.security.internal.IPublicIdentity"), 154);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initFromKeystore", "com.documentum.fc.client.security.impl.IdentityManager", "", "", "", "void"), 170);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "computeMaxCacheAge", "com.documentum.fc.client.security.impl.IdentityManager", "", "", "", "void"), 182);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c", "getMsToLive", "com.documentum.fc.client.security.impl.IdentityManager", "", "", "", "long"), 194);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c", "setMsToLive", "com.documentum.fc.client.security.impl.IdentityManager", "long:", "msToLive:", "", "void"), 199);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c", "getZombieCacheWindow", "com.documentum.fc.client.security.impl.IdentityManager", "", "", "", "long"), 205);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c", "setZombieCacheWindow", "com.documentum.fc.client.security.impl.IdentityManager", "long:", "zombieCacheWindow:", "", "void"), 210);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createIdentityBundle", "com.documentum.fc.client.security.impl.IdentityManager", "", "", "com.documentum.fc.common.DfException:", "java.lang.String"), 216);
        msToLive = 1800000L;
        zombieCacheWindow = 840000L;
    }
}

