/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.security.impl;

import com.documentum.fc.client.security.impl.JKSKeystoreUtil;
import com.documentum.fc.client.security.internal.SimplifiedX500DN;
import com.documentum.fc.common.DfCriticalException;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import javax.security.auth.x500.X500PrivateCredential;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public abstract class IdentityKeystore {
    protected JKSKeystoreUtil m_ksUtil;
    protected KeyStore m_ks;
    protected boolean m_Found;
    protected X509Certificate m_cert = null;
    protected String m_identity = null;
    protected String m_alias = null;
    protected static X500PrivateCredential s_credential;
    protected static final String needCredentialMsg = "DFC_SECURITY_CREDENTIAL_NA";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public X509Certificate getCertificate() throws DfException {
        JoinPoint joinPoint = null;
        try {
            X509Certificate x509Certificate;
            X509Certificate x509Certificate2;
            X509Certificate x509Certificate3;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (null != this.m_cert) {
                x509Certificate2 = x509Certificate3 = this.m_cert;
            } else {
                X509Certificate x509Certificate4;
                try {
                    x509Certificate4 = this.m_cert = (X509Certificate)this.m_ks.getCertificate(this.m_ksUtil.getSecurityName());
                }
                catch (KeyStoreException e) {
                    DfLogger.debug((Object)this, "keystore {0} not initialized, should be impossible here", new Object[]{this.m_ksUtil.getKeystoreFqfn()}, (Throwable)e);
                    throw new DfCriticalException("DFC_SECURITY_IDENTITY_INIT", null, e);
                }
                x509Certificate2 = x509Certificate3 = x509Certificate4;
            }
            X509Certificate x509Certificate5 = x509Certificate = x509Certificate2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(x509Certificate, joinPoint);
            }
            return x509Certificate3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public String getIdentity() throws DfException {
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            String string3;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (null != this.m_identity) {
                string2 = string3 = this.m_identity;
            } else {
                X509Certificate cert = this.getCertificate();
                X500Principal principal = cert.getSubjectX500Principal();
                SimplifiedX500DN dn = new SimplifiedX500DN(principal.getName());
                this.m_identity = dn.getValueForAttribute("CN");
                if (null == this.m_identity || 0 == this.m_identity.length()) {
                    throw new DfCriticalException("DFC_SECURITY_BAD_X500DN", new Object[]{this.m_ksUtil.getKeystoreFqfn(), cert.toString()});
                }
                string2 = string3 = this.m_identity;
            }
            String string4 = string = string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string, joinPoint);
            }
            return string3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public String getAlias() throws DfException {
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String string3 = string2 = null != this.m_alias ? (string = this.m_alias) : (string = (this.m_alias = this.m_ksUtil.getSecurityName()));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public boolean isCredentialFound() {
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            boolean bl3 = bl2 = (bl = this.m_Found);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    PrivateKey getPrivateKey() throws DfException {
        JoinPoint joinPoint = null;
        try {
            PrivateKey privateKey;
            PrivateKey privateKey2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            PrivateKey privateKey3 = privateKey2 = (privateKey = this.m_ksUtil.getPrivateKey(this.m_ks));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(privateKey2, joinPoint);
            }
            return privateKey;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    protected static void checkCredential() throws DfException {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (null == s_credential || s_credential.isDestroyed()) {
                throw new DfException("DFC_SECURITY_ILLEGAL_STATE", new Object[]{needCredentialMsg});
            }
            Object var1_1 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var1_1, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static void setIdentityCredential(X500PrivateCredential x500PrivateCredential) {
        X500PrivateCredential x500PrivateCredential2 = x500PrivateCredential;
        JoinPoint joinPoint = null;
        try {
            X500PrivateCredential c;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object)x500PrivateCredential2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            assert (null != c && !c.isDestroyed());
            s_credential = c;
            Object var3_3 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object)x500PrivateCredential2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var3_3, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object)x500PrivateCredential2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("IdentityKeystore.java", Class.forName("com.documentum.fc.client.security.impl.IdentityKeystore"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCertificate", "com.documentum.fc.client.security.impl.IdentityKeystore", "", "", "com.documentum.fc.common.DfException:", "java.security.cert.X509Certificate"), 49);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getIdentity", "com.documentum.fc.client.security.impl.IdentityKeystore", "", "", "com.documentum.fc.common.DfException:", "java.lang.String"), 67);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAlias", "com.documentum.fc.client.security.impl.IdentityKeystore", "", "", "com.documentum.fc.common.DfException:", "java.lang.String"), 82);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isCredentialFound", "com.documentum.fc.client.security.impl.IdentityKeystore", "", "", "", "boolean"), 90);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getPrivateKey", "com.documentum.fc.client.security.impl.IdentityKeystore", "", "", "com.documentum.fc.common.DfException:", "java.security.PrivateKey"), 96);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c", "checkCredential", "com.documentum.fc.client.security.impl.IdentityKeystore", "", "", "com.documentum.fc.common.DfException:", "void"), 101);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8", "setIdentityCredential", "com.documentum.fc.client.security.impl.IdentityKeystore", "javax.security.auth.x500.X500PrivateCredential:", "c:", "", "void"), 110);
        s_credential = null;
    }
}

