/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.security.impl;

import com.documentum.fc.client.security.impl.IIdentityManager;
import com.documentum.fc.client.security.impl.IdentityKeystore;
import com.documentum.fc.client.security.impl.JKSKeystoreUtil;
import com.documentum.fc.client.security.impl.JKSKeystoreUtilForDfc;
import com.documentum.fc.common.DfCriticalException;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfInterProcessLockFactory;
import com.documentum.fc.common.IDfInterProcessLock;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.security.KeyStore;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

final class DfcIdentityKeystore
extends IdentityKeystore {
    private static Object m_identityMutex;
    private static Object m_policyMutex;
    private final IDfInterProcessLock m_ipLock;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DfcIdentityKeystore() throws DfException {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_ipLock = DfInterProcessLockFactory.getInstance().getNewLock(IIdentityManager.ipLockName);
            Object object = m_identityMutex;
            synchronized (object) {
                try {
                    this.m_ipLock.acquire();
                    this.m_ksUtil = new JKSKeystoreUtilForDfc();
                    PolicyOutcome outcome = DfcIdentityKeystore.applyDfcInitPolicy(this.m_ksUtil);
                    assert (null != outcome.getKs());
                    this.m_ks = outcome.getKs();
                    this.m_Found = outcome.isCredentialsFound();
                }
                finally {
                    this.m_ipLock.release();
                }
            }
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PolicyOutcome applyDfcInitPolicy(JKSKeystoreUtil jKSKeystoreUtil) throws DfException {
        JKSKeystoreUtil jKSKeystoreUtil2 = jKSKeystoreUtil;
        JoinPoint joinPoint = null;
        try {
            PolicyOutcome policyOutcome;
            PolicyOutcome policyOutcome2;
            PolicyOutcome policyOutcome3;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)jKSKeystoreUtil2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            Object object = m_policyMutex;
            synchronized (object) {
                JKSKeystoreUtil ksUtil;
                KeyStore ks = null;
                boolean credentialsFound = true;
                ks = ksUtil.getExistingReadableAccessibleKeystore(false);
                if (null == ks) {
                    DfcIdentityKeystore.checkCredential();
                    try {
                        ksUtil.createNewKeystore(s_credential);
                        credentialsFound = false;
                    }
                    finally {
                        if (null != s_credential && !s_credential.isDestroyed()) {
                            s_credential.destroy();
                        }
                        s_credential = null;
                    }
                    ks = ksUtil.getExistingReadableAccessibleKeystore(false);
                }
                if (null == ks) {
                    throw new DfCriticalException("DFC_SECURITY_KEYSTORE_ERROR", new Object[]{"create", ksUtil.getKeystoreFqfn()});
                }
                if (ksUtil.isAliasVerify(ks, false, true)) {
                    boolean isOk = ksUtil.isPrivateKeyAccessible(ks);
                    if (!isOk) {
                        throw new DfException("DFC_SECURITY_PASSWORD_WRONG", new Object[]{"private key", ksUtil.getKeystoreFqfn()});
                    }
                } else {
                    ks = null;
                    System.gc();
                    DfcIdentityKeystore.checkCredential();
                    try {
                        ksUtil.appendToExistingKeystore(s_credential);
                        credentialsFound = false;
                    }
                    finally {
                        if (null != s_credential && !s_credential.isDestroyed()) {
                            s_credential.destroy();
                        }
                        s_credential = null;
                    }
                    ks = ksUtil.getExistingReadableAccessibleKeystore(false);
                }
                if (null != s_credential && !s_credential.isDestroyed()) {
                    s_credential.destroy();
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl49 : MonitorExitStatement: MONITOREXIT : var1_3
                policyOutcome2 = policyOutcome3 = new PolicyOutcome(ks, credentialsFound);
            }
            PolicyOutcome policyOutcome4 = policyOutcome = policyOutcome2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)jKSKeystoreUtil2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(policyOutcome, joinPoint);
            }
            return policyOutcome3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)jKSKeystoreUtil2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("DfcIdentityKeystore.java", Class.forName("com.documentum.fc.client.security.impl.DfcIdentityKeystore"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8", "applyDfcInitPolicy", "com.documentum.fc.client.security.impl.DfcIdentityKeystore", "com.documentum.fc.client.security.impl.JKSKeystoreUtil:", "ksUtil:", "com.documentum.fc.common.DfException:", "com.documentum.fc.client.security.impl.DfcIdentityKeystore$PolicyOutcome"), 71);
        ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("0", "com.documentum.fc.client.security.impl.DfcIdentityKeystore", "", "", "com.documentum.fc.common.DfException:"), 203);
        m_identityMutex = new Object();
        m_policyMutex = new Object();
    }

    static class PolicyOutcome {
        private KeyStore ks;
        private boolean credentialsFound;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        KeyStore getKs() {
            JoinPoint joinPoint = null;
            try {
                KeyStore keyStore;
                KeyStore keyStore2;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                KeyStore keyStore3 = keyStore2 = (keyStore = this.ks);
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(keyStore2, joinPoint);
                }
                return keyStore;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        boolean isCredentialsFound() {
            JoinPoint joinPoint = null;
            try {
                boolean bl;
                boolean bl2;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                boolean bl3 = bl2 = (bl = this.credentialsFound);
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    Object object = Conversions.booleanObject((boolean)bl2);
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        PolicyOutcome(KeyStore store, boolean found) {
            KeyStore keyStore = store;
            boolean bl = found;
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)keyStore, (Object)Conversions.booleanObject((boolean)bl));
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                this.ks = null;
                this.credentialsFound = true;
                this.ks = store;
                this.credentialsFound = found;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)keyStore, (Object)Conversions.booleanObject((boolean)bl));
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)keyStore, (Object)Conversions.booleanObject((boolean)bl));
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        static {
            Factory factory = new Factory("DfcIdentityKeystore.java", Class.forName("com.documentum.fc.client.security.impl.DfcIdentityKeystore$PolicyOutcome"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getKs", "com.documentum.fc.client.security.impl.DfcIdentityKeystore$PolicyOutcome", "", "", "", "java.security.KeyStore"), 183);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "isCredentialsFound", "com.documentum.fc.client.security.impl.DfcIdentityKeystore$PolicyOutcome", "", "", "", "boolean"), 188);
            ajc$tjp_2 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("0", "com.documentum.fc.client.security.impl.DfcIdentityKeystore$PolicyOutcome", "java.security.KeyStore:boolean:", "store:found:", ""), 191);
        }
    }
}

