/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.security.impl;

import com.documentum.fc.client.security.IDfAuthenticationInfo;
import com.documentum.fc.client.security.impl.JKSKeystoreUtilForAny;
import com.documentum.fc.client.security.internal.AuthenticationMgr;
import com.documentum.fc.client.security.internal.IAuthenticationMgr;
import com.documentum.fc.client.security.internal.SimplifiedX500DN;
import com.documentum.fc.common.DfCriticalException;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import javax.security.auth.x500.X500Principal;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class AuthenticationMgrForAny
implements IAuthenticationMgr {
    private final JKSKeystoreUtilForAny s_ku;
    private final String m_identity;
    private final boolean m_isAutoTimeStamp;
    Long timeStamp;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    public AuthenticationMgrForAny(String keystoreFqFn, String ksPwd, String pkPwd, String alias, Long secondsSinceEpoch) throws DfException {
        String string = keystoreFqFn;
        String string2 = ksPwd;
        String string3 = pkPwd;
        String string4 = alias;
        Long l = secondsSinceEpoch;
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string, string2, string3, string4, l};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.timeStamp = null;
            this.s_ku = new JKSKeystoreUtilForAny(keystoreFqFn, ksPwd, pkPwd, alias);
            this.m_identity = this.getIdentity();
            this.timeStamp = secondsSinceEpoch;
            this.m_isAutoTimeStamp = false;
            AuthenticationMgr.vetIdentity(this.m_identity);
            DfLogger.info((Object)this, "identity for authentication is {0}", new Object[]{this.m_identity}, null);
            DfLogger.info((Object)this, "keystore for authentication is {0}", new Object[]{keystoreFqFn}, null);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string, string2, string3, string4, l};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string, string2, string3, string4, l};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public AuthenticationMgrForAny(String keystoreFqFn, String ksPwd, String pkPwd, String alias) throws DfException {
        String string = keystoreFqFn;
        String string2 = ksPwd;
        String string3 = pkPwd;
        String string4 = alias;
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string, string2, string3, string4};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.timeStamp = null;
            this.s_ku = new JKSKeystoreUtilForAny(keystoreFqFn, ksPwd, pkPwd, alias);
            this.m_identity = this.getIdentity();
            this.m_isAutoTimeStamp = true;
            AuthenticationMgr.vetIdentity(this.m_identity);
            DfLogger.info((Object)this, "identity for authentication is {0}", new Object[]{this.m_identity}, null);
            DfLogger.info((Object)this, "keystore for authentication is {0}", new Object[]{keystoreFqFn}, null);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string, string2, string3, string4};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string, string2, string3, string4};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public AuthenticationMgrForAny(String identity, String keystoreFqFn, String ksPwd, String pkPwd, String alias) throws DfException {
        String string = identity;
        String string2 = keystoreFqFn;
        String string3 = ksPwd;
        String string4 = pkPwd;
        String string5 = alias;
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string, string2, string3, string4, string5};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.timeStamp = null;
            this.s_ku = new JKSKeystoreUtilForAny(keystoreFqFn, ksPwd, pkPwd, alias);
            this.m_identity = identity;
            this.m_isAutoTimeStamp = true;
            AuthenticationMgr.vetIdentity(this.m_identity);
            DfLogger.info((Object)this, "identity for authentication is {0}", new Object[]{this.m_identity}, null);
            DfLogger.info((Object)this, "keystore for authentication is {0}", new Object[]{keystoreFqFn}, null);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string, string2, string3, string4, string5};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string, string2, string3, string4, string5};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String createIdentityBundle(String string, String string2) throws DfException {
        String string3 = string;
        String string4 = string2;
        JoinPoint joinPoint = null;
        try {
            String string5;
            String string6;
            void customData;
            void hostName;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string3, (Object)string4);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (null == hostName || 0 == hostName.length()) {
                throw new DfException("DFC_SECURITY_MALFORMED_IDENTITY_BUNDLE", new Object[]{"empty hostname field"});
            }
            Matcher m_matcher = AuthenticationMgr.m_hostnameRegex.matcher((CharSequence)hostName);
            String matched = null;
            String unmatched = null;
            if (m_matcher.matches()) {
                matched = m_matcher.group(1);
                unmatched = hostName.replace(matched, "");
            }
            if (null == matched || 0 != unmatched.length()) {
                throw new DfException("DFC_SECURITY_MALFORMED_IDENTITY_BUNDLE", new Object[]{"bad hostname field"});
            }
            if (null != customData && 0 < customData.length() && customData.matches("[^A-Za-z0-9+/=]")) {
                throw new DfException("DFC_SECURITY_BASE64", new Object[]{"custom data"});
            }
            AuthenticationMgr.vetIdentity(this.m_identity);
            if (this.m_isAutoTimeStamp) {
                GregorianCalendar gmtCalendar = new GregorianCalendar();
                this.timeStamp = gmtCalendar.getTimeInMillis();
                this.timeStamp = this.timeStamp / 1000L;
            } else assert (null != this.timeStamp);
            String raw = null;
            raw = AuthenticationMgr.buildRaw((String)hostName, this.m_identity, (String)customData, Long.toString(this.timeStamp));
            String mda = "SHA1withRSA";
            byte[] ds = AuthenticationMgr.digitallySign(raw, mda, this.s_ku.getPrivateKey(this.s_ku.getExistingReadableAccessibleKeystore(false)));
            ByteArrayInputStream bais = new ByteArrayInputStream(ds);
            ByteArrayOutputStream baos = AuthenticationMgr.encodeBase64(bais);
            String aux = baos.toString();
            String digitalSignature = aux.replaceAll("\n", "");
            if (digitalSignature.matches("[^A-Za-z0-9+/=]")) {
                throw new DfCriticalException("DFC_SECURITY_BASE64", new Object[]{"RFC4648 encoder compliance"});
            }
            String string7 = string6 = (string5 = AuthenticationMgr.buildBundle((String)hostName, this.m_identity, (String)customData, Long.toString(this.timeStamp), digitalSignature));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string3, (Object)string4);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string6, joinPoint);
            }
            return string5;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string3, (Object)string4);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public IDfAuthenticationInfo createAuthenticationInfo(String string, String string2) throws DfException {
        String string3 = string;
        String string4 = string2;
        JoinPoint joinPoint = null;
        try {
            void customData;
            void hostName;
            IDfAuthenticationInfo iDfAuthenticationInfo;
            IDfAuthenticationInfo iDfAuthenticationInfo2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string3, (Object)string4);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            IDfAuthenticationInfo iDfAuthenticationInfo3 = iDfAuthenticationInfo2 = (iDfAuthenticationInfo = AuthenticationMgr.sCreateAuthenticationInfo(this.createIdentityBundle((String)hostName, (String)customData)));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string3, (Object)string4);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(iDfAuthenticationInfo2, joinPoint);
            }
            return iDfAuthenticationInfo;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string3, (Object)string4);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public IDfAuthenticationInfo createAuthenticationInfo(String string) throws DfException {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            void identityBundle;
            IDfAuthenticationInfo iDfAuthenticationInfo;
            IDfAuthenticationInfo iDfAuthenticationInfo2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            IDfAuthenticationInfo iDfAuthenticationInfo3 = iDfAuthenticationInfo2 = (iDfAuthenticationInfo = AuthenticationMgr.sCreateAuthenticationInfo((String)identityBundle));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(iDfAuthenticationInfo2, joinPoint);
            }
            return iDfAuthenticationInfo;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean verifyDigitalSignature(IDfAuthenticationInfo iDfAuthenticationInfo) throws DfException {
        IDfAuthenticationInfo iDfAuthenticationInfo2 = iDfAuthenticationInfo;
        JoinPoint joinPoint = null;
        try {
            void info;
            boolean bl;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)iDfAuthenticationInfo2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            boolean bl3 = bl2 = (bl = AuthenticationMgr.sVerifyDigitalSignature((IDfAuthenticationInfo)info, this.s_ku.getCertificateFromKeystore()));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)iDfAuthenticationInfo2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)iDfAuthenticationInfo2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public Certificate getPublicCertificate() throws DfException {
        JoinPoint joinPoint = null;
        try {
            X509Certificate x509Certificate;
            X509Certificate x509Certificate2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            X509Certificate x509Certificate3 = x509Certificate2 = (x509Certificate = this.s_ku.getCertificateFromKeystore());
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(x509Certificate2, joinPoint);
            }
            return x509Certificate;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public String getIdentity() throws DfException {
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            String string3;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (null != this.m_identity) {
                string2 = string3 = this.m_identity;
            } else {
                String identity = null;
                X509Certificate cert = this.s_ku.getCertificateFromKeystore();
                X500Principal principal = cert.getSubjectX500Principal();
                SimplifiedX500DN dn = new SimplifiedX500DN(principal.getName());
                identity = dn.getValueForAttribute("CN");
                if (null == identity || 0 == identity.length()) {
                    throw new DfCriticalException("DFC_SECURITY_BAD_X500DN", new Object[]{this.s_ku.getKeystoreFqfn(), cert.toString()});
                }
                string2 = string3 = identity;
            }
            String string4 = string = string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string, joinPoint);
            }
            return string3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("AuthenticationMgrForAny.java", Class.forName("com.documentum.fc.client.security.impl.AuthenticationMgrForAny"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createIdentityBundle", "com.documentum.fc.client.security.impl.AuthenticationMgrForAny", "java.lang.String:java.lang.String:", "hostName:customData:", "com.documentum.fc.common.DfException:", "java.lang.String"), 71);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createAuthenticationInfo", "com.documentum.fc.client.security.impl.AuthenticationMgrForAny", "java.lang.String:java.lang.String:", "hostName:customData:", "com.documentum.fc.common.DfException:", "com.documentum.fc.client.security.IDfAuthenticationInfo"), 159);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createAuthenticationInfo", "com.documentum.fc.client.security.impl.AuthenticationMgrForAny", "java.lang.String:", "identityBundle:", "com.documentum.fc.common.DfException:", "com.documentum.fc.client.security.IDfAuthenticationInfo"), 164);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "verifyDigitalSignature", "com.documentum.fc.client.security.impl.AuthenticationMgrForAny", "com.documentum.fc.client.security.IDfAuthenticationInfo:", "info:", "com.documentum.fc.common.DfException:", "boolean"), 169);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPublicCertificate", "com.documentum.fc.client.security.impl.AuthenticationMgrForAny", "", "", "com.documentum.fc.common.DfException:", "java.security.cert.Certificate"), 174);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getIdentity", "com.documentum.fc.client.security.impl.AuthenticationMgrForAny", "", "", "com.documentum.fc.common.DfException:", "java.lang.String"), 180);
        ajc$tjp_6 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.documentum.fc.client.security.impl.AuthenticationMgrForAny", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.Long:", "keystoreFqFn:ksPwd:pkPwd:alias:secondsSinceEpoch:", "com.documentum.fc.common.DfException:"), 198);
        ajc$tjp_7 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.documentum.fc.client.security.impl.AuthenticationMgrForAny", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:", "keystoreFqFn:ksPwd:pkPwd:alias:", "com.documentum.fc.common.DfException:"), 198);
        ajc$tjp_8 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.documentum.fc.client.security.impl.AuthenticationMgrForAny", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:", "identity:keystoreFqFn:ksPwd:pkPwd:alias:", "com.documentum.fc.common.DfException:"), 198);
    }
}

