/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.security;

import com.documentum.fc.client.impl.bof.security.RoleRequestManager;
import com.documentum.fc.client.security.DfRoleSpec;
import com.documentum.fc.common.DfLogger;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfPrivilegedActionInRole<T>
implements PrivilegedAction<T> {
    private final boolean m_propagate;
    private final DfRoleSpec[] m_roleSpecs;
    private final PrivilegedAction<T> m_targetAction;

    public DfPrivilegedActionInRole(DfRoleSpec roleSpec, PrivilegedAction<T> targetAction) {
        this(roleSpec, true, targetAction);
    }

    public DfPrivilegedActionInRole(DfRoleSpec roleSpec, boolean propagate, PrivilegedAction<T> targetAction) {
        if (roleSpec == null) {
            throw new NullPointerException("roleSpec");
        }
        if (targetAction == null) {
            throw new NullPointerException("targetAction");
        }
        this.m_roleSpecs = new DfRoleSpec[]{roleSpec};
        this.m_propagate = propagate;
        this.m_targetAction = targetAction;
    }

    public DfPrivilegedActionInRole(DfRoleSpec[] roleSpecs, boolean propagate, PrivilegedAction<T> targetAction) {
        if (roleSpecs == null) {
            throw new NullPointerException("roleSpecs");
        }
        if (targetAction == null) {
            throw new NullPointerException("targetAction");
        }
        this.m_roleSpecs = roleSpecs;
        this.m_propagate = propagate;
        this.m_targetAction = targetAction;
    }

    @Override
    public T run() {
        if (DfLogger.isInfoEnabled(this)) {
            DfLogger.info((Object)this, "DFC_PRIVILEGE_ASSUME", new Object[]{Arrays.asList(this.m_roleSpecs), this.m_propagate}, null);
        }
        this.pushPermissionRequest();
        try {
            T t = this.m_targetAction.run();
            return t;
        }
        catch (AccessControlException e) {
            DfLogger.error((Object)this, "DFC_PRIVILEGE_ASSUME_ERROR", new Object[]{Arrays.asList(this.m_roleSpecs), this.m_propagate}, (Throwable)e);
            throw e;
        }
        finally {
            this.popPermissionRequest();
        }
    }

    private void pushPermissionRequest() {
        if (this.m_propagate) {
            RoleRequestManager.getInstance().push(this.m_roleSpecs, AccessController.getContext());
        } else {
            RoleRequestManager.getInstance().push(this.m_roleSpecs);
        }
    }

    private void popPermissionRequest() {
        RoleRequestManager.getInstance().pop(this.m_roleSpecs);
    }
}

