/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.search.impl.result;

import com.documentum.fc.client.search.IDfResultEntry;
import com.documentum.fc.client.search.impl.result.ADfResultsSorter;
import com.documentum.fc.common.IDfAttr;
import com.documentum.fc.common.IDfTime;
import java.util.Comparator;

public class DfTimeAttributeSorter
extends ADfResultsSorter {
    private String m_criterion = null;
    private boolean m_ascendant = true;

    public DfTimeAttributeSorter(String name, boolean ascend) {
        this.m_criterion = name;
        this.m_ascendant = ascend;
    }

    public Comparator getComparator() {
        if (this.m_ascendant) {
            return new TimeAscendantAttribComparer();
        }
        return new TimeDescendantAttribComparer();
    }

    private IDfTime getTimeValue(IDfResultEntry entry, int index, IDfTime defaultValue) {
        IDfTime val = defaultValue;
        IDfAttr attr = entry.getAttr(this.m_criterion);
        if (attr != null && attr.getDataType() == 4) {
            if (attr.isRepeating() && index < entry.getValueCount(this.m_criterion)) {
                val = entry.getRepeatingTime(this.m_criterion, index);
            } else if (index == 0) {
                val = entry.getTime(this.m_criterion);
            }
        }
        return val;
    }

    class TimeDescendantAttribComparer
    implements Comparator {
        TimeDescendantAttribComparer() {
        }

        public int compare(Object o1, Object o2) {
            IDfResultEntry entry1 = (IDfResultEntry)o1;
            IDfResultEntry entry2 = (IDfResultEntry)o2;
            int retval = 0;
            int i = 0;
            while (retval == 0) {
                IDfTime time1 = DfTimeAttributeSorter.this.getTimeValue(entry1, i, null);
                IDfTime time2 = DfTimeAttributeSorter.this.getTimeValue(entry2, i, null);
                if (time1 == null && time2 == null) {
                    return 0;
                }
                if (time1 == null) {
                    return 1;
                }
                if (time2 == null) {
                    return -1;
                }
                retval = time2.compareTo(time1);
                ++i;
            }
            return retval;
        }
    }

    private class TimeAscendantAttribComparer
    implements Comparator {
        private TimeAscendantAttribComparer() {
        }

        public int compare(Object o1, Object o2) {
            IDfResultEntry entry1 = (IDfResultEntry)o1;
            IDfResultEntry entry2 = (IDfResultEntry)o2;
            int retval = 0;
            boolean isRepeatingValue = false;
            int i = 0;
            while (retval == 0) {
                IDfTime time1 = DfTimeAttributeSorter.this.getTimeValue(entry1, i, null);
                IDfTime time2 = DfTimeAttributeSorter.this.getTimeValue(entry2, i, null);
                if (time1 == null && time2 == null) {
                    return 0;
                }
                if (time1 == null) {
                    return isRepeatingValue ? -1 : 1;
                }
                if (time2 == null) {
                    return isRepeatingValue ? 1 : -1;
                }
                retval = time1.compareTo(time2);
                isRepeatingValue = true;
                ++i;
            }
            return retval;
        }
    }
}

