/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.search.impl.result;

import com.documentum.fc.client.search.IDfResultEntry;
import com.documentum.fc.client.search.impl.result.ADfResultsSorter;
import com.documentum.fc.common.IDfAttr;
import java.util.Comparator;

public class DfStringAttributeSorter
extends ADfResultsSorter {
    private String m_criterion = null;
    private boolean m_ascendant = true;

    public DfStringAttributeSorter(String attrCriterion, boolean ascendent) {
        this.m_criterion = attrCriterion;
        this.m_ascendant = ascendent;
    }

    public Comparator getComparator() {
        if (this.m_ascendant) {
            return new AlphaAscendantAttribComparer();
        }
        return new AlphaDescendantAttribComparer();
    }

    private String getStringValue(IDfResultEntry entry, int index, String defaultValue) {
        String val = defaultValue;
        IDfAttr attr = entry.getAttr(this.m_criterion);
        if (attr != null) {
            if (attr.isRepeating() && index < entry.getValueCount(this.m_criterion)) {
                val = entry.getRepeatingString(this.m_criterion, index);
            } else if (index == 0) {
                val = entry.getString(this.m_criterion);
            }
        }
        return val;
    }

    private static int compareString(String val1, String val2) {
        String s1 = val1.toLowerCase();
        String s2 = val2.toLowerCase();
        return s1.compareTo(s2);
    }

    private static boolean isNullOrEmpty(String a2) {
        return a2 == null || a2.length() == 0;
    }

    private class AlphaDescendantAttribComparer
    implements Comparator {
        private AlphaDescendantAttribComparer() {
        }

        public int compare(Object o1, Object o2) {
            IDfResultEntry entry1 = (IDfResultEntry)o1;
            IDfResultEntry entry2 = (IDfResultEntry)o2;
            int retval = 0;
            int i = 0;
            while (retval == 0) {
                String a1 = DfStringAttributeSorter.this.getStringValue(entry1, i, null);
                String a2 = DfStringAttributeSorter.this.getStringValue(entry2, i, null);
                boolean isNull1 = DfStringAttributeSorter.isNullOrEmpty(a1);
                boolean isNull2 = DfStringAttributeSorter.isNullOrEmpty(a2);
                if (isNull1 && isNull2) {
                    return 0;
                }
                if (isNull2) {
                    return -1;
                }
                if (isNull1) {
                    return 1;
                }
                retval = DfStringAttributeSorter.compareString(a2, a1);
                ++i;
            }
            return retval;
        }
    }

    private class AlphaAscendantAttribComparer
    implements Comparator {
        private AlphaAscendantAttribComparer() {
        }

        public int compare(Object o1, Object o2) {
            IDfResultEntry entry1 = (IDfResultEntry)o1;
            IDfResultEntry entry2 = (IDfResultEntry)o2;
            int retval = 0;
            boolean isRepeatingValue = false;
            int i = 0;
            while (retval == 0) {
                String a1 = DfStringAttributeSorter.this.getStringValue(entry1, i, null);
                String a2 = DfStringAttributeSorter.this.getStringValue(entry2, i, null);
                boolean isNull1 = DfStringAttributeSorter.isNullOrEmpty(a1);
                boolean isNull2 = DfStringAttributeSorter.isNullOrEmpty(a2);
                if (isNull1 && isNull2) {
                    return 0;
                }
                if (isNull2) {
                    return isRepeatingValue ? 1 : -1;
                }
                if (isNull1) {
                    return isRepeatingValue ? -1 : 1;
                }
                retval = DfStringAttributeSorter.compareString(a1, a2);
                isRepeatingValue = true;
                ++i;
            }
            return retval;
        }
    }
}

