/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.search.impl.result;

import com.documentum.fc.client.IDfEnumeration;
import com.documentum.fc.client.search.IDfResultsSet;
import com.documentum.fc.client.search.impl.definition.XMLQueryConstants;
import com.documentum.fc.client.search.impl.result.DfResultEntry;
import com.documentum.fc.client.search.impl.result.DfResultsSet;
import com.documentum.fc.client.search.impl.result.DfResultsSetXMLFormat;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.IDfList;
import com.documentum.fc.common.IDfTime;
import com.documentum.fc.common.IDfValue;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import xtrim.data.Attribute;
import xtrim.data.DataException;
import xtrim.data.DataFactory;
import xtrim.data.EmbeddedObjectReference;

public class DfResultsSetSAXSerializer
implements DfResultsSetXMLFormat {
    private boolean m_zipOutput = true;
    private boolean m_readableDataType = false;
    private boolean m_readableDate = false;
    private boolean m_addXMLHeader = true;
    private boolean m_addItemCount = false;
    private SimpleDateFormat m_dateFormatter = null;

    public DfResultsSetSAXSerializer() {
    }

    public DfResultsSetSAXSerializer(boolean zipOutput, boolean readableDataType, boolean readableDate, boolean addXMLHeader, boolean addItemCount) {
        this.m_zipOutput = zipOutput;
        this.m_readableDataType = readableDataType;
        this.m_readableDate = readableDate;
        this.m_addXMLHeader = addXMLHeader;
        this.m_addItemCount = addItemCount;
    }

    public void serialize(IDfResultsSet results, OutputStream out) throws IOException, DfException {
        OutputStream output = out;
        if (this.m_zipOutput) {
            ZipOutputStream zipOut = new ZipOutputStream(out);
            zipOut.putNextEntry(new ZipEntry("results.xml"));
            output = zipOut;
        }
        this.serializeXML(results, output, 0, results.size());
        output.close();
    }

    public void serialize(DfResultsSet results, OutputStream out, int from, int to) throws IOException, DfException {
        OutputStream output = out;
        if (this.m_zipOutput) {
            ZipOutputStream zipOut = new ZipOutputStream(out);
            zipOut.putNextEntry(new ZipEntry("results.xml"));
            output = zipOut;
        }
        this.serializeXML(results, output, from, to);
        output.close();
    }

    private void serializeXML(IDfResultsSet results, OutputStream out, int from, int to) throws IOException, DfException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, "UTF-8"));
        if (this.m_addXMLHeader) {
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        }
        writer.write("<ResultSet");
        writer.write(" version=\"1\"");
        int upperBound = to;
        if (upperBound > results.size()) {
            upperBound = results.size();
        }
        if (this.m_addItemCount) {
            writer.write(" results=\"" + (upperBound - from) + "\"");
        }
        writer.write(">");
        for (int i = from; i < upperBound; ++i) {
            DfResultEntry curResult = (DfResultEntry)results.getResultAt(i);
            this.serialize(curResult, writer);
        }
        DfResultsSetSAXSerializer.writeEndTag(writer, "ResultSet");
        ((Writer)writer).close();
    }

    private void serialize(DfResultEntry entry, Writer writer) throws IOException, DfException {
        writer.write("<result");
        if (this.m_addItemCount) {
            writer.write(" attrs=\"" + entry.getAttrCount() + "\"");
        }
        writer.write(">");
        DfResultsSetSAXSerializer.writeStartTag(writer, "key");
        writer.write(entry.getKey());
        DfResultsSetSAXSerializer.writeEndTag(writer, "key");
        DfResultsSetSAXSerializer.writeStartTag(writer, "status");
        writer.write(Integer.toString(entry.getStatus()));
        DfResultsSetSAXSerializer.writeEndTag(writer, "status");
        DfResultsSetSAXSerializer.writeObjectReference(entry, writer);
        DfResultsSetSAXSerializer.writeMatchingTerms(entry, writer);
        this.writeAttributes(entry, writer);
        String nodeName = "result";
        DfResultsSetSAXSerializer.writeEndTag(writer, nodeName);
    }

    private static void writeMatchingTerms(DfResultEntry entry, Writer writer) throws IOException {
        IDfEnumeration matching = entry.getMatchingTerms();
        if (matching.hasMoreElements()) {
            DfResultsSetSAXSerializer.writeStartTag(writer, "matchingTerms");
            while (matching.hasMoreElements()) {
                DfResultsSetSAXSerializer.writeStartTag(writer, "value");
                writer.write(DfResultsSetSAXSerializer.escapeXml((String)matching.nextElement()));
                DfResultsSetSAXSerializer.writeEndTag(writer, "value");
            }
            DfResultsSetSAXSerializer.writeEndTag(writer, "matchingTerms");
        }
    }

    private static void writeObjectReference(DfResultEntry entry, Writer writer) throws IOException, DfException {
        try {
            if (entry.getECISObjectReference() != null) {
                Attribute attribute = DataFactory.createAttribute((String)"ref", (String)"refValue", (EmbeddedObjectReference)entry.getECISObjectReference());
                String embeddedObj = attribute.packageEmbeddedRefInUrl();
                String nodeName = "embeddedObjectRef";
                DfResultsSetSAXSerializer.writeStartTag(writer, nodeName);
                writer.write(embeddedObj);
                DfResultsSetSAXSerializer.writeEndTag(writer, "embeddedObjectRef");
            }
        }
        catch (DataException e) {
            throw new DfException(e);
        }
    }

    private void writeAttributes(DfResultEntry entry, Writer writer) throws IOException, DfException {
        int nbAttrs = entry.getAttrCount();
        for (int j = 0; j < nbAttrs; ++j) {
            IDfValue dfValue = entry.getValueAt(j);
            String AttributeNameStr = entry.getAttr(j).getName();
            int type = entry.getAttr(j).getDataType();
            boolean isRepeating = entry.isAttrRepeating(AttributeNameStr);
            writer.write("<");
            writer.write("attr");
            writer.write(" name=\"" + DfResultsSetSAXSerializer.escapeXml(AttributeNameStr) + "\"");
            if (isRepeating) {
                writer.write(" repeating=\"" + isRepeating + "\"");
            }
            writer.write(" type=\"");
            if (this.m_readableDataType) {
                writer.write(XMLQueryConstants.convertDataTypeToXML(type));
            } else {
                writer.write(Integer.toString(type));
            }
            writer.write("\"");
            writer.write(">");
            if (isRepeating) {
                IDfList list = entry.getList(AttributeNameStr);
                for (int i = 0; i < list.getCount(); ++i) {
                    DfResultsSetSAXSerializer.writeStartTag(writer, "value");
                    IDfValue elementvalue = list.getValue(i);
                    writer.write(this.formatValue(elementvalue));
                    DfResultsSetSAXSerializer.writeEndTag(writer, "value");
                }
            } else {
                writer.write(this.formatValue(dfValue));
            }
            DfResultsSetSAXSerializer.writeEndTag(writer, "attr");
        }
    }

    private String formatValue(IDfValue dfValue) {
        String value;
        if (dfValue.getDataType() == 4) {
            IDfTime iDfTime = dfValue.asTime();
            Date date = iDfTime.getDate();
            if (date == null) {
                return "";
            }
            if (this.m_readableDate) {
                value = this.formatReadableDate(date);
            } else {
                long time = date.getTime();
                value = Long.toString(time);
            }
        } else {
            value = DfResultsSetSAXSerializer.escapeXml(dfValue.asString());
        }
        return DfResultsSetSAXSerializer.stripNonValidXMLCharacters(value);
    }

    private synchronized String formatReadableDate(Date date) {
        if (this.m_dateFormatter == null) {
            this.m_dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
            this.m_dateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        return this.m_dateFormatter.format(date);
    }

    private static void writeStartTag(Writer writer, String nodeName) throws IOException {
        writer.write("<");
        writer.write(nodeName);
        writer.write(">");
    }

    private static void writeEndTag(Writer writer, String nodeName) throws IOException {
        writer.write("</");
        writer.write(nodeName);
        writer.write(">");
    }

    private static String escapeXml(String str) {
        str = DfResultsSetSAXSerializer.replaceString(str, "&", "&amp;");
        str = DfResultsSetSAXSerializer.replaceString(str, "<", "&lt;");
        str = DfResultsSetSAXSerializer.replaceString(str, ">", "&gt;");
        str = DfResultsSetSAXSerializer.replaceString(str, "\"", "&quot;");
        str = DfResultsSetSAXSerializer.replaceString(str, "'", "&apos;");
        return str;
    }

    private static String stripNonValidXMLCharacters(String in) {
        if (in == null || in.length() == 0) {
            return in;
        }
        StringBuilder out = new StringBuilder(in.length());
        for (int i = 0; i < in.length(); ++i) {
            char current = in.charAt(i);
            if (!(current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd') && (current < '\u10000' || current > '\u10ffff')) continue;
            out.append(current);
        }
        return out.toString().length() == in.length() ? in : out.toString();
    }

    private static String replaceString(String text, String strToReplace, String replacement) {
        int end;
        if (text == null) {
            return null;
        }
        StringBuffer buffer = null;
        int start = 0;
        while ((end = text.indexOf(strToReplace, start)) != -1) {
            if (buffer == null) {
                buffer = new StringBuffer(text.length() + 10);
            }
            buffer.append(text.substring(start, end)).append(replacement);
            start = end + strToReplace.length();
        }
        if (buffer != null) {
            buffer.append(text.substring(start));
            return buffer.toString();
        }
        return text;
    }
}

