/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.search.impl.result;

import com.documentum.fc.client.search.IDfResultsSet;
import com.documentum.fc.client.search.impl.result.DfResultEntry;
import com.documentum.fc.client.search.impl.result.DfResultsSet;
import com.documentum.fc.client.search.impl.result.DfResultsSetXMLFormat;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.DfTime;
import com.documentum.fc.common.DfValue;
import com.documentum.fc.common.IDfValue;
import com.documentum.fc.internal.xml.IXMLParserFactory;
import com.documentum.fc.internal.xml.XMLUtilsFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import xtrim.data.DataException;
import xtrim.data.DataFactory;

public class DfResultsSetSAXDeserializer
implements ContentHandler,
ErrorHandler,
DfResultsSetXMLFormat {
    private ResultNodeChildTag m_currentResultNodeChildTag = null;
    private DfResultEntry m_currentEntry;
    private DfResultsSet m_resultsSet;
    private StringBuffer m_currentValueBuffer;

    public IDfResultsSet deserialize(ByteArrayInputStream input) throws DfException, IOException {
        ZipInputStream zipInput = new ZipInputStream(input);
        try {
            ZipEntry entry = zipInput.getNextEntry();
            if (entry != null) {
                this.deserializeXML(zipInput);
            } else {
                input.reset();
                this.deserializeXML(input);
            }
        }
        catch (ZipException e) {
            input.reset();
            this.deserializeXML(input);
        }
        return this.m_resultsSet;
    }

    private void deserializeXML(InputStream input) throws DfException {
        this.m_resultsSet = new DfResultsSet();
        IXMLParserFactory utils = new XMLUtilsFactory().getParserFactory();
        XMLReader saxReader = utils.getXMLReader();
        saxReader.setContentHandler(this);
        saxReader.setErrorHandler(this);
        try {
            saxReader.parse(new InputSource(input));
        }
        catch (IOException e) {
            throw new DfException("RESULTS_LOADING_ERROR", (Throwable)e);
        }
        catch (SAXException e) {
            throw new DfException("RESULTS_LOADING_ERROR", (Throwable)e);
        }
        this.m_resultsSet.reset();
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (localName.equals("attr")) {
            this.m_currentValueBuffer = null;
            this.m_currentResultNodeChildTag = new AttrTag(atts);
        } else if (localName.equals("matchingTerms")) {
            this.m_currentValueBuffer = null;
            this.m_currentResultNodeChildTag = new MatchingTermsTag();
        } else if (localName.equals("key")) {
            this.m_currentValueBuffer = null;
            this.m_currentResultNodeChildTag = new KeyTag();
        } else if (localName.equals("status")) {
            this.m_currentValueBuffer = null;
            this.m_currentResultNodeChildTag = new StatusTag();
        } else if (localName.equals("embeddedObjectRef")) {
            this.m_currentValueBuffer = null;
            this.m_currentResultNodeChildTag = new EmbeddedTag();
        } else if (localName.equals("value")) {
            this.m_currentValueBuffer = null;
            assert (this.m_currentResultNodeChildTag != null);
        } else assert (this.m_currentResultNodeChildTag == null);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!localName.equals("ResultSet")) {
            if (localName.equals("result")) {
                this.m_resultsSet.add(this.m_currentEntry);
                this.m_currentEntry = null;
                this.m_currentResultNodeChildTag = null;
            } else if (localName.equals("value")) {
                this.m_currentResultNodeChildTag.notifyValueTag(this.getCurrentValue());
            } else {
                this.m_currentResultNodeChildTag.notifyEndTag(this.getCurrentValue());
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.m_currentValueBuffer == null) {
            this.m_currentValueBuffer = new StringBuffer(length);
        }
        this.m_currentValueBuffer.append(ch, start, length);
    }

    private String getCurrentValue() {
        if (this.m_currentValueBuffer != null) {
            return this.m_currentValueBuffer.toString();
        }
        return null;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void warning(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    private class MatchingTermsTag
    implements ResultNodeChildTag {
        private ArrayList<String> currentMatchingTerms = new ArrayList();

        MatchingTermsTag() {
        }

        public void notifyValueTag(String value) {
            this.currentMatchingTerms.add(value);
        }

        public void notifyEndTag(String currentValue) {
            DfResultsSetSAXDeserializer.this.m_currentEntry.setMatchingTerms(this.currentMatchingTerms);
        }
    }

    private class AttrTag
    implements ResultNodeChildTag {
        private String attrName;
        private boolean isRepeating;
        private int type;

        AttrTag(Attributes attrs) {
            this.attrName = attrs.getValue("name");
            this.type = Integer.parseInt(attrs.getValue("type"));
            String isRepeatingStr = attrs.getValue("repeating");
            boolean bl = this.isRepeating = isRepeatingStr != null && Boolean.parseBoolean(isRepeatingStr);
            if (this.isRepeating) {
                DfResultsSetSAXDeserializer.this.m_currentEntry.addAttribute(this.attrName, true, this.type);
            }
        }

        public void notifyValueTag(String value) {
            if (value == null) {
                value = "";
            }
            assert (this.isRepeating);
            DfResultsSetSAXDeserializer.this.m_currentEntry.appendRepeatingValue(this.attrName, this.parseValue(this.type, value));
        }

        public void notifyEndTag(String value) {
            if (!this.isRepeating) {
                if (value == null) {
                    value = "";
                }
                IDfValue dfValue = this.parseValue(this.type, value);
                DfResultsSetSAXDeserializer.this.m_currentEntry.addAttribute(this.attrName, this.type, dfValue, value.length());
            }
        }

        private IDfValue parseValue(int type, String value) {
            DfValue rVal;
            if (type == 4) {
                try {
                    long dateAsLong = Long.parseLong(value);
                    Date date = new Date(dateAsLong);
                    DfTime dfValue = new DfTime(date);
                    rVal = new DfValue(dfValue);
                }
                catch (NumberFormatException e) {
                    if (DfLogger.isDebugEnabled(this)) {
                        DfLogger.debug((Object)this, "Load a date attribute not parseable as long. Try to parse it as a formatted date.(" + e + ")", null, null);
                    }
                    DfTime dfValue = new DfTime(value);
                    rVal = new DfValue(dfValue);
                }
            } else {
                rVal = new DfValue(value, type);
            }
            return rVal;
        }
    }

    private class StatusTag
    implements ResultNodeChildTag {
        private StatusTag() {
        }

        public void notifyValueTag(String value) throws SAXException {
            assert (false);
        }

        public void notifyEndTag(String value) throws SAXException {
            DfResultsSetSAXDeserializer.this.m_currentEntry.setStatus(Integer.parseInt(DfResultsSetSAXDeserializer.this.getCurrentValue().trim()));
        }
    }

    private class KeyTag
    implements ResultNodeChildTag {
        private KeyTag() {
        }

        public void notifyValueTag(String value) throws SAXException {
            assert (false);
        }

        public void notifyEndTag(String value) throws SAXException {
            DfResultsSetSAXDeserializer.this.m_currentEntry = new DfResultEntry(DfResultsSetSAXDeserializer.this.getCurrentValue().trim());
        }
    }

    private class EmbeddedTag
    implements ResultNodeChildTag {
        private EmbeddedTag() {
        }

        public void notifyValueTag(String value) throws SAXException {
            assert (false);
        }

        public void notifyEndTag(String objectRef) throws SAXException {
            if (objectRef != null && objectRef.length() > 0) {
                try {
                    DfResultsSetSAXDeserializer.this.m_currentEntry.setECISObjectReference(DataFactory.unpackageEmbeddedRefFromUrl((String)objectRef));
                }
                catch (DataException e) {
                    SAXException saxEcp = new SAXException((Exception)((Object)e));
                    saxEcp.initCause(e);
                    throw saxEcp;
                }
            }
        }
    }

    private static interface ResultNodeChildTag {
        public void notifyValueTag(String var1) throws SAXException;

        public void notifyEndTag(String var1) throws SAXException;
    }
}

