/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.search.impl.result;

import com.documentum.fc.client.search.IDfModifiableResultsSet;
import com.documentum.fc.client.search.IDfResultEntry;
import com.documentum.fc.client.search.IDfResultsSet;
import com.documentum.fc.client.search.impl.result.DfResultsManipulator;
import com.documentum.fc.client.search.impl.result.DfResultsSetSAXSerializer;
import com.documentum.fc.client.search.internal.result.IDfXmlResultsSet;
import com.documentum.fc.common.DfException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfResultsSet
implements IDfModifiableResultsSet,
IDfXmlResultsSet {
    private static final int DEFAULT_SET_SIZE = 100;
    private List<IDfResultEntry> m_results;
    private Map<String, IDfResultEntry> m_keys;
    private int m_index;
    private DfResultsSetSAXSerializer m_xmlSerializer = null;

    public DfResultsSet() {
        this.m_results = new ArrayList<IDfResultEntry>(100);
        this.m_keys = new HashMap<String, IDfResultEntry>(100);
        this.reset();
    }

    protected DfResultsSet(List<IDfResultEntry> initial) {
        this.m_results = new ArrayList<IDfResultEntry>(initial);
        int size = Math.max(2 * initial.size(), 100);
        this.m_keys = new HashMap<String, IDfResultEntry>(size);
        for (IDfResultEntry entry : initial) {
            this.m_keys.put(entry.getKey(), entry);
        }
        this.reset();
    }

    @Override
    public synchronized boolean next() {
        ++this.m_index;
        return this.m_index < this.m_results.size();
    }

    @Override
    public synchronized IDfResultEntry getResult() {
        return this.getResultAt(this.m_index);
    }

    @Override
    public synchronized void reset() {
        this.m_index = -1;
    }

    @Override
    public synchronized IDfResultEntry getResultAt(int index) {
        return this.m_results.get(index);
    }

    @Override
    public synchronized IDfResultEntry getResultByKey(String key) {
        IDfResultEntry entry = this.m_keys.get(key);
        return entry;
    }

    @Override
    public synchronized int size() {
        return this.m_results.size();
    }

    @Override
    public synchronized String getResultsAsXML(int from, int to) throws DfException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DfResultsSetSAXSerializer serializer = this.getXMLSerializer();
        try {
            serializer.serialize(this, out, from, to);
            return new String(out.toByteArray(), "UTF-8");
        }
        catch (IOException e) {
            throw new DfException(e);
        }
    }

    private DfResultsSetSAXSerializer getXMLSerializer() {
        if (this.m_xmlSerializer == null) {
            this.m_xmlSerializer = new DfResultsSetSAXSerializer(false, true, true, false, true);
        }
        return this.m_xmlSerializer;
    }

    @Override
    public synchronized void add(IDfResultEntry entry) {
        String key = entry.getKey();
        this.m_results.add(entry);
        this.m_keys.put(key, entry);
    }

    @Override
    public synchronized IDfResultsSet sort(String attributeName, boolean ascend, String locale) {
        DfResultsManipulator manipulator = new DfResultsManipulator();
        return manipulator.sortBy(this, attributeName, ascend);
    }

    @Override
    public synchronized IDfResultsSet subset(int from) {
        return this.subset(from, this.size());
    }

    @Override
    public synchronized IDfResultsSet subset(int from, int to) {
        return new DfResultsSet(this.m_results.subList(from, to));
    }

    public synchronized void addResults(List<IDfResultEntry> results) {
        for (IDfResultEntry r : results) {
            this.add(r);
        }
    }

    public synchronized void setResultAt(int index, IDfResultEntry entry) {
        this.m_results.set(index, entry);
        String key = entry.getKey();
        this.m_keys.put(key, entry);
    }

    public synchronized String toString() {
        StringBuffer out = new StringBuffer();
        Iterator<IDfResultEntry> iter = this.m_results.iterator();
        int index = 0;
        while (iter.hasNext()) {
            IDfResultEntry entry = iter.next();
            out.append("Result ").append(index).append("\n");
            out.append(entry).append("\n");
            ++index;
        }
        return out.toString();
    }
}

