/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.search.impl.result;

import com.documentum.fc.client.search.IDfResultEntry;
import com.documentum.fc.client.search.impl.result.ADfResultsSorter;
import com.documentum.fc.common.IDfAttr;
import java.util.Comparator;

public class DfDoubleAttributeSorter
extends ADfResultsSorter {
    private String m_criterion = null;
    private boolean m_ascendant = true;

    public DfDoubleAttributeSorter(String name, boolean ascend) {
        this.m_criterion = name;
        this.m_ascendant = ascend;
    }

    public Comparator getComparator() {
        if (this.m_ascendant) {
            return new DoubleAscendantAttribComparer();
        }
        return new DoubleDescendantAttribComparer();
    }

    private double getDoubleValue(IDfResultEntry entry, int index, double defaultValue) {
        double value = defaultValue;
        IDfAttr attr = entry.getAttr(this.m_criterion);
        if (attr != null && attr.getDataType() == 5) {
            if (attr.isRepeating() && index < entry.getValueCount(this.m_criterion)) {
                value = entry.getRepeatingDouble(this.m_criterion, index);
            } else if (index == 0) {
                value = entry.getDouble(this.m_criterion);
            }
        }
        return value;
    }

    private class DoubleDescendantAttribComparer
    implements Comparator {
        private DoubleDescendantAttribComparer() {
        }

        public int compare(Object o1, Object o2) {
            IDfResultEntry entry1 = (IDfResultEntry)o1;
            IDfResultEntry entry2 = (IDfResultEntry)o2;
            int retval = 0;
            double defVal = Double.MIN_VALUE;
            int i = 0;
            while (retval == 0) {
                double val1 = DfDoubleAttributeSorter.this.getDoubleValue(entry1, i, defVal);
                double val2 = DfDoubleAttributeSorter.this.getDoubleValue(entry2, i, defVal);
                if (val1 == defVal && val2 == defVal) {
                    return 0;
                }
                retval = Double.compare(val2, val1);
                ++i;
            }
            return retval;
        }
    }

    private class DoubleAscendantAttribComparer
    implements Comparator {
        private DoubleAscendantAttribComparer() {
        }

        public int compare(Object o1, Object o2) {
            IDfResultEntry entry1 = (IDfResultEntry)o1;
            IDfResultEntry entry2 = (IDfResultEntry)o2;
            int retval = 0;
            double defVal = Double.MAX_VALUE;
            int i = 0;
            while (retval == 0) {
                double val1 = DfDoubleAttributeSorter.this.getDoubleValue(entry1, i, defVal);
                double val2 = DfDoubleAttributeSorter.this.getDoubleValue(entry2, i, defVal);
                if (val1 == defVal && val2 == defVal) {
                    return 0;
                }
                retval = Double.compare(val1, val2);
                defVal = Double.MIN_VALUE;
                ++i;
            }
            return retval;
        }
    }
}

