/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.search.impl.result;

import com.documentum.fc.client.search.IDfResultEntry;
import com.documentum.fc.client.search.impl.result.ADfResultsSorter;
import com.documentum.fc.common.IDfAttr;
import java.util.Comparator;

public class DfBooleanAttributeSorter
extends ADfResultsSorter {
    private String m_criterion = null;
    private boolean m_ascendant = true;

    public DfBooleanAttributeSorter(String name, boolean ascend) {
        this.m_criterion = name;
        this.m_ascendant = ascend;
    }

    public Comparator getComparator() {
        if (this.m_ascendant) {
            return new BooleanAscendantAttribComparer();
        }
        return new BooleanDescendantAttribComparer();
    }

    private Boolean getBooleanValue(IDfResultEntry entry, int index, Boolean defaultValue) {
        Boolean value = defaultValue;
        IDfAttr attr = entry.getAttr(this.m_criterion);
        if (attr != null && attr.getDataType() == 0) {
            if (attr.isRepeating() && index < entry.getValueCount(this.m_criterion)) {
                value = entry.getRepeatingBoolean(this.m_criterion, index);
            } else if (index == 0) {
                value = entry.getBoolean(this.m_criterion);
            }
        }
        return value;
    }

    private int compareBoolean(Boolean b1, Boolean b2) {
        if (b1.equals(b2)) {
            return 0;
        }
        if (b1.booleanValue()) {
            return 1;
        }
        return -1;
    }

    private class BooleanDescendantAttribComparer
    implements Comparator {
        private BooleanDescendantAttribComparer() {
        }

        public int compare(Object o1, Object o2) {
            IDfResultEntry entry1 = (IDfResultEntry)o1;
            IDfResultEntry entry2 = (IDfResultEntry)o2;
            int retval = 0;
            int i = 0;
            while (retval == 0) {
                Boolean b1 = DfBooleanAttributeSorter.this.getBooleanValue(entry1, i, null);
                Boolean b2 = DfBooleanAttributeSorter.this.getBooleanValue(entry2, i, null);
                if (b1 == null && b2 == null) {
                    return 0;
                }
                if (b1 == null) {
                    return 1;
                }
                if (b2 == null) {
                    return -1;
                }
                retval = DfBooleanAttributeSorter.this.compareBoolean(b2, b1);
                ++i;
            }
            return retval;
        }
    }

    private class BooleanAscendantAttribComparer
    implements Comparator {
        private BooleanAscendantAttribComparer() {
        }

        public int compare(Object o1, Object o2) {
            IDfResultEntry entry1 = (IDfResultEntry)o1;
            IDfResultEntry entry2 = (IDfResultEntry)o2;
            int retval = 0;
            boolean isRepeatingValue = false;
            int i = 0;
            while (retval == 0) {
                Boolean b1 = DfBooleanAttributeSorter.this.getBooleanValue(entry1, i, null);
                Boolean b2 = DfBooleanAttributeSorter.this.getBooleanValue(entry2, i, null);
                if (b1 == null && b2 == null) {
                    return 0;
                }
                if (b1 == null) {
                    return isRepeatingValue ? -1 : 1;
                }
                if (b2 == null) {
                    return isRepeatingValue ? 1 : -1;
                }
                retval = DfBooleanAttributeSorter.this.compareBoolean(b1, b2);
                isRepeatingValue = true;
                ++i;
            }
            return retval;
        }
    }
}

