/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.search.impl.result;

import com.documentum.fc.client.search.impl.result.DfResultEntry;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfId;
import com.documentum.fc.common.DfList;
import com.documentum.fc.common.DfValue;
import com.documentum.fc.common.IDfAttr;
import com.documentum.fc.common.IDfList;
import com.documentum.fc.common.IDfValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AttributeCache {
    private static final long CACHE_TIMEOUT = 300000L;
    private static final int[] DATA_TYPES = new int[]{0, 1, 2, 3, 4, 5};
    private static final Integer[] DATA_TYPES_INTEGER = AttributeCache.initDataTypesInteger();
    private static final IDfList EMPTY_LIST = new DfList(1025);
    private static final Map SINGLE_NULL_VALUES = AttributeCache.initSingleNullValues();
    private static final Map REPEATING_EMPTY_LISTS = AttributeCache.initRepeatingEmptyLists();
    private static final IDfList[] NULL_LISTS = AttributeCache.initNullLists();
    private static final Map REPEATING_NULL_VALUES = AttributeCache.initRepeatingNullValues();
    private static AttributeCache s_singleInstance = null;
    private Map m_attributes = new HashMap(100);
    private Map m_attributeIndexes = new HashMap(50);
    private Map m_sourceNames = new HashMap(50);
    private long m_cacheTimeout = System.currentTimeMillis() + 300000L;

    public static synchronized AttributeCache access() {
        if (s_singleInstance == null) {
            s_singleInstance = new AttributeCache();
        }
        return s_singleInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDfAttr getCachedAttribute(IDfAttr attr, int attrIndex) {
        Map map = this.m_attributes;
        synchronized (map) {
            this.checkAttributeCacheCurrency();
            IDfAttr cachedAttr = (IDfAttr)this.m_attributes.get(attr);
            if (cachedAttr == null) {
                cachedAttr = attr;
                this.m_attributes.put(cachedAttr, cachedAttr);
                this.m_attributeIndexes.put(cachedAttr.getName(), new Integer(attrIndex));
            }
            return cachedAttr;
        }
    }

    public int getAttributeIndexHint(String attrName) {
        Integer attributeIndexHint = (Integer)this.m_attributeIndexes.get(attrName);
        return attributeIndexHint == null ? -1 : attributeIndexHint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDfValue getCachedSource(String sourceName) {
        Map map = this.m_sourceNames;
        synchronized (map) {
            IDfValue cachedSourceValue = (IDfValue)this.m_sourceNames.get(sourceName);
            if (cachedSourceValue == null) {
                cachedSourceValue = new DfValue(sourceName, 2);
                this.m_sourceNames.put(sourceName, cachedSourceValue);
            }
            return cachedSourceValue;
        }
    }

    public static IDfValue getCachedValue(IDfAttr attr, IDfValue value) {
        int dataType = attr.getDataType();
        if (attr.isRepeating()) {
            if (value == null) {
                value = (IDfValue)REPEATING_EMPTY_LISTS.get(new Integer(dataType));
            }
        } else if (AttributeCache.isNullValue(value)) {
            value = (IDfValue)SINGLE_NULL_VALUES.get(new Integer(dataType));
        }
        return value;
    }

    public static void appendRepeatingValue(DfResultEntry resultEntry, int attrIndex, IDfValue value) {
        IDfList list = resultEntry.getList(attrIndex);
        boolean addValue = true;
        if (AttributeCache.isEmptyList(list)) {
            if (AttributeCache.isNullValue(value)) {
                IDfValue repeatingNullValue = AttributeCache.getRepeatingNullValue(value.getDataType());
                resultEntry.setValue(attrIndex, repeatingNullValue);
                addValue = false;
            } else {
                list = new DfList(1025);
                DfValue repeatingValue = new DfValue(list, value.getDataType());
                resultEntry.setValue(attrIndex, (IDfValue)repeatingValue);
            }
        } else if (AttributeCache.isNullList(list)) {
            list = new DfList(1025);
            DfValue repeatingValue = new DfValue(list, value.getDataType());
            resultEntry.setValue(attrIndex, (IDfValue)repeatingValue);
            AttributeCache.appendListValue(list, AttributeCache.getSingleNullValue(value.getDataType()));
        }
        if (addValue) {
            AttributeCache.appendListValue(list, value);
        }
    }

    public static boolean isNullValue(IDfValue value) {
        if (value == null) {
            return true;
        }
        boolean nullValue = false;
        switch (value.getDataType()) {
            case 2: {
                if (value.asString().length() != 0) break;
                nullValue = true;
                break;
            }
            case 3: {
                if (!value.asId().isNull()) break;
                nullValue = true;
                break;
            }
            case 1: {
                if (value.asInteger() != 0) break;
                nullValue = true;
                break;
            }
            case 5: {
                if (value.asDouble() != 0.0) break;
                nullValue = true;
                break;
            }
            case 0: {
                if (value.asBoolean()) break;
                nullValue = true;
            }
        }
        return nullValue;
    }

    public static boolean isEmptyList(IDfList list) {
        return list == EMPTY_LIST;
    }

    public static boolean isNullList(IDfList list) {
        for (int i = 0; i < NULL_LISTS.length; ++i) {
            if (list != NULL_LISTS[i]) continue;
            return true;
        }
        return false;
    }

    public static IDfValue getSingleNullValue(int dataType) {
        return (IDfValue)SINGLE_NULL_VALUES.get(new Integer(dataType));
    }

    public static IDfValue getRepeatingNullValue(int dataType) {
        return (IDfValue)REPEATING_NULL_VALUES.get(new Integer(dataType));
    }

    private static Integer[] initDataTypesInteger() {
        Integer[] integers = new Integer[DATA_TYPES.length];
        for (int i = 0; i < DATA_TYPES.length; ++i) {
            integers[i] = new Integer(DATA_TYPES[i]);
        }
        return integers;
    }

    private static Map initSingleNullValues() {
        HashMap<Integer, DfValue> nullValues = new HashMap<Integer, DfValue>(6, 1.0f);
        nullValues.put(new Integer(0), new DfValue("false", 0));
        nullValues.put(new Integer(1), new DfValue("0", 1));
        nullValues.put(new Integer(2), new DfValue("", 2));
        nullValues.put(new Integer(3), new DfValue(DfId.DF_NULLID.toString(), 3));
        nullValues.put(new Integer(5), new DfValue("0", 5));
        return Collections.unmodifiableMap(nullValues);
    }

    private static Map initRepeatingEmptyLists() {
        HashMap<Integer, DfValue> repeatingEmptyLists = new HashMap<Integer, DfValue>(DATA_TYPES.length + 1, 1.0f);
        for (int i = 0; i < DATA_TYPES.length; ++i) {
            repeatingEmptyLists.put(DATA_TYPES_INTEGER[i], new DfValue(EMPTY_LIST, DATA_TYPES[i]));
        }
        return Collections.unmodifiableMap(repeatingEmptyLists);
    }

    private static IDfList[] initNullLists() {
        IDfList[] nullLists = new IDfList[DATA_TYPES.length];
        for (int i = 0; i < DATA_TYPES.length; ++i) {
            DfList nullList;
            block3: {
                nullList = new DfList(1025);
                try {
                    IDfValue value = (IDfValue)SINGLE_NULL_VALUES.get(DATA_TYPES_INTEGER[i]);
                    nullList.appendValue(value);
                }
                catch (DfException de) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)("Unexpected exception: " + de.getMessage()));
                }
            }
            nullLists[i] = nullList;
        }
        return nullLists;
    }

    private static Map initRepeatingNullValues() {
        HashMap<Integer, DfValue> repeatingNullValues = new HashMap<Integer, DfValue>(DATA_TYPES.length + 1, 1.0f);
        for (int i = 0; i < DATA_TYPES.length; ++i) {
            repeatingNullValues.put(DATA_TYPES_INTEGER[i], new DfValue(NULL_LISTS[i], DATA_TYPES[i]));
        }
        return Collections.unmodifiableMap(repeatingNullValues);
    }

    private static void appendListValue(IDfList list, IDfValue value) {
        block2: {
            try {
                list.appendValue(value);
            }
            catch (DfException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)("Unexpected exception: " + e.getMessage()));
            }
        }
    }

    private AttributeCache() {
    }

    private void checkAttributeCacheCurrency() {
        long time = System.currentTimeMillis();
        if (time >= this.m_cacheTimeout) {
            this.m_attributes.clear();
            this.m_attributeIndexes.clear();
            this.m_cacheTimeout = time + 300000L;
        }
    }
}

