/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.search.impl.rater;

import com.documentum.fc.client.search.DfSearchException;
import com.documentum.fc.client.search.IDfPerceptualRaterConfig;
import com.documentum.fc.client.search.IDfQueryDefinition;
import com.documentum.fc.client.search.IDfResultEntry;
import com.documentum.fc.client.search.IDfResultRater;
import com.documentum.fc.client.search.IDfResultRaterConfig;
import com.documentum.fc.client.search.impl.definition.query.DfQueryBuilder;
import com.documentum.fc.client.search.impl.rater.AccuracyValidityRater;
import com.documentum.fc.client.search.impl.rater.ClarityRater;
import com.documentum.fc.client.search.impl.rater.ConstraintCharacteristics;
import com.documentum.fc.client.search.impl.rater.CurrencyRater;
import com.documentum.fc.client.search.impl.rater.ExpressionMatcher;
import com.documentum.fc.client.search.impl.rater.ResultCache;
import com.documentum.fc.client.search.impl.rater.ScopeRater;
import com.documentum.fc.client.search.impl.rater.SourceCharacteristics;
import com.documentum.fc.client.search.impl.rater.SourceQualityRater;
import com.documentum.fc.client.search.impl.result.DfResultEntry;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

class PerceptualRater
implements IDfResultRater {
    private static final float RATING_WEIGHT_HIGH = 100.0f;
    private DfQueryBuilder m_queryBuilder;
    private IDfResultRaterConfig m_resultRaterConfig;
    private IDfPerceptualRaterConfig m_perceptualRaterConfig;
    private ExpressionMatcher m_expressionMatcher;
    private ScopeRater m_scopeRater;
    private AccuracyValidityRater m_accuracyValidityRater;
    private ClarityRater m_clarityRater;
    private CurrencyRater m_currencyRater;
    private SourceQualityRater m_sourceQualityRater;
    private ConstraintCharacteristics m_constraintCharacteristics;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    PerceptualRater(IDfQueryDefinition queryDefinition, IDfResultRaterConfig resultRaterConfig, IDfPerceptualRaterConfig perceptualRaterConfig) throws DfSearchException {
        IDfQueryDefinition iDfQueryDefinition = queryDefinition;
        IDfResultRaterConfig iDfResultRaterConfig = resultRaterConfig;
        IDfPerceptualRaterConfig iDfPerceptualRaterConfig = perceptualRaterConfig;
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iDfQueryDefinition, iDfResultRaterConfig, iDfPerceptualRaterConfig};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (!queryDefinition.isQueryBuilder()) {
                throw new DfSearchException("NOT_APPLICABLE");
            }
            this.m_queryBuilder = (DfQueryBuilder)queryDefinition;
            this.m_resultRaterConfig = resultRaterConfig;
            this.m_perceptualRaterConfig = perceptualRaterConfig;
            this.m_expressionMatcher = new ExpressionMatcher();
            this.m_scopeRater = new ScopeRater(this.m_queryBuilder, this.m_expressionMatcher, this.m_resultRaterConfig);
            this.m_accuracyValidityRater = new AccuracyValidityRater(this.m_queryBuilder.getRootExpressionSet(), this.m_expressionMatcher, this.m_resultRaterConfig);
            this.m_clarityRater = new ClarityRater(this.m_resultRaterConfig);
            this.m_currencyRater = new CurrencyRater(this.m_resultRaterConfig);
            this.m_sourceQualityRater = new SourceQualityRater();
            this.m_constraintCharacteristics = new ConstraintCharacteristics(this.m_queryBuilder);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iDfQueryDefinition, iDfResultRaterConfig, iDfPerceptualRaterConfig};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iDfQueryDefinition, iDfResultRaterConfig, iDfPerceptualRaterConfig};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public float rate(IDfResultEntry iDfResultEntry) {
        IDfResultEntry iDfResultEntry2 = iDfResultEntry;
        JoinPoint joinPoint = null;
        try {
            float f;
            float f2;
            float f3;
            void resultEntry;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)iDfResultEntry2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (DfLogger.isDebugEnabled(PerceptualRater.class)) {
                PerceptualRater.trace("Compute score for result [" + resultEntry.getKey() + " seqNum:" + resultEntry.getSeqNumber() + "] " + PerceptualRater.getResultIdForDebug((IDfResultEntry)resultEntry));
            }
            ResultCache resultCache = new ResultCache((IDfResultEntry)resultEntry, this.m_resultRaterConfig);
            SourceCharacteristics srcChar = this.createSourceCharacteristics(resultCache, (IDfResultEntry)resultEntry);
            float score = (float)resultCache.getResultEntry().getScore();
            float ratingWeight = srcChar.getRatingWeight();
            if (ratingWeight >= 100.0f && score > 0.0f) {
                if (DfLogger.isDebugEnabled(PerceptualRater.class)) {
                    PerceptualRater.trace("Source rating weight (" + ratingWeight + ") is higher than limit, source score will be used and perceptual score is ignored");
                }
                f2 = f3 = score;
            } else {
                float perceptualScore = this.computePerceptualScore(resultCache, srcChar);
                f2 = f3 = this.mergeScore(perceptualScore, resultCache, srcChar);
            }
            float f4 = f = f2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.floatObject((float)f);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)iDfResultEntry2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return f3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)iDfResultEntry2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private SourceCharacteristics createSourceCharacteristics(ResultCache resultCache, IDfResultEntry iDfResultEntry) {
        ResultCache resultCache2 = resultCache;
        IDfResultEntry iDfResultEntry2 = iDfResultEntry;
        JoinPoint joinPoint = null;
        try {
            void resultCache3;
            SourceCharacteristics sourceCharacteristics;
            SourceCharacteristics sourceCharacteristics2;
            void resultEntry;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)resultCache2, (Object)iDfResultEntry2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            boolean isRankTrusted = resultEntry.getAttr("score") != null;
            SourceCharacteristics sourceCharacteristics3 = sourceCharacteristics2 = (sourceCharacteristics = new SourceCharacteristics(resultCache3.getResultEntry().getSource(), this.m_queryBuilder.getMetadataMgr().getSourceMap(), this.m_resultRaterConfig, this.m_perceptualRaterConfig, isRankTrusted, this.m_queryBuilder.getSelectedSourceCount()));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)resultCache2, (Object)iDfResultEntry2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(sourceCharacteristics2, joinPoint);
            }
            return sourceCharacteristics;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)resultCache2, (Object)iDfResultEntry2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private float computePerceptualScore(ResultCache resultCache, SourceCharacteristics sourceCharacteristics) {
        ResultCache resultCache2 = resultCache;
        SourceCharacteristics sourceCharacteristics2 = sourceCharacteristics;
        JoinPoint joinPoint = null;
        try {
            float f;
            float f2;
            void resultCache3;
            void srcChar;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)resultCache2, (Object)sourceCharacteristics2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            float scopeWeight = this.m_perceptualRaterConfig.getScopeWeight();
            float accuracyValidityWeight = this.m_perceptualRaterConfig.getAccuracyValidityWeight();
            float clarityWeight = this.m_perceptualRaterConfig.getClarityWeight();
            float currencyWeight = this.m_perceptualRaterConfig.getCurrencyWeight();
            float sourceQualityWeight = this.m_perceptualRaterConfig.getSourceQualityWeight() * srcChar.getRankConfidence();
            float score = scopeWeight * this.m_scopeRater.rate((ResultCache)resultCache3) + accuracyValidityWeight * this.m_accuracyValidityRater.rate((ResultCache)resultCache3) + clarityWeight * this.m_clarityRater.rate((ResultCache)resultCache3) + currencyWeight * this.m_currencyRater.rate((ResultCache)resultCache3) + sourceQualityWeight * this.m_sourceQualityRater.rate((ResultCache)resultCache3);
            score /= scopeWeight + accuracyValidityWeight + clarityWeight + currencyWeight + sourceQualityWeight;
            this.m_expressionMatcher.reset();
            score += this.getSourceBonus((SourceCharacteristics)srcChar);
            score = this.normalizeScore(score);
            if (DfLogger.isDebugEnabled(PerceptualRater.class)) {
                PerceptualRater.trace(" perceptual score=" + score);
            }
            float f3 = f2 = (f = score);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.floatObject((float)f2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)resultCache2, (Object)sourceCharacteristics2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return f;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)resultCache2, (Object)sourceCharacteristics2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private float mergeScore(float f, ResultCache resultCache, SourceCharacteristics sourceCharacteristics) {
        float f2 = f;
        ResultCache resultCache2 = resultCache;
        SourceCharacteristics sourceCharacteristics2 = sourceCharacteristics;
        JoinPoint joinPoint = null;
        try {
            void var14_13;
            void v1;
            void var13_9;
            void perceptualScore;
            void resultCache3;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{Conversions.floatObject((float)f2), resultCache2, sourceCharacteristics2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (((DfResultEntry)resultCache3.getResultEntry()).isDefaultScore()) {
                if (DfLogger.isDebugEnabled(PerceptualRater.class)) {
                    PerceptualRater.trace("Source doesn't return score or current result score is 0 so computed perceptual score is used:" + (float)perceptualScore);
                }
                v1 = var13_9 = perceptualScore;
            } else {
                void srcChar;
                float resultScore = (float)resultCache3.getResultEntry().getScore();
                float sourceRatingWeight = this.m_constraintCharacteristics.hasFullTextConstraint() ? srcChar.getRatingWeight() : 0.0f;
                void mergedScore = (perceptualScore + sourceRatingWeight * resultScore) / (1.0f + sourceRatingWeight);
                if (DfLogger.isDebugEnabled(PerceptualRater.class)) {
                    PerceptualRater.trace(" result score=" + resultScore);
                    PerceptualRater.trace(" merged score=" + (float)mergedScore);
                }
                v1 = var13_9 = mergedScore;
            }
            void v2 = var14_13 = v1;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.floatObject((float)var14_13);
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{Conversions.floatObject((float)f2), resultCache2, sourceCharacteristics2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return (float)var13_9;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{Conversions.floatObject((float)f2), resultCache2, sourceCharacteristics2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private float getSourceBonus(SourceCharacteristics sourceCharacteristics) {
        SourceCharacteristics sourceCharacteristics2 = sourceCharacteristics;
        JoinPoint joinPoint = null;
        try {
            float f;
            float f2;
            void srcChar;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)sourceCharacteristics2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            float sourceBonus = 0.0f;
            int bonusCount = 0;
            if (this.m_constraintCharacteristics.hasFullTextConstraint()) {
                sourceBonus += srcChar.getSourceBonusFullText();
                ++bonusCount;
            }
            if (this.m_constraintCharacteristics.hasAttributeConstraint()) {
                sourceBonus += srcChar.getSourceBonusAttribute();
                ++bonusCount;
            }
            sourceBonus = bonusCount == 0 ? 0.0f : (sourceBonus /= (float)bonusCount);
            float f3 = f2 = (f = sourceBonus);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.floatObject((float)f2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)sourceCharacteristics2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return f;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)sourceCharacteristics2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private float normalizeScore(float f) {
        float f2 = f;
        JoinPoint joinPoint = null;
        try {
            float f3;
            float f4;
            float score;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.floatObject((float)f2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (score > 1.0f) {
                score = 1.0f;
            } else if (score < 0.0f) {
                score = 0.0f;
            }
            float f5 = f4 = (f3 = score);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.floatObject((float)f4);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.floatObject((float)f2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return f3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.floatObject((float)f2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    protected static void trace(String string) {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            String msg;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            PerceptualRater.trace(msg, null);
            Object var3_3 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var3_3, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static void trace(String string, Throwable throwable) {
        String string2 = string;
        Throwable throwable2 = throwable;
        JoinPoint joinPoint = null;
        try {
            void t;
            String msg;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null, (Object)string2, (Object)throwable2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            DfLogger.debug(PerceptualRater.class, msg, null, (Throwable)t);
            Object var5_5 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null, (Object)string2, (Object)throwable2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var5_5, joinPoint);
            }
            return;
        }
        catch (Throwable throwable3) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null, (Object)string2, (Object)throwable2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable3, joinPoint);
            }
            throw throwable3;
        }
    }

    private static String getResultIdForDebug(IDfResultEntry iDfResultEntry) {
        IDfResultEntry iDfResultEntry2 = iDfResultEntry;
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            String string3;
            block9: {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null, (Object)iDfResultEntry2);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                String[] attrNames = new String[]{"object_name", "subject", "summary", "abstract"};
                for (int i = 0; i < attrNames.length; ++i) {
                    IDfResultEntry resultEntry;
                    int attrIndex = resultEntry.findAttrIndex(attrNames[i]);
                    if (attrIndex == -1) continue;
                    string2 = string3 = resultEntry.getValueAt(attrIndex).asString();
                    break block9;
                }
                string2 = string3 = "";
            }
            String string4 = string = string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null, (Object)iDfResultEntry2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string, joinPoint);
            }
            return string3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null, (Object)iDfResultEntry2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("PerceptualRater.java", Class.forName("com.documentum.fc.client.search.impl.rater.PerceptualRater"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "rate", "com.documentum.fc.client.search.impl.rater.PerceptualRater", "com.documentum.fc.client.search.IDfResultEntry:", "resultEntry:", "", "float"), 96);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createSourceCharacteristics", "com.documentum.fc.client.search.impl.rater.PerceptualRater", "com.documentum.fc.client.search.impl.rater.ResultCache:com.documentum.fc.client.search.IDfResultEntry:", "resultCache:resultEntry:", "", "com.documentum.fc.client.search.impl.rater.SourceCharacteristics"), 125);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "computePerceptualScore", "com.documentum.fc.client.search.impl.rater.PerceptualRater", "com.documentum.fc.client.search.impl.rater.ResultCache:com.documentum.fc.client.search.impl.rater.SourceCharacteristics:", "resultCache:srcChar:", "", "float"), 140);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "mergeScore", "com.documentum.fc.client.search.impl.rater.PerceptualRater", "float:com.documentum.fc.client.search.impl.rater.ResultCache:com.documentum.fc.client.search.impl.rater.SourceCharacteristics:", "perceptualScore:resultCache:srcChar:", "", "float"), 171);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getSourceBonus", "com.documentum.fc.client.search.impl.rater.PerceptualRater", "com.documentum.fc.client.search.impl.rater.SourceCharacteristics:", "srcChar:", "", "float"), 194);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "normalizeScore", "com.documentum.fc.client.search.impl.rater.PerceptualRater", "float:", "score:", "", "float"), 219);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c", "trace", "com.documentum.fc.client.search.impl.rater.PerceptualRater", "java.lang.String:", "msg:", "", "void"), 231);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c", "trace", "com.documentum.fc.client.search.impl.rater.PerceptualRater", "java.lang.String:java.lang.Throwable:", "msg:t:", "", "void"), 236);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "getResultIdForDebug", "com.documentum.fc.client.search.impl.rater.PerceptualRater", "com.documentum.fc.client.search.IDfResultEntry:", "resultEntry:", "", "java.lang.String"), 241);
        ajc$tjp_9 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("0", "com.documentum.fc.client.search.impl.rater.PerceptualRater", "com.documentum.fc.client.search.IDfQueryDefinition:com.documentum.fc.client.search.IDfResultRaterConfig:com.documentum.fc.client.search.IDfPerceptualRaterConfig:", "queryDefinition:resultRaterConfig:perceptualRaterConfig:", "com.documentum.fc.client.search.DfSearchException:"), 78);
    }
}

