/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.search.impl.definition.metadata;

import com.documentum.fc.client.DfClient;
import com.documentum.fc.client.DfIteratorWrapper;
import com.documentum.fc.client.IDfClient;
import com.documentum.fc.client.IDfDocbaseMap;
import com.documentum.fc.client.IDfEnumeration;
import com.documentum.fc.client.IDfTypedObject;
import com.documentum.fc.client.impl.typeddata.Attribute;
import com.documentum.fc.client.search.DfConfigurationException;
import com.documentum.fc.client.search.DfSearchException;
import com.documentum.fc.client.search.IDfSearchSource;
import com.documentum.fc.client.search.impl.config.DfSearchMessages;
import com.documentum.fc.client.search.impl.config.SearchConfigFactory;
import com.documentum.fc.client.search.impl.definition.metadata.DfSearchSource;
import com.documentum.fc.client.search.impl.ecis.ECISDomainListener;
import com.documentum.fc.client.search.impl.ecis.ECISMetadataMgr;
import com.documentum.fc.client.search.impl.ecis.ECISProxy;
import com.documentum.fc.client.search.impl.execution.adapter.localeci.LocalECIProxy;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class DfSearchSourceCache
implements ECISDomainListener {
    public static final String FTDQL_MINIMAL_SERVER_VERSION = "5.3.0.95";
    public static final String TRY_FTDQL_FIRST_MINIMAL_SERVER_VERSION = "5.3.0.400";
    private static final int AVAIL_SOURCE_MAP_SIZE = 20;
    private static final long LOADING_FAILURE_TIMEOUT = 30000L;
    private static DfSearchSourceCache s_singleInstance;
    private Map m_availableSources;
    private long m_sourceCacheTimeStamp;
    private boolean m_eciOptionEnabled;
    private boolean m_loadingFailure;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;

    public DfSearchSourceCache() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            JoinPoint joinPoint2 = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint2 == null) {
                        joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint2);
                }
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint2 == null) {
                        joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint2);
                }
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint2 == null) {
                        joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint2);
                }
                throw throwable;
            }
            this.m_availableSources = new HashMap(20);
            this.m_sourceCacheTimeStamp = 0L;
            this.m_eciOptionEnabled = false;
            this.m_loadingFailure = false;
            ECISProxy.getECISProxy().addDomainListener(this);
            if (DfLogger.isDebugEnabled(this)) {
                DfLogger.debug((Object)this, "Create new source cache with timeout:" + DfSearchSourceCache.getTimeout() + " ms.", null, null);
            }
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public static synchronized DfSearchSourceCache access() {
        JoinPoint joinPoint = null;
        try {
            DfSearchSourceCache dfSearchSourceCache;
            DfSearchSourceCache dfSearchSourceCache2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (s_singleInstance == null) {
                s_singleInstance = new DfSearchSourceCache();
            }
            DfSearchSourceCache dfSearchSourceCache3 = dfSearchSourceCache2 = (dfSearchSourceCache = s_singleInstance);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(dfSearchSourceCache2, joinPoint);
            }
            return dfSearchSourceCache;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public synchronized IDfEnumeration getAvailableSources() throws DfException {
        JoinPoint joinPoint = null;
        try {
            DfIteratorWrapper dfIteratorWrapper;
            DfIteratorWrapper dfIteratorWrapper2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            DfIteratorWrapper dfIteratorWrapper3 = dfIteratorWrapper2 = (dfIteratorWrapper = new DfIteratorWrapper(this.getAvailableSourceTable().values().iterator()));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(dfIteratorWrapper2, joinPoint);
            }
            return dfIteratorWrapper;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized IDfEnumeration getAvailableSources(int n) throws DfException {
        int n2 = n;
        JoinPoint joinPoint = null;
        try {
            DfIteratorWrapper dfIteratorWrapper;
            DfIteratorWrapper dfIteratorWrapper2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            Map sourceTable = this.getAvailableSourceTable();
            Iterator iterator = sourceTable.values().iterator();
            LinkedList<IDfSearchSource> result = new LinkedList<IDfSearchSource>();
            while (iterator.hasNext()) {
                void sourceType;
                IDfSearchSource searchSource = (IDfSearchSource)iterator.next();
                if (searchSource.getType() != sourceType) continue;
                result.add(searchSource);
            }
            DfIteratorWrapper dfIteratorWrapper3 = dfIteratorWrapper2 = (dfIteratorWrapper = new DfIteratorWrapper(result.iterator()));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(dfIteratorWrapper2, joinPoint);
            }
            return dfIteratorWrapper;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public static synchronized void reset() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (s_singleInstance != null) {
                s_singleInstance.clear();
                s_singleInstance = null;
            }
            Object var1_1 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var1_1, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public IDfSearchSource getSource(String string) throws DfException {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            void sourceName;
            IDfSearchSource iDfSearchSource;
            IDfSearchSource iDfSearchSource2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            IDfSearchSource iDfSearchSource3 = iDfSearchSource2 = (iDfSearchSource = (IDfSearchSource)this.getAvailableSourceTable().get(sourceName));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(iDfSearchSource2, joinPoint);
            }
            return iDfSearchSource;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public int getAvailableSourceCount() throws DfException {
        JoinPoint joinPoint = null;
        try {
            int n;
            int n2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            int n3 = n2 = (n = this.getAvailableSourceTable().size());
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.intObject((int)n2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return n;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public synchronized void notifyECISDomainLoaded() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_sourceCacheTimeStamp = 0L;
            Object var2_2 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var2_2, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private static long getTimeout() {
        JoinPoint joinPoint = null;
        try {
            long l;
            long l2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            long l3 = l2 = (l = SearchConfigFactory.getConfig().getSearchSourceCacheTimeout());
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.longObject((long)l2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return l;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private synchronized void clear() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_availableSources.clear();
            Object var2_2 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var2_2, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private synchronized Map getAvailableSourceTable() throws DfException {
        JoinPoint joinPoint = null;
        try {
            Map map;
            Map map2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            long time = System.currentTimeMillis();
            if (this.m_sourceCacheTimeStamp == 0L || this.m_sourceCacheTimeStamp + DfSearchSourceCache.getTimeout() <= time || this.m_loadingFailure && this.m_sourceCacheTimeStamp + 30000L <= time || DfSearchSourceCache.isECIOptionEnabled() != this.m_eciOptionEnabled) {
                this.loadAvailableSources();
            }
            Map map3 = map2 = (map = this.m_availableSources);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(map2, joinPoint);
            }
            return map;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private static boolean isECIOptionEnabled() {
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, null, null);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            boolean bl3 = bl2 = (bl = SearchConfigFactory.getConfig().isECIOptionEnabled());
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, null, null);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, null, null);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private void loadAvailableSources() throws DfException {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (DfLogger.isDebugEnabled(this)) {
                DfLogger.debug((Object)this, "Load available search sources.", null, null);
            }
            this.clear();
            this.m_loadingFailure = !this.loadDocbases();
            this.m_eciOptionEnabled = DfSearchSourceCache.isECIOptionEnabled();
            if (!this.loadLocalECISources()) {
                this.m_loadingFailure = true;
            }
            if (this.m_eciOptionEnabled && !this.loadRemoteECISources()) {
                this.m_loadingFailure = true;
            }
            this.m_sourceCacheTimeStamp = System.currentTimeMillis();
            Object var2_2 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var2_2, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private boolean loadDocbases() throws DfException {
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            boolean bl3;
            IDfClient client;
            IDfTypedObject docbrokersMap;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (DfLogger.isDebugEnabled(this)) {
                DfLogger.debug((Object)this, "Load Docbase search sources.", null, null);
            }
            if ((docbrokersMap = (client = DfClient.getLocalClient()).getDocbrokerMap()).getValueCount("host_name") <= 0) {
                bl2 = bl3 = false;
            } else {
                IDfDocbaseMap docbaseMap = client.getDocbaseMap();
                int count = docbaseMap.getDocbaseCount();
                for (int i = 0; i < count; ++i) {
                    String docbaseName = docbaseMap.getDocbaseName(i);
                    String docbaseDescription = docbaseMap.getDocbaseDescription(i);
                    String serverVersion = docbaseMap.getServerVersion(i);
                    DfSearchSource searchSource = new DfSearchSource(docbaseName, docbaseDescription, serverVersion);
                    DfSearchSourceCache.setDocbaseSourceCapabilities(searchSource);
                    this.m_availableSources.put(docbaseName, searchSource);
                }
                bl2 = bl3 = true;
            }
            boolean bl4 = bl = bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private boolean loadRemoteECISources() {
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            boolean loadingSuccess = false;
            try {
                ECISProxy ecisProxy = ECISProxy.getECISProxy();
                ECISMetadataMgr ecisMetadata = ecisProxy.getECISMetadataMgr();
                this.loadECISources(ecisMetadata);
                loadingSuccess = true;
            }
            catch (DfConfigurationException e) {
                DfLogger.error((Object)this, DfSearchMessages.getString("COMMUNICATION_ERROR"), null, (Throwable)e);
            }
            catch (DfSearchException e) {
                DfLogger.error((Object)this, DfSearchMessages.getString("COMMUNICATION_ERROR"), null, (Throwable)e);
            }
            boolean bl3 = bl2 = (bl = loadingSuccess);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private boolean loadLocalECISources() {
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            boolean loadingSuccess = false;
            try {
                LocalECIProxy ecisProxy = LocalECIProxy.getECISProxy();
                ECISMetadataMgr ecisMetadata = ecisProxy.getECISMetadataMgr();
                this.loadECISources(ecisMetadata);
                loadingSuccess = true;
            }
            catch (DfConfigurationException e) {
                DfLogger.error((Object)this, DfSearchMessages.getString("LOCAL_ECIS_CONFIGURATION"), null, (Throwable)e);
            }
            catch (DfSearchException e) {
                DfLogger.error((Object)this, DfSearchMessages.getString("LOCAL_ECIS_CONFIGURATION"), null, (Throwable)e);
            }
            boolean bl3 = bl2 = (bl = loadingSuccess);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loadECISources(ECISMetadataMgr eCISMetadataMgr) throws DfSearchException {
        ECISMetadataMgr eCISMetadataMgr2 = eCISMetadataMgr;
        JoinPoint joinPoint = null;
        try {
            void ecisMetadata;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)eCISMetadataMgr2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            Iterator sourceNames = ecisMetadata.getSourcesNames();
            while (sourceNames.hasNext()) {
                String sourceName = (String)sourceNames.next();
                DfSearchSource newSource = new DfSearchSource(100, sourceName, ecisMetadata.getDescription(sourceName), "");
                DfSearchSourceCache.setExtSourceCapabilities(newSource, (ECISMetadataMgr)ecisMetadata, sourceName);
                this.m_availableSources.put(sourceName, newSource);
            }
            Object var7_7 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)eCISMetadataMgr2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var7_7, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)eCISMetadataMgr2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void setExtSourceCapabilities(DfSearchSource dfSearchSource, ECISMetadataMgr eCISMetadataMgr, String string) throws DfSearchException {
        DfSearchSource dfSearchSource2 = dfSearchSource;
        ECISMetadataMgr eCISMetadataMgr2 = eCISMetadataMgr;
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            boolean dupl;
            void sourceName;
            void ecisMetadata;
            DfSearchSource newSource;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{dfSearchSource2, eCISMetadataMgr2, string2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, null, null, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            newSource.setHomeURL(ecisMetadata.getHomeURL((String)sourceName));
            newSource.setCapability("all_versions_support", false);
            newSource.setCapability("duplicate_removal_support", true);
            newSource.setCapability("hidden_obj_support", false);
            newSource.setCapability("logical_or_expr_set_support", false);
            newSource.setCapability("login_support", ecisMetadata.isLoginSupported((String)sourceName));
            if (ecisMetadata.isLoginSupported((String)sourceName)) {
                newSource.setCapability("user_login_support", ecisMetadata.isUserLoginSupported((String)sourceName));
                newSource.setCapability("default_login_support", ecisMetadata.isCorporateLoginSupported((String)sourceName));
            }
            if (dupl = ecisMetadata.isDuplicateSupported((String)sourceName)) {
                newSource.setCapability("duplicate_removal_support", true);
                String duplKey = ecisMetadata.getDuplicateKey((String)sourceName);
                newSource.setDeDuplicationKey(new Attribute(0, duplKey, false, 2, 256));
                String[] modKeys = ecisMetadata.getModificationKeys((String)sourceName);
                newSource.setModificationKeys(modKeys);
            }
            Object var12_11 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{dfSearchSource2, eCISMetadataMgr2, string2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, null, null, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var12_11, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{dfSearchSource2, eCISMetadataMgr2, string2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, null, null, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private static void setDocbaseSourceCapabilities(DfSearchSource dfSearchSource) throws DfSearchException {
        DfSearchSource dfSearchSource2 = dfSearchSource;
        JoinPoint joinPoint = null;
        try {
            DfSearchSource searchSource;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, null, null, (Object)dfSearchSource2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            searchSource.setCapability("all_versions_support", true);
            searchSource.setCapability("duplicate_removal_support", true);
            searchSource.setCapability("hidden_obj_support", true);
            searchSource.setCapability("logical_or_expr_set_support", true);
            searchSource.setCapability("login_support", true);
            searchSource.setCapability("user_login_support", true);
            searchSource.setCapability("default_login_support", false);
            boolean ftDQLCapable = searchSource.checkMinServerVersionCompatibility(FTDQL_MINIMAL_SERVER_VERSION);
            searchSource.setCapability("ftdql_support", ftDQLCapable);
            searchSource.setCapability("try_ftdql_first_support", searchSource.checkMinServerVersionCompatibility(TRY_FTDQL_FIRST_MINIMAL_SERVER_VERSION));
            Object var4_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, null, null, (Object)dfSearchSource2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var4_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, null, null, (Object)dfSearchSource2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("DfSearchSourceCache.java", Class.forName("com.documentum.fc.client.search.impl.definition.metadata.DfSearchSourceCache"));
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.documentum.fc.client.search.impl.ecis.ECISDomainListener", "", "", ""), 83);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("29", "access", "com.documentum.fc.client.search.impl.definition.metadata.DfSearchSourceCache", "", "", "", "com.documentum.fc.client.search.impl.definition.metadata.DfSearchSourceCache"), 102);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("22", "getAvailableSourceTable", "com.documentum.fc.client.search.impl.definition.metadata.DfSearchSourceCache", "", "", "com.documentum.fc.common.DfException:", "java.util.Map"), 187);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "isECIOptionEnabled", "com.documentum.fc.client.search.impl.definition.metadata.DfSearchSourceCache", "", "", "", "boolean"), 199);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "loadAvailableSources", "com.documentum.fc.client.search.impl.definition.metadata.DfSearchSourceCache", "", "", "com.documentum.fc.common.DfException:", "void"), 204);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "loadDocbases", "com.documentum.fc.client.search.impl.definition.metadata.DfSearchSourceCache", "", "", "com.documentum.fc.common.DfException:", "boolean"), 234);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "loadRemoteECISources", "com.documentum.fc.client.search.impl.definition.metadata.DfSearchSourceCache", "", "", "", "boolean"), 271);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "loadLocalECISources", "com.documentum.fc.client.search.impl.definition.metadata.DfSearchSourceCache", "", "", "", "boolean"), 296);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "loadECISources", "com.documentum.fc.client.search.impl.definition.metadata.DfSearchSourceCache", "com.documentum.fc.client.search.impl.ecis.ECISMetadataMgr:", "ecisMetadata:", "com.documentum.fc.client.search.DfSearchException:", "void"), 321);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "setExtSourceCapabilities", "com.documentum.fc.client.search.impl.definition.metadata.DfSearchSourceCache", "com.documentum.fc.client.search.impl.definition.metadata.DfSearchSource:com.documentum.fc.client.search.impl.ecis.ECISMetadataMgr:java.lang.String:", "newSource:ecisMetadata:sourceName:", "com.documentum.fc.client.search.DfSearchException:", "void"), 338);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "setDocbaseSourceCapabilities", "com.documentum.fc.client.search.impl.definition.metadata.DfSearchSourceCache", "com.documentum.fc.client.search.impl.definition.metadata.DfSearchSource:", "searchSource:", "com.documentum.fc.client.search.DfSearchException:", "void"), 365);
        ajc$tjp_19 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.documentum.fc.client.search.impl.definition.metadata.DfSearchSourceCache", "", "", ""), 83);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "getAvailableSources", "com.documentum.fc.client.search.impl.definition.metadata.DfSearchSourceCache", "", "", "com.documentum.fc.common.DfException:", "com.documentum.fc.client.IDfEnumeration"), 117);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "getAvailableSources", "com.documentum.fc.client.search.impl.definition.metadata.DfSearchSourceCache", "int:", "sourceType:", "com.documentum.fc.common.DfException:", "com.documentum.fc.client.IDfEnumeration"), 129);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("29", "reset", "com.documentum.fc.client.search.impl.definition.metadata.DfSearchSourceCache", "", "", "", "void"), 149);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSource", "com.documentum.fc.client.search.impl.definition.metadata.DfSearchSourceCache", "java.lang.String:", "sourceName:", "com.documentum.fc.common.DfException:", "com.documentum.fc.client.search.IDfSearchSource"), 158);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAvailableSourceCount", "com.documentum.fc.client.search.impl.definition.metadata.DfSearchSourceCache", "", "", "com.documentum.fc.common.DfException:", "int"), 163);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "notifyECISDomainLoaded", "com.documentum.fc.client.search.impl.definition.metadata.DfSearchSourceCache", "", "", "", "void"), 168);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "getTimeout", "com.documentum.fc.client.search.impl.definition.metadata.DfSearchSourceCache", "", "", "", "long"), 177);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("22", "clear", "com.documentum.fc.client.search.impl.definition.metadata.DfSearchSourceCache", "", "", "", "void"), 182);
        s_singleInstance = null;
    }
}

