/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.search.impl.definition;

import com.documentum.fc.client.search.DfSearchException;
import com.documentum.fc.client.search.impl.config.DfSearchMessages;
import com.documentum.fc.client.search.impl.util.XMLUtil;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class XMLQueryConstants {
    public static final String SEARCH_SOURCE_LIST_NODE = "SourceList";
    public static final String SEARCH_SOURCE_NODE = "Source";
    public static final String SEARCH_SOURCE_NAME = "name";
    public static final String SEARCH_SOURCE_TYPE = "type";
    public static final String SEARCH_SOURCE_TYPE_DOCBASE = "docbase";
    public static final String SEARCH_SOURCE_TYPE_EXTERNAL = "external";
    public static final String SEARCH_SOURCE_DESCRIPTION = "description";
    public static final String SEARCH_SOURCE_SERVER_VERSION = "serverVersion";
    public static final String PASS_THROUGH_QUERY_ROOT = "PassThroughQuery";
    public static final String PASS_THROUGH_QUERY_MAX_RESULTS = "maxResults";
    public static final String PASS_THROUGH_QUERY_STRING_NODE = "QueryString";
    public static final String PASS_THROUGH_QUERY_DATA_NODE = "QueryData";
    public static final String QUERY_BUILDER_ROOT = "QueryBuilder";
    public static final String QUERY_BUILDER_MAX_RESULTS = "maxResults";
    public static final String QUERY_BUILDER_DB_SEARCH_REQUESTED = "isDatabaseSearchRequested";
    public static final String QUERY_BUILDER_OBJECT_TYPE = "objectType";
    public static final String QUERY_BUILDER_ALL_VERSIONS = "allVersions";
    public static final String QUERY_BUILDER_HIDDEN_OBJECTS = "hiddenObjects";
    public static final String LOCATION_SCOPE_LIST_NODE = "QueryScopeList";
    public static final String LOCATION_SCOPE_NODE = "LocationQueryScope";
    public static final String LOCATION_SCOPE_SOURCE = "source";
    public static final String LOCATION_SCOPE_IS_DESCEND = "isDescend";
    public static final String LOCATION_SCOPE_IS_EXCLUDE = "isExcluded";
    public static final String PARTITION_SCOPE_NODE = "PartitionScope";
    public static final String PARTITION_SCOPE_SOURCE = "source";
    public static final String EXPRESSION_SCOPE_NODE = "ExpressionScope";
    public static final String EXPRESSION_SCOPE_SOURCE = "source";
    public static final String RESULT_ATTRIBUTE_LIST_NODE = "ResultAttributeList";
    public static final String RESULT_ATTRIBUTE_NODE = "ResultAttribute";
    public static final String RESULT_ATTRIBUTE_NAME = "name";
    public static final String ORDER_ATTRIBUTE_LIST_NODE = "OrderAttributeList";
    public static final String ORDER_ATTRIBUTE_NODE = "OrderAttribute";
    public static final String ORDER_ATTRIBUTE_NAME = "name";
    public static final String ORDER_ATTRIBUTE_IS_ASCENDING = "isAcending";
    public static final String ATTR_EXPR_DATE_FORMAT = "dateFormat";
    public static final String ATTR_EXPR_DATA_TYPE = "dataType";
    public static final String ATTR_EXPR_DATA_TYPE_STRING = "string";
    public static final String ATTR_EXPR_DATA_TYPE_BOOLEAN = "boolean";
    public static final String ATTR_EXPR_DATA_TYPE_INTEGER = "integer";
    public static final String ATTR_EXPR_DATA_TYPE_ID = "id";
    public static final String ATTR_EXPR_DATA_TYPE_TIME = "time";
    public static final String ATTR_EXPR_DATA_TYPE_DOUBLE = "double";
    public static final String ATTR_EXPR_ATTRIBUTE = "attribute";
    public static final String ATTR_EXPR_SEARCH_OP = "searchOperation";
    public static final String ATTR_EXPR_SEARCH_OP_EQUAL = "equal";
    public static final String ATTR_EXPR_SEARCH_OP_NOT_EQUAL = "not_equal";
    public static final String ATTR_EXPR_SEARCH_OP_GREATER_THAN = "greater_than";
    public static final String ATTR_EXPR_SEARCH_OP_LESS_THAN = "less_than";
    public static final String ATTR_EXPR_SEARCH_OP_GREATER_EQUAL = "greater_equal";
    public static final String ATTR_EXPR_SEARCH_OP_LESS_EQUAL = "less_equal";
    public static final String ATTR_EXPR_SEARCH_OP_BEGINS_WITH = "begins_with";
    public static final String ATTR_EXPR_SEARCH_OP_CONTAINS = "contains";
    public static final String ATTR_EXPR_SEARCH_OP_DOES_NOT_CONTAIN = "does_not_contain";
    public static final String ATTR_EXPR_SEARCH_OP_ENDS_WITH = "ends_with";
    public static final String ATTR_EXPR_SEARCH_OP_IN = "in";
    public static final String ATTR_EXPR_SEARCH_OP_NOT_IN = "not_in";
    public static final String ATTR_EXPR_SEARCH_OP_BETWEEN = "between";
    public static final String ATTR_EXPR_SEARCH_OP_IS_NULL = "is_null";
    public static final String ATTR_EXPR_SEARCH_OP_IS_NOT_NULL = "is_not_null";
    public static final String ATTR_EXPR_CASE_SENSITIVE = "caseSensitive";
    public static final String ATTR_EXPR_REPEATED = "repeated";
    public static final String EXPR_SET_NODE = "ExpressionSet";
    public static final String EXPR_SET_LOGICAL_OP = "logicalOperator";
    public static final String EXPR_SET_LOGICAL_OP_AND = "AND";
    public static final String EXPR_SET_LOGICAL_OP_OR = "OR";
    public static final String FULL_TEXT_EXPR_NODE = "FulltextExpression";
    public static final String SIMPLE_ATTR_EXPR_NODE = "SimpleAttributeExpression";
    public static final String RELATIVE_DATE_EXPR_NODE = "RelativeDateExpression";
    public static final String RELATIVE_DATE_EXPR_TIME_UNIT = "timeUnit";
    public static final String VALUE_LIST_ATTR_EXPR_NODE = "ValueListAttributeExpression";
    public static final String VALUE_RANGE_ATTR_EXPR_NODE = "ValueRangeAttributeExpression";
    public static final String VALUE_RANGE_ATTR_EXPR_FROM = "fromValue";
    public static final String VALUE_RANGE_ATTR_EXPR_TO = "toValue";
    public static final String SMART_LIST_DEF_ROOT = "SmartListDefinition";
    public static final String DISPLAY_PREF_NODE = "DisplayPreferences";
    public static final String DISPLAY_PREF_ATTR_LIST_NODE = "DisplayAttributeList";
    public static final String DISPLAY_PREF_ATTR_NODE = "DisplayAttribute";
    public static final String DISPLAY_PREF_ATTR_NAME = "name";
    public static final String PROPERTY_LIST_NODE = "PropertyList";
    public static final String PROPERTY_NODE = "Property";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_VALUE = "value";
    private static final Map LOGICAL_OP_TO_XML;
    private static final Map XML_TO_LOGICAL_OP;
    private static final Map DATA_TYPE_TO_XML;
    private static final Map XML_TO_DATA_TYPE;
    private static final Map SEARCH_OP_TO_XML;
    private static final Map XML_TO_SEARCH_OP;
    private static final Map SOURCE_TYPE_TO_XML;
    private static final Map XML_TO_SOURCE_TYPE;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;

    public XMLQueryConstants() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public static String convertLogicalOpToXML(int n) {
        int n2 = n;
        JoinPoint joinPoint = null;
        try {
            int logicalOp;
            String string;
            String string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String string3 = string2 = (string = XMLQueryConstants.convertCodeToXML(logicalOp, LOGICAL_OP_TO_XML, EXPR_SET_LOGICAL_OP_AND));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public static int convertXMLToLogicalOp(String string) throws DfSearchException {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            String xmlLogOp;
            int n;
            int n2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            int n3 = n2 = (n = XMLQueryConstants.convertXMLToCode(xmlLogOp, XML_TO_LOGICAL_OP));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.intObject((int)n2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return n;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public static String convertDataTypeToXML(int n) {
        int n2 = n;
        JoinPoint joinPoint = null;
        try {
            int dataType;
            String string;
            String string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String string3 = string2 = (string = XMLQueryConstants.convertCodeToXML(dataType, DATA_TYPE_TO_XML, ATTR_EXPR_DATA_TYPE_STRING));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public static int convertXMLToDataType(String string) throws DfSearchException {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            String xmlDataType;
            int n;
            int n2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            int n3 = n2 = (n = XMLQueryConstants.convertXMLToCode(xmlDataType, XML_TO_DATA_TYPE));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.intObject((int)n2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return n;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public static String convertSearchOpToXML(int n) {
        int n2 = n;
        JoinPoint joinPoint = null;
        try {
            int searchOp;
            String string;
            String string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String string3 = string2 = (string = XMLQueryConstants.convertCodeToXML(searchOp, SEARCH_OP_TO_XML, ATTR_EXPR_SEARCH_OP_CONTAINS));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public static int convertXMLToSearchOp(String string) throws DfSearchException {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            String xmlSearchOp;
            int n;
            int n2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            int n3 = n2 = (n = XMLQueryConstants.convertXMLToCode(xmlSearchOp, XML_TO_SEARCH_OP));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.intObject((int)n2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return n;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public static String convertSourceTypeToXML(int n) {
        int n2 = n;
        JoinPoint joinPoint = null;
        try {
            int sourceType;
            String string;
            String string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String string3 = string2 = (string = XMLQueryConstants.convertCodeToXML(sourceType, SOURCE_TYPE_TO_XML, SEARCH_SOURCE_TYPE_DOCBASE));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public static int convertXMLToSourceType(String string) throws DfSearchException {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            String xmlSourceType;
            int n;
            int n2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            int n3 = n2 = (n = XMLQueryConstants.convertXMLToCode(xmlSourceType, XML_TO_SOURCE_TYPE));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.intObject((int)n2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return n;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String convertCodeToXML(int n, Map map, String string) {
        int n2 = n;
        Map map2 = map;
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            String string3;
            String string4;
            int code;
            Integer key;
            void conversionMap;
            String xml;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{Conversions.intObject((int)n2), map2, string2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if ((xml = (String)conversionMap.get(key = new Integer(code))) == null) {
                void defaultXML;
                if (DfLogger.isWarnEnabled(XMLQueryConstants.class)) {
                    DfLogger.warn(XMLQueryConstants.class, DfSearchMessages.getString("UNSUPPORTED_XML_CODE", Integer.toString(code)), null, null);
                }
                xml = defaultXML;
            }
            String string5 = string4 = (string3 = xml);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{Conversions.intObject((int)n2), map2, string2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string4, joinPoint);
            }
            return string3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{Conversions.intObject((int)n2), map2, string2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static int convertXMLToCode(String string, Map map) throws DfSearchException {
        String string2 = string;
        Map map2 = map;
        JoinPoint joinPoint = null;
        try {
            int n;
            int n2;
            String xml;
            void conversionMap;
            Integer code;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, null, null, (Object)string2, (Object)map2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if ((code = (Integer)conversionMap.get(xml)) == null) {
                XMLUtil.throwXMLFormatError(xml);
            }
            int n3 = n2 = (n = code.intValue());
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.intObject((int)n2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, null, null, (Object)string2, (Object)map2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return n;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, null, null, (Object)string2, (Object)map2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private static Map initLogicalOpToXML() {
        JoinPoint joinPoint = null;
        try {
            Map map;
            Map map2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, null, null);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            HashMap<Integer, String> map3 = new HashMap<Integer, String>(5);
            map3.put(new Integer(0), EXPR_SET_LOGICAL_OP_AND);
            map3.put(new Integer(1), EXPR_SET_LOGICAL_OP_OR);
            Map map4 = map2 = (map = Collections.unmodifiableMap(map3));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, null, null);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(map2, joinPoint);
            }
            return map;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, null, null);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private static Map initDataTypesToXML() {
        JoinPoint joinPoint = null;
        try {
            Map map;
            Map map2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, null, null);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            HashMap<Integer, String> map3 = new HashMap<Integer, String>(10);
            map3.put(new Integer(2), ATTR_EXPR_DATA_TYPE_STRING);
            map3.put(new Integer(0), ATTR_EXPR_DATA_TYPE_BOOLEAN);
            map3.put(new Integer(1), ATTR_EXPR_DATA_TYPE_INTEGER);
            map3.put(new Integer(3), ATTR_EXPR_DATA_TYPE_ID);
            map3.put(new Integer(4), ATTR_EXPR_DATA_TYPE_TIME);
            map3.put(new Integer(5), ATTR_EXPR_DATA_TYPE_DOUBLE);
            Map map4 = map2 = (map = Collections.unmodifiableMap(map3));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, null, null);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(map2, joinPoint);
            }
            return map;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, null, null);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private static Map initSearchOpToXML() {
        JoinPoint joinPoint = null;
        try {
            Map map;
            Map map2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, null, null);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            HashMap<Integer, String> map3 = new HashMap<Integer, String>(20);
            map3.put(new Integer(8), ATTR_EXPR_SEARCH_OP_CONTAINS);
            map3.put(new Integer(1), ATTR_EXPR_SEARCH_OP_EQUAL);
            map3.put(new Integer(2), ATTR_EXPR_SEARCH_OP_NOT_EQUAL);
            map3.put(new Integer(3), ATTR_EXPR_SEARCH_OP_GREATER_THAN);
            map3.put(new Integer(4), ATTR_EXPR_SEARCH_OP_LESS_THAN);
            map3.put(new Integer(5), ATTR_EXPR_SEARCH_OP_GREATER_EQUAL);
            map3.put(new Integer(6), ATTR_EXPR_SEARCH_OP_LESS_EQUAL);
            map3.put(new Integer(7), ATTR_EXPR_SEARCH_OP_BEGINS_WITH);
            map3.put(new Integer(9), ATTR_EXPR_SEARCH_OP_DOES_NOT_CONTAIN);
            map3.put(new Integer(10), ATTR_EXPR_SEARCH_OP_ENDS_WITH);
            map3.put(new Integer(11), ATTR_EXPR_SEARCH_OP_IN);
            map3.put(new Integer(12), ATTR_EXPR_SEARCH_OP_NOT_IN);
            map3.put(new Integer(13), ATTR_EXPR_SEARCH_OP_BETWEEN);
            map3.put(new Integer(14), ATTR_EXPR_SEARCH_OP_IS_NULL);
            map3.put(new Integer(15), ATTR_EXPR_SEARCH_OP_IS_NOT_NULL);
            Map map4 = map2 = (map = Collections.unmodifiableMap(map3));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, null, null);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(map2, joinPoint);
            }
            return map;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, null, null);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private static Map initSourceTypeToXML() {
        JoinPoint joinPoint = null;
        try {
            Map map;
            Map map2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, null, null);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            HashMap<Integer, String> map3 = new HashMap<Integer, String>(5);
            map3.put(new Integer(1), SEARCH_SOURCE_TYPE_DOCBASE);
            map3.put(new Integer(100), SEARCH_SOURCE_TYPE_EXTERNAL);
            Map map4 = map2 = (map = Collections.unmodifiableMap(map3));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, null, null);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(map2, joinPoint);
            }
            return map;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, null, null);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private static Map reverseMap(Map map) {
        Map map2 = map;
        JoinPoint joinPoint = null;
        try {
            HashMap hashMap;
            HashMap hashMap2;
            Map map3;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, null, null, (Object)map2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            HashMap reversedMap = new HashMap(map3.size());
            Iterator entries = map3.entrySet().iterator();
            Map.Entry entry = null;
            while (entries.hasNext()) {
                entry = entries.next();
                reversedMap.put(entry.getValue(), entry.getKey());
            }
            HashMap hashMap3 = hashMap2 = (hashMap = reversedMap);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, null, null, (Object)map2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(hashMap2, joinPoint);
            }
            return hashMap;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, null, null, (Object)map2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("XMLQueryConstants.java", Class.forName("com.documentum.fc.client.search.impl.definition.XMLQueryConstants"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "convertLogicalOpToXML", "com.documentum.fc.client.search.impl.definition.XMLQueryConstants", "int:", "logicalOp:", "", "java.lang.String"), 184);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "convertXMLToLogicalOp", "com.documentum.fc.client.search.impl.definition.XMLQueryConstants", "java.lang.String:", "xmlLogOp:", "com.documentum.fc.client.search.DfSearchException:", "int"), 192);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "initLogicalOpToXML", "com.documentum.fc.client.search.impl.definition.XMLQueryConstants", "", "", "", "java.util.Map"), 295);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "initDataTypesToXML", "com.documentum.fc.client.search.impl.definition.XMLQueryConstants", "", "", "", "java.util.Map"), 308);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "initSearchOpToXML", "com.documentum.fc.client.search.impl.definition.XMLQueryConstants", "", "", "", "java.util.Map"), 325);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "initSourceTypeToXML", "com.documentum.fc.client.search.impl.definition.XMLQueryConstants", "", "", "", "java.util.Map"), 351);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "reverseMap", "com.documentum.fc.client.search.impl.definition.XMLQueryConstants", "java.util.Map:", "map:", "", "java.util.Map"), 362);
        ajc$tjp_15 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.documentum.fc.client.search.impl.definition.XMLQueryConstants", "", "", ""), 31);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "convertDataTypeToXML", "com.documentum.fc.client.search.impl.definition.XMLQueryConstants", "int:", "dataType:", "", "java.lang.String"), 200);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "convertXMLToDataType", "com.documentum.fc.client.search.impl.definition.XMLQueryConstants", "java.lang.String:", "xmlDataType:", "com.documentum.fc.client.search.DfSearchException:", "int"), 208);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "convertSearchOpToXML", "com.documentum.fc.client.search.impl.definition.XMLQueryConstants", "int:", "searchOp:", "", "java.lang.String"), 216);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "convertXMLToSearchOp", "com.documentum.fc.client.search.impl.definition.XMLQueryConstants", "java.lang.String:", "xmlSearchOp:", "com.documentum.fc.client.search.DfSearchException:", "int"), 224);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "convertSourceTypeToXML", "com.documentum.fc.client.search.impl.definition.XMLQueryConstants", "int:", "sourceType:", "", "java.lang.String"), 232);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "convertXMLToSourceType", "com.documentum.fc.client.search.impl.definition.XMLQueryConstants", "java.lang.String:", "xmlSourceType:", "com.documentum.fc.client.search.DfSearchException:", "int"), 240);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "convertCodeToXML", "com.documentum.fc.client.search.impl.definition.XMLQueryConstants", "int:java.util.Map:java.lang.String:", "code:conversionMap:defaultXML:", "", "java.lang.String"), 257);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "convertXMLToCode", "com.documentum.fc.client.search.impl.definition.XMLQueryConstants", "java.lang.String:java.util.Map:", "xml:conversionMap:", "com.documentum.fc.client.search.DfSearchException:", "int"), 280);
        LOGICAL_OP_TO_XML = XMLQueryConstants.initLogicalOpToXML();
        XML_TO_LOGICAL_OP = XMLQueryConstants.reverseMap(LOGICAL_OP_TO_XML);
        DATA_TYPE_TO_XML = XMLQueryConstants.initDataTypesToXML();
        XML_TO_DATA_TYPE = XMLQueryConstants.reverseMap(DATA_TYPE_TO_XML);
        SEARCH_OP_TO_XML = XMLQueryConstants.initSearchOpToXML();
        XML_TO_SEARCH_OP = XMLQueryConstants.reverseMap(SEARCH_OP_TO_XML);
        SOURCE_TYPE_TO_XML = XMLQueryConstants.initSourceTypeToXML();
        XML_TO_SOURCE_TYPE = XMLQueryConstants.reverseMap(SOURCE_TYPE_TO_XML);
    }
}

