/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.util;

import com.documentum.fc.client.DfDeadlockException;
import com.documentum.fc.client.impl.session.ISession;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfPreferences;
import com.documentum.fc.impl.util.Functor;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class TransactionalFunctorWithRetry
extends Functor {
    private static final int MAXIMUM_DEADLOCK_RETRIES = 10;
    private ISession m_session;
    private Functor m_functor;
    private boolean m_flushServerCacheOnRetry;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public TransactionalFunctorWithRetry(ISession session, Functor functor, boolean flushServerCacheOnRetry) {
        ISession iSession = session;
        Functor functor2 = functor;
        boolean bl = flushServerCacheOnRetry;
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iSession, functor2, Conversions.booleanObject((boolean)bl)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_session = session;
            this.m_functor = functor;
            this.m_flushServerCacheOnRetry = flushServerCacheOnRetry;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iSession, functor2, Conversions.booleanObject((boolean)bl)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iSession, functor2, Conversions.booleanObject((boolean)bl)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public Object evaluate() throws DfException {
        return this.evaluateUnderTransactionWithDeadlockRetry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Object evaluateUnderTransactionWithDeadlockRetry() throws DfException {
        JoinPoint joinPoint = null;
        try {
            Object object;
            Object object2;
            block23: {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                int numberOfDeadlockRetries = 0;
                while (true) {
                    InternalTransaction internalTransaction = this.beginInternallTransactionIfNecessary();
                    try {
                        Object result = this.m_functor.evaluate();
                        if (internalTransaction != null) {
                            internalTransaction.commit();
                            internalTransaction.disconnect();
                            internalTransaction = null;
                        }
                        Object object3 = result;
                        object2 = object3;
                        break block23;
                    }
                    catch (DfDeadlockException e) {
                        if (this.m_flushServerCacheOnRetry) {
                            this.m_session.getDocbaseApi().sysObjFlushCache(true, null);
                        }
                        if (internalTransaction != null && numberOfDeadlockRetries < DfPreferences.getInstance().getSessionMaxDeadlockRetries()) {
                            ++numberOfDeadlockRetries;
                        } else {
                            throw e;
                        }
                        internalTransaction.abortForDeadlockRetry();
                        internalTransaction.disconnect();
                        internalTransaction = null;
                        continue;
                    }
                    finally {
                        if (internalTransaction == null) continue;
                        internalTransaction.abortWithoutException();
                        internalTransaction.disconnect();
                        internalTransaction = null;
                        continue;
                    }
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    break;
                }
                finally {
                    if (numberOfDeadlockRetries > 0) {
                        this.m_session.addMessage(0, "DM_SESSION_I_DEADLOCK_RETRY", null);
                    }
                }
            }
            Object object4 = object = object2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return object2;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private InternalTransaction beginInternallTransactionIfNecessary() throws DfException {
        JoinPoint joinPoint = null;
        try {
            InternalTransaction internalTransaction;
            InternalTransaction internalTransaction2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            InternalTransaction internalTransaction3 = internalTransaction2 = !this.m_session.isTransactionActive() ? (internalTransaction = new InternalTransaction(this.m_session)) : (internalTransaction = null);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(internalTransaction2, joinPoint);
            }
            return internalTransaction;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("TransactionalFunctorWithRetry.java", Class.forName("com.documentum.fc.client.impl.util.TransactionalFunctorWithRetry"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "evaluateUnderTransactionWithDeadlockRetry", "com.documentum.fc.client.impl.util.TransactionalFunctorWithRetry", "", "", "com.documentum.fc.common.DfException:", "java.lang.Object"), 30);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "beginInternallTransactionIfNecessary", "com.documentum.fc.client.impl.util.TransactionalFunctorWithRetry", "", "", "com.documentum.fc.common.DfException:", "com.documentum.fc.client.impl.util.TransactionalFunctorWithRetry$InternalTransaction"), 85);
        ajc$tjp_2 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.documentum.fc.client.impl.util.TransactionalFunctorWithRetry", "com.documentum.fc.client.impl.session.ISession:com.documentum.fc.impl.util.Functor:boolean:", "session:functor:flushServerCacheOnRetry:", ""), 18);
    }

    private class InternalTransaction {
        private final ISession m_session;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

        InternalTransaction(ISession s) throws DfException {
            this.m_session = s.newStrongHandle();
            try {
                this.m_session.beginTrans();
            }
            catch (DfException dfe) {
                this.m_session.disconnect();
                throw dfe;
            }
            catch (RuntimeException re) {
                this.m_session.disconnect();
                throw re;
            }
        }

        void commit() throws DfException {
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                this.m_session.commitTrans();
                Object var2_2 = null;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var2_2, joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        void disconnect() {
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                this.m_session.disconnect();
                Object var2_2 = null;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var2_2, joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        void abortWithoutException() throws DfException {
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                this.m_session.abortTransWithoutException();
                Object var2_2 = null;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var2_2, joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        void abortForDeadlockRetry() throws DfException {
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                if (this.m_session.isTransactionActive()) {
                    this.m_session.abortTransForDeadlockRetry();
                }
                Object var2_2 = null;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var2_2, joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        static {
            Factory factory = new Factory("TransactionalFunctorWithRetry.java", Class.forName("com.documentum.fc.client.impl.util.TransactionalFunctorWithRetry$InternalTransaction"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "commit", "com.documentum.fc.client.impl.util.TransactionalFunctorWithRetry$InternalTransaction", "", "", "com.documentum.fc.common.DfException:", "void"), 113);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "disconnect", "com.documentum.fc.client.impl.util.TransactionalFunctorWithRetry$InternalTransaction", "", "", "", "void"), 118);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "abortWithoutException", "com.documentum.fc.client.impl.util.TransactionalFunctorWithRetry$InternalTransaction", "", "", "com.documentum.fc.common.DfException:", "void"), 123);
            ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "abortForDeadlockRetry", "com.documentum.fc.client.impl.util.TransactionalFunctorWithRetry$InternalTransaction", "", "", "com.documentum.fc.common.DfException:", "void"), 130);
        }
    }
}

