/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.typeddata;

import com.documentum.fc.client.impl.typeddata.AbstractTypedData;
import com.documentum.fc.client.impl.typeddata.Attribute;
import com.documentum.fc.client.impl.typeddata.DataConverter;
import com.documentum.fc.client.impl.typeddata.ILiteType;
import com.documentum.fc.client.impl.typeddata.ITypedData;
import com.documentum.fc.client.impl.typeddata.MissingValueException;
import com.documentum.fc.client.impl.typeddata.NoSuchAttributeException;
import com.documentum.fc.client.impl.typeddata.ValueHolder;
import com.documentum.fc.client.impl.typeddata.ValueIndexException;
import com.documentum.fc.common.IDfId;
import com.documentum.fc.common.IDfTime;
import com.documentum.fc.tracing.ITraceString;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedData
extends AbstractTypedData
implements ITypedData,
ITraceString,
Externalizable,
Cloneable {
    private List<ValueHolder> m_valueHolders;
    private static final long serialVersionUID = 5978699260696491993L;

    public TypedData() {
        this(null, null);
    }

    public TypedData(ILiteType type) {
        this(type, null);
    }

    public TypedData(ILiteType type, IDfId id) {
        super(type, id);
        this.createValueHolderSlots();
    }

    @Override
    public void setType(ILiteType type) {
        super.setType(type);
        this.createValueHolderSlots();
    }

    private void createValueHolderSlots() {
        if (this.m_valueHolders == null) {
            this.m_valueHolders = new ArrayList<ValueHolder>(this.getAttrCount());
        }
        int limit = this.getAttrCount();
        for (int i = this.m_valueHolders.size(); i < limit; ++i) {
            this.m_valueHolders.add(null);
        }
    }

    @Override
    public void addAttr(Attribute attribute) {
        super.addAttr(attribute);
        this.m_valueHolders.add(null);
    }

    @Override
    public synchronized Object clone() {
        TypedData copy = (TypedData)super.clone();
        copy.m_valueHolders = this.cloneValueHolders();
        return copy;
    }

    private List<ValueHolder> cloneValueHolders() {
        int count = this.getAttrCount();
        ArrayList<ValueHolder> copy = new ArrayList<ValueHolder>(count);
        for (int i = 0; i < count; ++i) {
            ValueHolder holder = this.m_valueHolders.get(i);
            copy.add(holder == null ? null : new ValueHolder(holder));
        }
        return copy;
    }

    @Override
    public final int getValueCount(int index) {
        if (this.isRepeating(index)) {
            return this.getValueHolder(index).getList().size();
        }
        return 1;
    }

    private ValueHolder getValueHolder(int index) throws MissingValueException {
        return this.getValueHolder(index, this.isAutoFill(), true);
    }

    private ValueHolder getValueHolder(int index, boolean createIfMissing, boolean exceptionIfMissing) throws MissingValueException {
        if (index >= this.m_valueHolders.size()) {
            throw new NoSuchAttributeException(index);
        }
        ValueHolder valueHolder = this.m_valueHolders.get(index);
        if (valueHolder == null) {
            if (createIfMissing) {
                valueHolder = new ValueHolder();
                this.m_valueHolders.set(index, valueHolder);
            } else if (exceptionIfMissing) {
                throw new MissingValueException(this.getAttrName(index));
            }
        }
        return valueHolder;
    }

    @Override
    public final String get(int index) {
        Attribute attribute = this.getType().getAttr(index);
        if (!attribute.isRepeating()) {
            String value = this.getValueHolder(index).getString();
            if (value == null) {
                return this.getDefaultValue(attribute);
            }
            return value;
        }
        return this.getRepeating(index, 0);
    }

    private String getDefaultValue(Attribute attribute) {
        switch (attribute.getDataType()) {
            case 0: {
                return DataConverter.convertToString(false);
            }
            case 1: 
            case 5: {
                return DataConverter.convertToString(0);
            }
            case 3: {
                return DataConverter.convertToString((IDfId)null);
            }
            case 4: {
                return DataConverter.convertToString((IDfTime)null);
            }
        }
        return DataConverter.convertToString((String)null);
    }

    @Override
    public final String getRepeating(int index, int valueIndex) {
        if (this.isRepeating(index)) {
            List<String> values = this.getValueHolder(index).getList();
            if (values.size() > valueIndex && valueIndex >= 0) {
                return values.get(valueIndex);
            }
            throw new ValueIndexException(this.getAttrName(index), valueIndex, values.size() - 1);
        }
        if (valueIndex == 0) {
            return this.get(index);
        }
        throw new ValueIndexException(this.getAttrName(index), valueIndex, 0);
    }

    @Override
    public final void set(int index, String value) {
        if (!this.isRepeating(index)) {
            this.verifyWritability();
            ValueHolder valueHolder = this.getValueHolder(index, true, true);
            valueHolder.setString(value);
            valueHolder.setModified(true);
        } else {
            this.setRepeating(index, 0, value);
        }
    }

    @Override
    public void setRepeating(int index, int valueIndex, String value) {
        if (this.isRepeating(index)) {
            this.verifyWritability();
            ValueHolder valueHolder = this.getValueHolder(index);
            List<String> values = valueHolder.getList();
            if (values.size() > valueIndex && valueIndex >= 0) {
                values.set(valueIndex, value);
            } else if (values.size() == valueIndex) {
                values.add(value);
            } else {
                throw new ValueIndexException(this.getAttrName(index), valueIndex, values.size() - 1);
            }
            valueHolder.addModifiedIndex(valueIndex);
        } else if (valueIndex == 0) {
            this.set(index, value);
        } else {
            throw new ValueIndexException(this.getAttrName(index), valueIndex, 0);
        }
    }

    @Override
    public void append(int index, String value) {
        this.verifyWritability();
        this.verifyIsRepeating(index, 1);
        ValueHolder valueHolder = this.getValueHolder(index);
        List<String> valueList = valueHolder.getList();
        valueHolder.addModifiedIndex(valueList.size());
        valueList.add(value);
    }

    private void verifyIsRepeating(int index, int valueIndex) {
        if (!this.isRepeating(index)) {
            throw new ValueIndexException(this.getAttrName(index), valueIndex, 0);
        }
    }

    @Override
    public void insert(int index, int valueIndex, String value) {
        this.verifyWritability();
        this.verifyIsRepeating(index, valueIndex);
        ValueHolder valueHolder = this.getValueHolder(index);
        List<String> valueList = valueHolder.getList();
        int size = valueList.size();
        if (valueIndex >= size) {
            valueList.add(value);
            valueHolder.addModifiedIndex(size);
        } else {
            int i;
            ArrayList<String> newValueList = new ArrayList<String>();
            for (i = 0; i < valueIndex; ++i) {
                newValueList.add(valueList.get(i));
            }
            newValueList.add(value);
            valueHolder.addModifiedIndex(valueIndex);
            for (i = valueIndex; i < size; ++i) {
                newValueList.add(valueList.get(i));
                valueHolder.addModifiedIndex(i + 1);
            }
            valueHolder.setList(newValueList);
        }
    }

    @Override
    public int find(int index, String value) {
        if (this.isRepeating(index)) {
            return this.getValueHolder(index).getList().indexOf(value);
        }
        if (value.equals(this.getValueHolder(index).getString())) {
            return 0;
        }
        return -1;
    }

    @Override
    public void remove(int index, int valueIndex) {
        this.verifyWritability();
        this.verifyIsRepeating(index, valueIndex);
        ValueHolder valueHolder = this.getValueHolder(index);
        List<String> valueList = valueHolder.getList();
        int size = valueList.size();
        if (valueIndex >= 0 && valueIndex < size) {
            valueList.remove(valueIndex);
            int limit = size - 1;
            for (int i = valueIndex; i < limit; ++i) {
                valueHolder.addModifiedIndex(i);
            }
            valueHolder.removeModifiedIndex(size - 1);
            valueHolder.setModified(true);
        }
    }

    @Override
    public void removeAll(int index) {
        this.verifyWritability();
        this.verifyIsRepeating(index, 0);
        ValueHolder valueHolder = this.getValueHolder(index);
        valueHolder.getList().clear();
        valueHolder.removeAllModifiedIndexes();
        valueHolder.setModified(true);
    }

    @Override
    public final boolean isMissing(int index) {
        return this.getValueHolder(index, this.isAutoFill(), false) == null;
    }

    @Override
    public final boolean isModified(int index) {
        ValueHolder valueHolder = this.getValueHolder(index, false, false);
        if (valueHolder != null) {
            return valueHolder.isModified();
        }
        return false;
    }

    @Override
    public final void setModified(int index, boolean modified) {
        this.getValueHolder(index).setModified(modified, true);
    }

    @Override
    public List<Integer> getModifiedIndexes(int index) {
        ValueHolder valueHolder = this.getValueHolder(index, false, false);
        if (valueHolder != null) {
            return valueHolder.getModifiedIndexes();
        }
        return new ArrayList<Integer>();
    }

    @Override
    public final boolean isValidated(int index) {
        try {
            return this.getValueHolder(index).isValidated();
        }
        catch (MissingValueException e) {
            return false;
        }
    }

    @Override
    public final void setValidated(int index, boolean validated) {
        this.getValueHolder(index).setValidated(validated);
    }

    @Override
    public final boolean isModifiedButNotValidated(int index) {
        ValueHolder holder = this.getValueHolder(index);
        return holder.isModified() && !holder.isValidated();
    }

    @Override
    protected String getTraceStringDetails(boolean verbose) {
        StringBuilder sb = new StringBuilder(super.getTraceStringDetails(verbose));
        if (verbose) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append("values=[");
            int limit = this.getAttrCount();
            for (int i = 0; i < limit; ++i) {
                Object value;
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.getAttrName(i));
                sb.append("=");
                ValueHolder vh = this.getValueHolder(i, false, false);
                if (vh == null) continue;
                Object object = value = this.isRepeating(i) ? vh.getList() : vh.getString();
                if (value == null) continue;
                if (this.getAttrName(i).toLowerCase().contains("password")) {
                    sb.append("******");
                    continue;
                }
                sb.append(value);
            }
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    protected boolean equals(ITypedData that, int thisIndex, int thatIndex) {
        if (!(that instanceof TypedData)) {
            return super.equals(that, thisIndex, thatIndex);
        }
        ValueHolder thisHolder = this.getValueHolder(thisIndex, false, false);
        ValueHolder thatHolder = ((TypedData)that).getValueHolder(thatIndex, false, false);
        if (thisHolder == null || thatHolder == null) {
            return thisHolder == null && thatHolder == null;
        }
        return thisHolder.equals(thatHolder);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.m_valueHolders = (List)objectInput.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.m_valueHolders);
    }
}

