/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.typeddata;

import com.documentum.fc.client.impl.typeddata.Attribute;
import com.documentum.fc.client.impl.typeddata.ILiteType;
import com.documentum.fc.client.impl.typeddata.NoSuchAttributeException;
import com.documentum.fc.impl.util.StringUtil;
import com.documentum.fc.tracing.ITraceString;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LiteType
implements ILiteType,
ITraceString,
Externalizable,
Cloneable {
    private String m_name;
    private int m_vStamp;
    private int m_version;
    private int m_cacheVStamp;
    private String m_declaredParentTypeName;
    private String m_aspectName;
    private boolean m_aspectDataShareable;
    private ILiteType m_superType;
    private int m_superTypeAttributeCount;
    private List<Attribute> m_attributes;
    private Map<String, Attribute> m_attributeNameMap;
    private Map<String, Attribute> m_attributeIdMap;
    private boolean m_readOnly;
    private static final long serialVersionUID = 8066148690234779558L;

    public LiteType() {
        this(null, null);
    }

    public LiteType(String name) {
        this(name, null);
    }

    public LiteType(String name, ILiteType superType) {
        this.m_name = StringUtil.nullToEmpty(name);
        this.m_attributes = new ArrayList<Attribute>();
        this.m_attributeNameMap = new HashMap<String, Attribute>();
        this.m_attributeIdMap = new HashMap<String, Attribute>();
        this.m_superType = superType;
        if (this.m_superType != null) {
            this.m_superType.setReadOnly(true);
            this.m_superTypeAttributeCount = this.m_superType.getAttrCount();
            this.m_declaredParentTypeName = this.m_superType.getDeclaredParentTypeName();
        }
    }

    public void copyTypeInfoFrom(ILiteType srcType) {
        this.m_aspectName = srcType.getAspectName();
        this.m_aspectDataShareable = srcType.isAspectDataShareable();
        this.m_vStamp = srcType.getVStamp();
        this.m_declaredParentTypeName = srcType.getDeclaredParentTypeName();
        int attrCount = srcType.getAttrCount();
        for (int i = 0; i < attrCount; ++i) {
            this.addAttr(new Attribute(srcType.getAttr(i)));
        }
        this.m_readOnly = srcType.isReadOnly();
    }

    public final String getName() {
        return this.m_name;
    }

    public String getDeclaredParentTypeName() {
        return this.m_declaredParentTypeName;
    }

    public void setDeclaredParentTypeName(String parentTypeName) {
        this.m_declaredParentTypeName = parentTypeName;
    }

    public int getVStamp() {
        return this.m_vStamp;
    }

    public int getVersion() {
        return this.m_version;
    }

    public int getCacheVStamp() {
        return this.m_cacheVStamp;
    }

    public void setVersionInfo(int vStamp, int version, int cacheVStamp) {
        this.m_vStamp = vStamp;
        this.m_version = version;
        this.m_cacheVStamp = cacheVStamp;
    }

    public boolean isLightObjectType() {
        return false;
    }

    public final ILiteType getSuperType() {
        return this.m_superType;
    }

    public ILiteType getUnextendedType() {
        return this;
    }

    public final boolean isTypeOf(String typeName) {
        return this.m_name.equals(typeName) || this.isSubTypeOf(typeName);
    }

    public final boolean isSubTypeOf(String typeName) {
        return this.m_superType != null && this.m_superType.isTypeOf(typeName);
    }

    public final boolean hasAttr(String name) {
        if (name == null) {
            return false;
        }
        if (this.m_superType != null && this.m_superType.hasAttr(name)) {
            return true;
        }
        return this.m_attributeNameMap.get(name) != null;
    }

    public final boolean isSuperTypeAttribute(String name) {
        return this.m_attributeNameMap.get(name) == null;
    }

    public final int getAttrCount() {
        return this.m_superTypeAttributeCount + this.m_attributes.size();
    }

    public final Attribute getAttr(String name) {
        Attribute attribute = this.getAttrIfPresent(name);
        if (attribute == null) {
            throw new NoSuchAttributeException(name);
        }
        return attribute;
    }

    public Attribute getAttrById(String id) throws NoSuchAttributeException {
        Attribute attribute = this.getAttrByIdIfPresent(id);
        if (attribute == null) {
            throw new NoSuchAttributeException(id);
        }
        return attribute;
    }

    public final Attribute getAttr(int index) throws NoSuchAttributeException {
        if (index < this.m_superTypeAttributeCount) {
            return this.m_superType.getAttr(index);
        }
        int relativeIndex = index - this.m_superTypeAttributeCount;
        if (relativeIndex >= this.m_attributes.size()) {
            throw new NoSuchAttributeException(Integer.toString(index));
        }
        return this.m_attributes.get(relativeIndex);
    }

    public final Attribute getAttrIfPresent(String name) {
        Attribute attribute;
        if (this.m_superType != null && (attribute = this.m_superType.getAttrIfPresent(name)) != null) {
            return attribute;
        }
        return this.m_attributeNameMap.get(name);
    }

    public final Attribute getAttrByIdIfPresent(String id) {
        Attribute attribute;
        if (this.m_superType != null && (attribute = this.m_superType.getAttrByIdIfPresent(id)) != null) {
            return attribute;
        }
        return this.m_attributeIdMap.get(id);
    }

    public int getAttrIndex(String name) throws NoSuchAttributeException {
        return this.getAttr(name).getIndex();
    }

    public String getAttrName(int index) throws NoSuchAttributeException {
        return this.getAttr(index).getName();
    }

    public final void addAttr(Attribute attribute) {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("type can not be modified");
        }
        if (this.hasAttr(attribute.getName())) {
            throw new IllegalStateException("attribute '" + attribute.getName() + "' already exists");
        }
        attribute.setIndex(this.m_superTypeAttributeCount + this.m_attributes.size());
        this.addAttrInternal(attribute);
    }

    private void addAttrInternal(Attribute attribute) {
        this.m_attributes.add(attribute);
        this.m_attributeNameMap.put(attribute.getName(), attribute);
        if (!StringUtil.isEmptyOrNull(attribute.getId())) {
            this.m_attributeIdMap.put(attribute.getId(), attribute);
        }
    }

    public final boolean isReadOnly() {
        return this.m_readOnly;
    }

    public final void setReadOnly(boolean readOnly) {
        this.m_readOnly = readOnly;
    }

    public String toString() {
        return this.toTraceString(true);
    }

    public String toTraceString(boolean verbose) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(this.getTraceInstanceId());
        String details = this.getTraceStringDetails(verbose);
        if (details.length() > 0) {
            sb.append('{').append(details).append('}');
        }
        return sb.toString();
    }

    public String getTraceInstanceId() {
        StringBuilder sb = new StringBuilder(64);
        String fullName = this.getClass().getName();
        sb.append(fullName.substring(fullName.lastIndexOf(46) + 1));
        sb.append('@');
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        return sb.toString();
    }

    protected String getTraceStringDetails(boolean verbose) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("name=").append(this.m_name);
        if (verbose) {
            sb.append(", typeVersion=").append(this.m_vStamp);
            sb.append(", cacheVStamp=").append(this.m_cacheVStamp);
            sb.append(", attributes={");
            int limit = this.getAttrCount();
            for (int i = this.m_superTypeAttributeCount; i < limit; ++i) {
                if (i > this.m_superTypeAttributeCount) {
                    sb.append(", ");
                }
                sb.append(this.getAttr(i).getName());
            }
            sb.append('}');
        }
        if (this.m_superType != null) {
            sb.append(", superType=").append(this.m_superType);
        }
        return sb.toString();
    }

    public Object clone() {
        try {
            LiteType copy = (LiteType)super.clone();
            copy.m_declaredParentTypeName = this.m_declaredParentTypeName;
            copy.m_aspectName = this.m_aspectName;
            copy.m_aspectDataShareable = this.m_aspectDataShareable;
            copy.m_attributes = new ArrayList<Attribute>();
            copy.m_attributeNameMap = new HashMap<String, Attribute>();
            copy.m_attributeIdMap = new HashMap<String, Attribute>();
            int limit = this.m_attributes.size();
            for (int i = 0; i < limit; ++i) {
                copy.addAttrInternal(new Attribute(this.m_attributes.get(i)));
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("This should not happen since clone is implemented");
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof LiteType)) {
            return false;
        }
        LiteType that = (LiteType)o;
        if (!this.m_name.equals(that.m_name)) {
            return false;
        }
        if (this.m_version != that.m_version) {
            return false;
        }
        if (this.m_cacheVStamp != that.m_cacheVStamp) {
            return false;
        }
        if (!((Object)this.m_attributes).equals(that.m_attributes)) {
            return false;
        }
        if (this.m_declaredParentTypeName != null ? !this.m_declaredParentTypeName.equals(that.m_declaredParentTypeName) : that.m_declaredParentTypeName != null) {
            return false;
        }
        if (this.m_aspectName != null ? !this.m_aspectName.equals(that.m_aspectName) : that.m_aspectName != null) {
            return false;
        }
        if (this.m_aspectDataShareable != that.m_aspectDataShareable) {
            return false;
        }
        return !(this.m_superType == null ? that.m_superType != null : !this.m_superType.equals(that.m_superType));
    }

    public int hashCode() {
        int result = 45;
        result = 37 * result + this.m_name.hashCode();
        result = 37 * result + this.m_vStamp;
        result = 37 * result + ((Object)this.m_attributes).hashCode();
        result = 37 * result + (this.m_superType != null ? this.m_superType.hashCode() : 0);
        result = 37 * result + (this.m_declaredParentTypeName != null ? this.m_declaredParentTypeName.hashCode() : 0);
        result = 37 * result + (this.m_aspectName != null ? this.m_aspectName.hashCode() : 0);
        result = 37 * result + (this.m_aspectDataShareable ? 1 : 0);
        return result;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Attribute[] attributes;
        for (Attribute attribute : attributes = (Attribute[])objectInput.readObject()) {
            this.addAttrInternal(attribute);
        }
        this.m_name = (String)objectInput.readObject();
        this.m_vStamp = (Integer)objectInput.readObject();
        this.m_superType = (ILiteType)objectInput.readObject();
        this.m_superTypeAttributeCount = this.m_superType != null ? this.m_superType.getAttrCount() : 0;
        this.m_declaredParentTypeName = (String)objectInput.readObject();
        this.m_aspectName = (String)objectInput.readObject();
        this.m_aspectDataShareable = (Boolean)objectInput.readObject();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.m_attributes.toArray(new Attribute[0]));
        objectOutput.writeObject(this.m_name);
        objectOutput.writeObject(this.m_vStamp);
        objectOutput.writeObject(this.m_superType);
        objectOutput.writeObject(this.m_declaredParentTypeName);
        objectOutput.writeObject(this.m_aspectName);
        objectOutput.writeObject(this.m_aspectDataShareable);
    }

    public void setAspectName(String aspectName) {
        this.m_aspectName = aspectName;
    }

    public String getAspectName() {
        return this.m_aspectName;
    }

    public boolean isAspectAttrDefType() {
        return !StringUtil.isEmptyOrNull(this.m_aspectName);
    }

    public void setAspectDataShareable(boolean aspectDataShareable) {
        this.m_aspectDataShareable = aspectDataShareable;
    }

    public boolean isAspectDataShareable() {
        return this.m_aspectDataShareable;
    }
}

