/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.typeddata;

import com.documentum.fc.client.impl.typeddata.Attribute;
import com.documentum.fc.client.impl.typeddata.ITypedData;
import com.documentum.fc.client.impl.typeddata.TypedData;
import com.documentum.fc.client.impl.typeddata.ValueIndexException;
import com.documentum.fc.common.IDfId;
import com.documentum.fc.common.IDfTime;
import java.io.Externalizable;

public final class DynamicallyTypedData
extends TypedData
implements Externalizable {
    static final long serialVersionUID = 986915263054328371L;

    public void appendBoolean(String name, boolean value) throws ValueIndexException {
        this.addAttrIfNecessary(name, true, 0, 0);
        super.appendBoolean(name, value);
    }

    public void appendDouble(String name, double value) throws ValueIndexException {
        this.addAttrIfNecessary(name, true, 5, 0);
        super.appendDouble(name, value);
    }

    public void appendId(String name, IDfId value) throws ValueIndexException {
        this.addAttrIfNecessary(name, true, 3, 0);
        super.appendId(name, value);
    }

    public void appendInt(String name, int value) throws ValueIndexException {
        this.addAttrIfNecessary(name, true, 1, 0);
        super.appendInt(name, value);
    }

    public void appendLong(String name, long value) throws ValueIndexException {
        this.addAttrIfNecessary(name, true, 5, 0);
        super.appendLong(name, value);
    }

    public void appendString(String name, String value) throws ValueIndexException {
        this.addAttrIfNecessary(name, true, 2, 0);
        super.appendString(name, value);
    }

    public void appendTime(String name, IDfTime value) throws ValueIndexException {
        this.addAttrIfNecessary(name, true, 4, 0);
        super.appendTime(name, value);
    }

    public void insertBoolean(String name, int valueIndex, boolean value) throws ValueIndexException {
        this.addAttrIfNecessary(name, true, 0, 0);
        super.insertBoolean(name, valueIndex, value);
    }

    public void insertDouble(String name, int valueIndex, double value) throws ValueIndexException {
        this.addAttrIfNecessary(name, true, 5, 0);
        super.insertDouble(name, valueIndex, value);
    }

    public void insertId(String name, int valueIndex, IDfId value) throws ValueIndexException {
        this.addAttrIfNecessary(name, true, 3, 0);
        super.insertId(name, valueIndex, value);
    }

    public void insertInt(String name, int valueIndex, int value) throws ValueIndexException {
        this.addAttrIfNecessary(name, true, 1, 0);
        super.insertInt(name, valueIndex, value);
    }

    public void insertLong(String name, int valueIndex, long value) throws ValueIndexException {
        this.addAttrIfNecessary(name, true, 5, 0);
        super.insertLong(name, valueIndex, value);
    }

    public void insertString(String name, int valueIndex, String value) throws ValueIndexException {
        this.addAttrIfNecessary(name, true, 2, 0);
        super.insertString(name, valueIndex, value);
    }

    public void insertTime(String name, int valueIndex, IDfTime value) throws ValueIndexException {
        this.addAttrIfNecessary(name, true, 4, 0);
        super.insertTime(name, valueIndex, value);
    }

    public final void setBoolean(String name, boolean value) {
        this.addAttrIfNecessary(name, false, 0, 0);
        super.setBoolean(name, value);
    }

    public final void setDouble(String name, double value) {
        this.addAttrIfNecessary(name, false, 5, 0);
        super.setDouble(name, value);
    }

    public final void setId(String name, IDfId value) {
        this.addAttrIfNecessary(name, false, 3, 0);
        super.setId(name, value);
    }

    public final void setInt(String name, int value) {
        this.addAttrIfNecessary(name, false, 1, 0);
        super.setInt(name, value);
    }

    public final void setLong(String name, long value) {
        this.addAttrIfNecessary(name, false, 5, 0);
        super.setLong(name, value);
    }

    public final void setRepeatingBoolean(String name, int valueIndex, boolean value) throws ValueIndexException {
        this.addAttrIfNecessary(name, true, 0, 0);
        super.setRepeatingBoolean(name, valueIndex, value);
    }

    public final void setRepeatingDouble(String name, int valueIndex, double value) throws ValueIndexException {
        this.addAttrIfNecessary(name, true, 5, 0);
        super.setRepeatingDouble(name, valueIndex, value);
    }

    public final void setRepeatingId(String name, int valueIndex, IDfId value) throws ValueIndexException {
        this.addAttrIfNecessary(name, true, 3, 0);
        super.setRepeatingId(name, valueIndex, value);
    }

    public final void setRepeatingInt(String name, int valueIndex, int value) throws ValueIndexException {
        this.addAttrIfNecessary(name, true, 1, 0);
        super.setRepeatingInt(name, valueIndex, value);
    }

    public final void setRepeatingLong(String name, int valueIndex, long value) throws ValueIndexException {
        this.addAttrIfNecessary(name, true, 5, 0);
        super.setRepeatingLong(name, valueIndex, value);
    }

    public void setRepeatingString(String name, int valueIndex, String value) throws ValueIndexException {
        this.addAttrIfNecessary(name, true, 2, 0);
        super.setRepeatingString(name, valueIndex, value);
    }

    public final void setRepeatingTime(String name, int valueIndex, IDfTime value) throws ValueIndexException {
        this.addAttrIfNecessary(name, true, 4, 0);
        super.setRepeatingTime(name, valueIndex, value);
    }

    public void setString(String name, String value) {
        this.addAttrIfNecessary(name, false, 2, 0);
        super.setString(name, value);
    }

    public final void setTime(String name, IDfTime value) {
        this.addAttrIfNecessary(name, false, 4, 0);
        super.setTime(name, value);
    }

    public void addValuesFrom(ITypedData from) {
        int limit = from.getAttrCount();
        for (int fIx = 0; fIx < limit; ++fIx) {
            Attribute a = from.getType().getAttr(fIx);
            this.addAttr(a.getName(), a.isRepeating(), a.getDataType(), a.getLength());
            int toIx = this.getType().getAttr(a.getName()).getIndex();
            if (a.isRepeating()) {
                int limit1 = from.getValueCount(fIx);
                for (int vIx = 0; vIx < limit1; ++vIx) {
                    this.setRepeating(toIx, vIx, from.getRepeating(fIx, vIx));
                }
                continue;
            }
            this.set(toIx, from.get(fIx));
        }
    }

    private synchronized void addAttrIfNecessary(String name, boolean isRepeating, int dataType, int length) {
        if (!this.hasAttr(name)) {
            this.addAttr(name, isRepeating, dataType, length);
        }
    }
}

