/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.typeddata;

import com.documentum.fc.client.impl.util.LenientDmclDateFormat;
import com.documentum.fc.common.DfId;
import com.documentum.fc.common.DfTime;
import com.documentum.fc.common.IDfId;
import com.documentum.fc.common.IDfTime;
import com.documentum.fc.impl.util.StringUtil;
import java.util.Date;

public class DataConverter {
    public static boolean convertToBoolean(String value) {
        if (StringUtil.isEmptyOrNull(value)) {
            return false;
        }
        if (value.equalsIgnoreCase("t") || value.equalsIgnoreCase("1")) {
            return true;
        }
        if (value.equalsIgnoreCase("f") || value.equalsIgnoreCase("0")) {
            return false;
        }
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("on") || value.equalsIgnoreCase("yes")) {
            return true;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("off") || value.equalsIgnoreCase("no")) {
            return false;
        }
        try {
            return Integer.parseInt(value) != 0;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("invalid boolean string - " + value);
        }
    }

    public static int convertToInt(String value) {
        if (value != null && value.length() > 0) {
            if (value.indexOf(46) >= 0) {
                Double doubleValue = new Double(value);
                int intValue = doubleValue.intValue();
                if ((double)intValue != doubleValue) {
                    throw new NumberFormatException(value);
                }
                return intValue;
            }
            return Integer.parseInt(value.trim());
        }
        return 0;
    }

    public static long convertToLong(String value) {
        if (value != null && value.length() > 0) {
            if (value.indexOf(46) >= 0) {
                Double doubleValue = new Double(value);
                long longValue = doubleValue.longValue();
                if ((double)longValue != doubleValue) {
                    throw new NumberFormatException(value);
                }
                return longValue;
            }
            return Long.parseLong(value);
        }
        return 0L;
    }

    public static double convertToDouble(String value) {
        if (value != null && value.length() > 0) {
            return Double.parseDouble(value);
        }
        return 0.0;
    }

    public static IDfId convertToId(String value) {
        DfId id = DfId.valueOf(value);
        if (id.isNull() || id.isObjectId()) {
            return id;
        }
        throw new IllegalArgumentException("invalid object id string - " + value);
    }

    public static IDfTime convertToTime(String value) {
        if (value == null || value.length() == 0) {
            return DfTime.DF_NULLDATE;
        }
        if (value.equals("nulldate")) {
            return DfTime.DF_NULLDATE;
        }
        if (value.equals("invaliddate")) {
            return DfTime.DF_INVALIDDATE;
        }
        return new DfTime(DataConverter.convertToDate(value));
    }

    public static Date convertToDate(String value) {
        return LenientDmclDateFormat.getInstance().parse(value);
    }

    public static String convertToString(boolean value) {
        return value ? "T" : "F";
    }

    public static String convertToString(int value) {
        return Integer.toString(value);
    }

    public static String convertToString(long value) {
        return Long.toString(value);
    }

    public static String convertToString(double value) {
        String result = Double.toString(value);
        if (result.endsWith(".0")) {
            result = result.substring(0, result.length() - 2);
        }
        return result;
    }

    public static String convertToString(String value) {
        return value == null ? StringUtil.EMPTY_STRING : value;
    }

    public static String convertToString(IDfId value) {
        if (value == null) {
            return "0000000000000000";
        }
        return ((Object)value).toString();
    }

    public static String convertToString(IDfTime value) {
        if (value == null || value.isNullDate()) {
            return "nulldate";
        }
        return LenientDmclDateFormat.getInstance().format(value.getDate());
    }

    public static String convertToString(Date value) {
        if (value == null) {
            return "nulldate";
        }
        return LenientDmclDateFormat.getInstance().format(value);
    }
}

