/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.typeddata;

import com.documentum.fc.client.impl.typeddata.Attribute;
import com.documentum.fc.client.impl.typeddata.ExtendedLiteType;
import com.documentum.fc.client.impl.typeddata.ILiteType;
import com.documentum.fc.client.impl.typeddata.NoSuchAttributeException;
import com.documentum.fc.impl.util.StringUtil;
import com.documentum.fc.tracing.ITraceString;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateLiteType
implements ILiteType,
ITraceString,
Externalizable,
Cloneable {
    private String m_name;
    private ILiteType m_childType;
    private ILiteType m_parentType;
    private List<AggregateAttribute> m_attrList = new ArrayList<AggregateAttribute>(100);
    private Map<String, AggregateAttribute> m_attrNameMap = new HashMap<String, AggregateAttribute>();
    private Map<String, AggregateAttribute> m_attrIdMap = new HashMap<String, AggregateAttribute>();
    private static final long serialVersionUID = 8066148690234779558L;
    private AggregateLiteType m_superType;

    public AggregateLiteType() {
    }

    public AggregateLiteType(ILiteType parentType, ILiteType childType, AggregateLiteType superType) {
        this.m_parentType = parentType;
        this.m_superType = superType;
        this.m_childType = childType;
        this.m_name = childType.getName();
        this.buildMapping();
    }

    public ILiteType getChildType() {
        return this.m_childType;
    }

    public ILiteType getParentType() {
        return this.m_parentType;
    }

    @Override
    public final String getName() {
        return this.m_name;
    }

    @Override
    public int getVStamp() {
        return this.m_childType.getVStamp();
    }

    @Override
    public int getVersion() {
        return this.m_childType.getVersion();
    }

    @Override
    public int getCacheVStamp() {
        return this.m_childType.getCacheVStamp();
    }

    @Override
    public boolean isLightObjectType() {
        return true;
    }

    @Override
    public boolean isAspectAttrDefType() {
        return false;
    }

    @Override
    public String getDeclaredParentTypeName() {
        return this.m_childType.getDeclaredParentTypeName();
    }

    @Override
    public String getAspectName() {
        return this.m_childType.getAspectName();
    }

    @Override
    public boolean isAspectDataShareable() {
        return this.m_childType.isAspectDataShareable();
    }

    @Override
    public final ILiteType getSuperType() {
        return this.m_superType;
    }

    @Override
    public ILiteType getUnextendedType() {
        return new AggregateLiteType(this.m_parentType == null ? null : this.m_parentType.getUnextendedType(), this.m_childType.getUnextendedType(), this.m_superType == null ? null : (AggregateLiteType)this.m_superType.getUnextendedType());
    }

    @Override
    public final boolean isTypeOf(String typeName) {
        return this.m_name.equals(typeName) || this.isSubTypeOf(typeName) || this.m_parentType.isTypeOf(typeName);
    }

    @Override
    public final boolean isSubTypeOf(String typeName) {
        return this.m_superType != null && this.m_superType.isTypeOf(typeName);
    }

    @Override
    public final boolean hasAttr(String name) {
        if (StringUtil.isEmptyOrNull(name)) {
            return false;
        }
        return this.m_attrNameMap.containsKey(name);
    }

    @Override
    public final int getAttrCount() {
        return this.m_attrList.size();
    }

    @Override
    public final Attribute getAttr(String name) {
        Attribute attribute = this.getAttrIfPresent(name);
        if (attribute == null) {
            throw new NoSuchAttributeException(name);
        }
        return attribute;
    }

    @Override
    public Attribute getAttrById(String id) throws NoSuchAttributeException {
        Attribute attribute = this.getAttrByIdIfPresent(id);
        if (attribute == null) {
            throw new NoSuchAttributeException("attrid " + id);
        }
        return attribute;
    }

    @Override
    public final Attribute getAttr(int index) throws NoSuchAttributeException {
        if (index >= this.m_attrList.size()) {
            throw new NoSuchAttributeException(Integer.toString(index));
        }
        return this.m_attrList.get(index);
    }

    @Override
    public final Attribute getAttrIfPresent(String name) {
        return this.m_attrNameMap.get(name);
    }

    @Override
    public Attribute getAttrByIdIfPresent(String id) {
        return this.m_attrIdMap.get(id);
    }

    @Override
    public int getAttrIndex(String name) throws NoSuchAttributeException {
        return this.getAttr(name).getIndex();
    }

    @Override
    public String getAttrName(int index) throws NoSuchAttributeException {
        return this.getAttr(index).getName();
    }

    @Override
    public final void addAttr(Attribute attribute) {
        throw new UnsupportedOperationException("cannot add attribute to aggregate lite type");
    }

    @Override
    public final boolean isReadOnly() {
        return true;
    }

    @Override
    public final void setReadOnly(boolean readOnly) {
    }

    public String toString() {
        return this.toTraceString(true);
    }

    @Override
    public String toTraceString(boolean verbose) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(this.getTraceInstanceId());
        String details = this.getTraceStringDetails(verbose);
        if (details.length() > 0) {
            sb.append('{').append(details).append('}');
        }
        return sb.toString();
    }

    public String getTraceInstanceId() {
        StringBuilder sb = new StringBuilder(64);
        String fullName = this.getClass().getName();
        sb.append(fullName.substring(fullName.lastIndexOf(46) + 1));
        sb.append('@');
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        return sb.toString();
    }

    protected String getTraceStringDetails(boolean verbose) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("name=").append(this.m_name);
        if (verbose) {
            sb.append("attributes={");
            int count = this.m_attrList.size();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.getAttr(i).getName());
            }
            sb.append('}');
        }
        if (this.m_parentType != null) {
            sb.append(", parentType=").append(this.m_parentType.getName());
        }
        if (this.m_childType != null) {
            sb.append(", childType=").append(this.m_childType.getName());
        }
        return sb.toString();
    }

    @Override
    public Object clone() {
        try {
            AggregateLiteType copy = (AggregateLiteType)super.clone();
            copy.m_attrList = new ArrayList<AggregateAttribute>();
            copy.m_attrNameMap = new HashMap<String, AggregateAttribute>();
            copy.m_attrIdMap = new HashMap<String, AggregateAttribute>();
            int limit = this.m_attrList.size();
            for (int i = 0; i < limit; ++i) {
                copy.addAttrInternal(new AggregateAttribute(this.m_attrList.get(i)));
            }
            copy.m_childType = this.m_childType;
            copy.m_parentType = this.m_parentType;
            copy.m_name = this.m_name;
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("This should not happen since clone is implemented");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateLiteType that = (AggregateLiteType)o;
        if (this.m_attrList != null ? !((Object)this.m_attrList).equals(that.m_attrList) : that.m_attrList != null) {
            return false;
        }
        if (this.m_childType != null ? !this.m_childType.equals(that.m_childType) : that.m_childType != null) {
            return false;
        }
        if (this.m_name != null ? !this.m_name.equals(that.m_name) : that.m_name != null) {
            return false;
        }
        if (this.m_parentType != null ? !this.m_parentType.equals(that.m_parentType) : that.m_parentType != null) {
            return false;
        }
        return !(this.m_superType != null ? !this.m_superType.equals(that.m_superType) : that.m_superType != null);
    }

    public int hashCode() {
        int result = this.m_childType != null ? this.m_childType.hashCode() : 0;
        result = 29 * result + (this.m_parentType != null ? this.m_parentType.hashCode() : 0);
        result = 29 * result + (this.m_superType != null ? this.m_superType.hashCode() : 0);
        result = 29 * result + (this.m_attrList != null ? ((Object)this.m_attrList).hashCode() : 0);
        result = 29 * result + (this.m_name != null ? this.m_name.hashCode() : 0);
        return result;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        AggregateAttribute[] attributes;
        for (AggregateAttribute attribute : attributes = (AggregateAttribute[])objectInput.readObject()) {
            this.addAttrInternal(attribute);
        }
        this.m_name = (String)objectInput.readObject();
        this.m_parentType = (ILiteType)objectInput.readObject();
        this.m_childType = (ILiteType)objectInput.readObject();
        this.m_superType = (AggregateLiteType)objectInput.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.m_attrList.toArray(new AggregateAttribute[0]));
        objectOutput.writeObject(this.m_name);
        objectOutput.writeObject(this.m_parentType);
        objectOutput.writeObject(this.m_childType);
        objectOutput.writeObject(this.m_superType);
    }

    void buildMapping() {
        String attrName;
        Attribute attr;
        this.m_attrIdMap.clear();
        this.m_attrList.clear();
        this.m_attrNameMap.clear();
        ILiteType declaredParentType = this.getDeclaredParentType(this.getDeclaredParentTypeName(), this.m_parentType);
        ILiteType origDeclaredParentType = declaredParentType.getUnextendedType();
        int parentCount = origDeclaredParentType.getAttrCount();
        int index = 0;
        for (int i = 0; i < parentCount; ++i) {
            Attribute attr2 = origDeclaredParentType.getAttr(i);
            this.addAttrInternal(attr2, index++, 0);
        }
        ILiteType origChildType = this.m_childType.getUnextendedType();
        int childCount = origChildType.getAttrCount();
        for (int i = 0; i < childCount; ++i) {
            Attribute attr3 = origChildType.getAttr(i);
            String attrName2 = attr3.getName();
            if (!declaredParentType.hasAttr(attrName2)) {
                this.addAttrInternal(attr3, index++, 1);
                continue;
            }
            AggregateAttribute aggrAttr = this.m_attrNameMap.get(attrName2);
            this.setAttrInternal(attr3, aggrAttr.getIndex(), 1);
        }
        if (declaredParentType instanceof ExtendedLiteType) {
            int extendedParentCount = declaredParentType.getAttrCount();
            for (int i = parentCount; i < extendedParentCount; ++i) {
                attr = declaredParentType.getAttr(i);
                attrName = attr.getName();
                if (declaredParentType.isSuperTypeAttribute(attrName) || this.m_attrNameMap.containsKey(attrName)) continue;
                this.addAttrInternal(attr, index++, 0);
            }
        }
        if (this.m_childType instanceof ExtendedLiteType) {
            int extendedChildCount = this.m_childType.getAttrCount();
            for (int i = childCount; i < extendedChildCount; ++i) {
                attr = this.m_childType.getAttr(i);
                attrName = attr.getName();
                if (this.m_attrNameMap.containsKey(attrName)) {
                    AggregateAttribute aggrAttr = this.m_attrNameMap.get(attrName);
                    this.setAttrInternal(attr, aggrAttr.getIndex(), 1);
                    continue;
                }
                this.addAttrInternal(attr, index++, 1);
            }
        }
    }

    private ILiteType getDeclaredParentType(String declaredParentTypeName, ILiteType parentType) {
        ILiteType currParentType = parentType;
        while (!declaredParentTypeName.equals(currParentType.getName())) {
            if ((currParentType = currParentType.getSuperType()) != null) continue;
            return null;
        }
        return currParentType;
    }

    private void setAttrInternal(Attribute attr, int aggIndex, int rank) {
        AggregateAttribute newAggAttr = new AggregateAttribute(attr, aggIndex, rank);
        this.m_attrList.set(aggIndex, newAggAttr);
        this.m_attrNameMap.put(attr.getName(), newAggAttr);
        this.m_attrIdMap.put(attr.getId(), newAggAttr);
    }

    private void addAttrInternal(Attribute attr, int aggIndex, int rank) {
        AggregateAttribute aggAttr = new AggregateAttribute(attr, aggIndex, rank);
        this.addAttrInternal(aggAttr);
    }

    private void addAttrInternal(AggregateAttribute attr) {
        this.m_attrList.add(attr);
        this.m_attrNameMap.put(attr.getName(), attr);
        this.m_attrIdMap.put(attr.getId(), attr);
    }

    public boolean isChildAttribute(int aggIndex) {
        return this.m_attrList.get(aggIndex).isChildAttribute();
    }

    @Override
    public boolean isSuperTypeAttribute(String name) {
        return this.getChildType().isSuperTypeAttribute(name);
    }

    public boolean isParentAttribute(int aggIndex) {
        AggregateAttribute aggAttr = this.m_attrList.get(aggIndex);
        return aggAttr != null && !aggAttr.isChildAttribute();
    }

    public int getRawIndex(int aggIndex) {
        return this.m_attrList.get(aggIndex).getRawIndex();
    }

    void reparentType(ILiteType parentType) {
        this.m_parentType = parentType;
        this.buildMapping();
    }

    public Set<String> getParentAttributeNameSet() {
        HashSet<String> set = new HashSet<String>(this.m_parentType.getAttrCount());
        for (AggregateAttribute attr : this.m_attrList) {
            if (attr.isChildAttribute()) continue;
            set.add(attr.getName());
        }
        return set;
    }

    private static class AggregateAttribute
    extends Attribute {
        static final long serialVersionUID = 1505614370827981776L;
        private int m_rank;
        private int m_rawIndex;
        static final int RANK_PARENT = 0;
        static final int RANK_CHILD = 1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

        public AggregateAttribute() {
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        AggregateAttribute(AggregateAttribute attr) {
            super(attr);
            AggregateAttribute aggregateAttribute = attr;
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)aggregateAttribute);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                this.m_rank = attr.m_rank;
                this.m_rawIndex = attr.getRawIndex();
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)aggregateAttribute);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)aggregateAttribute);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        AggregateAttribute(Attribute attr, int aggIndex, int rank) {
            super(attr);
            Attribute attribute = attr;
            int n = aggIndex;
            int n2 = rank;
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        Object[] objectArray = new Object[]{attribute, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                this.m_rank = rank;
                this.m_rawIndex = attr.getIndex();
                this.setIndex(aggIndex);
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        Object[] objectArray = new Object[]{attribute, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        Object[] objectArray = new Object[]{attribute, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        public int getRawIndex() {
            JoinPoint joinPoint = null;
            try {
                int n;
                int n2;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                int n3 = n2 = (n = this.m_rawIndex);
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    Object object = Conversions.intObject((int)n2);
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
                }
                return n;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        public boolean isChildAttribute() {
            JoinPoint joinPoint = null;
            try {
                boolean bl;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                boolean bl2 = this.m_rank == 1;
                boolean bl3 = bl = bl2;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    Object object = Conversions.booleanObject((boolean)bl);
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
                }
                return bl2;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        public String toString() {
            return super.toString() + " {" + "rank='" + this.m_rank + "'" + ", rawIndex ='" + this.m_rawIndex + "'" + "}";
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            super.writeExternal(objectOutput);
            objectOutput.writeInt(this.m_rank);
            objectOutput.writeInt(this.m_rawIndex);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            super.readExternal(objectInput);
            this.m_rank = objectInput.readInt();
            this.m_rawIndex = objectInput.readInt();
        }

        static {
            Factory factory = new Factory("AggregateLiteType.java", Class.forName("com.documentum.fc.client.impl.typeddata.AggregateLiteType$AggregateAttribute"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRawIndex", "com.documentum.fc.client.impl.typeddata.AggregateLiteType$AggregateAttribute", "", "", "", "int"), 505);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isChildAttribute", "com.documentum.fc.client.impl.typeddata.AggregateLiteType$AggregateAttribute", "", "", "", "boolean"), 510);
            ajc$tjp_2 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.documentum.fc.client.impl.typeddata.AggregateLiteType$AggregateAttribute", "", "", ""), 486);
            ajc$tjp_3 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("0", "com.documentum.fc.client.impl.typeddata.AggregateLiteType$AggregateAttribute", "com.documentum.fc.client.impl.typeddata.AggregateLiteType$AggregateAttribute:", "attr:", ""), 491);
            ajc$tjp_4 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("0", "com.documentum.fc.client.impl.typeddata.AggregateLiteType$AggregateAttribute", "com.documentum.fc.client.impl.typeddata.Attribute:int:int:", "attr:aggIndex:rank:", ""), 498);
        }
    }
}

