/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.session.tokendiagnostics;

import com.documentum.fc.client.impl.objectprotocol.ObjectProtocolV0;
import com.documentum.fc.client.impl.session.tokendiagnostics.CDataParser;
import com.documentum.fc.client.impl.session.tokendiagnostics.DumpLineAccumulator;
import com.documentum.fc.client.impl.session.tokendiagnostics.InvalidCDataException;
import com.documentum.fc.client.impl.session.tokendiagnostics.TokenDumpUtils;
import com.documentum.fc.client.impl.typeddata.ITypedData;
import com.documentum.fc.common.DfCriticalException;
import com.documentum.fc.common.DfException;
import com.documentum.fc.impl.util.DfSimpleEncoderDecoder;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.io.UnsupportedEncodingException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class LoginTicket {
    private static final String TOKEN_NAME_FOR_EXCEPTIONS = "Login ticket";
    private static final String ENCODED_FORM_PREFIX = "DM_TICKET=";
    private static final long V1_FORM = 1L;
    private static final long V2_FORM = 2L;
    private static final long V3_FORM = 1329744416L;
    private static final int V3_OBJECT_VERSION = 3;
    private static final int DM_TICKET_PROP_SERVER = 4;
    private static final int DM_TICKET_PROP_DOCBASE = 2;
    private static final int DM_TICKET_PROP_SINGLE_USE = 8;
    private final long m_version;
    private final long m_tokenSize;
    private final long m_flags;
    private final long m_sequenceNumber;
    private final long m_creationTime;
    private final long m_expirationTime;
    private final long m_signatureLength;
    private final String m_docbaseName;
    private final String m_userName;
    private final String m_domainName;
    private final String m_serverName;
    private final String m_hostName;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    public static boolean isEncodedForm(String string) {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            String form;
            boolean bl;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            boolean bl3 = bl2 = (bl = form.startsWith(ENCODED_FORM_PREFIX));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public static LoginTicket makeFromEncodedForm(String string) throws DfException {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            LoginTicket loginTicket;
            LoginTicket loginTicket2;
            LoginTicket loginTicket3;
            block15: {
                String encodedForm;
                block14: {
                    long version;
                    byte[] data;
                    block13: {
                        if (BaseTracingAspect.ajc$if_0()) {
                            TracingAspect tracingAspect = TracingAspect.aspectOf();
                            if (joinPoint == null) {
                                joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string2);
                            }
                            tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                        }
                        try {
                            if (!LoginTicket.isEncodedForm(encodedForm)) {
                                throw DfException.newDecodingFailedException(TOKEN_NAME_FOR_EXCEPTIONS, encodedForm, null);
                            }
                            data = DfSimpleEncoderDecoder.base64Decode(encodedForm.substring(ENCODED_FORM_PREFIX.length()).toCharArray());
                            CDataParser cdp = new CDataParser(data);
                            version = cdp.getUnsigned();
                            if (version != 1L && version != 2L) break block13;
                            loginTicket2 = loginTicket3 = LoginTicket.makeFromV1OrV2Form(version, cdp);
                        }
                        catch (InvalidCDataException icde) {
                            throw DfException.newDecodingFailedException(TOKEN_NAME_FOR_EXCEPTIONS, encodedForm, icde);
                        }
                        break block15;
                    }
                    if (version != 1329744416L) break block14;
                    loginTicket2 = loginTicket3 = LoginTicket.makeFromV3Form(data);
                    break block15;
                }
                throw DfException.newDecodingFailedException(TOKEN_NAME_FOR_EXCEPTIONS, encodedForm, null);
            }
            LoginTicket loginTicket4 = loginTicket = loginTicket2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(loginTicket, joinPoint);
            }
            return loginTicket3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private static LoginTicket makeFromV3Form(byte[] byArray) throws DfException {
        byte[] byArray2 = byArray;
        JoinPoint joinPoint = null;
        try {
            LoginTicket loginTicket;
            LoginTicket loginTicket2;
            byte[] data;
            String form;
            ObjectProtocolV0 op;
            ITypedData to;
            int version;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)byArray2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if ((version = (to = (op = new ObjectProtocolV0()).deserializeObject(form = LoginTicket.getStringFormFromData(data), null)).getInt("version")) != 3) {
                throw DfException.newUnsupportedLoginTicketObjectVersionException(version);
            }
            long tokenSize = -1L;
            long flags = to.getInt("flags");
            long sequenceNumber = to.getInt("sequence_num");
            long createTime = LoginTicket.getMillisFromSignedSeconds(to.getInt("create_time"));
            long expireTime = LoginTicket.getMillisFromSignedSeconds(to.getInt("expire_time"));
            long signatureLength = to.getInt("signature_len");
            String docbaseName = to.getString("docbase_name");
            String userName = to.getString("user_name");
            String domainName = to.getString("domain");
            String serverName = to.getString("server_name");
            String hostName = to.getString("host_name");
            LoginTicket loginTicket3 = loginTicket2 = (loginTicket = new LoginTicket(version, tokenSize, flags, sequenceNumber, createTime, expireTime, signatureLength, docbaseName, userName, domainName, serverName, hostName));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)byArray2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(loginTicket2, joinPoint);
            }
            return loginTicket;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)byArray2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private static long getMillisFromSignedSeconds(int n) {
        int n2 = n;
        JoinPoint joinPoint = null;
        try {
            long l;
            long l2;
            int ss;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            long millis = ss >= 0 ? (long)ss : Integer.MAX_VALUE - (long)ss;
            long l3 = l2 = (l = millis * 1000L);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.longObject((long)l2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return l;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private static String getStringFormFromData(byte[] byArray) throws DfException {
        byte[] byArray2 = byArray;
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            String string3;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object)byArray2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            try {
                byte[] data;
                string2 = string3 = new String(data, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new DfCriticalException("UTF-8 should always be supported", e);
            }
            String string4 = string = string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object)byArray2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string, joinPoint);
            }
            return string3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object)byArray2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static LoginTicket makeFromV1OrV2Form(long l, CDataParser cDataParser) throws InvalidCDataException {
        long l2 = l;
        CDataParser cDataParser2 = cDataParser;
        JoinPoint joinPoint = null;
        try {
            long version;
            LoginTicket loginTicket;
            LoginTicket loginTicket2;
            void cdp;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)Conversions.longObject((long)l2), (Object)cDataParser2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            long tokenSize = cdp.getUnsigned();
            long flags = cdp.getUnsigned();
            long sequenceNumber = cdp.getUnsigned();
            long createTime = cdp.getUnsigned() * 1000L;
            long expireTime = cdp.getUnsigned() * 1000L;
            long signatureLength = cdp.getUnsigned();
            String docbaseName = cdp.getName();
            String userName = cdp.getName();
            String domainName = cdp.getName();
            String serverName = cdp.getName();
            String hostName = cdp.getName();
            LoginTicket loginTicket3 = loginTicket2 = (loginTicket = new LoginTicket(version, tokenSize, flags, sequenceNumber, createTime, expireTime, signatureLength, docbaseName, userName, domainName, serverName, hostName));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)Conversions.longObject((long)l2), (Object)cDataParser2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(loginTicket2, joinPoint);
            }
            return loginTicket;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)Conversions.longObject((long)l2), (Object)cDataParser2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public String toString() {
        DumpLineAccumulator dla = new DumpLineAccumulator();
        dla.addLine("LOGIN TICKET DUMP");
        dla.addLine("==========================================");
        if (this.m_version == 1L || this.m_version == 2L) {
            dla.addLine("Version         : 5.3");
        } else if (this.m_version == 3L) {
            dla.addLine("Version         : 6.0(" + this.m_version + ")");
        }
        dla.addLine("Scope           : ", this.getScope());
        dla.addLine("Sequence Number : ", this.padSequenceNumber());
        dla.addLine("Single Use      : ", this.getSingleUse());
        dla.addLine("Create Time     : ", TokenDumpUtils.getTimeString(this.m_creationTime));
        dla.addLine("Expiration Time : ", TokenDumpUtils.getTimeString(this.m_expirationTime));
        dla.addLine("User            : ", this.m_userName);
        dla.addLine("Domain          : ", this.m_domainName);
        dla.addLine("Server          : ", this.m_serverName);
        dla.addLine("Docbase         : ", this.m_docbaseName);
        dla.addLine("Host            : ", this.m_hostName);
        return dla.toString();
    }

    private String getScope() {
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String string3 = string2 = (this.m_flags & 4L) == 4L ? (string = "server") : ((this.m_flags & 2L) == 2L ? (string = "docbase") : (string = "global"));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private String getSingleUse() {
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String string3 = string2 = (this.m_flags & 8L) == 8L ? (string = "Yes") : (string = "No");
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private String padSequenceNumber() {
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            StringBuffer sb = new StringBuffer();
            sb.append(this.m_sequenceNumber);
            while (sb.length() < 10) {
                sb.insert(0, "0");
            }
            String string3 = string2 = (string = sb.toString());
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private LoginTicket(long version, long tokenSize, long flags, long sequenceNumber, long creationTime, long expirationTime, long signatureLenght, String docbaseName, String userName, String domainName, String serverName, String hostName) {
        long l = version;
        long l2 = tokenSize;
        long l3 = flags;
        long l4 = sequenceNumber;
        long l5 = creationTime;
        long l6 = expirationTime;
        long l7 = signatureLenght;
        String string = docbaseName;
        String string2 = userName;
        String string3 = domainName;
        String string4 = serverName;
        String string5 = hostName;
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{Conversions.longObject((long)l), Conversions.longObject((long)l2), Conversions.longObject((long)l3), Conversions.longObject((long)l4), Conversions.longObject((long)l5), Conversions.longObject((long)l6), Conversions.longObject((long)l7), string, string2, string3, string4, string5};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_version = version;
            this.m_tokenSize = tokenSize;
            this.m_flags = flags;
            this.m_sequenceNumber = sequenceNumber;
            this.m_creationTime = creationTime;
            this.m_expirationTime = expirationTime;
            this.m_signatureLength = signatureLenght;
            this.m_docbaseName = docbaseName;
            this.m_userName = userName;
            this.m_domainName = domainName;
            this.m_serverName = serverName;
            this.m_hostName = hostName;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{Conversions.longObject((long)l), Conversions.longObject((long)l2), Conversions.longObject((long)l3), Conversions.longObject((long)l4), Conversions.longObject((long)l5), Conversions.longObject((long)l6), Conversions.longObject((long)l7), string, string2, string3, string4, string5};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{Conversions.longObject((long)l), Conversions.longObject((long)l2), Conversions.longObject((long)l3), Conversions.longObject((long)l4), Conversions.longObject((long)l5), Conversions.longObject((long)l6), Conversions.longObject((long)l7), string, string2, string3, string4, string5};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("LoginTicket.java", Class.forName("com.documentum.fc.client.impl.session.tokendiagnostics.LoginTicket"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "isEncodedForm", "com.documentum.fc.client.impl.session.tokendiagnostics.LoginTicket", "java.lang.String:", "form:", "", "boolean"), 22);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "makeFromEncodedForm", "com.documentum.fc.client.impl.session.tokendiagnostics.LoginTicket", "java.lang.String:", "encodedForm:", "com.documentum.fc.common.DfException:", "com.documentum.fc.client.impl.session.tokendiagnostics.LoginTicket"), 33);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "makeFromV3Form", "com.documentum.fc.client.impl.session.tokendiagnostics.LoginTicket", "[B:", "data:", "com.documentum.fc.common.DfException:", "com.documentum.fc.client.impl.session.tokendiagnostics.LoginTicket"), 56);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "getMillisFromSignedSeconds", "com.documentum.fc.client.impl.session.tokendiagnostics.LoginTicket", "int:", "ss:", "", "long"), 80);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "getStringFormFromData", "com.documentum.fc.client.impl.session.tokendiagnostics.LoginTicket", "[B:", "data:", "com.documentum.fc.common.DfException:", "java.lang.String"), 95);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "makeFromV1OrV2Form", "com.documentum.fc.client.impl.session.tokendiagnostics.LoginTicket", "long:com.documentum.fc.client.impl.session.tokendiagnostics.CDataParser:", "version:cdp:", "com.documentum.fc.client.impl.session.tokendiagnostics.InvalidCDataException:", "com.documentum.fc.client.impl.session.tokendiagnostics.LoginTicket"), 105);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getScope", "com.documentum.fc.client.impl.session.tokendiagnostics.LoginTicket", "", "", "", "java.lang.String"), 151);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getSingleUse", "com.documentum.fc.client.impl.session.tokendiagnostics.LoginTicket", "", "", "", "java.lang.String"), 162);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "padSequenceNumber", "com.documentum.fc.client.impl.session.tokendiagnostics.LoginTicket", "", "", "", "java.lang.String"), 170);
        ajc$tjp_9 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("2", "com.documentum.fc.client.impl.session.tokendiagnostics.LoginTicket", "long:long:long:long:long:long:long:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:", "version:tokenSize:flags:sequenceNumber:creationTime:expirationTime:signatureLenght:docbaseName:userName:domainName:serverName:hostName:", ""), 180);
    }
}

