/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.session;

import com.documentum.fc.client.impl.session.ITicketCustodian;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

class TicketWatchdog {
    private Map<ITicketCustodian, Boolean> m_custodians;
    private static final int ONE_SECOND = 1000;
    private static final int SAFETY_MARGIN = 30000;
    private static final Timer s_timer;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    TicketWatchdog(long checkInterval) {
        long l = checkInterval;
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_custodians = new WeakHashMap<ITicketCustodian, Boolean>();
            s_timer.schedule((TimerTask)new ExpirationScanner(this, checkInterval), checkInterval, checkInterval);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    synchronized void register(ITicketCustodian iTicketCustodian) {
        ITicketCustodian iTicketCustodian2 = iTicketCustodian;
        JoinPoint joinPoint = null;
        try {
            void custodian;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)iTicketCustodian2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_custodians.put((ITicketCustodian)custodian, Boolean.TRUE);
            Object var4_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)iTicketCustodian2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var4_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)iTicketCustodian2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    synchronized void unregister(ITicketCustodian iTicketCustodian) {
        ITicketCustodian iTicketCustodian2 = iTicketCustodian;
        JoinPoint joinPoint = null;
        try {
            void custodian;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)iTicketCustodian2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_custodians.remove(custodian);
            Object var4_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)iTicketCustodian2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var4_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)iTicketCustodian2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    synchronized ITicketCustodian[] getCustodians() {
        JoinPoint joinPoint = null;
        try {
            ITicketCustodian[] iTicketCustodianArray;
            ITicketCustodian[] iTicketCustodianArray2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            ITicketCustodian[] iTicketCustodianArray3 = iTicketCustodianArray2 = (iTicketCustodianArray = this.m_custodians.keySet().toArray(new ITicketCustodian[0]));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(iTicketCustodianArray2, joinPoint);
            }
            return iTicketCustodianArray;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("TicketWatchdog.java", Class.forName("com.documentum.fc.client.impl.session.TicketWatchdog"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("20", "register", "com.documentum.fc.client.impl.session.TicketWatchdog", "com.documentum.fc.client.impl.session.ITicketCustodian:", "custodian:", "", "void"), 29);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("20", "unregister", "com.documentum.fc.client.impl.session.TicketWatchdog", "com.documentum.fc.client.impl.session.ITicketCustodian:", "custodian:", "", "void"), 34);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("20", "getCustodians", "com.documentum.fc.client.impl.session.TicketWatchdog", "", "", "", "[Lcom.documentum.fc.client.impl.session.ITicketCustodian;"), 39);
        ajc$tjp_3 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("0", "com.documentum.fc.client.impl.session.TicketWatchdog", "long:", "checkInterval:", ""), 23);
        s_timer = new Timer(true);
    }

    private static class ExpirationScanner
    extends TimerTask {
        private final long m_expirationThreshold;
        private final WeakReference<TicketWatchdog> m_watchdog;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        ExpirationScanner(TicketWatchdog watchdog, long checkInterval) {
            TicketWatchdog ticketWatchdog = watchdog;
            long l = checkInterval;
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)ticketWatchdog, (Object)Conversions.longObject((long)l));
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                this.m_watchdog = new WeakReference<TicketWatchdog>(watchdog);
                this.m_expirationThreshold = Math.max(0L, checkInterval + 30000L);
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)ticketWatchdog, (Object)Conversions.longObject((long)l));
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)ticketWatchdog, (Object)Conversions.longObject((long)l));
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        public void run() {
            JoinPoint joinPoint = null;
            try {
                TicketWatchdog watchdog;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                if ((watchdog = (TicketWatchdog)this.m_watchdog.get()) != null) {
                    ITicketCustodian[] custodians;
                    long minimumSafeExpirationTime = System.currentTimeMillis() + this.m_expirationThreshold;
                    if (DfLogger.isDebugEnabled(this)) {
                        DfLogger.debug((Object)this, "Scanning ticket custodians for expired tickets", null, null);
                    }
                    int numberOfTicketsRefreshed = 0;
                    for (ITicketCustodian custodian : custodians = watchdog.getCustodians()) {
                        if (custodian.getTicketExpirationTime() > minimumSafeExpirationTime) continue;
                        try {
                            custodian.refreshTicket();
                            ++numberOfTicketsRefreshed;
                        }
                        catch (Exception e) {
                            DfLogger.error((Object)this, "Failed to refresh ticket", null, (Throwable)e);
                        }
                    }
                    if (DfLogger.isDebugEnabled(this)) {
                        DfLogger.debug((Object)this, "Scanned {0} ticket custodians, {1} tickets were refreshed", new Object[]{custodians.length, numberOfTicketsRefreshed}, null);
                    }
                } else {
                    this.cancel();
                }
                Object var12_11 = null;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var12_11, joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        static {
            Factory factory = new Factory("TicketWatchdog.java", Class.forName("com.documentum.fc.client.impl.session.TicketWatchdog$ExpirationScanner"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "com.documentum.fc.client.impl.session.TicketWatchdog$ExpirationScanner", "", "", "", "void"), 59);
            ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("0", "com.documentum.fc.client.impl.session.TicketWatchdog$ExpirationScanner", "com.documentum.fc.client.impl.session.TicketWatchdog:long:", "watchdog:checkInterval:", ""), 53);
        }
    }
}

